/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueConfigurations;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueStatistics;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.AccessRequest;
import org.apache.hadoop.yarn.security.AccessType;
import org.apache.hadoop.yarn.security.PrivilegedEntity;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueResourceQuotas;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivitiesManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ContainerAllocationProposal;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ResourceCommitRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.SchedulerContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.SimpleCandidateNodeSet;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCSQueue
implements CSQueue {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCSQueue.class);
    volatile CSQueue parent;
    final String queueName;
    private final String queuePath;
    volatile int numContainers;
    final Resource minimumAllocation;
    volatile Resource maximumAllocation;
    private volatile QueueState state = null;
    final CSQueueMetrics metrics;
    protected final PrivilegedEntity queueEntity;
    final ResourceCalculator resourceCalculator;
    Set<String> accessibleLabels;
    Set<String> resourceTypes;
    final RMNodeLabelsManager labelManager;
    String defaultLabelExpression;
    private String multiNodeSortingPolicyName = null;
    Map<AccessType, AccessControlList> acls = new HashMap<AccessType, AccessControlList>();
    volatile boolean reservationsContinueLooking;
    private volatile boolean preemptionDisabled;
    private boolean intraQueuePreemptionDisabledInHierarchy;
    volatile ResourceUsage queueUsage;
    private final boolean fullPathQueueNamingPolicy = false;
    QueueCapacities queueCapacities;
    QueueResourceQuotas queueResourceQuotas;
    private volatile long maxApplicationLifetime = -1L;
    private volatile long defaultApplicationLifetime = -1L;
    private volatile boolean defaultAppLifetimeWasSpecifiedInConfig = false;
    protected CapacityConfigType capacityConfigType = CapacityConfigType.NONE;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    protected CapacitySchedulerContext csContext;
    protected YarnAuthorizationProvider authorizer = null;
    protected ActivitiesManager activitiesManager;
    protected ReentrantReadWriteLock.ReadLock readLock;
    protected ReentrantReadWriteLock.WriteLock writeLock;
    volatile Priority priority = Priority.newInstance((int)0);
    private Map<String, Float> userWeights = new HashMap<String, Float>();
    private int maxParallelApps;

    public AbstractCSQueue(CapacitySchedulerContext cs, String queueName, CSQueue parent, CSQueue old) throws IOException {
        this(cs, cs.getConfiguration(), queueName, parent, old);
    }

    public AbstractCSQueue(CapacitySchedulerContext cs, CapacitySchedulerConfiguration configuration, String queueName, CSQueue parent, CSQueue old) {
        this.labelManager = cs.getRMContext().getNodeLabelManager();
        this.parent = parent;
        this.queueName = queueName;
        this.queuePath = (parent == null ? "" : parent.getQueuePath() + ".") + this.queueName;
        this.resourceCalculator = cs.getResourceCalculator();
        this.activitiesManager = cs.getActivitiesManager();
        this.metrics = old != null ? (CSQueueMetrics)old.getMetrics() : CSQueueMetrics.forQueue(this.getQueuePath(), parent, cs.getConfiguration().getEnableUserMetrics(), cs.getConf());
        this.csContext = cs;
        this.minimumAllocation = this.csContext.getMinimumResourceCapability();
        this.queueUsage = new ResourceUsage();
        this.queueEntity = new PrivilegedEntity(PrivilegedEntity.EntityType.QUEUE, this.getQueuePath());
        this.queueCapacities = new QueueCapacities(parent == null);
        this.queueResourceQuotas = new QueueResourceQuotas();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    protected void setupConfigurableCapacities() {
        this.setupConfigurableCapacities(this.csContext.getConfiguration());
    }

    protected void setupConfigurableCapacities(CapacitySchedulerConfiguration configuration) {
        CSQueueUtils.loadUpdateAndCheckCapacities(this.getQueuePath(), configuration, this.queueCapacities, this.parent == null ? null : this.parent.getQueueCapacities());
    }

    @Override
    public String getQueuePath() {
        return this.queuePath;
    }

    @Override
    public float getCapacity() {
        return this.queueCapacities.getCapacity();
    }

    @Override
    public float getAbsoluteCapacity() {
        return this.queueCapacities.getAbsoluteCapacity();
    }

    @Override
    public float getAbsoluteMaximumCapacity() {
        return this.queueCapacities.getAbsoluteMaximumCapacity();
    }

    @Override
    public float getAbsoluteUsedCapacity() {
        return this.queueCapacities.getAbsoluteUsedCapacity();
    }

    @Override
    public float getMaximumCapacity() {
        return this.queueCapacities.getMaximumCapacity();
    }

    @Override
    public float getUsedCapacity() {
        return this.queueCapacities.getUsedCapacity();
    }

    @Override
    public Resource getUsedResources() {
        return this.queueUsage.getUsed();
    }

    public int getNumContainers() {
        return this.numContainers;
    }

    @Override
    public QueueState getState() {
        return this.state;
    }

    @Override
    public CSQueueMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public String getQueueShortName() {
        return this.queueName;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public PrivilegedEntity getPrivilegedEntity() {
        return this.queueEntity;
    }

    @Override
    public CSQueue getParent() {
        return this.parent;
    }

    @Override
    public void setParent(CSQueue newParentQueue) {
        this.parent = newParentQueue;
    }

    @Override
    public Set<String> getAccessibleNodeLabels() {
        return this.accessibleLabels;
    }

    @Override
    public boolean hasAccess(QueueACL acl, UserGroupInformation user) {
        return this.authorizer.checkPermission(new AccessRequest(this.queueEntity, user, SchedulerUtils.toAccessType(acl), null, null, Server.getRemoteAddress(), null));
    }

    void setMaxCapacity(float maximumCapacity) {
        this.writeLock.lock();
        try {
            CSQueueUtils.checkMaxCapacity(this.getQueuePath(), this.queueCapacities.getCapacity(), maximumCapacity);
            float absMaxCapacity = CSQueueUtils.computeAbsoluteMaximumCapacity(maximumCapacity, this.parent);
            CSQueueUtils.checkAbsoluteCapacity(this.getQueuePath(), this.queueCapacities.getAbsoluteCapacity(), absMaxCapacity);
            this.queueCapacities.setMaximumCapacity(maximumCapacity);
            this.queueCapacities.setAbsoluteMaximumCapacity(absMaxCapacity);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaxCapacity(String nodeLabel, float maximumCapacity) {
        this.writeLock.lock();
        try {
            CSQueueUtils.checkMaxCapacity(this.getQueuePath(), this.queueCapacities.getCapacity(nodeLabel), maximumCapacity);
            float absMaxCapacity = CSQueueUtils.computeAbsoluteMaximumCapacity(maximumCapacity, this.parent);
            CSQueueUtils.checkAbsoluteCapacity(this.getQueuePath(), this.queueCapacities.getAbsoluteCapacity(nodeLabel), absMaxCapacity);
            this.queueCapacities.setMaximumCapacity(maximumCapacity);
            this.queueCapacities.setAbsoluteMaximumCapacity(absMaxCapacity);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public String getDefaultNodeLabelExpression() {
        return this.defaultLabelExpression;
    }

    void setupQueueConfigs(Resource clusterResource) throws IOException {
        this.setupQueueConfigs(clusterResource, this.csContext.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupQueueConfigs(Resource clusterResource, CapacitySchedulerConfiguration configuration) throws IOException {
        this.writeLock.lock();
        try {
            this.accessibleLabels = configuration.getAccessibleNodeLabels(this.getQueuePath());
            this.defaultLabelExpression = configuration.getDefaultNodeLabelExpression(this.getQueuePath());
            this.resourceTypes = new HashSet<String>();
            for (CapacitySchedulerConfiguration.AbsoluteResourceType type : CapacitySchedulerConfiguration.AbsoluteResourceType.values()) {
                this.resourceTypes.add(type.toString().toLowerCase());
            }
            if (this.accessibleLabels == null && this.parent != null) {
                this.accessibleLabels = this.parent.getAccessibleNodeLabels();
            }
            if (this.defaultLabelExpression == null && this.parent != null && this.accessibleLabels.containsAll(this.parent.getAccessibleNodeLabels())) {
                this.defaultLabelExpression = this.parent.getDefaultNodeLabelExpression();
            }
            this.setupConfigurableCapacities(configuration);
            this.capacityConfigType = CapacityConfigType.NONE;
            this.updateConfigurableResourceRequirement(this.getQueuePath(), clusterResource);
            this.setupMaximumAllocation(configuration);
            int queueMaxParallelApps = configuration.getMaxParallelAppsForQueue(this.getQueuePath());
            this.setMaxParallelApps(queueMaxParallelApps);
            QueueState previous = this.getState();
            QueueState configuredState = configuration.getConfiguredState(this.getQueuePath());
            QueueState parentState = this.parent == null ? null : this.parent.getState();
            this.initializeQueueState(previous, configuredState, parentState);
            this.authorizer = YarnAuthorizationProvider.getInstance((Configuration)this.csContext.getConf());
            this.acls = configuration.getAcls(this.getQueuePath());
            CSQueueUtils.updateQueueStatistics(this.resourceCalculator, clusterResource, this, this.labelManager, null);
            if (this.parent != null && this.parent.getParent() != null && this.parent.getAccessibleNodeLabels() != null && !this.parent.getAccessibleNodeLabels().contains("*")) {
                if (this.getAccessibleNodeLabels().contains("*")) {
                    throw new IOException("Parent's accessible queue is not ANY(*), but child's accessible queue is *");
                }
                Sets.SetView diff = Sets.difference(this.getAccessibleNodeLabels(), this.parent.getAccessibleNodeLabels());
                if (!diff.isEmpty()) {
                    throw new IOException("Some labels of child queue is not a subset of parent queue, these labels=[" + StringUtils.join((Iterable)diff, (String)",") + "]");
                }
            }
            this.reservationsContinueLooking = this.csContext.getConfiguration().getReservationContinueLook();
            this.preemptionDisabled = this.isQueueHierarchyPreemptionDisabled(this, configuration);
            this.intraQueuePreemptionDisabledInHierarchy = this.isIntraQueueHierarchyPreemptionDisabled(this, configuration);
            this.priority = configuration.getQueuePriority(this.getQueuePath());
            this.setMultiNodeSortingPolicyName(configuration.getMultiNodesSortingAlgorithmPolicy(this.getQueuePath()));
            this.userWeights = this.getUserWeightsFromHierarchy(configuration);
            this.maxApplicationLifetime = this.getInheritedMaxAppLifetime(this, configuration);
            this.defaultApplicationLifetime = this.getInheritedDefaultAppLifetime(this, configuration, this.maxApplicationLifetime);
            if (this.maxApplicationLifetime > 0L && this.defaultApplicationLifetime > this.maxApplicationLifetime) {
                throw new YarnRuntimeException("Default lifetime " + this.defaultApplicationLifetime + " can't exceed maximum lifetime " + this.maxApplicationLifetime);
            }
            this.defaultApplicationLifetime = this.defaultApplicationLifetime > 0L ? this.defaultApplicationLifetime : this.maxApplicationLifetime;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void setupMaximumAllocation(CapacitySchedulerConfiguration csConf) {
        String myQueuePath = this.getQueuePath();
        Resource clusterMax = ResourceUtils.fetchMaximumAllocationFromConfig((Configuration)this.csContext.getConfiguration());
        Resource queueMax = csConf.getQueueMaximumAllocation(myQueuePath);
        this.maximumAllocation = Resources.clone((Resource)(this.parent == null ? clusterMax : this.parent.getMaximumAllocation()));
        String errMsg = "Queue maximum allocation cannot be larger than the cluster setting for queue " + myQueuePath + " max allocation per queue: %s cluster setting: " + clusterMax;
        if (queueMax == Resources.none()) {
            long queueMemory = csConf.getQueueMaximumAllocationMb(myQueuePath);
            int queueVcores = csConf.getQueueMaximumAllocationVcores(myQueuePath);
            if ((float)queueMemory != -1.0f) {
                this.maximumAllocation.setMemorySize(queueMemory);
            }
            if ((float)queueVcores != -1.0f) {
                this.maximumAllocation.setVirtualCores(queueVcores);
            }
            if ((float)queueMemory != -1.0f && queueMemory > clusterMax.getMemorySize() || (float)queueVcores != -1.0f && queueVcores > clusterMax.getVirtualCores()) {
                throw new IllegalArgumentException(String.format(errMsg, this.maximumAllocation));
            }
        } else {
            for (ResourceInformation ri : queueMax.getResources()) {
                if (ri.compareTo(clusterMax.getResourceInformation(ri.getName())) > 0) {
                    throw new IllegalArgumentException(String.format(errMsg, queueMax));
                }
                this.maximumAllocation.setResourceInformation(ri.getName(), ri);
            }
        }
    }

    private Map<String, Float> getUserWeightsFromHierarchy(CapacitySchedulerConfiguration configuration) throws IOException {
        HashMap<String, Float> unionInheritedWeights = new HashMap<String, Float>();
        CSQueue parentQ = this.getParent();
        if (parentQ != null) {
            unionInheritedWeights.putAll(parentQ.getUserWeights());
        }
        unionInheritedWeights.putAll(configuration.getAllUserWeightsForQueue(this.getQueuePath()));
        return unionInheritedWeights;
    }

    protected void updateConfigurableResourceRequirement(String queuePath, Resource clusterResource) {
        CapacitySchedulerConfiguration conf = this.csContext.getConfiguration();
        Set<String> configuredNodelabels = conf.getConfiguredNodeLabels(queuePath);
        for (String label : configuredNodelabels) {
            Resource parentMaxRes;
            Resource minResource = conf.getMinimumResourceRequirement(label, queuePath, this.resourceTypes);
            Resource maxResource = conf.getMaximumResourceRequirement(label, queuePath, this.resourceTypes);
            LOG.debug("capacityConfigType is '{}' for queue {}", (Object)this.capacityConfigType, (Object)this.getQueuePath());
            if (this.capacityConfigType.equals((Object)CapacityConfigType.NONE)) {
                this.capacityConfigType = !minResource.equals((Object)Resources.none()) && this.queueCapacities.getAbsoluteCapacity(label) == 0.0f ? CapacityConfigType.ABSOLUTE_RESOURCE : CapacityConfigType.PERCENTAGE;
                LOG.debug("capacityConfigType is updated as '{}' for queue {}", (Object)this.capacityConfigType, (Object)this.getQueuePath());
            }
            this.validateAbsoluteVsPercentageCapacityConfig(minResource);
            if (!maxResource.equals((Object)Resources.none()) && Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)minResource, (Resource)maxResource)) {
                throw new IllegalArgumentException("Min resource configuration " + minResource + " is greater than its max value:" + maxResource + " in queue:" + this.getQueuePath());
            }
            if (this.parent != null && Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)(parentMaxRes = this.parent.getQueueResourceQuotas().getConfiguredMaxResource(label)), (Resource)Resources.none())) {
                if (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)maxResource, (Resource)parentMaxRes)) {
                    throw new IllegalArgumentException("Max resource configuration " + maxResource + " is greater than parents max value:" + parentMaxRes + " in queue:" + this.getQueuePath());
                }
                if (maxResource.equals((Object)Resources.none()) && !minResource.equals((Object)Resources.none())) {
                    maxResource = Resources.clone((Resource)parentMaxRes);
                }
            }
            LOG.debug("Updating absolute resource configuration for queue:{} as minResource={} and maxResource={}", new Object[]{this.getQueuePath(), minResource, maxResource});
            this.queueResourceQuotas.setConfiguredMinResource(label, minResource);
            this.queueResourceQuotas.setConfiguredMaxResource(label, maxResource);
        }
    }

    private void validateAbsoluteVsPercentageCapacityConfig(Resource minResource) {
        CapacityConfigType localType = CapacityConfigType.PERCENTAGE;
        if (!minResource.equals((Object)Resources.none())) {
            localType = CapacityConfigType.ABSOLUTE_RESOURCE;
        }
        if (!this.queuePath.equals("root") && !this.capacityConfigType.equals((Object)localType)) {
            throw new IllegalArgumentException("Queue '" + this.getQueuePath() + "' should use either percentage based capacity configuration or absolute resource.");
        }
    }

    @Override
    public CapacityConfigType getCapacityConfigType() {
        return this.capacityConfigType;
    }

    @Override
    public Resource getEffectiveCapacity(String label) {
        return Resources.clone((Resource)this.getQueueResourceQuotas().getEffectiveMinResource(label));
    }

    @Override
    public Resource getEffectiveCapacityDown(String label, Resource factor) {
        return Resources.normalizeDown((ResourceCalculator)this.resourceCalculator, (Resource)this.getQueueResourceQuotas().getEffectiveMinResource(label), (Resource)this.minimumAllocation);
    }

    @Override
    public Resource getEffectiveMaxCapacity(String label) {
        return Resources.clone((Resource)this.getQueueResourceQuotas().getEffectiveMaxResource(label));
    }

    @Override
    public Resource getEffectiveMaxCapacityDown(String label, Resource factor) {
        return Resources.normalizeDown((ResourceCalculator)this.resourceCalculator, (Resource)this.getQueueResourceQuotas().getEffectiveMaxResource(label), (Resource)this.minimumAllocation);
    }

    private void initializeQueueState(QueueState previousState, QueueState configuredState, QueueState parentState) {
        if (configuredState != null && configuredState != QueueState.RUNNING && configuredState != QueueState.STOPPED) {
            throw new IllegalArgumentException("Invalid queue state configuration. We can only use RUNNING or STOPPED.");
        }
        QueueState defaultState = QueueState.RUNNING;
        if (previousState == null) {
            if (parentState == null) {
                this.updateQueueState(configuredState == null ? defaultState : configuredState);
            } else if (configuredState == null) {
                this.updateQueueState(parentState == QueueState.DRAINING ? QueueState.STOPPED : parentState);
            } else {
                if (configuredState == QueueState.RUNNING && parentState != QueueState.RUNNING) {
                    throw new IllegalArgumentException("The parent queue:" + this.parent.getQueuePath() + " cannot be STOPPED as the child queue:" + this.queuePath + " is in RUNNING state.");
                }
                this.updateQueueState(configuredState);
            }
        } else if (previousState == QueueState.RUNNING) {
            if (configuredState == QueueState.STOPPED) {
                this.stopQueue();
            }
        } else if (configuredState == QueueState.RUNNING) {
            try {
                this.activeQueue();
            }
            catch (YarnException ex) {
                throw new IllegalArgumentException(ex.getMessage());
            }
        }
    }

    protected QueueInfo getQueueInfo() {
        QueueInfo queueInfo = (QueueInfo)this.recordFactory.newRecordInstance(QueueInfo.class);
        queueInfo.setQueueName(this.queueName);
        queueInfo.setAccessibleNodeLabels(this.accessibleLabels);
        queueInfo.setCapacity(this.queueCapacities.getCapacity());
        queueInfo.setMaximumCapacity(this.queueCapacities.getMaximumCapacity());
        queueInfo.setQueueState(this.getState());
        queueInfo.setDefaultNodeLabelExpression(this.defaultLabelExpression);
        queueInfo.setCurrentCapacity(this.getUsedCapacity());
        queueInfo.setQueueStatistics(this.getQueueStatistics());
        queueInfo.setPreemptionDisabled(this.preemptionDisabled);
        queueInfo.setIntraQueuePreemptionDisabled(this.getIntraQueuePreemptionDisabled());
        queueInfo.setQueueConfigurations(this.getQueueConfigurations());
        return queueInfo;
    }

    public QueueStatistics getQueueStatistics() {
        QueueStatistics stats = (QueueStatistics)this.recordFactory.newRecordInstance(QueueStatistics.class);
        stats.setNumAppsSubmitted((long)this.getMetrics().getAppsSubmitted());
        stats.setNumAppsRunning((long)this.getMetrics().getAppsRunning());
        stats.setNumAppsPending((long)this.getMetrics().getAppsPending());
        stats.setNumAppsCompleted((long)this.getMetrics().getAppsCompleted());
        stats.setNumAppsKilled((long)this.getMetrics().getAppsKilled());
        stats.setNumAppsFailed((long)this.getMetrics().getAppsFailed());
        stats.setNumActiveUsers((long)this.getMetrics().getActiveUsers());
        stats.setAvailableMemoryMB(this.getMetrics().getAvailableMB());
        stats.setAllocatedMemoryMB(this.getMetrics().getAllocatedMB());
        stats.setPendingMemoryMB(this.getMetrics().getPendingMB());
        stats.setReservedMemoryMB(this.getMetrics().getReservedMB());
        stats.setAvailableVCores((long)this.getMetrics().getAvailableVirtualCores());
        stats.setAllocatedVCores((long)this.getMetrics().getAllocatedVirtualCores());
        stats.setPendingVCores((long)this.getMetrics().getPendingVirtualCores());
        stats.setReservedVCores((long)this.getMetrics().getReservedVirtualCores());
        stats.setPendingContainers((long)this.getMetrics().getPendingContainers());
        stats.setAllocatedContainers((long)this.getMetrics().getAllocatedContainers());
        stats.setReservedContainers((long)this.getMetrics().getReservedContainers());
        return stats;
    }

    public Map<String, QueueConfigurations> getQueueConfigurations() {
        HashMap<String, QueueConfigurations> queueConfigurations = new HashMap<String, QueueConfigurations>();
        Set<String> nodeLabels = this.getNodeLabelsForQueue();
        for (String nodeLabel : nodeLabels) {
            QueueConfigurations queueConfiguration = (QueueConfigurations)this.recordFactory.newRecordInstance(QueueConfigurations.class);
            float capacity = this.queueCapacities.getCapacity(nodeLabel);
            float absoluteCapacity = this.queueCapacities.getAbsoluteCapacity(nodeLabel);
            float maxCapacity = this.queueCapacities.getMaximumCapacity(nodeLabel);
            float absMaxCapacity = this.queueCapacities.getAbsoluteMaximumCapacity(nodeLabel);
            float maxAMPercentage = this.queueCapacities.getMaxAMResourcePercentage(nodeLabel);
            queueConfiguration.setCapacity(capacity);
            queueConfiguration.setAbsoluteCapacity(absoluteCapacity);
            queueConfiguration.setMaxCapacity(maxCapacity);
            queueConfiguration.setAbsoluteMaxCapacity(absMaxCapacity);
            queueConfiguration.setMaxAMPercentage(maxAMPercentage);
            queueConfiguration.setConfiguredMinCapacity(this.queueResourceQuotas.getConfiguredMinResource(nodeLabel));
            queueConfiguration.setConfiguredMaxCapacity(this.queueResourceQuotas.getConfiguredMaxResource(nodeLabel));
            queueConfiguration.setEffectiveMinCapacity(this.queueResourceQuotas.getEffectiveMinResource(nodeLabel));
            queueConfiguration.setEffectiveMaxCapacity(this.queueResourceQuotas.getEffectiveMaxResource(nodeLabel));
            queueConfigurations.put(nodeLabel, queueConfiguration);
        }
        return queueConfigurations;
    }

    @Override
    @InterfaceAudience.Private
    public Resource getMaximumAllocation() {
        return this.maximumAllocation;
    }

    @Override
    @InterfaceAudience.Private
    public Resource getMinimumAllocation() {
        return this.minimumAllocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void allocateResource(Resource clusterResource, Resource resource, String nodePartition) {
        this.writeLock.lock();
        try {
            this.queueUsage.incUsed(nodePartition, resource);
            ++this.numContainers;
            CSQueueUtils.updateQueueStatistics(this.resourceCalculator, clusterResource, this, this.labelManager, nodePartition);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseResource(Resource clusterResource, Resource resource, String nodePartition) {
        this.writeLock.lock();
        try {
            this.queueUsage.decUsed(nodePartition, resource);
            CSQueueUtils.updateQueueStatistics(this.resourceCalculator, clusterResource, this, this.labelManager, nodePartition);
            --this.numContainers;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @InterfaceAudience.Private
    public boolean getReservationContinueLooking() {
        return this.reservationsContinueLooking;
    }

    @InterfaceAudience.Private
    public Map<AccessType, AccessControlList> getACLs() {
        this.readLock.lock();
        try {
            Map<AccessType, AccessControlList> map = this.acls;
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    @InterfaceAudience.Private
    public boolean getPreemptionDisabled() {
        return this.preemptionDisabled;
    }

    @Override
    @InterfaceAudience.Private
    public boolean getIntraQueuePreemptionDisabled() {
        return this.intraQueuePreemptionDisabledInHierarchy || this.preemptionDisabled;
    }

    @Override
    @InterfaceAudience.Private
    public boolean getIntraQueuePreemptionDisabledInHierarchy() {
        return this.intraQueuePreemptionDisabledInHierarchy;
    }

    @Override
    @InterfaceAudience.Private
    public QueueCapacities getQueueCapacities() {
        return this.queueCapacities;
    }

    @Override
    @InterfaceAudience.Private
    public ResourceUsage getQueueResourceUsage() {
        return this.queueUsage;
    }

    @Override
    public QueueResourceQuotas getQueueResourceQuotas() {
        return this.queueResourceQuotas;
    }

    @Override
    public ReentrantReadWriteLock.ReadLock getReadLock() {
        return this.readLock;
    }

    private boolean isQueueHierarchyPreemptionDisabled(CSQueue q, CapacitySchedulerConfiguration configuration) {
        boolean systemWidePreemption = this.csContext.getConfiguration().getBoolean("yarn.resourcemanager.scheduler.monitor.enable", false);
        CSQueue parentQ = q.getParent();
        if (!systemWidePreemption) {
            return true;
        }
        if (parentQ == null) {
            return configuration.getPreemptionDisabled(q.getQueuePath(), false);
        }
        return configuration.getPreemptionDisabled(q.getQueuePath(), parentQ.getPreemptionDisabled());
    }

    private long getInheritedMaxAppLifetime(CSQueue q, CapacitySchedulerConfiguration conf) {
        CSQueue parentQ = q.getParent();
        long maxAppLifetime = conf.getMaximumLifetimePerQueue(q.getQueuePath());
        if (parentQ == null) {
            return maxAppLifetime;
        }
        long parentsMaxAppLifetime = this.getParent().getMaximumApplicationLifetime();
        return maxAppLifetime >= 0L ? maxAppLifetime : parentsMaxAppLifetime;
    }

    private long getInheritedDefaultAppLifetime(CSQueue q, CapacitySchedulerConfiguration conf, long myMaxAppLifetime) {
        CSQueue parentQ = q.getParent();
        long defaultAppLifetime = conf.getDefaultLifetimePerQueue(this.getQueuePath());
        boolean bl = this.defaultAppLifetimeWasSpecifiedInConfig = defaultAppLifetime >= 0L || parentQ != null && parentQ.getDefaultAppLifetimeWasSpecifiedInConfig();
        if (parentQ == null) {
            return defaultAppLifetime;
        }
        long parentsDefaultAppLifetime = this.getParent().getDefaultApplicationLifetime();
        if (defaultAppLifetime < 0L) {
            defaultAppLifetime = this.defaultAppLifetimeWasSpecifiedInConfig ? (parentsDefaultAppLifetime <= myMaxAppLifetime ? parentsDefaultAppLifetime : myMaxAppLifetime) : myMaxAppLifetime;
        }
        return defaultAppLifetime;
    }

    private boolean isIntraQueueHierarchyPreemptionDisabled(CSQueue q, CapacitySchedulerConfiguration configuration) {
        boolean systemWideIntraQueuePreemption = this.csContext.getConfiguration().getBoolean("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.enabled", false);
        if (!systemWideIntraQueuePreemption) {
            return true;
        }
        CSQueue parentQ = q.getParent();
        if (parentQ == null) {
            return configuration.getIntraQueuePreemptionDisabled(q.getQueuePath(), false);
        }
        return configuration.getIntraQueuePreemptionDisabled(q.getQueuePath(), parentQ.getIntraQueuePreemptionDisabledInHierarchy());
    }

    private Resource getCurrentLimitResource(String nodePartition, Resource clusterResource, ResourceLimits currentResourceLimits, SchedulingMode schedulingMode) {
        if (schedulingMode == SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY) {
            Resource queueMaxResource = this.getQueueMaxResource(nodePartition);
            return Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)queueMaxResource, (Resource)currentResourceLimits.getLimit());
        }
        if (schedulingMode == SchedulingMode.IGNORE_PARTITION_EXCLUSIVITY) {
            return this.labelManager.getResourceByLabel(nodePartition, clusterResource);
        }
        return Resources.none();
    }

    Resource getQueueMaxResource(String nodePartition) {
        return this.getEffectiveMaxCapacity(nodePartition);
    }

    public boolean hasChildQueues() {
        List<CSQueue> childQueues = this.getChildQueues();
        return childQueues != null && !childQueues.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canAssignToThisQueue(Resource clusterResource, String nodePartition, ResourceLimits currentResourceLimits, Resource resourceCouldBeUnreserved, SchedulingMode schedulingMode) {
        this.readLock.lock();
        try {
            Resource nowTotalUsed;
            Resource currentLimitResource = this.getCurrentLimitResource(nodePartition, clusterResource, currentResourceLimits, schedulingMode);
            Resource usedExceptKillable = nowTotalUsed = this.queueUsage.getUsed(nodePartition);
            if (this.hasChildQueues()) {
                usedExceptKillable = Resources.subtract((Resource)nowTotalUsed, (Resource)this.getTotalKillableResource(nodePartition));
            }
            currentResourceLimits.setHeadroom(Resources.subtract((Resource)currentLimitResource, (Resource)usedExceptKillable));
            if (Resources.greaterThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)usedExceptKillable, (Resource)currentLimitResource)) {
                Resource newTotalWithoutReservedResource;
                if (this.reservationsContinueLooking && Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)resourceCouldBeUnreserved, (Resource)Resources.none()) && Resources.lessThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)(newTotalWithoutReservedResource = Resources.subtract((Resource)usedExceptKillable, (Resource)resourceCouldBeUnreserved)), (Resource)currentLimitResource)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("try to use reserved: " + this.getQueuePath() + " usedResources: " + this.queueUsage.getUsed() + ", clusterResources: " + clusterResource + ", reservedResources: " + resourceCouldBeUnreserved + ", capacity-without-reserved: " + newTotalWithoutReservedResource + ", maxLimitCapacity: " + currentLimitResource);
                    }
                    boolean bl = true;
                    return bl;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Failed to assign to queue: " + this.getQueuePath() + " nodePatrition: " + nodePartition + ", usedResources: " + this.queueUsage.getUsed(nodePartition) + ", clusterResources: " + clusterResource + ", reservedResources: " + resourceCouldBeUnreserved + ", maxLimitCapacity: " + currentLimitResource + ", currTotalUsed:" + usedExceptKillable);
                }
                boolean bl = false;
                return bl;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Check assign to queue: " + this.getQueuePath() + " nodePartition: " + nodePartition + ", usedResources: " + this.queueUsage.getUsed(nodePartition) + ", clusterResources: " + clusterResource + ", currentUsedCapacity: " + Resources.divide((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)this.queueUsage.getUsed(nodePartition), (Resource)this.labelManager.getResourceByLabel(nodePartition, clusterResource)) + ", max-capacity: " + this.queueCapacities.getAbsoluteMaximumCapacity(nodePartition));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void incReservedResource(String partition, Resource reservedRes) {
        if (partition == null) {
            partition = "";
        }
        this.queueUsage.incReserved(partition, reservedRes);
        if (null != this.parent) {
            this.parent.incReservedResource(partition, reservedRes);
        }
    }

    @Override
    public void decReservedResource(String partition, Resource reservedRes) {
        if (partition == null) {
            partition = "";
        }
        this.queueUsage.decReserved(partition, reservedRes);
        if (null != this.parent) {
            this.parent.decReservedResource(partition, reservedRes);
        }
    }

    @Override
    public void incPendingResource(String nodeLabel, Resource resourceToInc) {
        if (nodeLabel == null) {
            nodeLabel = "";
        }
        this.queueUsage.incPending(nodeLabel, resourceToInc);
        if (null != this.parent) {
            this.parent.incPendingResource(nodeLabel, resourceToInc);
        }
    }

    @Override
    public void decPendingResource(String nodeLabel, Resource resourceToDec) {
        if (nodeLabel == null) {
            nodeLabel = "";
        }
        this.queueUsage.decPending(nodeLabel, resourceToDec);
        if (null != this.parent) {
            this.parent.decPendingResource(nodeLabel, resourceToDec);
        }
    }

    @Override
    public void incUsedResource(String nodeLabel, Resource resourceToInc, SchedulerApplicationAttempt application) {
        if (nodeLabel == null) {
            nodeLabel = "";
        }
        this.queueUsage.incUsed(nodeLabel, resourceToInc);
        CSQueueUtils.updateUsedCapacity(this.resourceCalculator, this.labelManager.getResourceByLabel(nodeLabel, Resources.none()), nodeLabel, this);
        if (null != this.parent) {
            this.parent.incUsedResource(nodeLabel, resourceToInc, null);
        }
    }

    @Override
    public void decUsedResource(String nodeLabel, Resource resourceToDec, SchedulerApplicationAttempt application) {
        if (nodeLabel == null) {
            nodeLabel = "";
        }
        this.queueUsage.decUsed(nodeLabel, resourceToDec);
        CSQueueUtils.updateUsedCapacity(this.resourceCalculator, this.labelManager.getResourceByLabel(nodeLabel, Resources.none()), nodeLabel, this);
        if (null != this.parent) {
            this.parent.decUsedResource(nodeLabel, resourceToDec, null);
        }
    }

    boolean hasPendingResourceRequest(String nodePartition, Resource cluster, SchedulingMode schedulingMode) {
        return SchedulerUtils.hasPendingResourceRequest(this.resourceCalculator, this.queueUsage, nodePartition, cluster, schedulingMode);
    }

    public boolean accessibleToPartition(String nodePartition) {
        if (this.accessibleLabels != null && this.accessibleLabels.contains("*")) {
            return true;
        }
        if (nodePartition == null || nodePartition.equals("")) {
            return true;
        }
        return this.accessibleLabels != null && this.accessibleLabels.contains(nodePartition);
    }

    @Override
    public Priority getDefaultApplicationPriority() {
        return null;
    }

    @Override
    public Set<String> getNodeLabelsForQueue() {
        HashSet<String> nodeLabels = new HashSet<String>();
        if (this.getAccessibleNodeLabels() != null && this.getAccessibleNodeLabels().contains("*")) {
            nodeLabels.addAll((Collection<String>)Sets.union(this.getQueueCapacities().getNodePartitionsSet(), this.getQueueResourceUsage().getNodePartitionsSet()));
        } else {
            nodeLabels.addAll(this.getAccessibleNodeLabels());
        }
        if (!nodeLabels.contains("")) {
            nodeLabels.add("");
        }
        return nodeLabels;
    }

    public Resource getTotalKillableResource(String partition) {
        return this.csContext.getPreemptionManager().getKillableResource(this.getQueuePath(), partition);
    }

    public Iterator<RMContainer> getKillableContainers(String partition) {
        return this.csContext.getPreemptionManager().getKillableContainers(this.getQueuePath(), partition);
    }

    @Override
    @VisibleForTesting
    public CSAssignment assignContainers(Resource clusterResource, FiCaSchedulerNode node, ResourceLimits resourceLimits, SchedulingMode schedulingMode) {
        return this.assignContainers(clusterResource, new SimpleCandidateNodeSet<FiCaSchedulerNode>(node), resourceLimits, schedulingMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accept(Resource cluster, ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> request) {
        boolean checkParentQueue = false;
        ContainerAllocationProposal<FiCaSchedulerApp, FiCaSchedulerNode> allocation = request.getFirstAllocatedOrReservedContainer();
        SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer = allocation.getAllocatedOrReservedContainer();
        if (allocation.getAllocateFromReservedContainer() == null) {
            Resource required = allocation.getAllocatedOrReservedResource();
            Resource netAllocated = Resources.subtract((Resource)required, (Resource)request.getTotalReleasedResource());
            this.readLock.lock();
            try {
                String partition = schedulerContainer.getNodePartition();
                Resource maxResourceLimit = allocation.getSchedulingMode() == SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY ? this.getQueueMaxResource(partition) : this.labelManager.getResourceByLabel(schedulerContainer.getNodePartition(), cluster);
                if (!Resources.fitsIn((ResourceCalculator)this.resourceCalculator, (Resource)Resources.add((Resource)this.queueUsage.getUsed(partition), (Resource)netAllocated), (Resource)maxResourceLimit)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Used resource=" + this.queueUsage.getUsed(partition) + " exceeded maxResourceLimit of the queue =" + maxResourceLimit);
                    }
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.readLock.unlock();
            }
            checkParentQueue = true;
        }
        if (this.parent != null && checkParentQueue) {
            return this.parent.accept(cluster, request);
        }
        return true;
    }

    @Override
    public void validateSubmitApplication(ApplicationId applicationId, String userName, String queue) throws AccessControlException {
    }

    @Override
    public void updateQueueState(QueueState queueState) {
        this.state = queueState;
    }

    @Override
    public void activeQueue() throws YarnException {
        block5: {
            this.writeLock.lock();
            try {
                if (this.getState() == QueueState.RUNNING) {
                    LOG.info("The specified queue:" + this.getQueuePath() + " is already in the RUNNING state.");
                    break block5;
                }
                CSQueue parent = this.getParent();
                if (parent == null || parent.getState() == QueueState.RUNNING) {
                    this.updateQueueState(QueueState.RUNNING);
                    break block5;
                }
                throw new YarnException("The parent Queue:" + parent.getQueuePath() + " is not running. Please activate the parent queue first");
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    protected void appFinished() {
        this.writeLock.lock();
        try {
            if (this.getState() == QueueState.DRAINING && this.getNumApplications() == 0) {
                this.updateQueueState(QueueState.STOPPED);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Priority getPriority() {
        return this.priority;
    }

    @Override
    public Map<String, Float> getUserWeights() {
        return this.userWeights;
    }

    public void recoverDrainingState() {
        this.writeLock.lock();
        try {
            if (this.getState() == QueueState.STOPPED) {
                this.updateQueueState(QueueState.DRAINING);
            }
            LOG.info("Recover draining state for queue " + this.getQueuePath());
            if (this.getParent() != null && this.getParent().getState() == QueueState.STOPPED) {
                ((AbstractCSQueue)this.getParent()).recoverDrainingState();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public String getMultiNodeSortingPolicyName() {
        return this.multiNodeSortingPolicyName;
    }

    public void setMultiNodeSortingPolicyName(String policyName) {
        this.multiNodeSortingPolicyName = policyName;
    }

    @Override
    public long getMaximumApplicationLifetime() {
        return this.maxApplicationLifetime;
    }

    @Override
    public long getDefaultApplicationLifetime() {
        return this.defaultApplicationLifetime;
    }

    @Override
    public boolean getDefaultAppLifetimeWasSpecifiedInConfig() {
        return this.defaultAppLifetimeWasSpecifiedInConfig;
    }

    public void setMaxParallelApps(int maxParallelApps) {
        this.maxParallelApps = maxParallelApps;
    }

    public int getMaxParallelApps() {
        return this.maxParallelApps;
    }

    @Override
    public String getLabel() {
        return null;
    }

    abstract int getNumRunnableApps();

    protected static enum CapacityConfigType {
        NONE,
        PERCENTAGE,
        ABSOLUTE_RESOURCE;

    }
}

