/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.helper.XmlCustomResourceTypeTestCase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.junit.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ResourceRequestsXmlVerifications {
    private final ResourceRequest resourceRequest;
    private final Element requestInfo;
    private final Map<String, Long> customResourceTypes;
    private final List<String> expectedCustomResourceTypes;

    ResourceRequestsXmlVerifications(Builder builder) {
        this.resourceRequest = builder.resourceRequest;
        this.requestInfo = builder.requestInfo;
        this.customResourceTypes = builder.customResourceTypes;
        this.expectedCustomResourceTypes = builder.expectedCustomResourceTypes;
    }

    public static void verifyWithCustomResourceTypes(Element requestInfo, ResourceRequest resourceRequest, List<String> expectedResourceTypes) {
        ResourceRequestsXmlVerifications.createDefaultBuilder(requestInfo, resourceRequest).withExpectedCustomResourceTypes(expectedResourceTypes).withCustomResourceTypes(ResourceRequestsXmlVerifications.extractActualCustomResourceType(requestInfo, expectedResourceTypes)).build().verify();
    }

    private static Builder createDefaultBuilder(Element requestInfo, ResourceRequest resourceRequest) {
        return new Builder().withRequest(resourceRequest).withRequestInfo(requestInfo);
    }

    private static Map<String, Long> extractActualCustomResourceType(Element requestInfo, List<String> expectedResourceTypes) {
        Element capability = (Element)requestInfo.getElementsByTagName("capability").item(0);
        return ResourceRequestsXmlVerifications.extractCustomResorceTypes(capability, Sets.newHashSet(expectedResourceTypes));
    }

    private static Map<String, Long> extractCustomResorceTypes(Element capability, Set<String> expectedResourceTypes) {
        Assert.assertEquals((String)(XmlCustomResourceTypeTestCase.toXml(capability) + " should have only one resourceInformations child!"), (long)1L, (long)capability.getElementsByTagName("resourceInformations").getLength());
        Element resourceInformations = (Element)capability.getElementsByTagName("resourceInformations").item(0);
        NodeList customResources = resourceInformations.getElementsByTagName("resourceInformation");
        Assert.assertEquals((String)"Different number of custom resource types found than expected", (long)expectedResourceTypes.size(), (long)(customResources.getLength() - 2));
        HashMap resourceTypesAndValues = Maps.newHashMap();
        for (int i = 0; i < customResources.getLength(); ++i) {
            Element customResource = (Element)customResources.item(i);
            String name = WebServicesTestUtils.getXmlString((Element)customResource, (String)"name");
            String unit = WebServicesTestUtils.getXmlString((Element)customResource, (String)"units");
            String resourceType = WebServicesTestUtils.getXmlString((Element)customResource, (String)"resourceType");
            Long value = WebServicesTestUtils.getXmlLong((Element)customResource, (String)"value");
            if ("memory-mb".equals(name) || "vcores".equals(name)) continue;
            TestCase.assertTrue((String)("Custom resource type " + name + " not found"), (boolean)expectedResourceTypes.contains(name));
            Assert.assertEquals((Object)"k", (Object)unit);
            Assert.assertEquals((Object)ResourceTypes.COUNTABLE, (Object)ResourceTypes.valueOf((String)resourceType));
            Assert.assertNotNull((String)("Resource value should not be null for resource type " + resourceType + ", listing xml contents: " + XmlCustomResourceTypeTestCase.toXml(customResource)), (Object)value);
            resourceTypesAndValues.put(name, value);
        }
        return resourceTypesAndValues;
    }

    private void verify() {
        Assert.assertEquals((String)"nodeLabelExpression doesn't match", (Object)this.resourceRequest.getNodeLabelExpression(), (Object)WebServicesTestUtils.getXmlString((Element)this.requestInfo, (String)"nodeLabelExpression"));
        Assert.assertEquals((String)"numContainers doesn't match", (long)this.resourceRequest.getNumContainers(), (long)WebServicesTestUtils.getXmlInt((Element)this.requestInfo, (String)"numContainers"));
        Assert.assertEquals((String)"relaxLocality doesn't match", (Object)this.resourceRequest.getRelaxLocality(), (Object)WebServicesTestUtils.getXmlBoolean((Element)this.requestInfo, (String)"relaxLocality"));
        Assert.assertEquals((String)"priority does not match", (long)this.resourceRequest.getPriority().getPriority(), (long)WebServicesTestUtils.getXmlInt((Element)this.requestInfo, (String)"priority"));
        Assert.assertEquals((String)"resourceName does not match", (Object)this.resourceRequest.getResourceName(), (Object)WebServicesTestUtils.getXmlString((Element)this.requestInfo, (String)"resourceName"));
        Element capability = (Element)this.requestInfo.getElementsByTagName("capability").item(0);
        Assert.assertEquals((String)"memory does not match", (long)this.resourceRequest.getCapability().getMemorySize(), (long)WebServicesTestUtils.getXmlLong((Element)capability, (String)"memory"));
        Assert.assertEquals((String)"vCores does not match", (long)this.resourceRequest.getCapability().getVirtualCores(), (long)WebServicesTestUtils.getXmlLong((Element)capability, (String)"vCores"));
        for (String expectedCustomResourceType : this.expectedCustomResourceTypes) {
            TestCase.assertTrue((String)("Custom resource type " + expectedCustomResourceType + " cannot be found!"), (boolean)this.customResourceTypes.containsKey(expectedCustomResourceType));
            Long resourceValue = this.customResourceTypes.get(expectedCustomResourceType);
            Assert.assertNotNull((String)"Resource value should not be null!", (Object)resourceValue);
        }
        Element executionTypeRequest = (Element)this.requestInfo.getElementsByTagName("executionTypeRequest").item(0);
        Assert.assertEquals((String)"executionType does not match", (Object)this.resourceRequest.getExecutionTypeRequest().getExecutionType().name(), (Object)WebServicesTestUtils.getXmlString((Element)executionTypeRequest, (String)"executionType"));
        Assert.assertEquals((String)"enforceExecutionType does not match", (Object)this.resourceRequest.getExecutionTypeRequest().getEnforceExecutionType(), (Object)WebServicesTestUtils.getXmlBoolean((Element)executionTypeRequest, (String)"enforceExecutionType"));
    }

    public static final class Builder {
        private List<String> expectedCustomResourceTypes = Lists.newArrayList();
        private Map<String, Long> customResourceTypes;
        private ResourceRequest resourceRequest;
        private Element requestInfo;

        Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        Builder withExpectedCustomResourceTypes(List<String> expectedCustomResourceTypes) {
            this.expectedCustomResourceTypes = expectedCustomResourceTypes;
            return this;
        }

        Builder withCustomResourceTypes(Map<String, Long> customResourceTypes) {
            this.customResourceTypes = customResourceTypes;
            return this;
        }

        Builder withRequest(ResourceRequest resourceRequest) {
            this.resourceRequest = resourceRequest;
            return this;
        }

        Builder withRequestInfo(Element requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        public ResourceRequestsXmlVerifications build() {
            return new ResourceRequestsXmlVerifications(this);
        }
    }
}

