/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.fairscheduler;

import java.util.List;
import java.util.Set;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.helper.XmlCustomResourceTypeTestCase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FairSchedulerXmlVerifications {
    private static final Set<String> RESOURCE_FIELDS = Sets.newHashSet((Object[])new String[]{"minResources", "amUsedResources", "amMaxResources", "fairResources", "clusterResources", "reservedResources", "maxResources", "usedResources", "steadyFairResources", "demandResources"});
    private final Set<String> customResourceTypes;

    FairSchedulerXmlVerifications(List<String> customResourceTypes) {
        this.customResourceTypes = Sets.newHashSet(customResourceTypes);
    }

    public void verify(Element element) {
        this.verifyResourcesContainDefaultResourceTypes(element, RESOURCE_FIELDS);
        this.verifyResourcesContainCustomResourceTypes(element, RESOURCE_FIELDS);
    }

    private void verifyResourcesContainDefaultResourceTypes(Element queue, Set<String> resourceCategories) {
        for (String resourceCategory : resourceCategories) {
            boolean hasResourceCategory = this.hasChild(queue, resourceCategory);
            Assert.assertTrue((String)("Queue " + queue + " does not have resource category key: " + resourceCategory), (boolean)hasResourceCategory);
            this.verifyResourceContainsDefaultResourceTypes((Element)queue.getElementsByTagName(resourceCategory).item(0));
        }
    }

    private void verifyResourceContainsDefaultResourceTypes(Element element) {
        Object memory = this.opt(element, "memory");
        Object vCores = this.opt(element, "vCores");
        Assert.assertNotNull((String)("Key 'memory' not found in: " + element), (Object)memory);
        Assert.assertNotNull((String)("Key 'vCores' not found in: " + element), (Object)vCores);
    }

    private void verifyResourcesContainCustomResourceTypes(Element queue, Set<String> resourceCategories) {
        for (String resourceCategory : resourceCategories) {
            Assert.assertTrue((String)("Queue " + queue + " does not have key for resourceCategory: " + resourceCategory), (boolean)this.hasChild(queue, resourceCategory));
            this.verifyResourceContainsCustomResourceTypes((Element)queue.getElementsByTagName(resourceCategory).item(0));
        }
    }

    private void verifyResourceContainsCustomResourceTypes(Element resourceCategory) {
        Assert.assertEquals((String)(XmlCustomResourceTypeTestCase.toXml(resourceCategory) + " should have only one resourceInformations child!"), (long)1L, (long)resourceCategory.getElementsByTagName("resourceInformations").getLength());
        Element resourceInformations = (Element)resourceCategory.getElementsByTagName("resourceInformations").item(0);
        NodeList customResources = resourceInformations.getElementsByTagName("resourceInformation");
        Assert.assertEquals((String)"Different number of custom resource types found than expected", (long)this.customResourceTypes.size(), (long)(customResources.getLength() - 2));
        for (int i = 0; i < customResources.getLength(); ++i) {
            Element customResource = (Element)customResources.item(i);
            String name = WebServicesTestUtils.getXmlString((Element)customResource, (String)"name");
            String unit = WebServicesTestUtils.getXmlString((Element)customResource, (String)"units");
            String resourceType = WebServicesTestUtils.getXmlString((Element)customResource, (String)"resourceType");
            Long value = WebServicesTestUtils.getXmlLong((Element)customResource, (String)"value");
            if ("memory-mb".equals(name) || "vcores".equals(name)) continue;
            Assert.assertTrue((String)("Custom resource type " + name + " not found"), (boolean)this.customResourceTypes.contains(name));
            Assert.assertEquals((Object)"k", (Object)unit);
            Assert.assertEquals((Object)ResourceTypes.COUNTABLE, (Object)ResourceTypes.valueOf((String)resourceType));
            Assert.assertNotNull((String)("Resource value should not be null for resource type " + resourceType + ", listing xml contents: " + XmlCustomResourceTypeTestCase.toXml(customResource)), (Object)value);
        }
    }

    private Object opt(Node node, String child) {
        NodeList nodes = this.getElementsByTagNameInternal(node, child);
        if (nodes.getLength() > 0) {
            return nodes.item(0);
        }
        return null;
    }

    private boolean hasChild(Node node, String child) {
        return this.getElementsByTagNameInternal(node, child).getLength() > 0;
    }

    private NodeList getElementsByTagNameInternal(Node node, String child) {
        if (node instanceof Element) {
            return ((Element)node).getElementsByTagName(child);
        }
        if (node instanceof Document) {
            return ((Document)node).getElementsByTagName(child);
        }
        throw new IllegalStateException("Unknown type of wrappedObject: " + node + ", type: " + node.getClass());
    }
}

