/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy;

import java.util.Iterator;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.FifoOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.IteratorSelector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.MockSchedulableEntity;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.SchedulableEntity;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestFifoOrderingPolicy {
    @Test
    public void testFifoOrderingPolicy() {
        FifoOrderingPolicy policy = new FifoOrderingPolicy();
        MockSchedulableEntity r1 = new MockSchedulableEntity();
        MockSchedulableEntity r2 = new MockSchedulableEntity();
        Assertions.assertThat((int)policy.getComparator().compare(r1, r2)).isEqualTo(0);
        r1.setSerial(1L);
        Assertions.assertThat((int)policy.getComparator().compare(r1, r2)).isEqualTo(1);
        r2.setSerial(2L);
        Assertions.assertThat((int)policy.getComparator().compare(r1, r2)).isEqualTo(-1);
    }

    @Test
    public void testIterators() {
        FifoOrderingPolicy schedOrder = new FifoOrderingPolicy();
        MockSchedulableEntity msp1 = new MockSchedulableEntity();
        MockSchedulableEntity msp2 = new MockSchedulableEntity();
        MockSchedulableEntity msp3 = new MockSchedulableEntity();
        msp1.setSerial(3L);
        msp2.setSerial(2L);
        msp3.setSerial(1L);
        schedOrder.addSchedulableEntity((SchedulableEntity)msp1);
        schedOrder.addSchedulableEntity((SchedulableEntity)msp2);
        schedOrder.addSchedulableEntity((SchedulableEntity)msp3);
        this.checkSerials(schedOrder.getAssignmentIterator(IteratorSelector.EMPTY_ITERATOR_SELECTOR), new long[]{1L, 2L, 3L});
        this.checkSerials(schedOrder.getPreemptionIterator(), new long[]{3L, 2L, 1L});
    }

    public void checkSerials(Iterator<MockSchedulableEntity> si, long[] serials) {
        for (int i = 0; i < serials.length; ++i) {
            Assert.assertEquals((long)si.next().getSerial(), (long)serials[i]);
        }
    }

    @Test
    public void testFifoOrderingPolicyAlongWithPriorty() {
        FifoOrderingPolicy policy = new FifoOrderingPolicy();
        MockSchedulableEntity r1 = new MockSchedulableEntity();
        MockSchedulableEntity r2 = new MockSchedulableEntity();
        Priority p1 = Priority.newInstance((int)1);
        Priority p2 = Priority.newInstance((int)0);
        Assert.assertEquals((long)0L, (long)policy.getComparator().compare(r1, r2));
        r2.setApplicationPriority(p2);
        Assert.assertEquals((long)-1L, (long)policy.getComparator().compare(r1, r2));
        r2.setApplicationPriority(null);
        r1.setApplicationPriority(p1);
        Assert.assertEquals((long)1L, (long)policy.getComparator().compare(r1, r2));
        r1.setApplicationPriority(p1);
        r2.setApplicationPriority(p2);
        Assert.assertEquals((long)-1L, (long)policy.getComparator().compare(r1, r2));
    }
}

