/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileWriter;
import org.junit.Assert;

public class FSConfigConverterTestCommons {
    public static final String TEST_DIR = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
    public static final String FS_ALLOC_FILE = new File(TEST_DIR, "test-fair-scheduler.xml").getAbsolutePath();
    public static final String YARN_SITE_XML = new File(TEST_DIR, "test-yarn-site.xml").getAbsolutePath();
    public static final String CONVERSION_RULES_FILE = new File(TEST_DIR, "test-conversion-rules.properties").getAbsolutePath();
    public static final String OUTPUT_DIR = new File(TEST_DIR, "conversion-output").getAbsolutePath();
    private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();
    private final ByteArrayOutputStream errContent = new ByteArrayOutputStream();
    private PrintStream originalOutStream;
    private PrintStream originalErrStream;

    public FSConfigConverterTestCommons() {
        this.saveOriginalStreams();
        this.replaceStreamsWithByteArrays();
    }

    public void setUp() throws IOException {
        File d = new File(TEST_DIR, "conversion-output");
        if (d.exists()) {
            FileUtils.deleteDirectory((File)d);
        }
        boolean success = d.mkdirs();
        Assert.assertTrue((String)("Can't create directory: " + d.getAbsolutePath()), (boolean)success);
    }

    public void tearDown() {
        this.deleteTestFiles();
        this.restoreStreams();
    }

    private void saveOriginalStreams() {
        this.originalOutStream = System.out;
        this.originalErrStream = System.err;
    }

    private void replaceStreamsWithByteArrays() {
        System.setOut(new PrintStream(this.outContent));
        System.setErr(new PrintStream(this.errContent));
    }

    private void restoreStreams() {
        System.setOut(this.originalOutStream);
        System.setErr(this.originalErrStream);
    }

    ByteArrayOutputStream getErrContent() {
        return this.errContent;
    }

    ByteArrayOutputStream getStdOutContent() {
        return this.outContent;
    }

    public void deleteTestFiles() {
        FSConfigConverterTestCommons.deleteFile(FS_ALLOC_FILE, false);
        FSConfigConverterTestCommons.deleteFile(YARN_SITE_XML, false);
        FSConfigConverterTestCommons.deleteFile(CONVERSION_RULES_FILE, false);
        FSConfigConverterTestCommons.deleteFile(OUTPUT_DIR, false);
    }

    private static void deleteFile(String f, boolean strict) {
        boolean delete = new File(f).delete();
        if (strict && !delete) {
            throw new RuntimeException("Can't delete test file: " + f);
        }
    }

    public static void setupFSConfigConversionFiles() throws IOException {
        FSConfigConverterTestCommons.configureFairSchedulerXml();
        FSConfigConverterTestCommons.configureYarnSiteXmlWithFsAllocFileDefined();
        FSConfigConverterTestCommons.configureDummyConversionRulesFile();
    }

    public static void configureFairSchedulerXml() {
        AllocationFileWriter.create().disableQueueMaxAMShareDefault().fairDefaultQueueSchedulingPolicy().addQueue(new AllocationFileQueue.Builder("root").schedulingPolicy("fair").weight(1.0f).fairSharePreemptionTimeout(100).minSharePreemptionTimeout(120).fairSharePreemptionThreshold(0.5).build()).writeToFile(FS_ALLOC_FILE);
    }

    public static void configureEmptyFairSchedulerXml() {
        AllocationFileWriter.create().writeToFile(FS_ALLOC_FILE);
    }

    public static void configureYarnSiteXmlWithFsAllocFileDefined() throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(YARN_SITE_XML));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<property>");
        out.println("<name>yarn.scheduler.fair.allocation.file</name>");
        out.println("<value>" + FS_ALLOC_FILE + "</value>");
        out.println("</property>");
        out.close();
    }

    public static void configureEmptyYarnSiteXml() throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(YARN_SITE_XML));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<property></property>");
        out.close();
    }

    public static void configureDummyConversionRulesFile() throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(CONVERSION_RULES_FILE));
        out.println("dummy_key=dummy_value");
        out.close();
    }

    public static void configureInvalidConversionRulesFile() throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(CONVERSION_RULES_FILE));
        out.println("bla");
        out.close();
    }

    public static void configureEmptyConversionRulesFile() throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(CONVERSION_RULES_FILE));
        out.close();
    }
}

