/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.PlanQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ReservationQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestCapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.QueueEntitlement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCapacitySchedulerDynamicBehavior {
    private static final Logger LOG = LoggerFactory.getLogger(TestCapacitySchedulerDynamicBehavior.class);
    private static final String A = "root.a";
    private static final String B = "root.b";
    private static final String B1 = "root.b.b1";
    private static final String B2 = "root.b.b2";
    private static final String B3 = "root.b.b3";
    private static float A_CAPACITY = 10.5f;
    private static float B_CAPACITY = 89.5f;
    private static float A1_CAPACITY = 30.0f;
    private static float A2_CAPACITY = 70.0f;
    private static float B1_CAPACITY = 79.2f;
    private static float B2_CAPACITY = 0.8f;
    private static float B3_CAPACITY = 20.0f;
    private final TestCapacityScheduler tcs = new TestCapacityScheduler();
    private int GB = 1024;
    private MockRM rm;

    @Before
    public void setUp() {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        this.setupPlanQueueConfiguration(conf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setBoolean("yarn.resourcemanager.reservation-system.enable", false);
        this.rm = new MockRM((Configuration)conf);
        this.rm.start();
    }

    @Test
    public void testRefreshQueuesWithReservations() throws Exception {
        CapacityScheduler cs = (CapacityScheduler)this.rm.getResourceScheduler();
        ((ReservationQueue)cs.getQueue("a-default")).setEntitlement(new QueueEntitlement(0.0f, 1.0f));
        ReservationQueue a1 = new ReservationQueue((CapacitySchedulerContext)cs, "a1", (PlanQueue)cs.getQueue("a"));
        cs.addQueue((Queue)a1);
        a1.setEntitlement(new QueueEntitlement(A1_CAPACITY / 100.0f, 1.0f));
        ReservationQueue a2 = new ReservationQueue((CapacitySchedulerContext)cs, "a2", (PlanQueue)cs.getQueue("a"));
        cs.addQueue((Queue)a2);
        cs.setEntitlement("a2", new QueueEntitlement(A2_CAPACITY / 100.0f, 1.0f));
        this.tcs.checkQueueCapacities(cs, A_CAPACITY, B_CAPACITY);
        CapacitySchedulerConfiguration conf = cs.getConfiguration();
        conf.setCapacity(A, 80.0f);
        conf.setCapacity(B, 20.0f);
        cs.reinitialize((Configuration)conf, this.rm.getRMContext());
        this.tcs.checkQueueCapacities(cs, 80.0f, 20.0f);
    }

    @Test
    public void testAddQueueFailCases() throws Exception {
        ReservationQueue a12;
        CapacityScheduler cs = (CapacityScheduler)this.rm.getResourceScheduler();
        try {
            a12 = new ReservationQueue((CapacitySchedulerContext)cs, "a1", (PlanQueue)cs.getQueue("a"));
            a12.setEntitlement(new QueueEntitlement(A1_CAPACITY / 100.0f, 1.0f));
            cs.addQueue((Queue)a12);
            Assert.fail();
        }
        catch (Exception a12) {
            // empty catch block
        }
        a12 = new ReservationQueue((CapacitySchedulerContext)cs, "a1", (PlanQueue)cs.getQueue("a"));
        cs.addQueue((Queue)a12);
        ((ReservationQueue)cs.getQueue("a-default")).setEntitlement(new QueueEntitlement(0.0f, 1.0f));
        a12.setEntitlement(new QueueEntitlement(A1_CAPACITY / 100.0f, 1.0f));
        ReservationQueue a2 = new ReservationQueue((CapacitySchedulerContext)cs, "a2", (PlanQueue)cs.getQueue("a"));
        cs.addQueue((Queue)a2);
        try {
            cs.setEntitlement("a2", new QueueEntitlement(A2_CAPACITY / 100.0f + 0.1f, 1.0f));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        cs.setEntitlement("a2", new QueueEntitlement(A2_CAPACITY / 100.0f, 1.0f));
        this.tcs.checkQueueCapacities(cs, A_CAPACITY, B_CAPACITY);
        cs.stop();
    }

    @Test
    public void testRemoveQueue() throws Exception {
        CapacityScheduler cs = (CapacityScheduler)this.rm.getResourceScheduler();
        ReservationQueue a1 = new ReservationQueue((CapacitySchedulerContext)cs, "a1", (PlanQueue)cs.getQueue("a"));
        cs.addQueue((Queue)a1);
        a1.setEntitlement(new QueueEntitlement(A1_CAPACITY / 100.0f, 1.0f));
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(this.GB, this.rm).withAppName("test-move-1").withUser("user_0").withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app = MockRMAppSubmitter.submit(this.rm, data);
        List appsInA1 = cs.getAppsInQueue("a1");
        Assert.assertEquals((long)1L, (long)appsInA1.size());
        try {
            cs.removeQueue("a1");
            Assert.fail();
        }
        catch (SchedulerDynamicEditException schedulerDynamicEditException) {
            // empty catch block
        }
        cs.killAllAppsInQueue("a1");
        this.rm.waitForState(app.getApplicationId(), RMAppState.KILLED);
        try {
            cs.removeQueue("a1");
            Assert.fail();
        }
        catch (SchedulerDynamicEditException schedulerDynamicEditException) {
            // empty catch block
        }
        cs.setEntitlement("a1", new QueueEntitlement(0.0f, 0.0f));
        cs.removeQueue("a1");
        Assert.assertTrue((cs.getQueue("a1") == null ? 1 : 0) != 0);
        this.rm.stop();
    }

    @Test
    public void testMoveAppToPlanQueue() throws Exception {
        CapacityScheduler scheduler = (CapacityScheduler)this.rm.getResourceScheduler();
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(this.GB, this.rm).withAppName("test-move-1").withUser("user_0").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
        RMApp app = MockRMAppSubmitter.submit(this.rm, data);
        ApplicationAttemptId appAttemptId = this.rm.getApplicationReport(app.getApplicationId()).getCurrentApplicationAttemptId();
        List appsInB1 = scheduler.getAppsInQueue("b1");
        Assert.assertEquals((long)1L, (long)appsInB1.size());
        List appsInB = scheduler.getAppsInQueue("b");
        Assert.assertEquals((long)1L, (long)appsInB.size());
        Assert.assertTrue((boolean)appsInB.contains(appAttemptId));
        List appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.isEmpty());
        String queue = scheduler.getApplicationAttempt((ApplicationAttemptId)appsInB1.get(0)).getQueue().getQueueName();
        Assert.assertEquals((Object)"b1", (Object)queue);
        List appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInRoot.size());
        String defQName = "a-default";
        ReservationQueue defQ = new ReservationQueue((CapacitySchedulerContext)scheduler, defQName, (PlanQueue)scheduler.getQueue("a"));
        scheduler.addQueue((Queue)defQ);
        defQ.setEntitlement(new QueueEntitlement(1.0f, 1.0f));
        List appsInDefQ = scheduler.getAppsInQueue(defQName);
        Assert.assertTrue((boolean)appsInDefQ.isEmpty());
        scheduler.moveApplication(app.getApplicationId(), "a");
        appsInDefQ = scheduler.getAppsInQueue(defQName);
        Assert.assertEquals((long)1L, (long)appsInDefQ.size());
        queue = scheduler.getApplicationAttempt((ApplicationAttemptId)appsInDefQ.get(0)).getQueue().getQueueName();
        Assert.assertTrue((boolean)queue.equals(defQName));
        appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInA.size());
        appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInRoot.size());
        appsInB1 = scheduler.getAppsInQueue("b1");
        Assert.assertTrue((boolean)appsInB1.isEmpty());
        appsInB = scheduler.getAppsInQueue("b");
        Assert.assertTrue((boolean)appsInB.isEmpty());
        this.rm.stop();
    }

    private void setupPlanQueueConfiguration(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{"a", "b"});
        conf.setCapacity(A, A_CAPACITY);
        conf.setCapacity(B, B_CAPACITY);
        conf.setQueues(B, new String[]{"b1", "b2", "b3"});
        conf.setCapacity(B1, B1_CAPACITY);
        conf.setUserLimitFactor(B1, 100.0f);
        conf.setCapacity(B2, B2_CAPACITY);
        conf.setUserLimitFactor(B2, 100.0f);
        conf.setCapacity(B3, B3_CAPACITY);
        conf.setUserLimitFactor(B3, 100.0f);
        conf.setReservable(A, true);
        conf.setReservationWindow(A, 86400000L);
        conf.setAverageCapacity(A, 1.0f);
        LOG.info("Setup a as a plan queue");
    }
}

