/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.TestQueueMetrics;
import org.mockito.Mockito;

public final class QueueInfo {
    private final QueueInfo parentQueueInfo;
    private final Queue queue;
    final QueueMetrics queueMetrics;
    final MetricsSource queueSource;
    final MetricsSource userSource;

    public QueueInfo(QueueInfo parent, String queueName, MetricsSystem ms, Configuration conf, String user) {
        Queue parentQueue = parent == null ? null : parent.queue;
        this.parentQueueInfo = parent;
        this.queueMetrics = QueueMetrics.forQueue((MetricsSystem)ms, (String)queueName, (Queue)parentQueue, (boolean)true, (Configuration)conf);
        this.queue = (Queue)Mockito.mock(Queue.class);
        Mockito.when((Object)this.queue.getMetrics()).thenReturn((Object)this.queueMetrics);
        this.queueSource = ms.getSource(QueueMetrics.sourceName((String)queueName).toString());
        this.queueMetrics.getUserMetrics(user);
        this.userSource = TestQueueMetrics.userSource(ms, queueName, user);
    }

    public QueueInfo getRoot() {
        QueueInfo root = this;
        while (root.parentQueueInfo != null) {
            root = root.parentQueueInfo;
        }
        return root;
    }

    public void checkAllQueueSources(Consumer<MetricsSource> consumer) {
        this.checkQueueSourcesRecursive(this, consumer);
    }

    private void checkQueueSourcesRecursive(QueueInfo queueInfo, Consumer<MetricsSource> consumer) {
        consumer.accept(queueInfo.queueSource);
        if (queueInfo.parentQueueInfo != null) {
            this.checkQueueSourcesRecursive(queueInfo.parentQueueInfo, consumer);
        }
    }

    public void checkAllQueueMetrics(Consumer<QueueMetrics> consumer) {
        this.checkAllQueueMetricsRecursive(this, consumer);
    }

    private void checkAllQueueMetricsRecursive(QueueInfo queueInfo, Consumer<QueueMetrics> consumer) {
        consumer.accept(queueInfo.queueMetrics);
        if (queueInfo.parentQueueInfo != null) {
            this.checkAllQueueMetricsRecursive(queueInfo.parentQueueInfo, consumer);
        }
    }
}

