/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.utils.Lists;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.NullGroupsMapping;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueueMapping;
import org.apache.hadoop.yarn.server.resourcemanager.placement.UserGroupMappingPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.PrimaryGroupMapping;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SimpleGroupsMapping;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUserGroupMappingPlacementRule {
    private static final Logger LOG = LoggerFactory.getLogger(TestUserGroupMappingPlacementRule.class);
    YarnConfiguration conf = new YarnConfiguration();

    @Before
    public void setup() {
        this.conf.setClass("hadoop.security.group.mapping", SimpleGroupsMapping.class, GroupMappingServiceProvider.class);
    }

    private void verifyQueueMapping(QueueMappingTestData queueMappingTestData) throws YarnException {
        QueueMapping queueMapping = queueMappingTestData.queueMapping;
        String inputUser = queueMappingTestData.inputUser;
        String inputQueue = queueMappingTestData.inputQueue;
        String expectedQueue = queueMappingTestData.expectedQueue;
        boolean overwrite = queueMappingTestData.overwrite;
        String expectedParentQueue = queueMappingTestData.expectedParentQueue;
        Groups groups = new Groups((Configuration)this.conf);
        UserGroupMappingPlacementRule rule = new UserGroupMappingPlacementRule(overwrite, Arrays.asList(queueMapping), groups);
        CapacitySchedulerQueueManager queueManager = (CapacitySchedulerQueueManager)Mockito.mock(CapacitySchedulerQueueManager.class);
        MockQueueHierarchyBuilder.create().withQueueManager(queueManager).withQueue("root.agroup.a").withQueue("root.asubgroup2").withQueue("root.bsubgroup2.b").withQueue("root.users.primarygrouponly").withQueue("root.admins.primarygrouponly").withManagedParentQueue("root.managedParent").build();
        Mockito.when((Object)queueManager.getQueue((String)Mockito.isNull())).thenReturn(null);
        Mockito.when((Object)queueManager.isAmbiguous("primarygrouponly")).thenReturn((Object)true);
        rule.setQueueManager(queueManager);
        ApplicationSubmissionContext asc = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        asc.setQueue(inputQueue);
        ApplicationPlacementContext ctx = rule.getPlacementForApp(asc, inputUser);
        Assert.assertEquals((String)"Queue", (Object)expectedQueue, (Object)(ctx != null ? ctx.getQueue() : inputQueue));
        if (expectedParentQueue != null) {
            Assert.assertEquals((String)"Parent Queue", (Object)expectedParentQueue, (Object)ctx.getParentQueue());
        }
    }

    @Test
    public void testSecondaryGroupMapping() throws YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%secondary_group").build()).inputUser("a").expectedQueue("asubgroup2").expectedParentQueue("root").build());
        this.conf.setClass("hadoop.security.group.mapping", PrimaryGroupMapping.class, GroupMappingServiceProvider.class);
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%secondary_group").build()).inputUser("a").expectedQueue("default").build());
    }

    @Test
    public void testNullGroupMapping() throws YarnException {
        this.conf.setClass("hadoop.security.group.mapping", NullGroupsMapping.class, GroupMappingServiceProvider.class);
        try {
            this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%secondary_group").build()).inputUser("a").expectedQueue("default").build());
            Assert.fail((String)"No Groups for user 'a'");
        }
        catch (YarnException yarnException) {
            // empty catch block
        }
    }

    @Test
    public void testMapping() throws YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("a").queue("a").build()).inputUser("a").expectedQueue("a").build());
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.GROUP).source("agroup").queue("a").build()).inputUser("a").expectedQueue("a").build());
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("b").build()).inputUser("a").expectedQueue("b").build());
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%user").build()).inputUser("a").expectedQueue("a").build());
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%primary_group").build()).inputUser("a").expectedQueue("agroup").expectedParentQueue("root").build());
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%user").parentQueue("%primary_group").build()).inputUser("a").expectedQueue("a").expectedParentQueue("root.agroup").build());
    }

    @Test
    public void testUserMappingToPrimaryGroupInvalidNestedPlaceholder() throws YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%random").parentQueue("%primary_group").build()).inputUser("a").expectedQueue("default").build());
    }

    @Test
    public void testUserMappingToSecondaryGroupInvalidNestedPlaceholder() throws YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%random").parentQueue("%secondary_group").build()).inputUser("a").expectedQueue("default").build());
    }

    @Test
    public void testUserMappingDiffersFromSubmitterQueueDoesNotExist() throws YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("a").queue("%random").build()).inputUser("xyz").expectedQueue("default").build());
    }

    @Test
    public void testSpecificUserMappingToPrimaryGroup() throws YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("a").queue("%primary_group").build()).inputUser("a").expectedQueue("agroup").build());
    }

    @Test
    public void testSpecificUserMappingToSecondaryGroup() throws YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("a").queue("%secondary_group").build()).inputUser("a").expectedQueue("asubgroup2").build());
    }

    @Test
    public void testSpecificUserMappingWithNoSecondaryGroup() throws YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("nosecondarygroupuser").queue("%secondary_group").build()).inputUser("nosecondarygroupuser").expectedQueue("default").build());
    }

    @Test
    public void testGenericUserMappingWithNoSecondaryGroup() throws YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%user").parentQueue("%secondary_group").build()).inputUser("nosecondarygroupuser").expectedQueue("default").build());
    }

    @Test(expected=YarnException.class)
    public void testUserMappingToNestedUserPrimaryGroupWithAmbiguousQueues() throws YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%user").parentQueue("%primary_group").build()).inputUser("nosecondarygroupuser").build());
    }

    @Test(expected=YarnException.class)
    public void testResolvedQueueIsNotManaged() throws YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%user").parentQueue("%primary_group").build()).inputUser("admins").build());
    }

    @Test(expected=YarnException.class)
    public void testUserMappingToPrimaryGroupWithAmbiguousQueues() throws YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%primary_group").build()).inputUser("nosecondarygroupuser").expectedQueue("default").build());
    }

    @Test
    public void testUserMappingToQueueNamedAsUsernameWithSecondaryGroupAsParentQueue() throws YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%user").parentQueue("%secondary_group").build()).inputUser("b").expectedQueue("b").expectedParentQueue("root.bsubgroup2").build());
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.GROUP).source("asubgroup1").queue("a").build()).inputUser("a").expectedQueue("a").build());
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%primary_group").parentQueue("root").build()).inputUser("a").expectedQueue("agroup").expectedParentQueue("root").build());
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%primary_group").parentQueue("bsubgroup2").build()).inputUser("abc").expectedQueue("default").build());
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%primary_group").parentQueue("managedParent").build()).inputUser("abc").expectedQueue("abcgroup").expectedParentQueue("root.managedParent").build());
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%secondary_group").parentQueue("bsubgroup2").build()).inputUser("abc").expectedQueue("default").build());
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%secondary_group").parentQueue("root").build()).inputUser("a").expectedQueue("asubgroup2").expectedParentQueue("root").build());
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("user").queue("a").build()).inputUser("user").inputQueue("b").expectedQueue("a").overwrite(true).build());
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("user").queue("a").build()).inputUser("user").inputQueue("b").expectedQueue("b").build());
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.GROUP).source("usergroup").queue("%user").parentQueue("usergroup").build()).inputUser("user").inputQueue("a").expectedQueue("a").build());
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.GROUP).source("usergroup").queue("b").parentQueue("root.bsubgroup2").build()).inputUser("user").inputQueue("a").expectedQueue("b").overwrite(true).build());
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.GROUP).source("agroup").queue("%user").parentQueue("root.agroup").build()).inputUser("a").expectedQueue("a").build());
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.GROUP).source("agroup").queue("%user").build()).inputUser("a").expectedQueue("a").build());
    }

    public static final class QueueMappingTestData {
        private QueueMapping queueMapping;
        private String inputUser;
        private String inputQueue;
        private String expectedQueue;
        private boolean overwrite;
        private String expectedParentQueue;

        private QueueMappingTestData(QueueMappingTestDataBuilder builder) {
            this.queueMapping = builder.queueMapping;
            this.inputUser = builder.inputUser;
            this.inputQueue = builder.inputQueue;
            this.expectedQueue = builder.expectedQueue;
            this.overwrite = builder.overwrite;
            this.expectedParentQueue = builder.expectedParentQueue;
        }

        public static class QueueMappingTestDataBuilder {
            private QueueMapping queueMapping = null;
            private String inputUser = null;
            private String inputQueue = "default";
            private String expectedQueue = null;
            private boolean overwrite = false;
            private String expectedParentQueue = null;

            public static QueueMappingTestDataBuilder create() {
                return new QueueMappingTestDataBuilder();
            }

            public QueueMappingTestDataBuilder queueMapping(QueueMapping mapping) {
                this.queueMapping = mapping;
                return this;
            }

            public QueueMappingTestDataBuilder inputUser(String user) {
                this.inputUser = user;
                return this;
            }

            public QueueMappingTestDataBuilder inputQueue(String queue) {
                this.inputQueue = queue;
                return this;
            }

            public QueueMappingTestDataBuilder expectedQueue(String outputQueue) {
                this.expectedQueue = outputQueue;
                return this;
            }

            public QueueMappingTestDataBuilder overwrite(boolean overwriteMappings) {
                this.overwrite = overwriteMappings;
                return this;
            }

            public QueueMappingTestDataBuilder expectedParentQueue(String outputParentQueue) {
                this.expectedParentQueue = outputParentQueue;
                return this;
            }

            public QueueMappingTestData build() {
                return new QueueMappingTestData(this);
            }
        }
    }

    private static class MockQueueHierarchyBuilder {
        private static final String ROOT = "root";
        private static final String QUEUE_SEP = ".";
        private List<String> queuePaths = Lists.newArrayList();
        private List<String> managedParentQueues = Lists.newArrayList();
        private CapacitySchedulerQueueManager queueManager;

        private MockQueueHierarchyBuilder() {
        }

        public static MockQueueHierarchyBuilder create() {
            return new MockQueueHierarchyBuilder();
        }

        public MockQueueHierarchyBuilder withQueueManager(CapacitySchedulerQueueManager queueManager) {
            this.queueManager = queueManager;
            return this;
        }

        public MockQueueHierarchyBuilder withQueue(String queue) {
            this.queuePaths.add(queue);
            return this;
        }

        public MockQueueHierarchyBuilder withManagedParentQueue(String managedQueue) {
            this.managedParentQueues.add(managedQueue);
            return this;
        }

        public void build() {
            if (this.queueManager == null) {
                throw new IllegalStateException("QueueManager instance is not provided!");
            }
            for (String managedParentQueue : this.managedParentQueues) {
                if (!this.queuePaths.contains(managedParentQueue)) {
                    this.queuePaths.add(managedParentQueue);
                    continue;
                }
                throw new IllegalStateException("Cannot add a managed parent and a simple queue with the same path");
            }
            HashMap queues = Maps.newHashMap();
            for (String queuePath : this.queuePaths) {
                LOG.info("Processing queue path: " + queuePath);
                this.addQueues(queues, queuePath);
            }
        }

        private void addQueues(Map<String, AbstractCSQueue> queues, String queuePath) {
            String[] pathComponents = queuePath.split("\\.");
            String currentQueuePath = "";
            for (int i = 0; i < pathComponents.length; ++i) {
                boolean isLeaf = i == pathComponents.length - 1;
                String queueName = pathComponents[i];
                String parentPath = currentQueuePath;
                currentQueuePath = currentQueuePath + (currentQueuePath.equals("") ? queueName : QUEUE_SEP + queueName);
                if (this.managedParentQueues.contains(parentPath) && !isLeaf) {
                    throw new IllegalStateException("Cannot add a queue under managed parent");
                }
                if (queues.containsKey(currentQueuePath)) continue;
                ParentQueue parentQueue = (ParentQueue)queues.get(parentPath);
                AbstractCSQueue queue = this.createQueue(parentQueue, queueName, currentQueuePath, isLeaf);
                queues.put(currentQueuePath, queue);
            }
        }

        private AbstractCSQueue createQueue(ParentQueue parentQueue, String queueName, String currentQueuePath, boolean isLeaf) {
            if (queueName.equals(ROOT)) {
                return this.createRootQueue(ROOT);
            }
            if (this.managedParentQueues.contains(currentQueuePath)) {
                return this.addManagedParentQueueAsChildOf(parentQueue, queueName);
            }
            if (isLeaf) {
                return this.addLeafQueueAsChildOf(parentQueue, queueName);
            }
            return this.addParentQueueAsChildOf(parentQueue, queueName);
        }

        private AbstractCSQueue createRootQueue(String rootQueueName) {
            ParentQueue root = (ParentQueue)Mockito.mock(ParentQueue.class);
            Mockito.when((Object)root.getQueuePath()).thenReturn((Object)rootQueueName);
            Mockito.when((Object)this.queueManager.getQueue(rootQueueName)).thenReturn((Object)root);
            Mockito.when((Object)this.queueManager.getQueueByFullName(rootQueueName)).thenReturn((Object)root);
            return root;
        }

        private AbstractCSQueue addParentQueueAsChildOf(ParentQueue parent, String queueName) {
            ParentQueue queue = (ParentQueue)Mockito.mock(ParentQueue.class);
            this.setQueueFields(parent, (AbstractCSQueue)queue, queueName);
            return queue;
        }

        private AbstractCSQueue addManagedParentQueueAsChildOf(ParentQueue parent, String queueName) {
            ManagedParentQueue queue = (ManagedParentQueue)Mockito.mock(ManagedParentQueue.class);
            this.setQueueFields(parent, (AbstractCSQueue)queue, queueName);
            return queue;
        }

        private AbstractCSQueue addLeafQueueAsChildOf(ParentQueue parent, String queueName) {
            LeafQueue queue = (LeafQueue)Mockito.mock(LeafQueue.class);
            this.setQueueFields(parent, (AbstractCSQueue)queue, queueName);
            return queue;
        }

        private void setQueueFields(ParentQueue parent, AbstractCSQueue newQueue, String queueName) {
            String fullPathOfQueue = parent.getQueuePath() + QUEUE_SEP + queueName;
            this.addQueueToQueueManager(queueName, newQueue, fullPathOfQueue);
            Mockito.when((Object)newQueue.getParent()).thenReturn((Object)parent);
            Mockito.when((Object)newQueue.getQueuePath()).thenReturn((Object)fullPathOfQueue);
            Mockito.when((Object)newQueue.getQueueName()).thenReturn((Object)queueName);
        }

        private void addQueueToQueueManager(String queueName, AbstractCSQueue queue, String fullPathOfQueue) {
            Mockito.when((Object)this.queueManager.getQueue(queueName)).thenReturn((Object)queue);
            Mockito.when((Object)this.queueManager.getQueue(fullPathOfQueue)).thenReturn((Object)queue);
            Mockito.when((Object)this.queueManager.getQueueByFullName(fullPathOfQueue)).thenReturn((Object)queue);
        }
    }
}

