/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.InvalidApplicationMasterRequestException;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.ParameterizedSchedulerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.event.Level;

public class TestWorkPreservingUnmanagedAM
extends ParameterizedSchedulerTestBase {
    private YarnConfiguration conf;

    public TestWorkPreservingUnmanagedAM(ParameterizedSchedulerTestBase.SchedulerType type) throws IOException {
        super(type);
    }

    @Before
    public void setup() {
        GenericTestUtils.setRootLogLevel((Level)Level.DEBUG);
        this.conf = this.getConf();
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
    }

    protected void testUAMRestart(boolean keepContainers) throws Exception {
        MockRM rm = new MockRM();
        rm.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 15120, rm.getResourceTrackerService());
        nm.registerNode();
        boolean unamanged = true;
        int maxAttempts = 1;
        boolean waitForAccepted = true;
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(200L, rm).withAppName("").withUser(UserGroupInformation.getCurrentUser().getShortUserName()).withAcls(null).withUnmanagedAM(unamanged).withQueue(null).withMaxAppAttempts(maxAttempts).withCredentials(null).withAppType(null).withWaitForAppAcceptedState(waitForAccepted).withKeepContainers(keepContainers).build();
        RMApp app = MockRMAppSubmitter.submit(rm, data);
        MockAM am = MockRM.launchUAM(app, rm, nm);
        am.registerAppAttempt();
        int numContainers = 3;
        List conts = am.allocate("127.0.0.1", 1000, numContainers, new ArrayList<ContainerId>()).getAllocatedContainers();
        while (conts.size() < numContainers) {
            nm.nodeHeartbeat(true);
            conts.addAll(am.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
            Thread.sleep(100L);
        }
        List<ContainerId> releaseList = Collections.singletonList(((Container)conts.get(0)).getId());
        List finishedConts = am.allocate(new ArrayList<ResourceRequest>(), releaseList).getCompletedContainersStatuses();
        while (finishedConts.size() < releaseList.size()) {
            nm.nodeHeartbeat(true);
            finishedConts.addAll(am.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getCompletedContainersStatuses());
            Thread.sleep(100L);
        }
        RegisterApplicationMasterResponse response = null;
        try {
            response = am.registerAppAttempt(false);
        }
        catch (InvalidApplicationMasterRequestException e) {
            Assert.assertEquals((Object)false, (Object)keepContainers);
            return;
        }
        Assert.assertEquals((String)"RM should not allow second register for UAM without keep container flag ", (Object)true, (Object)keepContainers);
        Assert.assertEquals((long)2L, (long)response.getContainersFromPreviousAttempts().size());
        Assert.assertEquals((long)1L, (long)response.getNMTokensFromPreviousAttempts().size());
        numContainers = 1;
        am.allocate("127.0.0.1", 1000, numContainers, new ArrayList<ContainerId>());
        nm.nodeHeartbeat(true);
        conts = am.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        while (conts.size() < numContainers) {
            nm.nodeHeartbeat(true);
            conts.addAll(am.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
            Thread.sleep(100L);
        }
        rm.stop();
    }

    @Test(timeout=600000L)
    public void testUAMRestartKeepContainers() throws Exception {
        this.testUAMRestart(true);
    }

    @Test(timeout=600000L)
    public void testUAMRestartNoKeepContainers() throws Exception {
        this.testUAMRestart(false);
    }
}

