/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.TestRpcBase;
import org.apache.hadoop.ipc.protobuf.TestProtos;
import org.apache.hadoop.ipc.protobuf.TestRpcServiceProtos;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.thirdparty.protobuf.BlockingService;
import org.apache.hadoop.thirdparty.protobuf.RpcController;
import org.apache.hadoop.thirdparty.protobuf.ServiceException;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRMAuditLogger {
    private static final String USER = "test";
    private static final String OPERATION = "oper";
    private static final String TARGET = "tgt";
    private static final String PERM = "admin group";
    private static final String DESC = "description of an audit log";
    private static final String QUEUE = "root";
    private static final ApplicationId APPID = (ApplicationId)Mockito.mock(ApplicationId.class);
    private static final ApplicationAttemptId ATTEMPTID = (ApplicationAttemptId)Mockito.mock(ApplicationAttemptId.class);
    private static final ContainerId CONTAINERID = (ContainerId)Mockito.mock(ContainerId.class);
    private static final Resource RESOURCE = (Resource)Mockito.mock(Resource.class);
    private static final String CALLER_CONTEXT = "context";
    private static final byte[] CALLER_SIGNATURE = "signature".getBytes();
    private static final String PARTITION = "label1";

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)APPID.toString()).thenReturn((Object)"app_1");
        Mockito.when((Object)ATTEMPTID.toString()).thenReturn((Object)"app_attempt_1");
        Mockito.when((Object)CONTAINERID.toString()).thenReturn((Object)"container_1");
        Mockito.when((Object)RESOURCE.toString()).thenReturn((Object)"<memory:1536, vcores:1>");
    }

    @Test
    public void testKeyValLogFormat() throws Exception {
        StringBuilder actLog = new StringBuilder();
        StringBuilder expLog = new StringBuilder();
        RMAuditLogger.start((RMAuditLogger.Keys)RMAuditLogger.Keys.USER, (String)USER, (StringBuilder)actLog);
        expLog.append("USER=test");
        Assert.assertEquals((Object)expLog.toString(), (Object)actLog.toString());
        RMAuditLogger.add((RMAuditLogger.Keys)RMAuditLogger.Keys.OPERATION, (String)OPERATION, (StringBuilder)actLog);
        expLog.append("\tOPERATION=oper");
        Assert.assertEquals((Object)expLog.toString(), (Object)actLog.toString());
        RMAuditLogger.add((RMAuditLogger.Keys)RMAuditLogger.Keys.APPID, (String)null, (StringBuilder)actLog);
        expLog.append("\tAPPID=null");
        Assert.assertEquals((Object)expLog.toString(), (Object)actLog.toString());
        RMAuditLogger.add((RMAuditLogger.Keys)RMAuditLogger.Keys.TARGET, (String)TARGET, (StringBuilder)actLog);
        expLog.append("\tTARGET=tgt");
        Assert.assertEquals((Object)expLog.toString(), (Object)actLog.toString());
    }

    private void testSuccessLogFormatHelper(boolean checkIP, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId) {
        this.testSuccessLogFormatHelper(checkIP, appId, attemptId, containerId, null, null);
    }

    private void testSuccessLogFormatHelper(boolean checkIP, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId, CallerContext callerContext, Resource resource) {
        this.testSuccessLogFormatHelper(checkIP, appId, attemptId, containerId, callerContext, resource, Server.getRemoteIp());
    }

    private void testSuccessLogFormatHelper(boolean checkIP, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId, CallerContext callerContext, Resource resource, InetAddress remoteIp) {
        this.testSuccessLogFormatHelper(checkIP, appId, attemptId, containerId, callerContext, resource, remoteIp, null);
    }

    private void testSuccessLogFormatHelper(boolean checkIP, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId, CallerContext callerContext, Resource resource, InetAddress remoteIp, RMAuditLogger.ArgsBuilder args) {
        this.testSuccessLogFormatHelper(checkIP, appId, attemptId, containerId, callerContext, resource, remoteIp, args, null, null);
    }

    private void testSuccessLogFormatHelper(boolean checkIP, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId, CallerContext callerContext, Resource resource, InetAddress remoteIp, RMAuditLogger.ArgsBuilder args, String queueName, String partition) {
        InetAddress tmpIp = checkIP ? remoteIp : null;
        String sLog = args != null ? RMAuditLogger.createSuccessLog((String)USER, (String)OPERATION, (String)TARGET, (InetAddress)tmpIp, (RMAuditLogger.ArgsBuilder)args) : RMAuditLogger.createSuccessLog((String)USER, (String)OPERATION, (String)TARGET, (ApplicationId)appId, (ApplicationAttemptId)attemptId, (ContainerId)containerId, (Resource)resource, (CallerContext)callerContext, (InetAddress)tmpIp, (String)queueName, (String)partition);
        StringBuilder expLog = new StringBuilder();
        expLog.append("USER=test\t");
        if (checkIP) {
            InetAddress ip = remoteIp != null ? remoteIp : Server.getRemoteIp();
            expLog.append(RMAuditLogger.Keys.IP.name() + "=" + ip.getHostAddress() + "\t");
        }
        expLog.append("OPERATION=oper\tTARGET=tgt\tRESULT=SUCCESS");
        if (appId != null) {
            expLog.append("\tAPPID=app_1");
        }
        if (attemptId != null) {
            expLog.append("\tAPPATTEMPTID=app_attempt_1");
        }
        if (containerId != null) {
            expLog.append("\tCONTAINERID=container_1");
        }
        if (resource != null) {
            expLog.append("\tRESOURCE=<memory:1536, vcores:1>");
        }
        if (callerContext != null) {
            if (callerContext.getContext() != null) {
                expLog.append("\tCALLERCONTEXT=context");
            }
            if (callerContext.getSignature() != null) {
                expLog.append("\tCALLERSIGNATURE=signature");
            }
        }
        if (args != null) {
            expLog.append("\tQUEUENAME=root");
            expLog.append("\tRECURSIVE=true");
        } else if (queueName != null) {
            expLog.append("\tQUEUENAME=root");
        }
        if (partition != null) {
            expLog.append("\tNODELABEL=label1");
        }
        Assert.assertEquals((Object)expLog.toString(), (Object)sLog);
    }

    private void testSuccessLogFormatHelperWithIP(boolean checkIP, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId, InetAddress ip) {
        this.testSuccessLogFormatHelper(checkIP, appId, attemptId, containerId, null, null, ip);
    }

    private void testSuccessLogNulls(boolean checkIP) {
        String sLog = RMAuditLogger.createSuccessLog(null, null, null, null, null, null, null);
        StringBuilder expLog = new StringBuilder();
        expLog.append("USER=null\t");
        if (checkIP) {
            InetAddress ip = Server.getRemoteIp();
            expLog.append(RMAuditLogger.Keys.IP.name() + "=" + ip.getHostAddress() + "\t");
        }
        expLog.append("OPERATION=null\tTARGET=null\tRESULT=SUCCESS");
        Assert.assertEquals((Object)expLog.toString(), (Object)sLog);
    }

    private void testSuccessLogFormatHelperWithIP(boolean checkIP, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId) {
        this.testSuccessLogFormatHelperWithIP(checkIP, appId, attemptId, containerId, InetAddress.getLoopbackAddress());
        byte[] ipAddr = new byte[]{100, 10, 10, 1};
        InetAddress addr = null;
        try {
            addr = InetAddress.getByAddress(ipAddr);
        }
        catch (UnknownHostException uhe) {
            Assert.fail((String)"Check ip address being constructed");
        }
        this.testSuccessLogFormatHelperWithIP(checkIP, appId, attemptId, containerId, addr);
    }

    private void testSuccessLogFormat(boolean checkIP) {
        this.testSuccessLogFormatHelper(checkIP, null, null, null);
        this.testSuccessLogFormatHelper(checkIP, APPID, null, null);
        this.testSuccessLogFormatHelper(checkIP, null, null, CONTAINERID);
        this.testSuccessLogFormatHelper(checkIP, null, ATTEMPTID, null);
        this.testSuccessLogFormatHelper(checkIP, APPID, ATTEMPTID, null);
        this.testSuccessLogFormatHelper(checkIP, APPID, null, CONTAINERID);
        this.testSuccessLogFormatHelper(checkIP, null, ATTEMPTID, CONTAINERID);
        this.testSuccessLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID);
        this.testSuccessLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID, null, null);
        this.testSuccessLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID, new CallerContext.Builder(null).setSignature(null).build(), RESOURCE);
        this.testSuccessLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID, new CallerContext.Builder(CALLER_CONTEXT).setSignature(null).build(), RESOURCE);
        this.testSuccessLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID, new CallerContext.Builder(null).setSignature(CALLER_SIGNATURE).build(), RESOURCE);
        this.testSuccessLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID, new CallerContext.Builder(CALLER_CONTEXT).setSignature(CALLER_SIGNATURE).build(), RESOURCE);
        RMAuditLogger.ArgsBuilder args = new RMAuditLogger.ArgsBuilder().append(RMAuditLogger.Keys.QUEUENAME, QUEUE).append(RMAuditLogger.Keys.RECURSIVE, "true");
        this.testSuccessLogFormatHelper(checkIP, null, null, null, null, null, Server.getRemoteIp(), args);
        this.testSuccessLogFormatHelper(checkIP, null, null, null, null, null, Server.getRemoteIp(), null, QUEUE, PARTITION);
        this.testSuccessLogFormatHelperWithIP(checkIP, APPID, ATTEMPTID, CONTAINERID);
        this.testSuccessLogNulls(checkIP);
    }

    private void testFailureLogFormatHelper(boolean checkIP, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId) {
        this.testFailureLogFormatHelper(checkIP, appId, attemptId, containerId, null, null);
    }

    private void testFailureLogFormatHelper(boolean checkIP, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId, CallerContext callerContext, Resource resource) {
        this.testFailureLogFormatHelper(checkIP, appId, attemptId, containerId, callerContext, resource, null, null, null);
    }

    private void testFailureLogFormatHelper(boolean checkIP, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId, CallerContext callerContext, Resource resource, String queueName, String partition, RMAuditLogger.ArgsBuilder args) {
        String fLog = args == null ? RMAuditLogger.createFailureLog((String)USER, (String)OPERATION, (String)PERM, (String)TARGET, (String)DESC, (ApplicationId)appId, (ApplicationAttemptId)attemptId, (ContainerId)containerId, (Resource)resource, (CallerContext)callerContext, (String)queueName, (String)partition) : RMAuditLogger.createFailureLog((String)USER, (String)OPERATION, (String)PERM, (String)TARGET, (String)DESC, (RMAuditLogger.ArgsBuilder)args);
        StringBuilder expLog = new StringBuilder();
        expLog.append("USER=test\t");
        if (checkIP) {
            InetAddress ip = Server.getRemoteIp();
            expLog.append(RMAuditLogger.Keys.IP.name() + "=" + ip.getHostAddress() + "\t");
        }
        expLog.append("OPERATION=oper\tTARGET=tgt\tRESULT=FAILURE\t");
        expLog.append("DESCRIPTION=description of an audit log");
        expLog.append("\tPERMISSIONS=admin group");
        if (appId != null) {
            expLog.append("\tAPPID=app_1");
        }
        if (attemptId != null) {
            expLog.append("\tAPPATTEMPTID=app_attempt_1");
        }
        if (containerId != null) {
            expLog.append("\tCONTAINERID=container_1");
        }
        if (resource != null) {
            expLog.append("\tRESOURCE=<memory:1536, vcores:1>");
        }
        if (callerContext != null) {
            if (callerContext.getContext() != null) {
                expLog.append("\tCALLERCONTEXT=context");
            }
            if (callerContext.getSignature() != null) {
                expLog.append("\tCALLERSIGNATURE=signature");
            }
        }
        if (queueName != null) {
            expLog.append("\tQUEUENAME=root");
        }
        if (partition != null) {
            expLog.append("\tNODELABEL=label1");
        }
        if (args != null) {
            expLog.append("\tQUEUENAME=root");
            expLog.append("\tRECURSIVE=true");
        }
        Assert.assertEquals((Object)expLog.toString(), (Object)fLog);
    }

    private void testFailureLogFormat(boolean checkIP) {
        this.testFailureLogFormatHelper(checkIP, null, null, null);
        this.testFailureLogFormatHelper(checkIP, APPID, null, null);
        this.testFailureLogFormatHelper(checkIP, null, null, CONTAINERID);
        this.testFailureLogFormatHelper(checkIP, null, ATTEMPTID, null);
        this.testFailureLogFormatHelper(checkIP, APPID, ATTEMPTID, null);
        this.testFailureLogFormatHelper(checkIP, APPID, null, CONTAINERID);
        this.testFailureLogFormatHelper(checkIP, null, ATTEMPTID, CONTAINERID);
        this.testFailureLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID);
        this.testFailureLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID, new CallerContext.Builder(null).setSignature(null).build(), RESOURCE);
        this.testFailureLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID, new CallerContext.Builder(CALLER_CONTEXT).setSignature(null).build(), RESOURCE);
        this.testFailureLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID, new CallerContext.Builder(null).setSignature(CALLER_SIGNATURE).build(), RESOURCE);
        this.testFailureLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID, new CallerContext.Builder(CALLER_CONTEXT).setSignature(CALLER_SIGNATURE).build(), RESOURCE);
        this.testFailureLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID, new CallerContext.Builder(CALLER_CONTEXT).setSignature(CALLER_SIGNATURE).build(), RESOURCE, QUEUE, null, null);
        this.testFailureLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID, new CallerContext.Builder(CALLER_CONTEXT).setSignature(CALLER_SIGNATURE).build(), RESOURCE, QUEUE, PARTITION, null);
        RMAuditLogger.ArgsBuilder args = new RMAuditLogger.ArgsBuilder().append(RMAuditLogger.Keys.QUEUENAME, QUEUE).append(RMAuditLogger.Keys.RECURSIVE, "true");
        this.testFailureLogFormatHelper(checkIP, null, null, null, null, null, null, null, args);
    }

    @Test
    public void testRMAuditLoggerWithoutIP() throws Exception {
        this.testSuccessLogFormat(false);
        this.testFailureLogFormat(false);
    }

    @Test
    public void testRMAuditLoggerWithIP() throws Exception {
        Configuration conf = new Configuration();
        RPC.setProtocolEngine((Configuration)conf, TestRpcBase.TestRpcService.class, ProtobufRpcEngine2.class);
        MyTestRPCServer serverImpl = new MyTestRPCServer();
        BlockingService service = TestRpcServiceProtos.TestProtobufRpcProto.newReflectiveBlockingService((TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface)serverImpl);
        RPC.Server server = new RPC.Builder(conf).setProtocol(TestRpcBase.TestRpcService.class).setInstance((Object)service).setBindAddress("0.0.0.0").setPort(0).setNumHandlers(5).setVerbose(true).build();
        server.start();
        InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        TestRpcBase.TestRpcService proxy = (TestRpcBase.TestRpcService)RPC.getProxy(TestRpcBase.TestRpcService.class, (long)1L, (InetSocketAddress)addr, (Configuration)conf);
        TestProtos.EmptyRequestProto pingRequest = TestProtos.EmptyRequestProto.newBuilder().build();
        proxy.ping(null, pingRequest);
        server.stop();
        RPC.stopProxy((Object)proxy);
    }

    private class MyTestRPCServer
    extends TestRpcBase.PBServerImpl {
        private MyTestRPCServer() {
        }

        public TestProtos.EmptyResponseProto ping(RpcController unused, TestProtos.EmptyRequestProto request) throws ServiceException {
            byte[] clientId = Server.getClientId();
            Assert.assertNotNull((Object)clientId);
            Assert.assertEquals((long)16L, (long)clientId.length);
            TestRMAuditLogger.this.testSuccessLogFormat(true);
            TestRMAuditLogger.this.testFailureLogFormat(true);
            return TestProtos.EmptyResponseProto.newBuilder().build();
        }
    }
}

