/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CyclicBarrier;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.ApplicationsRequestScope;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceTypeInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceTypeInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetAttributesToNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAttributesToNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeAttributesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeAttributesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToAttributesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToAttributesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationPriorityRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationPriorityResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeAttributeInfo;
import org.apache.hadoop.yarn.api.records.NodeAttributeType;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.NodeToAttributeValue;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueConfigurations;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.ReservationAllocationState;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.ReservationRequests;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.ResourceTypeInfo;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.nodelabels.NodeAttributesManager;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.NodeAttributeTestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.QueueACLsManager;
import org.apache.hadoop.yarn.server.resourcemanager.timelineservice.RMTimelineCollectorManager;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.UTCClock;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestClientRMService {
    private static final Logger LOG = LoggerFactory.getLogger(TestClientRMService.class);
    private RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private String appType = "MockApp";
    private static final String QUEUE_1 = "Q-1";
    private static final String QUEUE_2 = "Q-2";
    private static final String APPLICATION_TAG_SC_PREPROCESSOR = "mytag:foo";
    private File resourceTypesFile = null;

    @Test
    public void testGetDecommissioningClusterNodes() throws Exception {
        MockRM rm = new MockRM(){

            @Override
            protected ClientRMService createClientRMService() {
                return new ClientRMService((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager());
            }
        };
        rm.start();
        int nodeMemory = 1024;
        MockNM nm1 = rm.registerNode("host1:1234", nodeMemory);
        rm.sendNodeStarted(nm1);
        nm1.nodeHeartbeat(true);
        rm.waitForState(nm1.getNodeId(), NodeState.RUNNING);
        Integer decommissioningTimeout = 600;
        rm.sendNodeGracefulDecommission(nm1, decommissioningTimeout);
        rm.waitForState(nm1.getNodeId(), NodeState.DECOMMISSIONING);
        Configuration conf = new Configuration();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress rmAddress = rm.getClientRMService().getBindAddress();
        LOG.info("Connecting to ResourceManager at " + rmAddress);
        ApplicationClientProtocol client = (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, rmAddress, conf);
        List nodeReports = client.getClusterNodes(GetClusterNodesRequest.newInstance(EnumSet.of(NodeState.DECOMMISSIONING))).getNodeReports();
        Assert.assertEquals((long)1L, (long)nodeReports.size());
        NodeReport nr = (NodeReport)nodeReports.iterator().next();
        Assert.assertEquals((Object)decommissioningTimeout, (Object)nr.getDecommissioningTimeout());
        Assert.assertNull((Object)nr.getNodeUpdateType());
        rpc.stopProxy((Object)client, conf);
        rm.close();
    }

    @Test
    public void testGetClusterNodes() throws Exception {
        MockRM rm = new MockRM(){

            @Override
            protected ClientRMService createClientRMService() {
                return new ClientRMService((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager());
            }
        };
        rm.start();
        RMNodeLabelsManager labelsMgr = rm.getRMContext().getNodeLabelManager();
        labelsMgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        MockNM node = rm.registerNode("host1:1234", 1024);
        HashMap<NodeId, ImmutableSet> map = new HashMap<NodeId, ImmutableSet>();
        map.put(node.getNodeId(), ImmutableSet.of((Object)"x"));
        labelsMgr.replaceLabelsOnNode(map);
        rm.sendNodeStarted(node);
        node.nodeHeartbeat(true);
        MockNM lostNode = rm.registerNode("host2:1235", 1024);
        rm.sendNodeStarted(lostNode);
        lostNode.nodeHeartbeat(true);
        rm.waitForState(lostNode.getNodeId(), NodeState.RUNNING);
        rm.sendNodeLost(lostNode);
        Configuration conf = new Configuration();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress rmAddress = rm.getClientRMService().getBindAddress();
        LOG.info("Connecting to ResourceManager at " + rmAddress);
        ApplicationClientProtocol client = (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, rmAddress, conf);
        GetClusterNodesRequest request = GetClusterNodesRequest.newInstance(EnumSet.of(NodeState.RUNNING));
        List nodeReports = client.getClusterNodes(request).getNodeReports();
        Assert.assertEquals((long)1L, (long)nodeReports.size());
        Assert.assertNotSame((String)"Node is expected to be healthy!", (Object)NodeState.UNHEALTHY, (Object)((NodeReport)nodeReports.get(0)).getNodeState());
        Assert.assertTrue((boolean)((NodeReport)nodeReports.get(0)).getNodeLabels().contains("x"));
        Assert.assertNull((Object)((NodeReport)nodeReports.get(0)).getDecommissioningTimeout());
        Assert.assertNull((Object)((NodeReport)nodeReports.get(0)).getNodeUpdateType());
        node.nodeHeartbeat(false);
        rm.waitForState(node.getNodeId(), NodeState.UNHEALTHY);
        nodeReports = client.getClusterNodes(request).getNodeReports();
        Assert.assertEquals((String)"Unhealthy nodes should not show up by default", (long)0L, (long)nodeReports.size());
        map = new HashMap();
        map.put(node.getNodeId(), ImmutableSet.of((Object)"y"));
        labelsMgr.replaceLabelsOnNode(map);
        request = GetClusterNodesRequest.newInstance(EnumSet.of(NodeState.UNHEALTHY));
        nodeReports = client.getClusterNodes(request).getNodeReports();
        Assert.assertEquals((long)1L, (long)nodeReports.size());
        Assert.assertEquals((String)"Node is expected to be unhealthy!", (Object)NodeState.UNHEALTHY, (Object)((NodeReport)nodeReports.get(0)).getNodeState());
        Assert.assertTrue((boolean)((NodeReport)nodeReports.get(0)).getNodeLabels().contains("y"));
        Assert.assertNull((Object)((NodeReport)nodeReports.get(0)).getDecommissioningTimeout());
        Assert.assertNull((Object)((NodeReport)nodeReports.get(0)).getNodeUpdateType());
        map = new HashMap();
        map.put(node.getNodeId(), ImmutableSet.of((Object)"y"));
        labelsMgr.removeLabelsFromNode(map);
        rm.registerNode("host3:1236", 1024);
        request = GetClusterNodesRequest.newInstance(EnumSet.allOf(NodeState.class));
        nodeReports = client.getClusterNodes(request).getNodeReports();
        Assert.assertEquals((long)3L, (long)nodeReports.size());
        for (NodeReport report : nodeReports) {
            Assert.assertTrue((report.getNodeLabels() != null && report.getNodeLabels().isEmpty() ? 1 : 0) != 0);
            Assert.assertNull((Object)report.getDecommissioningTimeout());
            Assert.assertNull((Object)report.getNodeUpdateType());
        }
        rpc.stopProxy((Object)client, conf);
        rm.close();
    }

    @Test
    public void testNonExistingApplicationReport() throws YarnException {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(new ConcurrentHashMap());
        ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, null);
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        GetApplicationReportRequest request = (GetApplicationReportRequest)recordFactory.newRecordInstance(GetApplicationReportRequest.class);
        request.setApplicationId(ApplicationId.newInstance((long)0L, (int)0));
        try {
            rmService.getApplicationReport(request);
            Assert.fail();
        }
        catch (ApplicationNotFoundException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)("Application with id '" + request.getApplicationId() + "' doesn't exist in RM. Please check that the job submission was successful."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetApplicationReport() throws Exception {
        ResourceScheduler scheduler = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(scheduler, rmContext);
        ApplicationId appId1 = TestClientRMService.getApplicationId(1);
        ApplicationACLsManager mockAclsManager = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        Mockito.when((Object)mockAclsManager.checkAccess(UserGroupInformation.getCurrentUser(), ApplicationAccessType.VIEW_APP, null, appId1)).thenReturn((Object)true);
        try (ClientRMService rmService = new ClientRMService(rmContext, (YarnScheduler)scheduler, null, mockAclsManager, null, null);){
            RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
            GetApplicationReportRequest request = (GetApplicationReportRequest)recordFactory.newRecordInstance(GetApplicationReportRequest.class);
            request.setApplicationId(appId1);
            GetApplicationReportResponse response = rmService.getApplicationReport(request);
            ApplicationReport report = response.getApplicationReport();
            ApplicationResourceUsageReport usageReport = report.getApplicationResourceUsageReport();
            Assert.assertEquals((long)10L, (long)usageReport.getMemorySeconds());
            Assert.assertEquals((long)3L, (long)usageReport.getVcoreSeconds());
            Assert.assertEquals((Object)"<Not set>", (Object)report.getAmNodeLabelExpression());
            Assert.assertEquals((Object)"<Not set>", (Object)report.getAppNodeLabelExpression());
            ApplicationId appId2 = TestClientRMService.getApplicationId(2);
            Mockito.when((Object)mockAclsManager.checkAccess(UserGroupInformation.getCurrentUser(), ApplicationAccessType.VIEW_APP, null, appId2)).thenReturn((Object)true);
            request.setApplicationId(appId2);
            response = rmService.getApplicationReport(request);
            report = response.getApplicationReport();
            Assert.assertEquals((Object)"<DEFAULT_PARTITION>", (Object)report.getAmNodeLabelExpression());
            Assert.assertEquals((Object)"<Not set>", (Object)report.getAppNodeLabelExpression());
            ApplicationId appId3 = TestClientRMService.getApplicationId(3);
            Mockito.when((Object)mockAclsManager.checkAccess(UserGroupInformation.getCurrentUser(), ApplicationAccessType.VIEW_APP, null, appId3)).thenReturn((Object)true);
            request.setApplicationId(appId3);
            response = rmService.getApplicationReport(request);
            report = response.getApplicationReport();
            Assert.assertEquals((Object)"high-mem", (Object)report.getAmNodeLabelExpression());
            Assert.assertEquals((Object)"high-mem", (Object)report.getAppNodeLabelExpression());
            GetApplicationReportRequest invalidRequest = (GetApplicationReportRequest)recordFactory.newRecordInstance(GetApplicationReportRequest.class);
            invalidRequest.setApplicationId(null);
            try {
                rmService.getApplicationReport(invalidRequest);
            }
            catch (YarnException e) {
                Assert.assertTrue((boolean)(e instanceof ApplicationNotFoundException));
            }
        }
    }

    @Test
    public void testGetApplicationAttemptReport() throws YarnException, IOException {
        ClientRMService rmService = this.createRMService();
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        GetApplicationAttemptReportRequest request = (GetApplicationAttemptReportRequest)recordFactory.newRecordInstance(GetApplicationAttemptReportRequest.class);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)123456L, (int)1), (int)1);
        request.setApplicationAttemptId(attemptId);
        try {
            GetApplicationAttemptReportResponse response = rmService.getApplicationAttemptReport(request);
            Assert.assertEquals((Object)attemptId, (Object)response.getApplicationAttemptReport().getApplicationAttemptId());
        }
        catch (ApplicationNotFoundException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testGetApplicationResourceUsageReportDummy() throws YarnException, IOException {
        ApplicationAttemptId attemptId = TestClientRMService.getApplicationAttemptId(1);
        ResourceScheduler scheduler = TestClientRMService.mockResourceScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(scheduler, rmContext);
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)new EventHandler<Event>(){

            public void handle(Event event) {
            }
        });
        ApplicationSubmissionContext asContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        YarnConfiguration config = new YarnConfiguration();
        RMAppAttemptImpl rmAppAttemptImpl = new RMAppAttemptImpl(attemptId, rmContext, (YarnScheduler)scheduler, null, asContext, (Configuration)config, null, null);
        ApplicationResourceUsageReport report = rmAppAttemptImpl.getApplicationResourceUsageReport();
        Assert.assertEquals((Object)report, (Object)RMServerUtils.DUMMY_APPLICATION_RESOURCE_USAGE_REPORT);
    }

    @Test
    public void testGetApplicationAttempts() throws YarnException, IOException {
        ClientRMService rmService = this.createRMService();
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        GetApplicationAttemptsRequest request = (GetApplicationAttemptsRequest)recordFactory.newRecordInstance(GetApplicationAttemptsRequest.class);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)123456L, (int)1), (int)1);
        request.setApplicationId(ApplicationId.newInstance((long)123456L, (int)1));
        try {
            GetApplicationAttemptsResponse response = rmService.getApplicationAttempts(request);
            Assert.assertEquals((long)1L, (long)response.getApplicationAttemptList().size());
            Assert.assertEquals((Object)attemptId, (Object)((ApplicationAttemptReport)response.getApplicationAttemptList().get(0)).getApplicationAttemptId());
        }
        catch (ApplicationNotFoundException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testGetContainerReport() throws YarnException, IOException {
        ClientRMService rmService = this.createRMService();
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        GetContainerReportRequest request = (GetContainerReportRequest)recordFactory.newRecordInstance(GetContainerReportRequest.class);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)123456L, (int)1), (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        request.setContainerId(containerId);
        try {
            GetContainerReportResponse response = rmService.getContainerReport(request);
            Assert.assertEquals((Object)containerId, (Object)response.getContainerReport().getContainerId());
        }
        catch (ApplicationNotFoundException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testGetContainers() throws YarnException, IOException {
        ClientRMService rmService = this.createRMService();
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        GetContainersRequest request = (GetContainersRequest)recordFactory.newRecordInstance(GetContainersRequest.class);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)123456L, (int)1), (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        request.setApplicationAttemptId(attemptId);
        try {
            GetContainersResponse response = rmService.getContainers(request);
            Assert.assertEquals((Object)containerId, (Object)((ContainerReport)response.getContainerList().get(0)).getContainerId());
        }
        catch (ApplicationNotFoundException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    public ClientRMService createRMService() throws IOException, YarnException {
        ResourceScheduler scheduler = TestClientRMService.mockResourceScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(scheduler, rmContext);
        ConcurrentHashMap<ApplicationId, RMApp> apps = this.getRMApps(rmContext, (YarnScheduler)scheduler);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(apps);
        Mockito.when((Object)rmContext.getYarnConfiguration()).thenReturn((Object)new Configuration());
        RMAppManager appManager = new RMAppManager(rmContext, (YarnScheduler)scheduler, null, (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class), new Configuration());
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)new EventHandler<Event>(){

            public void handle(Event event) {
            }
        });
        ApplicationACLsManager mockAclsManager = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        QueueACLsManager mockQueueACLsManager = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)mockQueueACLsManager.checkAccess((UserGroupInformation)ArgumentMatchers.any(UserGroupInformation.class), (QueueACL)ArgumentMatchers.any(QueueACL.class), (RMApp)ArgumentMatchers.any(RMApp.class), (String)ArgumentMatchers.any(), (List)ArgumentMatchers.any())).thenReturn((Object)true);
        return new ClientRMService(rmContext, (YarnScheduler)scheduler, appManager, mockAclsManager, mockQueueACLsManager, null);
    }

    @Test
    public void testForceKillNonExistingApplication() throws YarnException {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(new ConcurrentHashMap());
        ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, null);
        ApplicationId applicationId = BuilderUtils.newApplicationId((long)System.currentTimeMillis(), (int)0);
        KillApplicationRequest request = KillApplicationRequest.newInstance((ApplicationId)applicationId);
        try {
            rmService.forceKillApplication(request);
            Assert.fail();
        }
        catch (ApplicationNotFoundException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)("Trying to kill an absent application " + request.getApplicationId()));
        }
    }

    @Test
    public void testApplicationTagsValidation() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        int maxtags = 3;
        int appMaxTagLength = 5;
        conf.setInt("yarn.resourcemanager.application.max-tags", maxtags);
        conf.setInt("yarn.resourcemanager.application.max-tag.length", appMaxTagLength);
        MockRM rm = new MockRM((Configuration)conf);
        rm.init((Configuration)conf);
        rm.start();
        ClientRMService rmService = rm.getClientRMService();
        List<String> tags = Arrays.asList("Tag1", "Tag2", "Tag3", "Tag4");
        this.validateApplicationTag(rmService, tags, "Too many applicationTags, a maximum of only " + maxtags + " are allowed!");
        tags = Arrays.asList("ApplicationTag1", "ApplicationTag2", "ApplicationTag3");
        this.validateApplicationTag(rmService, tags, "Tag applicationtag1 is too long, maximum allowed length of a tag is " + appMaxTagLength);
        tags = Arrays.asList("t\u00e3g1", "tag2#");
        this.validateApplicationTag(rmService, tags, "A tag can only have ASCII characters! Invalid tag - t\u00e3g1");
        rm.close();
    }

    private void validateApplicationTag(ClientRMService rmService, List<String> tags, String errorMsg) {
        SubmitApplicationRequest submitRequest = this.mockSubmitAppRequest(TestClientRMService.getApplicationId(101), MockApps.newAppName(), QUEUE_1, new HashSet<String>(tags));
        try {
            rmService.submitApplication(submitRequest);
            Assert.fail();
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains(errorMsg));
        }
    }

    @Test
    public void testForceKillApplication() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("mockrm.webapp.enabled", true);
        MockRM rm = new MockRM((Configuration)conf);
        rm.init((Configuration)conf);
        rm.start();
        ClientRMService rmService = rm.getClientRMService();
        GetApplicationsRequest getRequest = GetApplicationsRequest.newInstance(EnumSet.of(YarnApplicationState.KILLED));
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(1024L, rm);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withUnmanagedAM(true).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm, data);
        Assert.assertEquals((String)"Incorrect number of apps in the RM", (long)0L, (long)rmService.getApplications(getRequest).getApplicationList().size());
        KillApplicationRequest killRequest1 = KillApplicationRequest.newInstance((ApplicationId)app1.getApplicationId());
        String diagnostic = "message1";
        killRequest1.setDiagnostics(diagnostic);
        KillApplicationRequest killRequest2 = KillApplicationRequest.newInstance((ApplicationId)app2.getApplicationId());
        int killAttemptCount = 0;
        for (int i = 0; i < 100; ++i) {
            KillApplicationResponse killResponse1 = rmService.forceKillApplication(killRequest1);
            ++killAttemptCount;
            if (killResponse1.getIsKillCompleted()) break;
            Thread.sleep(10L);
        }
        Assert.assertTrue((String)"Kill attempt count should be greater than 1 for managed AMs", (killAttemptCount > 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Incorrect number of apps in the RM", (long)1L, (long)rmService.getApplications(getRequest).getApplicationList().size());
        Assert.assertTrue((String)"Diagnostic message is incorrect", (boolean)app1.getDiagnostics().toString().contains(diagnostic));
        KillApplicationResponse killResponse2 = rmService.forceKillApplication(killRequest2);
        Assert.assertTrue((String)"Killing UnmanagedAM should falsely acknowledge true", (boolean)killResponse2.getIsKillCompleted());
        for (int i = 0; i < 100 && 2 != rmService.getApplications(getRequest).getApplicationList().size(); ++i) {
            Thread.sleep(10L);
        }
        Assert.assertEquals((String)"Incorrect number of apps in the RM", (long)2L, (long)rmService.getApplications(getRequest).getApplicationList().size());
    }

    @Test(expected=ApplicationNotFoundException.class)
    public void testMoveAbsentApplication() throws YarnException {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(new ConcurrentHashMap());
        ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, null);
        ApplicationId applicationId = BuilderUtils.newApplicationId((long)System.currentTimeMillis(), (int)0);
        MoveApplicationAcrossQueuesRequest request = MoveApplicationAcrossQueuesRequest.newInstance((ApplicationId)applicationId, (String)"newqueue");
        rmService.moveApplicationAcrossQueues(request);
    }

    @Test
    public void testMoveApplicationSubmitTargetQueue() throws Exception {
        ApplicationId applicationId = TestClientRMService.getApplicationId(1);
        UserGroupInformation aclUGI = UserGroupInformation.getCurrentUser();
        QueueACLsManager queueACLsManager = this.getQueueAclManager("allowed_queue", QueueACL.SUBMIT_APPLICATIONS, aclUGI);
        ApplicationACLsManager appAclsManager = this.getAppAclManager();
        ClientRMService rmService = this.createClientRMServiceForMoveApplicationRequest(applicationId, aclUGI.getShortUserName(), appAclsManager, queueACLsManager);
        MoveApplicationAcrossQueuesRequest moveAppRequest = MoveApplicationAcrossQueuesRequest.newInstance((ApplicationId)applicationId, (String)"allowed_queue");
        rmService.moveApplicationAcrossQueues(moveAppRequest);
        moveAppRequest = MoveApplicationAcrossQueuesRequest.newInstance((ApplicationId)applicationId, (String)"not_allowed");
        try {
            rmService.moveApplicationAcrossQueues(moveAppRequest);
            Assert.fail((String)"The request should fail with an AccessControlException");
        }
        catch (YarnException rex) {
            Assert.assertTrue((String)"AccessControlException is expected", (boolean)(rex.getCause() instanceof AccessControlException));
        }
        aclUGI = UserGroupInformation.createUserForTesting((String)"moveuser", (String[])new String[0]);
        queueACLsManager = this.getQueueAclManager("move_queue", QueueACL.SUBMIT_APPLICATIONS, aclUGI);
        appAclsManager = this.getAppAclManager();
        final ClientRMService rmService2 = this.createClientRMServiceForMoveApplicationRequest(applicationId, aclUGI.getShortUserName(), appAclsManager, queueACLsManager);
        final MoveApplicationAcrossQueuesRequest moveAppRequest2 = MoveApplicationAcrossQueuesRequest.newInstance((ApplicationId)applicationId, (String)"move_queue");
        try {
            rmService2.moveApplicationAcrossQueues(moveAppRequest2);
            Assert.fail((String)"The request should fail with an AccessControlException");
        }
        catch (YarnException rex) {
            Assert.assertTrue((String)"AccessControlException is expected", (boolean)(rex.getCause() instanceof AccessControlException));
        }
        aclUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                return rmService2.moveApplicationAcrossQueues(moveAppRequest2);
            }
        });
    }

    @Test
    public void testMoveApplicationAdminTargetQueue() throws Exception {
        ApplicationId applicationId = TestClientRMService.getApplicationId(1);
        UserGroupInformation aclUGI = UserGroupInformation.getCurrentUser();
        QueueACLsManager queueAclsManager = this.getQueueAclManager("allowed_queue", QueueACL.ADMINISTER_QUEUE, aclUGI);
        ApplicationACLsManager appAclsManager = this.getAppAclManager();
        ClientRMService rmService = this.createClientRMServiceForMoveApplicationRequest(applicationId, aclUGI.getShortUserName(), appAclsManager, queueAclsManager);
        MoveApplicationAcrossQueuesRequest moveAppRequest = MoveApplicationAcrossQueuesRequest.newInstance((ApplicationId)applicationId, (String)"allowed_queue");
        rmService.moveApplicationAcrossQueues(moveAppRequest);
        moveAppRequest = MoveApplicationAcrossQueuesRequest.newInstance((ApplicationId)applicationId, (String)"not_allowed");
        try {
            rmService.moveApplicationAcrossQueues(moveAppRequest);
            Assert.fail((String)"The request should fail with an AccessControlException");
        }
        catch (YarnException rex) {
            Assert.assertTrue((String)"AccessControlException is expected", (boolean)(rex.getCause() instanceof AccessControlException));
        }
        aclUGI = UserGroupInformation.createUserForTesting((String)"moveuser", (String[])new String[0]);
        queueAclsManager = this.getQueueAclManager("move_queue", QueueACL.ADMINISTER_QUEUE, aclUGI);
        appAclsManager = this.getAppAclManager();
        final ClientRMService rmService2 = this.createClientRMServiceForMoveApplicationRequest(applicationId, aclUGI.getShortUserName(), appAclsManager, queueAclsManager);
        final MoveApplicationAcrossQueuesRequest moveAppRequest2 = MoveApplicationAcrossQueuesRequest.newInstance((ApplicationId)applicationId, (String)"move_queue");
        try {
            rmService2.moveApplicationAcrossQueues(moveAppRequest2);
            Assert.fail((String)"The request should fail with an AccessControlException");
        }
        catch (YarnException rex) {
            Assert.assertTrue((String)"AccessControlException is expected", (boolean)(rex.getCause() instanceof AccessControlException));
        }
        aclUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                return rmService2.moveApplicationAcrossQueues(moveAppRequest2);
            }
        });
    }

    @Test(expected=YarnException.class)
    public void testNonExistingQueue() throws Exception {
        ApplicationId applicationId = TestClientRMService.getApplicationId(1);
        UserGroupInformation aclUGI = UserGroupInformation.getCurrentUser();
        QueueACLsManager queueAclsManager = this.getQueueAclManager();
        ApplicationACLsManager appAclsManager = this.getAppAclManager();
        ClientRMService rmService = this.createClientRMServiceForMoveApplicationRequest(applicationId, aclUGI.getShortUserName(), appAclsManager, queueAclsManager);
        MoveApplicationAcrossQueuesRequest moveAppRequest = MoveApplicationAcrossQueuesRequest.newInstance((ApplicationId)applicationId, (String)"unknown_queue");
        rmService.moveApplicationAcrossQueues(moveAppRequest);
    }

    private ClientRMService createClientRMServiceForMoveApplicationRequest(ApplicationId applicationId, String appOwner, ApplicationACLsManager appAclsManager, QueueACLsManager queueAclsManager) {
        RMApp app = (RMApp)Mockito.mock(RMApp.class);
        Mockito.when((Object)app.getUser()).thenReturn((Object)appOwner);
        Mockito.when((Object)app.getState()).thenReturn((Object)RMAppState.RUNNING);
        Mockito.when((Object)app.getApplicationId()).thenReturn((Object)applicationId);
        ConcurrentHashMap<ApplicationId, RMApp> apps = new ConcurrentHashMap<ApplicationId, RMApp>();
        apps.put(applicationId, app);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(apps);
        RMAppManager rmAppManager = (RMAppManager)Mockito.mock(RMAppManager.class);
        return new ClientRMService(rmContext, null, rmAppManager, appAclsManager, queueAclsManager, null);
    }

    private ApplicationACLsManager getAppAclManager() {
        ApplicationACLsManager aclsManager = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        Mockito.when((Object)aclsManager.checkAccess((UserGroupInformation)ArgumentMatchers.any(UserGroupInformation.class), (ApplicationAccessType)ArgumentMatchers.any(ApplicationAccessType.class), (String)ArgumentMatchers.any(String.class), (ApplicationId)ArgumentMatchers.any(ApplicationId.class))).thenReturn((Object)true);
        return aclsManager;
    }

    private QueueACLsManager getQueueAclManager(final String allowedQueue, final QueueACL queueACL, final UserGroupInformation aclUser) throws IOException {
        QueueACLsManager queueACLsManager = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)queueACLsManager.checkAccess((UserGroupInformation)ArgumentMatchers.any(UserGroupInformation.class), (QueueACL)ArgumentMatchers.any(QueueACL.class), (RMApp)ArgumentMatchers.any(RMApp.class), (String)ArgumentMatchers.any(), (List)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocationOnMock) {
                UserGroupInformation user = (UserGroupInformation)invocationOnMock.getArguments()[0];
                QueueACL acl = (QueueACL)invocationOnMock.getArguments()[1];
                return queueACL.equals((Object)acl) && aclUser.getShortUserName().equals(user.getShortUserName());
            }
        });
        Mockito.when((Object)queueACLsManager.checkAccess((UserGroupInformation)ArgumentMatchers.any(UserGroupInformation.class), (QueueACL)ArgumentMatchers.any(QueueACL.class), (RMApp)ArgumentMatchers.any(RMApp.class), (String)ArgumentMatchers.any(), (List)ArgumentMatchers.any(), (String)ArgumentMatchers.any(String.class))).thenAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocationOnMock) {
                UserGroupInformation user = (UserGroupInformation)invocationOnMock.getArguments()[0];
                QueueACL acl = (QueueACL)invocationOnMock.getArguments()[1];
                String queue = (String)invocationOnMock.getArguments()[5];
                return allowedQueue.equals(queue) && queueACL.equals((Object)acl) && aclUser.getShortUserName().equals(user.getShortUserName());
            }
        });
        return queueACLsManager;
    }

    private QueueACLsManager getQueueAclManager() {
        QueueACLsManager queueACLsManager = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)queueACLsManager.checkAccess((UserGroupInformation)ArgumentMatchers.any(UserGroupInformation.class), (QueueACL)ArgumentMatchers.any(QueueACL.class), (RMApp)ArgumentMatchers.any(RMApp.class), (String)ArgumentMatchers.any(String.class), ArgumentMatchers.anyList(), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)false);
        Mockito.when((Object)queueACLsManager.checkAccess((UserGroupInformation)ArgumentMatchers.any(UserGroupInformation.class), (QueueACL)ArgumentMatchers.any(QueueACL.class), (RMApp)ArgumentMatchers.any(RMApp.class), (String)ArgumentMatchers.any(String.class), ArgumentMatchers.anyList())).thenReturn((Object)true);
        return queueACLsManager;
    }

    @Test
    public void testGetQueueInfo() throws Exception {
        ResourceScheduler scheduler = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(scheduler, rmContext);
        ApplicationACLsManager mockAclsManager = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        QueueACLsManager mockQueueACLsManager = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)mockQueueACLsManager.checkAccess((UserGroupInformation)ArgumentMatchers.any(UserGroupInformation.class), (QueueACL)ArgumentMatchers.any(QueueACL.class), (RMApp)ArgumentMatchers.any(RMApp.class), (String)ArgumentMatchers.any(String.class), (List)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)mockAclsManager.checkAccess((UserGroupInformation)ArgumentMatchers.any(UserGroupInformation.class), (ApplicationAccessType)ArgumentMatchers.any(ApplicationAccessType.class), (String)ArgumentMatchers.any(), (ApplicationId)ArgumentMatchers.any(ApplicationId.class))).thenReturn((Object)true);
        ClientRMService rmService = new ClientRMService(rmContext, (YarnScheduler)scheduler, null, mockAclsManager, mockQueueACLsManager, null);
        GetQueueInfoRequest request = (GetQueueInfoRequest)this.recordFactory.newRecordInstance(GetQueueInfoRequest.class);
        request.setQueueName("testqueue");
        request.setIncludeApplications(true);
        GetQueueInfoResponse queueInfo = rmService.getQueueInfo(request);
        List applications = queueInfo.getQueueInfo().getApplications();
        Assert.assertEquals((long)2L, (long)applications.size());
        Map queueConfigsByPartition = queueInfo.getQueueInfo().getQueueConfigurations();
        Assert.assertEquals((long)1L, (long)queueConfigsByPartition.size());
        Assert.assertTrue((boolean)queueConfigsByPartition.containsKey("*"));
        QueueConfigurations queueConfigs = (QueueConfigurations)queueConfigsByPartition.get("*");
        Assert.assertEquals((float)0.5f, (float)queueConfigs.getCapacity(), (float)1.0E-4f);
        Assert.assertEquals((float)0.1f, (float)queueConfigs.getAbsoluteCapacity(), (float)1.0E-4f);
        Assert.assertEquals((float)1.0f, (float)queueConfigs.getMaxCapacity(), (float)1.0E-4f);
        Assert.assertEquals((float)1.0f, (float)queueConfigs.getAbsoluteMaxCapacity(), (float)1.0E-4f);
        Assert.assertEquals((float)0.2f, (float)queueConfigs.getMaxAMPercentage(), (float)1.0E-4f);
        request.setQueueName("nonexistentqueue");
        request.setIncludeApplications(true);
        queueInfo = rmService.getQueueInfo(request);
        ApplicationACLsManager mockAclsManager1 = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        QueueACLsManager mockQueueACLsManager1 = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)mockQueueACLsManager1.checkAccess((UserGroupInformation)ArgumentMatchers.any(UserGroupInformation.class), (QueueACL)ArgumentMatchers.any(QueueACL.class), (RMApp)ArgumentMatchers.any(RMApp.class), (String)ArgumentMatchers.any(String.class), (List)ArgumentMatchers.any())).thenReturn((Object)false);
        Mockito.when((Object)mockAclsManager1.checkAccess((UserGroupInformation)ArgumentMatchers.any(UserGroupInformation.class), (ApplicationAccessType)ArgumentMatchers.any(ApplicationAccessType.class), ArgumentMatchers.anyString(), (ApplicationId)ArgumentMatchers.any(ApplicationId.class))).thenReturn((Object)false);
        ClientRMService rmService1 = new ClientRMService(rmContext, (YarnScheduler)scheduler, null, mockAclsManager1, mockQueueACLsManager1, null);
        request.setQueueName("testqueue");
        request.setIncludeApplications(true);
        GetQueueInfoResponse queueInfo1 = rmService1.getQueueInfo(request);
        List applications1 = queueInfo1.getQueueInfo().getApplications();
        Assert.assertEquals((long)0L, (long)applications1.size());
    }

    @Test(timeout=30000L)
    public void testAppSubmitWithSubmissionPreProcessor() throws Exception {
        ResourceScheduler scheduler = TestClientRMService.mockResourceScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(scheduler, rmContext);
        YarnConfiguration yConf = new YarnConfiguration();
        yConf.setBoolean("yarn.resourcemanager.submission-preprocessor.enabled", true);
        yConf.setBoolean("yarn.node-labels.enabled", true);
        Mockito.when((Object)rmContext.getYarnConfiguration()).thenReturn((Object)yConf);
        RMStateStore stateStore = (RMStateStore)Mockito.mock(RMStateStore.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)stateStore);
        RMAppManager appManager = new RMAppManager(rmContext, (YarnScheduler)scheduler, null, (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class), new Configuration());
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)new EventHandler<Event>(){

            public void handle(Event event) {
            }
        });
        ApplicationId appId1 = TestClientRMService.getApplicationId(100);
        ApplicationACLsManager mockAclsManager = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        Mockito.when((Object)mockAclsManager.checkAccess(UserGroupInformation.getCurrentUser(), ApplicationAccessType.VIEW_APP, null, appId1)).thenReturn((Object)true);
        QueueACLsManager mockQueueACLsManager = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)mockQueueACLsManager.checkAccess((UserGroupInformation)ArgumentMatchers.any(UserGroupInformation.class), (QueueACL)ArgumentMatchers.any(QueueACL.class), (RMApp)ArgumentMatchers.any(RMApp.class), (String)ArgumentMatchers.any(String.class), (List)ArgumentMatchers.any())).thenReturn((Object)true);
        ClientRMService rmService = new ClientRMService(rmContext, (YarnScheduler)scheduler, appManager, mockAclsManager, mockQueueACLsManager, null);
        File rulesFile = File.createTempFile("submission_rules", ".tmp");
        rulesFile.deleteOnExit();
        rulesFile.createNewFile();
        yConf.set("yarn.resourcemanager.submission-preprocessor.file-path", rulesFile.getAbsolutePath());
        rmService.serviceInit((Configuration)yConf);
        rmService.serviceStart();
        BufferedWriter writer = new BufferedWriter(new FileWriter(rulesFile));
        writer.write("host.cluster1.com   NL=foo     Q=bar  TA=cluster:cluster1");
        writer.newLine();
        writer.write("host.cluster2.com   Q=hello  NL=zuess   TA=cluster:cluster2");
        writer.newLine();
        writer.write("host.cluster.*.com   Q=hello  NL=reg   TA=cluster:reg");
        writer.newLine();
        writer.write("host.cluster.*.com   Q=hello  NL=reg   TA=cluster:reg");
        writer.newLine();
        writer.write("*   TA=cluster:other    Q=default  NL=barfoo");
        writer.newLine();
        writer.write("host.testcluster1.com  Q=default");
        writer.flush();
        writer.close();
        rmService.getContextPreProcessor().refresh();
        this.setupCurrentCall("host.cluster1.com");
        SubmitApplicationRequest submitRequest1 = this.mockSubmitAppRequest(appId1, null, null);
        try {
            rmService.submitApplication(submitRequest1);
        }
        catch (YarnException e) {
            Assert.fail((String)"Exception is not expected.");
        }
        RMApp app1 = (RMApp)rmContext.getRMApps().get(appId1);
        Assert.assertNotNull((String)"app doesn't exist", (Object)app1);
        Assert.assertEquals((String)"app name doesn't match", (Object)"N/A", (Object)app1.getName());
        Assert.assertTrue((String)"custom tag not present", (boolean)app1.getApplicationTags().contains("cluster:cluster1"));
        Assert.assertEquals((String)"app queue doesn't match", (Object)"bar", (Object)app1.getQueue());
        Assert.assertEquals((String)"app node label doesn't match", (Object)"foo", (Object)app1.getApplicationSubmissionContext().getNodeLabelExpression());
        this.setupCurrentCall("host.cluster2.com");
        ApplicationId appId2 = TestClientRMService.getApplicationId(101);
        SubmitApplicationRequest submitRequest2 = this.mockSubmitAppRequest(appId2, null, null);
        submitRequest2.getApplicationSubmissionContext().setApplicationType("matchType");
        HashSet<String> aTags = new HashSet<String>();
        aTags.add(APPLICATION_TAG_SC_PREPROCESSOR);
        submitRequest2.getApplicationSubmissionContext().setApplicationTags(aTags);
        try {
            rmService.submitApplication(submitRequest2);
        }
        catch (YarnException e) {
            Assert.fail((String)"Exception is not expected.");
        }
        RMApp app2 = (RMApp)rmContext.getRMApps().get(appId2);
        Assert.assertNotNull((String)"app doesn't exist", (Object)app2);
        Assert.assertEquals((String)"app name doesn't match", (Object)"N/A", (Object)app2.getName());
        Assert.assertTrue((String)"client tag not present", (boolean)app2.getApplicationTags().contains(APPLICATION_TAG_SC_PREPROCESSOR));
        Assert.assertTrue((String)"custom tag not present", (boolean)app2.getApplicationTags().contains("cluster:cluster2"));
        Assert.assertEquals((String)"app queue doesn't match", (Object)"hello", (Object)app2.getQueue());
        Assert.assertEquals((String)"app node label doesn't match", (Object)"zuess", (Object)app2.getApplicationSubmissionContext().getNodeLabelExpression());
        this.setupCurrentCall("host2.cluster3.com");
        ApplicationId appId3 = TestClientRMService.getApplicationId(102);
        SubmitApplicationRequest submitRequest3 = this.mockSubmitAppRequest(appId3, null, null);
        submitRequest3.getApplicationSubmissionContext().setApplicationType("matchType");
        submitRequest3.getApplicationSubmissionContext().setApplicationTags(aTags);
        try {
            rmService.submitApplication(submitRequest3);
        }
        catch (YarnException e) {
            Assert.fail((String)"Exception is not expected.");
        }
        RMApp app3 = (RMApp)rmContext.getRMApps().get(appId3);
        Assert.assertNotNull((String)"app doesn't exist", (Object)app3);
        Assert.assertEquals((String)"app name doesn't match", (Object)"N/A", (Object)app3.getName());
        Assert.assertTrue((String)"client tag not present", (boolean)app3.getApplicationTags().contains(APPLICATION_TAG_SC_PREPROCESSOR));
        Assert.assertTrue((String)"custom tag not present", (boolean)app3.getApplicationTags().contains("cluster:other"));
        Assert.assertEquals((String)"app queue doesn't match", (Object)"default", (Object)app3.getQueue());
        Assert.assertEquals((String)"app node label doesn't match", (Object)"barfoo", (Object)app3.getApplicationSubmissionContext().getNodeLabelExpression());
        this.setupCurrentCall("host.cluster100.com");
        ApplicationId appId4 = TestClientRMService.getApplicationId(103);
        SubmitApplicationRequest submitRequest4 = this.mockSubmitAppRequest(appId4, null, null);
        try {
            rmService.submitApplication(submitRequest4);
        }
        catch (YarnException e) {
            Assert.fail((String)"Exception is not expected.");
        }
        RMApp app4 = (RMApp)rmContext.getRMApps().get(appId4);
        Assert.assertTrue((String)"custom tag not present", (boolean)app4.getApplicationTags().contains("cluster:reg"));
        Assert.assertEquals((String)"app node label doesn't match", (Object)"reg", (Object)app4.getApplicationSubmissionContext().getNodeLabelExpression());
        this.testSubmissionContextWithAbsentTAG(rmService, rmContext);
        rmService.serviceStop();
    }

    private void testSubmissionContextWithAbsentTAG(ClientRMService rmService, RMContext rmContext) throws Exception {
        this.setupCurrentCall("host.testcluster1.com");
        ApplicationId appId5 = TestClientRMService.getApplicationId(104);
        SubmitApplicationRequest submitRequest5 = this.mockSubmitAppRequest(appId5, null, null);
        try {
            rmService.submitApplication(submitRequest5);
        }
        catch (YarnException e) {
            Assert.fail((String)"Exception is not expected.");
        }
        RMApp app5 = (RMApp)rmContext.getRMApps().get(appId5);
        Assert.assertEquals((String)"custom tag  present", (long)app5.getApplicationTags().size(), (long)0L);
        Assert.assertNull((String)"app node label present", (Object)app5.getApplicationSubmissionContext().getNodeLabelExpression());
        Assert.assertEquals((String)"Queue name is not present", (Object)app5.getQueue(), (Object)"default");
    }

    private void setupCurrentCall(String hostName) throws UnknownHostException {
        Server.Call mockCall = (Server.Call)Mockito.mock(Server.Call.class);
        Mockito.when((Object)mockCall.getHostInetAddress()).thenReturn((Object)InetAddress.getByAddress(hostName, new byte[]{123, 123, 123, 123}));
        Server.getCurCall().set(mockCall);
    }

    @Test(timeout=30000L)
    public void testAppSubmit() throws Exception {
        ResourceScheduler scheduler = TestClientRMService.mockResourceScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(scheduler, rmContext);
        RMStateStore stateStore = (RMStateStore)Mockito.mock(RMStateStore.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)stateStore);
        RMAppManager appManager = new RMAppManager(rmContext, (YarnScheduler)scheduler, null, (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class), new Configuration());
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)new EventHandler<Event>(){

            public void handle(Event event) {
            }
        });
        ((RMContext)Mockito.doReturn((Object)Mockito.mock(RMTimelineCollectorManager.class)).when((Object)rmContext)).getRMTimelineCollectorManager();
        ApplicationId appId1 = TestClientRMService.getApplicationId(100);
        ApplicationACLsManager mockAclsManager = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        Mockito.when((Object)mockAclsManager.checkAccess(UserGroupInformation.getCurrentUser(), ApplicationAccessType.VIEW_APP, null, appId1)).thenReturn((Object)true);
        QueueACLsManager mockQueueACLsManager = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)mockQueueACLsManager.checkAccess((UserGroupInformation)ArgumentMatchers.any(UserGroupInformation.class), (QueueACL)ArgumentMatchers.any(QueueACL.class), (RMApp)ArgumentMatchers.any(RMApp.class), (String)ArgumentMatchers.any(String.class), (List)ArgumentMatchers.any())).thenReturn((Object)true);
        ClientRMService rmService = new ClientRMService(rmContext, (YarnScheduler)scheduler, appManager, mockAclsManager, mockQueueACLsManager, null);
        rmService.init(new Configuration());
        SubmitApplicationRequest submitRequest1 = this.mockSubmitAppRequest(appId1, null, null);
        try {
            rmService.submitApplication(submitRequest1);
        }
        catch (YarnException e) {
            Assert.fail((String)"Exception is not expected.");
        }
        RMApp app1 = (RMApp)rmContext.getRMApps().get(appId1);
        Assert.assertNotNull((String)"app doesn't exist", (Object)app1);
        Assert.assertEquals((String)"app name doesn't match", (Object)"N/A", (Object)app1.getName());
        Assert.assertEquals((String)"app queue doesn't match", (Object)"default", (Object)app1.getQueue());
        String name = MockApps.newAppName();
        String queue = MockApps.newQueue();
        ApplicationId appId2 = TestClientRMService.getApplicationId(101);
        SubmitApplicationRequest submitRequest2 = this.mockSubmitAppRequest(appId2, name, queue);
        submitRequest2.getApplicationSubmissionContext().setApplicationType("matchType");
        try {
            rmService.submitApplication(submitRequest2);
        }
        catch (YarnException e) {
            Assert.fail((String)"Exception is not expected.");
        }
        RMApp app2 = (RMApp)rmContext.getRMApps().get(appId2);
        Assert.assertNotNull((String)"app doesn't exist", (Object)app2);
        Assert.assertEquals((String)"app name doesn't match", (Object)name, (Object)app2.getName());
        Assert.assertEquals((String)"app queue doesn't match", (Object)queue, (Object)app2.getQueue());
        try {
            rmService.submitApplication(submitRequest2);
        }
        catch (YarnException e) {
            Assert.fail((String)"Exception is not expected.");
        }
        GetApplicationsRequest getAllAppsRequest = GetApplicationsRequest.newInstance(new HashSet());
        GetApplicationsResponse getAllApplicationsResponse = rmService.getApplications(getAllAppsRequest);
        Assert.assertEquals((long)5L, (long)getAllApplicationsResponse.getApplicationList().size());
        HashSet<String> appTypes = new HashSet<String>();
        appTypes.add("matchType");
        getAllAppsRequest = GetApplicationsRequest.newInstance(appTypes);
        getAllApplicationsResponse = rmService.getApplications(getAllAppsRequest);
        Assert.assertEquals((long)1L, (long)getAllApplicationsResponse.getApplicationList().size());
        Assert.assertEquals((Object)appId2, (Object)((ApplicationReport)getAllApplicationsResponse.getApplicationList().get(0)).getApplicationId());
        appTypes = new HashSet();
        appTypes.add("MATCHTYPE");
        getAllAppsRequest = GetApplicationsRequest.newInstance(appTypes);
        getAllApplicationsResponse = rmService.getApplications(getAllAppsRequest);
        Assert.assertEquals((long)1L, (long)getAllApplicationsResponse.getApplicationList().size());
        Assert.assertEquals((Object)appId2, (Object)((ApplicationReport)getAllApplicationsResponse.getApplicationList().get(0)).getApplicationId());
    }

    @Test
    public void testGetApplications() throws Exception {
        ResourceScheduler scheduler = TestClientRMService.mockResourceScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(scheduler, rmContext);
        RMStateStore stateStore = (RMStateStore)Mockito.mock(RMStateStore.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)stateStore);
        ((RMContext)Mockito.doReturn((Object)Mockito.mock(RMTimelineCollectorManager.class)).when((Object)rmContext)).getRMTimelineCollectorManager();
        RMAppManager appManager = new RMAppManager(rmContext, (YarnScheduler)scheduler, null, (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class), new Configuration());
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)new EventHandler<Event>(){

            public void handle(Event event) {
            }
        });
        ApplicationACLsManager mockAclsManager = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        QueueACLsManager mockQueueACLsManager = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)mockQueueACLsManager.checkAccess((UserGroupInformation)ArgumentMatchers.any(UserGroupInformation.class), (QueueACL)ArgumentMatchers.any(QueueACL.class), (RMApp)ArgumentMatchers.any(RMApp.class), (String)ArgumentMatchers.any(), (List)ArgumentMatchers.any())).thenReturn((Object)true);
        ClientRMService rmService = new ClientRMService(rmContext, (YarnScheduler)scheduler, appManager, mockAclsManager, mockQueueACLsManager, null);
        rmService.init(new Configuration());
        String[] queues = new String[]{QUEUE_1, QUEUE_2};
        String[] appNames = new String[]{MockApps.newAppName(), MockApps.newAppName(), MockApps.newAppName()};
        ApplicationId[] appIds = new ApplicationId[]{TestClientRMService.getApplicationId(101), TestClientRMService.getApplicationId(102), TestClientRMService.getApplicationId(103)};
        List<String> tags = Arrays.asList("Tag1", "Tag2", "Tag3");
        long[] submitTimeMillis = new long[3];
        for (int i = 0; i < appIds.length; ++i) {
            ApplicationId appId = appIds[i];
            Mockito.when((Object)mockAclsManager.checkAccess(UserGroupInformation.getCurrentUser(), ApplicationAccessType.VIEW_APP, null, appId)).thenReturn((Object)true);
            SubmitApplicationRequest submitRequest = this.mockSubmitAppRequest(appId, appNames[i], queues[i % queues.length], new HashSet<String>(tags.subList(0, i + 1)));
            Thread.sleep(1L);
            rmService.submitApplication(submitRequest);
            submitTimeMillis[i] = rmService.getApplicationReport(GetApplicationReportRequest.newInstance((ApplicationId)appId)).getApplicationReport().getStartTime();
        }
        GetApplicationsRequest request = GetApplicationsRequest.newInstance();
        Assert.assertEquals((String)"Incorrect total number of apps", (long)6L, (long)rmService.getApplications(request).getApplicationList().size());
        request.setLimit(1L);
        Assert.assertEquals((String)"Failed to limit applications", (long)1L, (long)rmService.getApplications(request).getApplicationList().size());
        request = GetApplicationsRequest.newInstance();
        request.setStartRange(submitTimeMillis[0] + 1L, System.currentTimeMillis());
        Assert.assertEquals((String)"Incorrect number of matching start range", (long)2L, (long)rmService.getApplications(request).getApplicationList().size());
        request.setStartRange(submitTimeMillis[1] + 1L, System.currentTimeMillis());
        Assert.assertEquals((String)"Incorrect number of matching start range", (long)1L, (long)rmService.getApplications(request).getApplicationList().size());
        request.setStartRange(submitTimeMillis[2] + 1L, System.currentTimeMillis());
        Assert.assertEquals((String)"Incorrect number of matching start range", (long)0L, (long)rmService.getApplications(request).getApplicationList().size());
        request = GetApplicationsRequest.newInstance();
        HashSet<String> queueSet = new HashSet<String>();
        request.setQueues(queueSet);
        queueSet.add(queues[0]);
        Assert.assertEquals((String)"Incorrect number of applications in queue", (long)2L, (long)rmService.getApplications(request).getApplicationList().size());
        Assert.assertEquals((String)"Incorrect number of applications in queue", (long)2L, (long)rmService.getApplications(request).getApplicationList().size());
        queueSet.add(queues[1]);
        Assert.assertEquals((String)"Incorrect number of applications in queue", (long)3L, (long)rmService.getApplications(request).getApplicationList().size());
        request = GetApplicationsRequest.newInstance();
        HashSet<String> userSet = new HashSet<String>();
        request.setUsers(userSet);
        userSet.add("random-user-name");
        Assert.assertEquals((String)"Incorrect number of applications for user", (long)0L, (long)rmService.getApplications(request).getApplicationList().size());
        userSet.add(UserGroupInformation.getCurrentUser().getShortUserName());
        Assert.assertEquals((String)"Incorrect number of applications for user", (long)3L, (long)rmService.getApplications(request).getApplicationList().size());
        rmService.setDisplayPerUserApps(true);
        userSet.clear();
        Assert.assertEquals((String)"Incorrect number of applications for user", (long)6L, (long)rmService.getApplications(request).getApplicationList().size());
        rmService.setDisplayPerUserApps(false);
        request = GetApplicationsRequest.newInstance((ApplicationsRequestScope)ApplicationsRequestScope.ALL, null, null, null, null, null, null, null, null);
        HashSet tagSet = new HashSet();
        request.setApplicationTags(tagSet);
        Assert.assertEquals((String)"Incorrect number of matching tags", (long)6L, (long)rmService.getApplications(request).getApplicationList().size());
        tagSet = Sets.newHashSet((Object[])new String[]{tags.get(0)});
        request.setApplicationTags((Set)tagSet);
        Assert.assertEquals((String)"Incorrect number of matching tags", (long)3L, (long)rmService.getApplications(request).getApplicationList().size());
        tagSet = Sets.newHashSet((Object[])new String[]{tags.get(1)});
        request.setApplicationTags((Set)tagSet);
        Assert.assertEquals((String)"Incorrect number of matching tags", (long)2L, (long)rmService.getApplications(request).getApplicationList().size());
        tagSet = Sets.newHashSet((Object[])new String[]{tags.get(2)});
        request.setApplicationTags((Set)tagSet);
        Assert.assertEquals((String)"Incorrect number of matching tags", (long)1L, (long)rmService.getApplications(request).getApplicationList().size());
        request = GetApplicationsRequest.newInstance((ApplicationsRequestScope)ApplicationsRequestScope.VIEWABLE);
        Assert.assertEquals((String)"Incorrect number of applications for the scope", (long)6L, (long)rmService.getApplications(request).getApplicationList().size());
        request = GetApplicationsRequest.newInstance((ApplicationsRequestScope)ApplicationsRequestScope.OWN);
        Assert.assertEquals((String)"Incorrect number of applications for the scope", (long)3L, (long)rmService.getApplications(request).getApplicationList().size());
    }

    @Test(timeout=4000L)
    public void testConcurrentAppSubmit() throws IOException, InterruptedException, BrokenBarrierException, YarnException {
        ResourceScheduler scheduler = TestClientRMService.mockResourceScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(scheduler, rmContext);
        RMStateStore stateStore = (RMStateStore)Mockito.mock(RMStateStore.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)stateStore);
        RMAppManager appManager = new RMAppManager(rmContext, (YarnScheduler)scheduler, null, (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class), new Configuration());
        final ApplicationId appId1 = TestClientRMService.getApplicationId(100);
        ApplicationId appId2 = TestClientRMService.getApplicationId(101);
        final SubmitApplicationRequest submitRequest1 = this.mockSubmitAppRequest(appId1, null, null);
        SubmitApplicationRequest submitRequest2 = this.mockSubmitAppRequest(appId2, null, null);
        final CyclicBarrier startBarrier = new CyclicBarrier(2);
        final CyclicBarrier endBarrier = new CyclicBarrier(2);
        EventHandler<Event> eventHandler = new EventHandler<Event>(){

            public void handle(Event rawEvent) {
                RMAppEvent event;
                if (rawEvent instanceof RMAppEvent && (event = (RMAppEvent)rawEvent).getApplicationId().equals((Object)appId1)) {
                    try {
                        startBarrier.await();
                        endBarrier.await();
                    }
                    catch (BrokenBarrierException e) {
                        LOG.warn("Broken Barrier", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Interrupted while awaiting barriers", (Throwable)e);
                    }
                }
            }
        };
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)eventHandler);
        ((RMContext)Mockito.doReturn((Object)Mockito.mock(RMTimelineCollectorManager.class)).when((Object)rmContext)).getRMTimelineCollectorManager();
        final ClientRMService rmService = new ClientRMService(rmContext, (YarnScheduler)scheduler, appManager, null, null, null);
        rmService.init(new Configuration());
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    rmService.submitApplication(submitRequest1);
                }
                catch (IOException | YarnException throwable) {
                    // empty catch block
                }
            }
        };
        t.start();
        startBarrier.await();
        rmService.submitApplication(submitRequest2);
        endBarrier.await();
        t.join();
    }

    private SubmitApplicationRequest mockSubmitAppRequest(ApplicationId appId, String name, String queue) {
        return this.mockSubmitAppRequest(appId, name, queue, null);
    }

    private SubmitApplicationRequest mockSubmitAppRequest(ApplicationId appId, String name, String queue, Set<String> tags) {
        return this.mockSubmitAppRequest(appId, name, queue, tags, false);
    }

    private SubmitApplicationRequest mockSubmitAppRequest(ApplicationId appId, String name, String queue, Set<String> tags, boolean unmanaged) {
        ContainerLaunchContext amContainerSpec = (ContainerLaunchContext)Mockito.mock(ContainerLaunchContext.class);
        Resource resource = Resources.createResource((int)1024);
        ApplicationSubmissionContext submissionContext = (ApplicationSubmissionContext)this.recordFactory.newRecordInstance(ApplicationSubmissionContext.class);
        submissionContext.setAMContainerSpec(amContainerSpec);
        submissionContext.setApplicationName(name);
        submissionContext.setQueue(queue);
        submissionContext.setApplicationId(appId);
        submissionContext.setResource(resource);
        submissionContext.setApplicationType(this.appType);
        submissionContext.setApplicationTags(tags);
        submissionContext.setUnmanagedAM(unmanaged);
        submissionContext.setPriority(Priority.newInstance((int)0));
        SubmitApplicationRequest submitRequest = (SubmitApplicationRequest)this.recordFactory.newRecordInstance(SubmitApplicationRequest.class);
        submitRequest.setApplicationSubmissionContext(submissionContext);
        return submitRequest;
    }

    private void mockRMContext(ResourceScheduler scheduler, RMContext rmContext) throws IOException {
        Dispatcher dispatcher = (Dispatcher)Mockito.mock(Dispatcher.class);
        Mockito.when((Object)rmContext.getDispatcher()).thenReturn((Object)dispatcher);
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        Mockito.when((Object)dispatcher.getEventHandler()).thenReturn((Object)eventHandler);
        QueueInfo queInfo = (QueueInfo)this.recordFactory.newRecordInstance(QueueInfo.class);
        queInfo.setQueueName("testqueue");
        QueueConfigurations queueConfigs = (QueueConfigurations)this.recordFactory.newRecordInstance(QueueConfigurations.class);
        queueConfigs.setCapacity(0.5f);
        queueConfigs.setAbsoluteCapacity(0.1f);
        queueConfigs.setMaxCapacity(1.0f);
        queueConfigs.setAbsoluteMaxCapacity(1.0f);
        queueConfigs.setMaxAMPercentage(0.2f);
        HashMap<String, QueueConfigurations> queueConfigsByPartition = new HashMap<String, QueueConfigurations>();
        queueConfigsByPartition.put("*", queueConfigs);
        queInfo.setQueueConfigurations(queueConfigsByPartition);
        Mockito.when((Object)scheduler.getQueueInfo((String)ArgumentMatchers.eq((Object)"testqueue"), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean())).thenReturn((Object)queInfo);
        Mockito.when((Object)scheduler.getQueueInfo((String)ArgumentMatchers.eq((Object)"nonexistentqueue"), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean())).thenThrow(new Throwable[]{new IOException("queue does not exist")});
        RMApplicationHistoryWriter writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        Mockito.when((Object)rmContext.getRMApplicationHistoryWriter()).thenReturn((Object)writer);
        SystemMetricsPublisher publisher = (SystemMetricsPublisher)Mockito.mock(SystemMetricsPublisher.class);
        Mockito.when((Object)rmContext.getSystemMetricsPublisher()).thenReturn((Object)publisher);
        Mockito.when((Object)rmContext.getYarnConfiguration()).thenReturn((Object)new YarnConfiguration());
        ConcurrentHashMap<ApplicationId, RMApp> apps = this.getRMApps(rmContext, (YarnScheduler)scheduler);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(apps);
        Mockito.when((Object)scheduler.getAppsInQueue((String)ArgumentMatchers.eq((Object)"testqueue"))).thenReturn(this.getSchedulerApps(apps));
        Mockito.when((Object)rmContext.getScheduler()).thenReturn((Object)scheduler);
    }

    private ConcurrentHashMap<ApplicationId, RMApp> getRMApps(RMContext rmContext, YarnScheduler yarnScheduler) {
        ConcurrentHashMap<ApplicationId, RMApp> apps = new ConcurrentHashMap<ApplicationId, RMApp>();
        ApplicationId applicationId1 = TestClientRMService.getApplicationId(1);
        ApplicationId applicationId2 = TestClientRMService.getApplicationId(2);
        ApplicationId applicationId3 = TestClientRMService.getApplicationId(3);
        YarnConfiguration config = new YarnConfiguration();
        apps.put(applicationId1, (RMApp)this.getRMApp(rmContext, yarnScheduler, applicationId1, config, "testqueue", 10L, 3L, null, null));
        apps.put(applicationId2, (RMApp)this.getRMApp(rmContext, yarnScheduler, applicationId2, config, "a", 20L, 2L, null, ""));
        apps.put(applicationId3, (RMApp)this.getRMApp(rmContext, yarnScheduler, applicationId3, config, "testqueue", 40L, 5L, "high-mem", "high-mem"));
        return apps;
    }

    private List<ApplicationAttemptId> getSchedulerApps(Map<ApplicationId, RMApp> apps) {
        ArrayList<ApplicationAttemptId> schedApps = new ArrayList<ApplicationAttemptId>();
        schedApps.add(ApplicationAttemptId.newInstance((ApplicationId)TestClientRMService.getApplicationId(1), (int)0));
        schedApps.add(ApplicationAttemptId.newInstance((ApplicationId)TestClientRMService.getApplicationId(3), (int)0));
        return schedApps;
    }

    private static ApplicationId getApplicationId(int id) {
        return ApplicationId.newInstance((long)123456L, (int)id);
    }

    private static ApplicationAttemptId getApplicationAttemptId(int id) {
        return ApplicationAttemptId.newInstance((ApplicationId)TestClientRMService.getApplicationId(id), (int)1);
    }

    private RMAppImpl getRMApp(RMContext rmContext, YarnScheduler yarnScheduler, ApplicationId applicationId3, YarnConfiguration config, String queueName, final long memorySeconds, final long vcoreSeconds, String appNodeLabelExpression, String amNodeLabelExpression) {
        ApplicationSubmissionContext asContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        Mockito.when((Object)asContext.getMaxAppAttempts()).thenReturn((Object)1);
        Mockito.when((Object)asContext.getNodeLabelExpression()).thenReturn((Object)appNodeLabelExpression);
        Mockito.when((Object)asContext.getPriority()).thenReturn((Object)Priority.newInstance((int)0));
        RMAppImpl app = (RMAppImpl)Mockito.spy((Object)new RMAppImpl(applicationId3, rmContext, (Configuration)config, null, null, queueName, asContext, yarnScheduler, null, System.currentTimeMillis(), "YARN", null, Collections.singletonList(BuilderUtils.newResourceRequest((Priority)RMAppAttemptImpl.AM_CONTAINER_PRIORITY, (String)"*", (Resource)Resource.newInstance((int)1024, (int)1), (int)1))){

            public ApplicationReport createAndGetApplicationReport(String clientUserName, boolean allowAccess) {
                ApplicationReport report = super.createAndGetApplicationReport(clientUserName, allowAccess);
                ApplicationResourceUsageReport usageReport = report.getApplicationResourceUsageReport();
                usageReport.setMemorySeconds(memorySeconds);
                usageReport.setVcoreSeconds(vcoreSeconds);
                report.setApplicationResourceUsageReport(usageReport);
                return report;
            }
        });
        ((ResourceRequest)app.getAMResourceRequests().get(0)).setNodeLabelExpression(amNodeLabelExpression);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)123456L, (int)1), (int)1);
        RMAppAttemptImpl rmAppAttemptImpl = (RMAppAttemptImpl)Mockito.spy((Object)new RMAppAttemptImpl(attemptId, rmContext, yarnScheduler, null, asContext, (Configuration)config, null, (RMApp)app));
        Container container = Container.newInstance((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L), null, (String)"", null, null, null);
        RMContainerImpl containerimpl = (RMContainerImpl)Mockito.spy((Object)new RMContainerImpl(container, SchedulerRequestKey.extractFrom((Container)container), attemptId, null, "", rmContext));
        HashMap<ApplicationAttemptId, RMAppAttemptImpl> attempts = new HashMap<ApplicationAttemptId, RMAppAttemptImpl>();
        attempts.put(attemptId, rmAppAttemptImpl);
        Mockito.when((Object)app.getCurrentAppAttempt()).thenReturn((Object)rmAppAttemptImpl);
        Mockito.when((Object)app.getAppAttempts()).thenReturn(attempts);
        Mockito.when((Object)app.getApplicationPriority()).thenReturn((Object)Priority.newInstance((int)0));
        Mockito.when((Object)rmAppAttemptImpl.getMasterContainer()).thenReturn((Object)container);
        ResourceScheduler rs = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        Mockito.when((Object)rmContext.getScheduler()).thenReturn((Object)rs);
        Mockito.when((Object)rmContext.getScheduler().getRMContainer((ContainerId)ArgumentMatchers.any(ContainerId.class))).thenReturn((Object)containerimpl);
        SchedulerAppReport sAppReport = (SchedulerAppReport)Mockito.mock(SchedulerAppReport.class);
        Mockito.when((Object)rmContext.getScheduler().getSchedulerAppInfo((ApplicationAttemptId)ArgumentMatchers.any(ApplicationAttemptId.class))).thenReturn((Object)sAppReport);
        ArrayList<RMContainerImpl> rmContainers = new ArrayList<RMContainerImpl>();
        rmContainers.add(containerimpl);
        Mockito.when((Object)rmContext.getScheduler().getSchedulerAppInfo(attemptId).getLiveContainers()).thenReturn(rmContainers);
        ContainerStatus cs = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)containerimpl.completed()).thenReturn((Object)false);
        Mockito.when((Object)containerimpl.getDiagnosticsInfo()).thenReturn((Object)"N/A");
        Mockito.when((Object)containerimpl.getContainerExitStatus()).thenReturn((Object)0);
        Mockito.when((Object)containerimpl.getContainerState()).thenReturn((Object)ContainerState.COMPLETE);
        return app;
    }

    private static ResourceScheduler mockResourceScheduler() throws YarnException {
        ResourceScheduler scheduler = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        Mockito.when((Object)scheduler.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024));
        Mockito.when((Object)scheduler.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)8192));
        Mockito.when((Object)scheduler.getMaximumResourceCapability(ArgumentMatchers.anyString())).thenReturn((Object)Resources.createResource((int)8192));
        Mockito.when((Object)scheduler.getAppsInQueue(QUEUE_1)).thenReturn(Arrays.asList(TestClientRMService.getApplicationAttemptId(101), TestClientRMService.getApplicationAttemptId(102)));
        Mockito.when((Object)scheduler.getAppsInQueue(QUEUE_2)).thenReturn(Arrays.asList(TestClientRMService.getApplicationAttemptId(103)));
        ApplicationAttemptId attemptId = TestClientRMService.getApplicationAttemptId(1);
        Mockito.when((Object)scheduler.getAppResourceUsageReport(attemptId)).thenReturn(null);
        ResourceCalculator rs = (ResourceCalculator)Mockito.mock(ResourceCalculator.class);
        Mockito.when((Object)scheduler.getResourceCalculator()).thenReturn((Object)rs);
        Mockito.when((Object)scheduler.checkAndGetApplicationPriority((Priority)ArgumentMatchers.any(Priority.class), (UserGroupInformation)ArgumentMatchers.any(UserGroupInformation.class), ArgumentMatchers.anyString(), (ApplicationId)ArgumentMatchers.any(ApplicationId.class))).thenReturn((Object)Priority.newInstance((int)0));
        return scheduler;
    }

    private ResourceManager setupResourceManager() {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        ReservationSystemTestUtil.setupQueueConfiguration(conf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setBoolean("yarn.resourcemanager.reservation-system.enable", true);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        try {
            rm.registerNode("127.0.0.1:1", 102400, 100);
            Thread.sleep(1050L);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        return rm;
    }

    private ReservationSubmissionRequest submitReservationTestHelper(ClientRMService clientService, long arrival, long deadline, long duration) {
        ReservationSubmissionResponse sResponse = null;
        GetNewReservationRequest newReservationRequest = GetNewReservationRequest.newInstance();
        ReservationId reservationID = null;
        try {
            reservationID = clientService.getNewReservation(newReservationRequest).getReservationId();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        ReservationSubmissionRequest sRequest = ReservationSystemTestUtil.createSimpleReservationRequest(reservationID, 4, arrival, deadline, duration);
        try {
            sResponse = clientService.submitReservation(sRequest);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)sResponse);
        Assert.assertNotNull((Object)reservationID);
        System.out.println("Submit reservation response: " + reservationID);
        return sRequest;
    }

    @Test
    public void testCreateReservation() {
        ResourceManager rm = this.setupResourceManager();
        ClientRMService clientService = rm.getClientRMService();
        UTCClock clock = new UTCClock();
        long arrival = clock.getTime();
        long duration = 60000L;
        long deadline = (long)((double)arrival + 1.05 * (double)duration);
        ReservationSubmissionRequest sRequest = this.submitReservationTestHelper(clientService, arrival, deadline, duration);
        try {
            clientService.submitReservation(sRequest);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        arrival = clock.getTime();
        ReservationDefinition rDef = sRequest.getReservationDefinition();
        rDef.setArrival(arrival + duration);
        sRequest.setReservationDefinition(rDef);
        try {
            clientService.submitReservation(sRequest);
            Assert.fail((String)"Reservation submission should fail if a duplicate reservation id is used, but the reservation definition has been updated.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof YarnException));
        }
        rm.stop();
    }

    @Test
    public void testUpdateReservation() {
        ResourceManager rm = this.setupResourceManager();
        ClientRMService clientService = rm.getClientRMService();
        UTCClock clock = new UTCClock();
        long arrival = clock.getTime();
        long duration = 60000L;
        long deadline = (long)((double)arrival + 1.05 * (double)duration);
        ReservationSubmissionRequest sRequest = this.submitReservationTestHelper(clientService, arrival, deadline, duration);
        ReservationDefinition rDef = sRequest.getReservationDefinition();
        ReservationRequest rr = (ReservationRequest)rDef.getReservationRequests().getReservationResources().get(0);
        ReservationId reservationID = sRequest.getReservationId();
        rr.setNumContainers(5);
        arrival = clock.getTime();
        duration = 30000L;
        deadline = (long)((double)arrival + 1.05 * (double)duration);
        rr.setDuration(duration);
        rDef.setArrival(arrival);
        rDef.setDeadline(deadline);
        ReservationUpdateRequest uRequest = ReservationUpdateRequest.newInstance((ReservationDefinition)rDef, (ReservationId)reservationID);
        ReservationUpdateResponse uResponse = null;
        try {
            uResponse = clientService.updateReservation(uRequest);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)uResponse);
        System.out.println("Update reservation response: " + uResponse);
        rm.stop();
    }

    @Test
    public void testListReservationsByReservationId() {
        ResourceManager rm = this.setupResourceManager();
        ClientRMService clientService = rm.getClientRMService();
        UTCClock clock = new UTCClock();
        long arrival = clock.getTime();
        long duration = 60000L;
        long deadline = (long)((double)arrival + 1.05 * (double)duration);
        ReservationSubmissionRequest sRequest = this.submitReservationTestHelper(clientService, arrival, deadline, duration);
        ReservationId reservationID = sRequest.getReservationId();
        ReservationListResponse response = null;
        ReservationListRequest request = ReservationListRequest.newInstance((String)"root.dedicated", (String)reservationID.toString(), (long)-1L, (long)-1L, (boolean)false);
        try {
            response = clientService.listReservations(request);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)1L, (long)response.getReservationAllocationState().size());
        Assert.assertEquals((long)((ReservationAllocationState)response.getReservationAllocationState().get(0)).getReservationId().getId(), (long)reservationID.getId());
        Assert.assertEquals((long)((ReservationAllocationState)response.getReservationAllocationState().get(0)).getResourceAllocationRequests().size(), (long)0L);
        rm.stop();
    }

    @Test
    public void testListReservationsByTimeInterval() {
        ResourceManager rm = this.setupResourceManager();
        ClientRMService clientService = rm.getClientRMService();
        UTCClock clock = new UTCClock();
        long arrival = clock.getTime();
        long duration = 60000L;
        long deadline = (long)((double)arrival + 1.05 * (double)duration);
        ReservationSubmissionRequest sRequest = this.submitReservationTestHelper(clientService, arrival, deadline, duration);
        arrival = clock.getTime();
        ReservationId reservationID = sRequest.getReservationId();
        ReservationListRequest request = ReservationListRequest.newInstance((String)"root.dedicated", (String)"", (long)(arrival + duration / 2L), (long)(arrival + duration / 2L), (boolean)true);
        ReservationListResponse response = null;
        try {
            response = clientService.listReservations(request);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)1L, (long)response.getReservationAllocationState().size());
        Assert.assertEquals((long)((ReservationAllocationState)response.getReservationAllocationState().get(0)).getReservationId().getId(), (long)reservationID.getId());
        request = ReservationListRequest.newInstance((String)"root.dedicated", (String)"", (long)1L, (long)Long.MAX_VALUE, (boolean)true);
        response = null;
        try {
            response = clientService.listReservations(request);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)1L, (long)response.getReservationAllocationState().size());
        Assert.assertEquals((long)((ReservationAllocationState)response.getReservationAllocationState().get(0)).getReservationId().getId(), (long)reservationID.getId());
        Assert.assertTrue((((ReservationAllocationState)response.getReservationAllocationState().get(0)).getResourceAllocationRequests().size() > 0 ? 1 : 0) != 0);
        ReservationRequests reservationRequests = ((ReservationAllocationState)response.getReservationAllocationState().get(0)).getReservationDefinition().getReservationRequests();
        Assert.assertEquals((Object)"R_ALL", (Object)reservationRequests.getInterpreter().toString());
        Assert.assertTrue((((ReservationRequest)reservationRequests.getReservationResources().get(0)).getDuration() == duration ? 1 : 0) != 0);
        rm.stop();
    }

    @Test
    public void testListReservationsByInvalidTimeInterval() {
        ResourceManager rm = this.setupResourceManager();
        ClientRMService clientService = rm.getClientRMService();
        UTCClock clock = new UTCClock();
        long arrival = clock.getTime();
        long duration = 60000L;
        long deadline = (long)((double)arrival + 1.05 * (double)duration);
        ReservationSubmissionRequest sRequest = this.submitReservationTestHelper(clientService, arrival, deadline, duration);
        ReservationListRequest request = ReservationListRequest.newInstance((String)"root.dedicated", (String)"", (long)1L, (long)-1L, (boolean)true);
        ReservationListResponse response = null;
        try {
            response = clientService.listReservations(request);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)1L, (long)response.getReservationAllocationState().size());
        Assert.assertEquals((long)((ReservationAllocationState)response.getReservationAllocationState().get(0)).getReservationId().getId(), (long)sRequest.getReservationId().getId());
        request = ReservationListRequest.newInstance((String)"root.dedicated", (String)"", (long)1L, (long)-10L, (boolean)true);
        response = null;
        try {
            response = clientService.listReservations(request);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)1L, (long)response.getReservationAllocationState().size());
        Assert.assertEquals((long)((ReservationAllocationState)response.getReservationAllocationState().get(0)).getReservationId().getId(), (long)sRequest.getReservationId().getId());
        rm.stop();
    }

    @Test
    public void testListReservationsByTimeIntervalContainingNoReservations() {
        ResourceManager rm = this.setupResourceManager();
        ClientRMService clientService = rm.getClientRMService();
        UTCClock clock = new UTCClock();
        long arrival = clock.getTime();
        long duration = 60000L;
        long deadline = (long)((double)arrival + 1.05 * (double)duration);
        ReservationSubmissionRequest sRequest = this.submitReservationTestHelper(clientService, arrival, deadline, duration);
        ReservationListRequest request = ReservationListRequest.newInstance((String)"root.dedicated", (String)"", (long)Long.MAX_VALUE, (long)-1L, (boolean)false);
        ReservationListResponse response = null;
        try {
            response = clientService.listReservations(request);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)response);
        Assertions.assertThat((List)response.getReservationAllocationState()).isEmpty();
        duration = 30000L;
        deadline = sRequest.getReservationDefinition().getDeadline();
        request = ReservationListRequest.newInstance((String)"root.dedicated", (String)"", (long)(deadline + duration), (long)(deadline + 2L * duration), (boolean)false);
        response = null;
        try {
            response = clientService.listReservations(request);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)response);
        Assertions.assertThat((List)response.getReservationAllocationState()).isEmpty();
        arrival = clock.getTime();
        request = ReservationListRequest.newInstance((String)"root.dedicated", (String)"", (long)0L, (long)(arrival - duration), (boolean)false);
        response = null;
        try {
            response = clientService.listReservations(request);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)response);
        Assertions.assertThat((List)response.getReservationAllocationState()).isEmpty();
        request = ReservationListRequest.newInstance((String)"root.dedicated", (String)"", (long)0L, (long)1L, (boolean)false);
        response = null;
        try {
            response = clientService.listReservations(request);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)response);
        Assertions.assertThat((List)response.getReservationAllocationState()).isEmpty();
        rm.stop();
    }

    @Test
    public void testReservationDelete() {
        ResourceManager rm = this.setupResourceManager();
        ClientRMService clientService = rm.getClientRMService();
        UTCClock clock = new UTCClock();
        long arrival = clock.getTime();
        long duration = 60000L;
        long deadline = (long)((double)arrival + 1.05 * (double)duration);
        ReservationSubmissionRequest sRequest = this.submitReservationTestHelper(clientService, arrival, deadline, duration);
        ReservationId reservationID = sRequest.getReservationId();
        ReservationDeleteRequest dRequest = ReservationDeleteRequest.newInstance((ReservationId)reservationID);
        ReservationDeleteResponse dResponse = null;
        try {
            dResponse = clientService.deleteReservation(dRequest);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)dResponse);
        System.out.println("Delete reservation response: " + dResponse);
        ReservationListRequest request = ReservationListRequest.newInstance((String)"root.dedicated", (String)reservationID.toString(), (long)-1L, (long)-1L, (boolean)false);
        ReservationListResponse response = null;
        try {
            response = clientService.listReservations(request);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)0L, (long)response.getReservationAllocationState().size());
        rm.stop();
    }

    @Test
    public void testGetNodeLabels() throws Exception {
        MockRM rm = new MockRM(){

            @Override
            protected ClientRMService createClientRMService() {
                return new ClientRMService((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager());
            }
        };
        rm.start();
        NodeLabel labelX = NodeLabel.newInstance((String)"x", (boolean)false);
        NodeLabel labelY = NodeLabel.newInstance((String)"y");
        RMNodeLabelsManager labelsMgr = rm.getRMContext().getNodeLabelManager();
        labelsMgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)labelX, (Object)labelY));
        NodeId node1 = NodeId.newInstance((String)"host1", (int)1234);
        NodeId node2 = NodeId.newInstance((String)"host2", (int)1234);
        HashMap<NodeId, ImmutableSet> map = new HashMap<NodeId, ImmutableSet>();
        map.put(node1, ImmutableSet.of((Object)"x"));
        map.put(node2, ImmutableSet.of((Object)"y"));
        labelsMgr.replaceLabelsOnNode(map);
        Configuration conf = new Configuration();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress rmAddress = rm.getClientRMService().getBindAddress();
        LOG.info("Connecting to ResourceManager at " + rmAddress);
        ApplicationClientProtocol client = (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, rmAddress, conf);
        GetClusterNodeLabelsResponse response = client.getClusterNodeLabels(GetClusterNodeLabelsRequest.newInstance());
        Assert.assertTrue((boolean)response.getNodeLabelList().containsAll(Arrays.asList(labelX, labelY)));
        GetNodesToLabelsResponse response1 = client.getNodeToLabels(GetNodesToLabelsRequest.newInstance());
        Map nodeToLabels = response1.getNodeToLabels();
        Assert.assertTrue((boolean)nodeToLabels.keySet().containsAll(Arrays.asList(node1, node2)));
        Assert.assertTrue((boolean)((Set)nodeToLabels.get(node1)).containsAll(Arrays.asList(labelX.getName())));
        Assert.assertTrue((boolean)((Set)nodeToLabels.get(node2)).containsAll(Arrays.asList(labelY.getName())));
        Assert.assertFalse((boolean)((Set)nodeToLabels.get(node1)).containsAll(Arrays.asList(NodeLabel.newInstance((String)"x"))));
        rpc.stopProxy((Object)client, conf);
        rm.stop();
    }

    @Test
    public void testGetLabelsToNodes() throws Exception {
        MockRM rm = new MockRM(){

            @Override
            protected ClientRMService createClientRMService() {
                return new ClientRMService((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager());
            }
        };
        rm.start();
        NodeLabel labelX = NodeLabel.newInstance((String)"x", (boolean)false);
        NodeLabel labelY = NodeLabel.newInstance((String)"y", (boolean)false);
        NodeLabel labelZ = NodeLabel.newInstance((String)"z", (boolean)false);
        RMNodeLabelsManager labelsMgr = rm.getRMContext().getNodeLabelManager();
        labelsMgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)labelX, (Object)labelY, (Object)labelZ));
        NodeId node1A = NodeId.newInstance((String)"host1", (int)1234);
        NodeId node1B = NodeId.newInstance((String)"host1", (int)5678);
        NodeId node2A = NodeId.newInstance((String)"host2", (int)1234);
        NodeId node3A = NodeId.newInstance((String)"host3", (int)1234);
        NodeId node3B = NodeId.newInstance((String)"host3", (int)5678);
        HashMap<NodeId, ImmutableSet> map = new HashMap<NodeId, ImmutableSet>();
        map.put(node1A, ImmutableSet.of((Object)"x"));
        map.put(node1B, ImmutableSet.of((Object)"z"));
        map.put(node2A, ImmutableSet.of((Object)"y"));
        map.put(node3A, ImmutableSet.of((Object)"y"));
        map.put(node3B, ImmutableSet.of((Object)"z"));
        labelsMgr.replaceLabelsOnNode(map);
        Configuration conf = new Configuration();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress rmAddress = rm.getClientRMService().getBindAddress();
        LOG.info("Connecting to ResourceManager at " + rmAddress);
        ApplicationClientProtocol client = (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, rmAddress, conf);
        GetClusterNodeLabelsResponse response = client.getClusterNodeLabels(GetClusterNodeLabelsRequest.newInstance());
        Assert.assertTrue((boolean)response.getNodeLabelList().containsAll(Arrays.asList(labelX, labelY, labelZ)));
        GetLabelsToNodesResponse response1 = client.getLabelsToNodes(GetLabelsToNodesRequest.newInstance());
        Map labelsToNodes = response1.getLabelsToNodes();
        Assert.assertTrue((boolean)labelsToNodes.keySet().containsAll(Arrays.asList(labelX.getName(), labelY.getName(), labelZ.getName())));
        Assert.assertTrue((boolean)((Set)labelsToNodes.get(labelX.getName())).containsAll(Arrays.asList(node1A)));
        Assert.assertTrue((boolean)((Set)labelsToNodes.get(labelY.getName())).containsAll(Arrays.asList(node2A, node3A)));
        Assert.assertTrue((boolean)((Set)labelsToNodes.get(labelZ.getName())).containsAll(Arrays.asList(node1B, node3B)));
        HashSet<String> setlabels = new HashSet<String>(Arrays.asList("x", "z"));
        GetLabelsToNodesResponse response2 = client.getLabelsToNodes(GetLabelsToNodesRequest.newInstance(setlabels));
        labelsToNodes = response2.getLabelsToNodes();
        Assert.assertTrue((boolean)labelsToNodes.keySet().containsAll(Arrays.asList(labelX.getName(), labelZ.getName())));
        Assert.assertTrue((boolean)((Set)labelsToNodes.get(labelX.getName())).containsAll(Arrays.asList(node1A)));
        Assert.assertTrue((boolean)((Set)labelsToNodes.get(labelZ.getName())).containsAll(Arrays.asList(node1B, node3B)));
        Assertions.assertThat((Iterable)((Iterable)labelsToNodes.get(labelY.getName()))).isNull();
        rpc.stopProxy((Object)client, conf);
        rm.close();
    }

    @Test(timeout=120000L)
    public void testGetClusterNodeAttributes() throws IOException, YarnException {
        YarnConfiguration newConf = NodeAttributeTestUtils.getRandomDirConf(null);
        MockRM rm = new MockRM((Configuration)newConf){

            @Override
            protected ClientRMService createClientRMService() {
                return new ClientRMService((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager());
            }
        };
        rm.start();
        NodeAttributesManager mgr = rm.getRMContext().getNodeAttributesManager();
        NodeId host1 = NodeId.newInstance((String)"host1", (int)0);
        NodeId host2 = NodeId.newInstance((String)"host2", (int)0);
        NodeAttribute gpu = NodeAttribute.newInstance((String)"rm.yarn.io", (String)"GPU", (NodeAttributeType)NodeAttributeType.STRING, (String)"nvida");
        NodeAttribute os = NodeAttribute.newInstance((String)"rm.yarn.io", (String)"OS", (NodeAttributeType)NodeAttributeType.STRING, (String)"windows64");
        NodeAttribute docker = NodeAttribute.newInstance((String)"nm.yarn.io", (String)"DOCKER", (NodeAttributeType)NodeAttributeType.STRING, (String)"docker0");
        HashMap<String, ImmutableSet> nodes = new HashMap<String, ImmutableSet>();
        nodes.put(host1.getHost(), ImmutableSet.of((Object)gpu, (Object)os));
        nodes.put(host2.getHost(), ImmutableSet.of((Object)docker));
        mgr.addNodeAttributes(nodes);
        Configuration conf = new Configuration();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress rmAddress = rm.getClientRMService().getBindAddress();
        LOG.info("Connecting to ResourceManager at " + rmAddress);
        ApplicationClientProtocol client = (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, rmAddress, conf);
        GetClusterNodeAttributesRequest request = GetClusterNodeAttributesRequest.newInstance();
        GetClusterNodeAttributesResponse response = client.getClusterNodeAttributes(request);
        Set attributes = response.getNodeAttributes();
        Assert.assertEquals((String)"Size not correct", (long)3L, (long)attributes.size());
        Assert.assertTrue((boolean)attributes.contains(NodeAttributeInfo.newInstance((NodeAttribute)gpu)));
        Assert.assertTrue((boolean)attributes.contains(NodeAttributeInfo.newInstance((NodeAttribute)os)));
        Assert.assertTrue((boolean)attributes.contains(NodeAttributeInfo.newInstance((NodeAttribute)docker)));
        rpc.stopProxy((Object)client, conf);
        rm.close();
    }

    @Test(timeout=120000L)
    public void testGetAttributesToNodes() throws IOException, YarnException {
        YarnConfiguration newConf = NodeAttributeTestUtils.getRandomDirConf(null);
        MockRM rm = new MockRM((Configuration)newConf){

            @Override
            protected ClientRMService createClientRMService() {
                return new ClientRMService((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager());
            }
        };
        rm.start();
        NodeAttributesManager mgr = rm.getRMContext().getNodeAttributesManager();
        String node1 = "host1";
        String node2 = "host2";
        NodeAttribute gpu = NodeAttribute.newInstance((String)"rm.yarn.io", (String)"GPU", (NodeAttributeType)NodeAttributeType.STRING, (String)"nvidia");
        NodeAttribute os = NodeAttribute.newInstance((String)"rm.yarn.io", (String)"OS", (NodeAttributeType)NodeAttributeType.STRING, (String)"windows64");
        NodeAttribute docker = NodeAttribute.newInstance((String)"nm.yarn.io", (String)"DOCKER", (NodeAttributeType)NodeAttributeType.STRING, (String)"docker0");
        NodeAttribute dist = NodeAttribute.newInstance((String)"nm.yarn.io", (String)"VERSION", (NodeAttributeType)NodeAttributeType.STRING, (String)"3_0_2");
        HashMap<String, ImmutableSet> nodes = new HashMap<String, ImmutableSet>();
        nodes.put(node1, ImmutableSet.of((Object)gpu, (Object)os, (Object)dist));
        nodes.put(node2, ImmutableSet.of((Object)docker, (Object)dist));
        mgr.addNodeAttributes(nodes);
        Configuration conf = new Configuration();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress rmAddress = rm.getClientRMService().getBindAddress();
        LOG.info("Connecting to ResourceManager at " + rmAddress);
        ApplicationClientProtocol client = (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, rmAddress, conf);
        GetAttributesToNodesRequest request = GetAttributesToNodesRequest.newInstance();
        GetAttributesToNodesResponse response = client.getAttributesToNodes(request);
        Map attrs = response.getAttributesToNodes();
        Assertions.assertThat((Map)response.getAttributesToNodes()).hasSize(4);
        Assertions.assertThat((List)((List)attrs.get(dist.getAttributeKey()))).hasSize(2);
        Assertions.assertThat((List)((List)attrs.get(os.getAttributeKey()))).hasSize(1);
        Assertions.assertThat((List)((List)attrs.get(gpu.getAttributeKey()))).hasSize(1);
        Assert.assertTrue((boolean)this.findHostnameAndValInMapping(node1, "3_0_2", (List)attrs.get(dist.getAttributeKey())));
        Assert.assertTrue((boolean)this.findHostnameAndValInMapping(node2, "3_0_2", (List)attrs.get(dist.getAttributeKey())));
        Assert.assertTrue((boolean)this.findHostnameAndValInMapping(node2, "docker0", (List)attrs.get(docker.getAttributeKey())));
        GetAttributesToNodesRequest request2 = GetAttributesToNodesRequest.newInstance((Set)ImmutableSet.of((Object)docker.getAttributeKey()));
        GetAttributesToNodesResponse response2 = client.getAttributesToNodes(request2);
        Map attrs2 = response2.getAttributesToNodes();
        Assertions.assertThat((Map)attrs2).hasSize(1);
        Assert.assertTrue((boolean)this.findHostnameAndValInMapping(node2, "docker0", (List)attrs2.get(docker.getAttributeKey())));
        GetAttributesToNodesRequest request3 = GetAttributesToNodesRequest.newInstance((Set)ImmutableSet.of((Object)docker.getAttributeKey(), (Object)os.getAttributeKey()));
        GetAttributesToNodesResponse response3 = client.getAttributesToNodes(request3);
        Map attrs3 = response3.getAttributesToNodes();
        Assertions.assertThat((Map)attrs3).hasSize(2);
        Assert.assertTrue((boolean)this.findHostnameAndValInMapping(node1, "windows64", (List)attrs3.get(os.getAttributeKey())));
        Assert.assertTrue((boolean)this.findHostnameAndValInMapping(node2, "docker0", (List)attrs3.get(docker.getAttributeKey())));
        rpc.stopProxy((Object)client, conf);
        rm.close();
    }

    private boolean findHostnameAndValInMapping(String hostname, String attrVal, List<NodeToAttributeValue> mappingVals) {
        for (NodeToAttributeValue value : mappingVals) {
            if (!value.getHostname().equals(hostname)) continue;
            return attrVal.equals(value.getAttributeValue());
        }
        return false;
    }

    @Test(timeout=120000L)
    public void testGetNodesToAttributes() throws IOException, YarnException {
        YarnConfiguration newConf = NodeAttributeTestUtils.getRandomDirConf(null);
        MockRM rm = new MockRM((Configuration)newConf){

            @Override
            protected ClientRMService createClientRMService() {
                return new ClientRMService((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager());
            }
        };
        rm.start();
        NodeAttributesManager mgr = rm.getRMContext().getNodeAttributesManager();
        String node1 = "host1";
        String node2 = "host2";
        NodeAttribute gpu = NodeAttribute.newInstance((String)"rm.yarn.io", (String)"GPU", (NodeAttributeType)NodeAttributeType.STRING, (String)"nvida");
        NodeAttribute os = NodeAttribute.newInstance((String)"rm.yarn.io", (String)"OS", (NodeAttributeType)NodeAttributeType.STRING, (String)"windows64");
        NodeAttribute docker = NodeAttribute.newInstance((String)"nm.yarn.io", (String)"DOCKER", (NodeAttributeType)NodeAttributeType.STRING, (String)"docker0");
        NodeAttribute dist = NodeAttribute.newInstance((String)"nm.yarn.io", (String)"VERSION", (NodeAttributeType)NodeAttributeType.STRING, (String)"3_0_2");
        HashMap<String, ImmutableSet> nodes = new HashMap<String, ImmutableSet>();
        nodes.put(node1, ImmutableSet.of((Object)gpu, (Object)os, (Object)dist));
        nodes.put(node2, ImmutableSet.of((Object)docker, (Object)dist));
        mgr.addNodeAttributes(nodes);
        Configuration conf = new Configuration();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress rmAddress = rm.getClientRMService().getBindAddress();
        LOG.info("Connecting to ResourceManager at " + rmAddress);
        ApplicationClientProtocol client = (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, rmAddress, conf);
        GetNodesToAttributesRequest request1 = GetNodesToAttributesRequest.newInstance(null);
        GetNodesToAttributesResponse response1 = client.getNodesToAttributes(request1);
        Map hostToAttrs = response1.getNodeToAttributes();
        Assert.assertEquals((long)2L, (long)hostToAttrs.size());
        Assert.assertTrue((boolean)((Set)hostToAttrs.get(node2)).contains(dist));
        Assert.assertTrue((boolean)((Set)hostToAttrs.get(node2)).contains(docker));
        Assert.assertTrue((boolean)((Set)hostToAttrs.get(node1)).contains(dist));
        GetNodesToAttributesRequest request2 = GetNodesToAttributesRequest.newInstance((Set)ImmutableSet.of((Object)node1));
        GetNodesToAttributesResponse response2 = client.getNodesToAttributes(request2);
        hostToAttrs = response2.getNodeToAttributes();
        Assert.assertEquals((long)1L, (long)response2.getNodeToAttributes().size());
        Assert.assertTrue((boolean)((Set)hostToAttrs.get(node1)).contains(dist));
        GetNodesToAttributesRequest request3 = GetNodesToAttributesRequest.newInstance(Collections.emptySet());
        GetNodesToAttributesResponse response3 = client.getNodesToAttributes(request3);
        hostToAttrs = response3.getNodeToAttributes();
        Assert.assertEquals((long)2L, (long)hostToAttrs.size());
        Assert.assertTrue((boolean)((Set)hostToAttrs.get(node2)).contains(dist));
        Assert.assertTrue((boolean)((Set)hostToAttrs.get(node2)).contains(docker));
        Assert.assertTrue((boolean)((Set)hostToAttrs.get(node1)).contains(dist));
        GetNodesToAttributesRequest request4 = GetNodesToAttributesRequest.newInstance((Set)ImmutableSet.of((Object)"invalid"));
        GetNodesToAttributesResponse response4 = client.getNodesToAttributes(request4);
        hostToAttrs = response4.getNodeToAttributes();
        Assert.assertEquals((long)0L, (long)hostToAttrs.size());
        rpc.stopProxy((Object)client, conf);
        rm.close();
    }

    @Test(timeout=120000L)
    public void testUpdatePriorityAndKillAppWithZeroClusterResource() throws Exception {
        int maxPriority = 10;
        int appPriority = 5;
        YarnConfiguration conf = new YarnConfiguration();
        Assume.assumeFalse((String)"FairScheduler does not support Application Priorities", (boolean)conf.get("yarn.resourcemanager.scheduler.class").equals(FairScheduler.class.getName()));
        conf.setInt("yarn.cluster.max-application-priority", maxPriority);
        MockRM rm = new MockRM((Configuration)conf);
        rm.init((Configuration)conf);
        rm.start();
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppPriority(Priority.newInstance((int)appPriority)).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        ClientRMService rmService = rm.getClientRMService();
        this.testApplicationPriorityUpdation(rmService, app1, appPriority, appPriority);
        rm.killApp(app1.getApplicationId());
        rm.waitForState(app1.getApplicationId(), RMAppState.KILLED);
        rm.stop();
    }

    @Test(timeout=120000L)
    public void testUpdateApplicationPriorityRequest() throws Exception {
        int maxPriority = 10;
        int appPriority = 5;
        YarnConfiguration conf = new YarnConfiguration();
        Assume.assumeFalse((String)"FairScheduler does not support Application Priorities", (boolean)conf.get("yarn.resourcemanager.scheduler.class").equals(FairScheduler.class.getName()));
        conf.setInt("yarn.cluster.max-application-priority", maxPriority);
        MockRM rm = new MockRM((Configuration)conf);
        rm.init((Configuration)conf);
        rm.start();
        rm.registerNode("host1:1234", 1024);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppPriority(Priority.newInstance((int)appPriority)).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        Assert.assertEquals((String)"Incorrect priority has been set to application", (long)appPriority, (long)app1.getApplicationPriority().getPriority());
        appPriority = 11;
        ClientRMService rmService = rm.getClientRMService();
        this.testApplicationPriorityUpdation(rmService, app1, appPriority, maxPriority);
        appPriority = 9;
        this.testApplicationPriorityUpdation(rmService, app1, appPriority, appPriority);
        rm.killApp(app1.getApplicationId());
        rm.waitForState(app1.getApplicationId(), RMAppState.KILLED);
        ApplicationId invalidAppId = ApplicationId.newInstance((long)123456789L, (int)3);
        UpdateApplicationPriorityRequest updateRequest = UpdateApplicationPriorityRequest.newInstance((ApplicationId)invalidAppId, (Priority)Priority.newInstance((int)appPriority));
        try {
            rmService.updateApplicationPriority(updateRequest);
            Assert.fail((String)"ApplicationNotFoundException should be thrown for invalid application id");
        }
        catch (ApplicationNotFoundException applicationNotFoundException) {
            // empty catch block
        }
        updateRequest = UpdateApplicationPriorityRequest.newInstance((ApplicationId)app1.getApplicationId(), (Priority)Priority.newInstance((int)11));
        Assert.assertEquals((String)"Incorrect priority has been set to application", (long)appPriority, (long)rmService.updateApplicationPriority(updateRequest).getApplicationPriority().getPriority());
        rm.stop();
    }

    private void testApplicationPriorityUpdation(ClientRMService rmService, RMApp app1, int tobeUpdatedPriority, int expected) throws YarnException, IOException {
        UpdateApplicationPriorityRequest updateRequest = UpdateApplicationPriorityRequest.newInstance((ApplicationId)app1.getApplicationId(), (Priority)Priority.newInstance((int)tobeUpdatedPriority));
        UpdateApplicationPriorityResponse updateApplicationPriority = rmService.updateApplicationPriority(updateRequest);
        Assert.assertEquals((String)"Incorrect priority has been set to application", (long)expected, (long)app1.getApplicationSubmissionContext().getPriority().getPriority());
        Assert.assertEquals((String)"Incorrect priority has been returned", (long)expected, (long)updateApplicationPriority.getApplicationPriority().getPriority());
    }

    private void createExcludeFile(String filename) throws IOException {
        File file = new File(filename);
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream out = new FileOutputStream(file);
        out.write("decommisssionedHost".getBytes());
        out.close();
    }

    @Test
    public void testRMStartWithDecommissionedNode() throws Exception {
        String excludeFile = "excludeFile";
        this.createExcludeFile(excludeFile);
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.resourcemanager.nodes.exclude-path", excludeFile);
        MockRM rm = new MockRM((Configuration)conf){

            @Override
            protected ClientRMService createClientRMService() {
                return new ClientRMService((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager());
            }
        };
        rm.start();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress rmAddress = rm.getClientRMService().getBindAddress();
        LOG.info("Connecting to ResourceManager at " + rmAddress);
        ApplicationClientProtocol client = (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, rmAddress, (Configuration)conf);
        GetClusterNodesRequest request = GetClusterNodesRequest.newInstance(EnumSet.allOf(NodeState.class));
        List nodeReports = client.getClusterNodes(request).getNodeReports();
        Assert.assertEquals((long)1L, (long)nodeReports.size());
        rm.stop();
        rpc.stopProxy((Object)client, (Configuration)conf);
        new File(excludeFile).delete();
    }

    @Test
    public void testGetResourceTypesInfoWhenResourceProfileDisabled() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        MockRM rm = new MockRM((Configuration)conf){

            @Override
            protected ClientRMService createClientRMService() {
                return new ClientRMService((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager());
            }
        };
        rm.start();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress rmAddress = rm.getClientRMService().getBindAddress();
        LOG.info("Connecting to ResourceManager at " + rmAddress);
        ApplicationClientProtocol client = (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, rmAddress, (Configuration)conf);
        GetAllResourceTypeInfoRequest request = GetAllResourceTypeInfoRequest.newInstance();
        GetAllResourceTypeInfoResponse response = client.getResourceTypeInfo(request);
        Assert.assertEquals((long)2L, (long)response.getResourceTypeInfo().size());
        Assert.assertEquals((Object)ResourceInformation.MEMORY_MB.getName(), (Object)((ResourceTypeInfo)response.getResourceTypeInfo().get(0)).getName());
        Assert.assertEquals((Object)ResourceInformation.MEMORY_MB.getUnits(), (Object)((ResourceTypeInfo)response.getResourceTypeInfo().get(0)).getDefaultUnit());
        Assert.assertEquals((Object)ResourceInformation.VCORES.getName(), (Object)((ResourceTypeInfo)response.getResourceTypeInfo().get(1)).getName());
        Assert.assertEquals((Object)ResourceInformation.VCORES.getUnits(), (Object)((ResourceTypeInfo)response.getResourceTypeInfo().get(1)).getDefaultUnit());
        rm.stop();
        rpc.stopProxy((Object)client, (Configuration)conf);
    }

    @Test
    public void testGetApplicationsWithPerUserApps() throws IOException, YarnException {
        ResourceScheduler scheduler = TestClientRMService.mockResourceScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(scheduler, rmContext);
        RMStateStore stateStore = (RMStateStore)Mockito.mock(RMStateStore.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)stateStore);
        ((RMContext)Mockito.doReturn((Object)Mockito.mock(RMTimelineCollectorManager.class)).when((Object)rmContext)).getRMTimelineCollectorManager();
        RMAppManager appManager = new RMAppManager(rmContext, (YarnScheduler)scheduler, null, (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class), new Configuration());
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)new EventHandler<Event>(){

            public void handle(Event event) {
            }
        });
        QueueACLsManager queueAclsManager = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)queueAclsManager.checkAccess((UserGroupInformation)ArgumentMatchers.any(UserGroupInformation.class), (QueueACL)ArgumentMatchers.any(QueueACL.class), (RMApp)ArgumentMatchers.any(RMApp.class), (String)ArgumentMatchers.any(String.class), ArgumentMatchers.anyList())).thenReturn((Object)false);
        ApplicationACLsManager appAclsManager = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        Mockito.when((Object)appAclsManager.checkAccess((UserGroupInformation)ArgumentMatchers.eq((Object)UserGroupInformation.getCurrentUser()), (ApplicationAccessType)ArgumentMatchers.any(ApplicationAccessType.class), (String)ArgumentMatchers.any(String.class), (ApplicationId)ArgumentMatchers.any(ApplicationId.class))).thenReturn((Object)false);
        ClientRMService rmService = new ClientRMService(rmContext, (YarnScheduler)scheduler, appManager, appAclsManager, queueAclsManager, null);
        rmService.init(new Configuration());
        String[] queues = new String[]{QUEUE_1, QUEUE_2};
        String[] appNames = new String[]{MockApps.newAppName(), MockApps.newAppName(), MockApps.newAppName()};
        ApplicationId[] appIds = new ApplicationId[]{TestClientRMService.getApplicationId(101), TestClientRMService.getApplicationId(102), TestClientRMService.getApplicationId(103)};
        List<String> tags = Arrays.asList("Tag1", "Tag2", "Tag3");
        long[] submitTimeMillis = new long[3];
        for (int i = 0; i < appIds.length; ++i) {
            ApplicationId appId = appIds[i];
            SubmitApplicationRequest submitRequest = this.mockSubmitAppRequest(appId, appNames[i], queues[i % queues.length], new HashSet<String>(tags.subList(0, i + 1)));
            rmService.submitApplication(submitRequest);
            submitTimeMillis[i] = System.currentTimeMillis();
        }
        GetApplicationsRequest request = GetApplicationsRequest.newInstance();
        Assert.assertEquals((String)"Incorrect total number of apps", (long)6L, (long)rmService.getApplications(request).getApplicationList().size());
        rmService.setDisplayPerUserApps(true);
        Assert.assertEquals((String)"Incorrect number of applications for user", (long)0L, (long)rmService.getApplications(request).getApplicationList().size());
        rmService.setDisplayPerUserApps(false);
    }

    @Test
    public void testRegisterNMWithDiffUnits() throws Exception {
        ResourceUtils.resetResourceTypes();
        YarnConfiguration yarnConf = new YarnConfiguration();
        String resourceTypesFileName = "resource-types-4.xml";
        InputStream source = yarnConf.getClassLoader().getResourceAsStream(resourceTypesFileName);
        this.resourceTypesFile = new File(yarnConf.getClassLoader().getResource(".").getPath(), "resource-types.xml");
        FileUtils.copyInputStreamToFile((InputStream)source, (File)this.resourceTypesFile);
        ResourceUtils.getResourceTypes();
        yarnConf.setClass("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class, ResourceCalculator.class);
        MockRM rm = new MockRM((Configuration)yarnConf){

            @Override
            protected ClientRMService createClientRMService() {
                return new ClientRMService((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager());
            }
        };
        rm.start();
        Resource resource = BuilderUtils.newResource((long)1024L, (int)1);
        resource.setResourceInformation("memory-mb", ResourceInformation.newInstance((String)"memory-mb", (String)"G", (long)1024L));
        resource.setResourceInformation("resource1", ResourceInformation.newInstance((String)"resource1", (String)"T", (long)1L));
        resource.setResourceInformation("resource2", ResourceInformation.newInstance((String)"resource2", (String)"M", (long)1L));
        MockNM node = rm.registerNode("host1:1234", resource);
        node.nodeHeartbeat(true);
        Configuration conf = new Configuration();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress rmAddress = rm.getClientRMService().getBindAddress();
        LOG.info("Connecting to ResourceManager at " + rmAddress);
        ApplicationClientProtocol client = (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, rmAddress, conf);
        GetClusterNodesRequest request = GetClusterNodesRequest.newInstance(EnumSet.of(NodeState.RUNNING));
        List nodeReports = client.getClusterNodes(request).getNodeReports();
        Assert.assertEquals((long)1L, (long)nodeReports.size());
        Assert.assertNotSame((String)"Node is expected to be healthy!", (Object)NodeState.UNHEALTHY, (Object)((NodeReport)nodeReports.get(0)).getNodeState());
        Assert.assertEquals((long)1L, (long)nodeReports.size());
        Assert.assertEquals((Object)"G", (Object)((NodeReport)nodeReports.get(0)).getCapability().getResourceInformation("resource1").getUnits());
        Assert.assertEquals((long)1000L, (long)((NodeReport)nodeReports.get(0)).getCapability().getResourceInformation("resource1").getValue());
        Assert.assertEquals((Object)"m", (Object)((NodeReport)nodeReports.get(0)).getCapability().getResourceInformation("resource2").getUnits());
        Assert.assertEquals((long)1000000000L, (long)((NodeReport)nodeReports.get(0)).getCapability().getResourceInformation("resource2").getValue());
        Assert.assertEquals((Object)"Mi", (Object)((NodeReport)nodeReports.get(0)).getCapability().getResourceInformation("memory-mb").getUnits());
        Assert.assertEquals((long)976562L, (long)((NodeReport)nodeReports.get(0)).getCapability().getResourceInformation("memory-mb").getValue());
        rpc.stopProxy((Object)client, conf);
        rm.close();
    }

    @After
    public void tearDown() {
        if (this.resourceTypesFile != null && this.resourceTypesFile.exists()) {
            this.resourceTypesFile.delete();
        }
    }
}

