/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.ams.ApplicationMasterServiceContext;
import org.apache.hadoop.yarn.ams.ApplicationMasterServiceProcessor;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestApplicationMasterServiceInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(TestApplicationMasterServiceInterceptor.class);
    private static AtomicInteger beforeRegCount = new AtomicInteger(0);
    private static AtomicInteger afterRegCount = new AtomicInteger(0);
    private static AtomicInteger beforeAllocCount = new AtomicInteger(0);
    private static AtomicInteger afterAllocCount = new AtomicInteger(0);
    private static AtomicInteger beforeFinishCount = new AtomicInteger(0);
    private static AtomicInteger afterFinishCount = new AtomicInteger(0);
    private static AtomicInteger initCount = new AtomicInteger(0);
    private static YarnConfiguration conf;
    private static final int GB = 1024;

    @Before
    public void setup() {
        conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
    }

    @Test(timeout=300000L)
    public void testApplicationMasterInterceptor() throws Exception {
        conf.set("yarn.resourcemanager.application-master-service.processors", TestInterceptor1.class.getName() + "," + TestInterceptor2.class.getName());
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(2048L, rm);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        int allocCount = 0;
        am1.addRequests(new String[]{"127.0.0.1"}, 1024, 1, 1);
        AllocateResponse alloc1Response = am1.schedule();
        ++allocCount;
        nm1.nodeHeartbeat(true);
        while (alloc1Response.getAllocatedContainers().size() < 1) {
            LOG.info("Waiting for containers to be created for app 1...");
            Thread.sleep(1000L);
            alloc1Response = am1.schedule();
            ++allocCount;
        }
        Container allocatedContainer = (Container)alloc1Response.getAllocatedContainers().get(0);
        ContainerTokenIdentifier tokenId = BuilderUtils.newContainerTokenIdentifier((Token)allocatedContainer.getContainerToken());
        am1.unregisterAppAttempt();
        Assert.assertEquals((long)1L, (long)beforeRegCount.get());
        Assert.assertEquals((long)1L, (long)afterRegCount.get());
        Assert.assertEquals((long)(allocCount * 2), (long)beforeAllocCount.get());
        Assert.assertEquals((long)(allocCount * 2), (long)afterAllocCount.get());
        Assert.assertEquals((long)1L, (long)beforeFinishCount.get());
        Assert.assertEquals((long)1L, (long)afterFinishCount.get());
        rm.stop();
    }

    static class TestInterceptor2
    implements ApplicationMasterServiceProcessor {
        private ApplicationMasterServiceProcessor nextProcessor;

        TestInterceptor2() {
        }

        public void init(ApplicationMasterServiceContext amsContext, ApplicationMasterServiceProcessor next) {
            initCount.incrementAndGet();
            this.nextProcessor = next;
        }

        public void registerApplicationMaster(ApplicationAttemptId applicationAttemptId, RegisterApplicationMasterRequest request, RegisterApplicationMasterResponse response) throws IOException, YarnException {
            beforeRegCount.incrementAndGet();
            this.nextProcessor.registerApplicationMaster(applicationAttemptId, request, response);
            afterRegCount.incrementAndGet();
        }

        public void allocate(ApplicationAttemptId appAttemptId, AllocateRequest request, AllocateResponse response) throws YarnException {
            beforeAllocCount.incrementAndGet();
            this.nextProcessor.allocate(appAttemptId, request, response);
            afterAllocCount.incrementAndGet();
        }

        public void finishApplicationMaster(ApplicationAttemptId applicationAttemptId, FinishApplicationMasterRequest request, FinishApplicationMasterResponse response) {
            beforeFinishCount.incrementAndGet();
            this.nextProcessor.finishApplicationMaster(applicationAttemptId, request, response);
            afterFinishCount.incrementAndGet();
        }
    }

    static class TestInterceptor1
    implements ApplicationMasterServiceProcessor {
        private ApplicationMasterServiceProcessor nextProcessor;

        TestInterceptor1() {
        }

        public void init(ApplicationMasterServiceContext amsContext, ApplicationMasterServiceProcessor next) {
            initCount.incrementAndGet();
            this.nextProcessor = next;
        }

        public void registerApplicationMaster(ApplicationAttemptId applicationAttemptId, RegisterApplicationMasterRequest request, RegisterApplicationMasterResponse response) throws IOException, YarnException {
            this.nextProcessor.registerApplicationMaster(applicationAttemptId, request, response);
        }

        public void allocate(ApplicationAttemptId appAttemptId, AllocateRequest request, AllocateResponse response) throws YarnException {
            beforeAllocCount.incrementAndGet();
            this.nextProcessor.allocate(appAttemptId, request, response);
            afterAllocCount.incrementAndGet();
        }

        public void finishApplicationMaster(ApplicationAttemptId applicationAttemptId, FinishApplicationMasterRequest request, FinishApplicationMasterResponse response) {
            beforeFinishCount.incrementAndGet();
            afterFinishCount.incrementAndGet();
        }
    }
}

