/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ParameterizedSchedulerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreFactory;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileQueuePlacementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileQueuePlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileWriter;
import org.apache.hadoop.yarn.server.resourcemanager.security.QueueACLsManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestApplicationACLs
extends ParameterizedSchedulerTestBase {
    private static final String APP_OWNER = "owner";
    private static final String FRIEND = "friend";
    private static final String ENEMY = "enemy";
    private static final String QUEUE_ADMIN_USER = "queue-admin-user";
    private static final String SUPER_USER = "superUser";
    private static final String FRIENDLY_GROUP = "friendly-group";
    private static final String SUPER_GROUP = "superGroup";
    private static final String UNAVAILABLE = "N/A";
    private static final Logger LOG = LoggerFactory.getLogger(TestApplicationACLs.class);
    private MockRM resourceManager;
    private Configuration conf;
    private YarnRPC rpc;
    private InetSocketAddress rmAddress;
    private ApplicationClientProtocol rmClient;
    private RecordFactory recordFactory;
    private boolean isQueueUser;

    public TestApplicationACLs(ParameterizedSchedulerTestBase.SchedulerType type) throws IOException {
        super(type);
    }

    @Before
    public void setup() throws InterruptedException, IOException {
        this.conf = this.getConf();
        this.rpc = YarnRPC.create((Configuration)this.conf);
        this.rmAddress = this.conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
        RMStateStoreFactory.getStore((Configuration)this.conf);
        this.conf.setBoolean("yarn.acl.enable", true);
        AccessControlList adminACL = new AccessControlList("");
        adminACL.addGroup(SUPER_GROUP);
        this.conf.set("yarn.admin.acl", adminACL.getAclString());
        this.recordFactory = RecordFactoryProvider.getRecordFactory((Configuration)this.conf);
        this.isQueueUser = false;
        this.resourceManager = new MockRM(this.conf){

            protected QueueACLsManager createQueueACLsManager(ResourceScheduler scheduler, Configuration conf) {
                QueueACLsManager mockQueueACLsManager = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
                Mockito.when((Object)mockQueueACLsManager.checkAccess((UserGroupInformation)ArgumentMatchers.any(UserGroupInformation.class), (QueueACL)ArgumentMatchers.any(QueueACL.class), (RMApp)ArgumentMatchers.any(RMApp.class), (String)ArgumentMatchers.any(String.class), (List)ArgumentMatchers.any())).thenAnswer(new Answer(){

                    public Object answer(InvocationOnMock invocation) {
                        return TestApplicationACLs.this.isQueueUser;
                    }
                });
                return mockQueueACLsManager;
            }

            @Override
            protected ClientRMService createClientRMService() {
                return new ClientRMService(this.getRMContext(), (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, null);
            }
        };
        new Thread(){

            @Override
            public void run() {
                UserGroupInformation.createUserForTesting((String)TestApplicationACLs.ENEMY, (String[])new String[0]);
                UserGroupInformation.createUserForTesting((String)TestApplicationACLs.FRIEND, (String[])new String[]{TestApplicationACLs.FRIENDLY_GROUP});
                UserGroupInformation.createUserForTesting((String)TestApplicationACLs.SUPER_USER, (String[])new String[]{TestApplicationACLs.SUPER_GROUP});
                TestApplicationACLs.this.resourceManager.start();
            }
        }.start();
        int waitCount = 0;
        while (this.resourceManager.getServiceState() == Service.STATE.INITED && waitCount++ < 60) {
            LOG.info("Waiting for RM to start...");
            Thread.sleep(1500L);
        }
        if (this.resourceManager.getServiceState() != Service.STATE.STARTED) {
            throw new IOException("ResourceManager failed to start. Final state is " + this.resourceManager.getServiceState());
        }
        UserGroupInformation owner = UserGroupInformation.createRemoteUser((String)APP_OWNER);
        this.rmClient = (ApplicationClientProtocol)owner.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ApplicationClientProtocol>(){

            @Override
            public ApplicationClientProtocol run() throws Exception {
                return (ApplicationClientProtocol)TestApplicationACLs.this.rpc.getProxy(ApplicationClientProtocol.class, TestApplicationACLs.this.rmAddress, TestApplicationACLs.this.conf);
            }
        });
    }

    @Override
    @After
    public void tearDown() {
        if (this.resourceManager != null) {
            this.resourceManager.stop();
        }
    }

    @Override
    protected void configureFairScheduler(YarnConfiguration configuration) {
        String testDir = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
        String allocFile = new File(testDir, "test-queues.xml").getAbsolutePath();
        AllocationFileWriter.create().addQueue(new AllocationFileQueue.Builder("root").subQueue(new AllocationFileQueue.Builder("default").build()).build()).queuePlacementPolicy(new AllocationFileQueuePlacementPolicy().addRule(new AllocationFileQueuePlacementRule(AllocationFileQueuePlacementRule.RuleName.SPECIFIED).create(false)).addRule(new AllocationFileQueuePlacementRule(AllocationFileQueuePlacementRule.RuleName.REJECT))).writeToFile(allocFile);
        configuration.set("yarn.scheduler.fair.allocation.file", allocFile);
    }

    @Test
    public void testApplicationACLs() throws Exception {
        this.verifyOwnerAccess();
        this.verifySuperUserAccess();
        this.verifyFriendAccess();
        this.verifyEnemyAccess();
        this.verifyAdministerQueueUserAccess();
        this.verifyInvalidQueueWithAcl();
    }

    private ApplicationId submitAppAndGetAppId(AccessControlList viewACL, AccessControlList modifyACL) throws Exception {
        SubmitApplicationRequest submitRequest = (SubmitApplicationRequest)this.recordFactory.newRecordInstance(SubmitApplicationRequest.class);
        ApplicationSubmissionContext context = (ApplicationSubmissionContext)this.recordFactory.newRecordInstance(ApplicationSubmissionContext.class);
        ApplicationId applicationId = this.rmClient.getNewApplication((GetNewApplicationRequest)this.recordFactory.newRecordInstance(GetNewApplicationRequest.class)).getApplicationId();
        context.setApplicationId(applicationId);
        HashMap<ApplicationAccessType, String> acls = new HashMap<ApplicationAccessType, String>();
        acls.put(ApplicationAccessType.VIEW_APP, viewACL.getAclString());
        acls.put(ApplicationAccessType.MODIFY_APP, modifyACL.getAclString());
        ContainerLaunchContext amContainer = (ContainerLaunchContext)this.recordFactory.newRecordInstance(ContainerLaunchContext.class);
        Resource resource = BuilderUtils.newResource((long)1024L, (int)1);
        context.setResource(resource);
        amContainer.setApplicationACLs(acls);
        if (this.conf.get("yarn.resourcemanager.scheduler.class").equals(FairScheduler.class.getName())) {
            context.setQueue("root.default");
        }
        context.setAMContainerSpec(amContainer);
        submitRequest.setApplicationSubmissionContext(context);
        this.rmClient.submitApplication(submitRequest);
        this.resourceManager.waitForState(applicationId, RMAppState.ACCEPTED);
        return applicationId;
    }

    private ApplicationClientProtocol getRMClientForUser(String user) throws IOException, InterruptedException {
        UserGroupInformation userUGI = UserGroupInformation.createRemoteUser((String)user);
        ApplicationClientProtocol userClient = (ApplicationClientProtocol)userUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ApplicationClientProtocol>(){

            @Override
            public ApplicationClientProtocol run() throws Exception {
                return (ApplicationClientProtocol)TestApplicationACLs.this.rpc.getProxy(ApplicationClientProtocol.class, TestApplicationACLs.this.rmAddress, TestApplicationACLs.this.conf);
            }
        });
        return userClient;
    }

    private void verifyOwnerAccess() throws Exception {
        AccessControlList viewACL = new AccessControlList("");
        viewACL.addGroup(FRIENDLY_GROUP);
        AccessControlList modifyACL = new AccessControlList("");
        modifyACL.addUser(FRIEND);
        ApplicationId applicationId = this.submitAppAndGetAppId(viewACL, modifyACL);
        GetApplicationReportRequest appReportRequest = (GetApplicationReportRequest)this.recordFactory.newRecordInstance(GetApplicationReportRequest.class);
        appReportRequest.setApplicationId(applicationId);
        KillApplicationRequest finishAppRequest = (KillApplicationRequest)this.recordFactory.newRecordInstance(KillApplicationRequest.class);
        finishAppRequest.setApplicationId(applicationId);
        this.rmClient.getApplicationReport(appReportRequest);
        Assert.assertEquals((String)"App view by owner should list the apps!!", (long)1L, (long)this.rmClient.getApplications((GetApplicationsRequest)this.recordFactory.newRecordInstance(GetApplicationsRequest.class)).getApplicationList().size());
        this.rmClient.forceKillApplication(finishAppRequest);
        this.resourceManager.waitForState(applicationId, RMAppState.KILLED);
    }

    private void verifySuperUserAccess() throws Exception {
        AccessControlList viewACL = new AccessControlList("");
        viewACL.addGroup(FRIENDLY_GROUP);
        AccessControlList modifyACL = new AccessControlList("");
        modifyACL.addUser(FRIEND);
        ApplicationId applicationId = this.submitAppAndGetAppId(viewACL, modifyACL);
        GetApplicationReportRequest appReportRequest = (GetApplicationReportRequest)this.recordFactory.newRecordInstance(GetApplicationReportRequest.class);
        appReportRequest.setApplicationId(applicationId);
        KillApplicationRequest finishAppRequest = (KillApplicationRequest)this.recordFactory.newRecordInstance(KillApplicationRequest.class);
        finishAppRequest.setApplicationId(applicationId);
        ApplicationClientProtocol superUserClient = this.getRMClientForUser(SUPER_USER);
        superUserClient.getApplicationReport(appReportRequest);
        Assert.assertEquals((String)"App view by super-user should list the apps!!", (long)2L, (long)superUserClient.getApplications((GetApplicationsRequest)this.recordFactory.newRecordInstance(GetApplicationsRequest.class)).getApplicationList().size());
        superUserClient.forceKillApplication(finishAppRequest);
        this.resourceManager.waitForState(applicationId, RMAppState.KILLED);
    }

    private void verifyFriendAccess() throws Exception {
        AccessControlList viewACL = new AccessControlList("");
        viewACL.addGroup(FRIENDLY_GROUP);
        AccessControlList modifyACL = new AccessControlList("");
        modifyACL.addUser(FRIEND);
        ApplicationId applicationId = this.submitAppAndGetAppId(viewACL, modifyACL);
        GetApplicationReportRequest appReportRequest = (GetApplicationReportRequest)this.recordFactory.newRecordInstance(GetApplicationReportRequest.class);
        appReportRequest.setApplicationId(applicationId);
        KillApplicationRequest finishAppRequest = (KillApplicationRequest)this.recordFactory.newRecordInstance(KillApplicationRequest.class);
        finishAppRequest.setApplicationId(applicationId);
        ApplicationClientProtocol friendClient = this.getRMClientForUser(FRIEND);
        friendClient.getApplicationReport(appReportRequest);
        Assert.assertEquals((String)"App view by a friend should list the apps!!", (long)3L, (long)friendClient.getApplications((GetApplicationsRequest)this.recordFactory.newRecordInstance(GetApplicationsRequest.class)).getApplicationList().size());
        friendClient.forceKillApplication(finishAppRequest);
        this.resourceManager.waitForState(applicationId, RMAppState.KILLED);
    }

    private void verifyEnemyAccess() throws Exception {
        AccessControlList viewACL = new AccessControlList("");
        viewACL.addGroup(FRIENDLY_GROUP);
        AccessControlList modifyACL = new AccessControlList("");
        modifyACL.addUser(FRIEND);
        ApplicationId applicationId = this.submitAppAndGetAppId(viewACL, modifyACL);
        GetApplicationReportRequest appReportRequest = (GetApplicationReportRequest)this.recordFactory.newRecordInstance(GetApplicationReportRequest.class);
        appReportRequest.setApplicationId(applicationId);
        KillApplicationRequest finishAppRequest = (KillApplicationRequest)this.recordFactory.newRecordInstance(KillApplicationRequest.class);
        finishAppRequest.setApplicationId(applicationId);
        ApplicationClientProtocol enemyRmClient = this.getRMClientForUser(ENEMY);
        ApplicationReport appReport = enemyRmClient.getApplicationReport(appReportRequest).getApplicationReport();
        this.verifyEnemyAppReport(appReport);
        List appReports = enemyRmClient.getApplications((GetApplicationsRequest)this.recordFactory.newRecordInstance(GetApplicationsRequest.class)).getApplicationList();
        Assert.assertEquals((String)"App view by enemy should list the apps!!", (long)4L, (long)appReports.size());
        for (ApplicationReport report : appReports) {
            this.verifyEnemyAppReport(report);
        }
        try {
            enemyRmClient.forceKillApplication(finishAppRequest);
            Assert.fail((String)"App killing by the enemy should fail!!");
        }
        catch (YarnException e) {
            LOG.info("Got exception while killing app as the enemy", (Throwable)e);
            Assert.assertTrue((boolean)e.getMessage().contains("User enemy cannot perform operation MODIFY_APP on " + applicationId));
        }
        this.rmClient.forceKillApplication(finishAppRequest);
    }

    private void verifyEnemyAppReport(ApplicationReport appReport) {
        Assert.assertEquals((String)"Enemy should not see app host!", (Object)UNAVAILABLE, (Object)appReport.getHost());
        Assert.assertEquals((String)"Enemy should not see app rpc port!", (long)-1L, (long)appReport.getRpcPort());
        Assert.assertEquals((String)"Enemy should not see app client token!", null, (Object)appReport.getClientToAMToken());
        Assert.assertEquals((String)"Enemy should not see app diagnostics!", (Object)UNAVAILABLE, (Object)appReport.getDiagnostics());
        Assert.assertEquals((String)"Enemy should not see app tracking url!", (Object)UNAVAILABLE, (Object)appReport.getTrackingUrl());
        Assert.assertEquals((String)"Enemy should not see app original tracking url!", (Object)UNAVAILABLE, (Object)appReport.getOriginalTrackingUrl());
        ApplicationResourceUsageReport usageReport = appReport.getApplicationResourceUsageReport();
        Assert.assertEquals((String)"Enemy should not see app used containers", (long)-1L, (long)usageReport.getNumUsedContainers());
        Assert.assertEquals((String)"Enemy should not see app reserved containers", (long)-1L, (long)usageReport.getNumReservedContainers());
        Assert.assertEquals((String)"Enemy should not see app used resources", (long)-1L, (long)usageReport.getUsedResources().getMemorySize());
        Assert.assertEquals((String)"Enemy should not see app reserved resources", (long)-1L, (long)usageReport.getReservedResources().getMemorySize());
        Assert.assertEquals((String)"Enemy should not see app needed resources", (long)-1L, (long)usageReport.getNeededResources().getMemorySize());
    }

    private void verifyInvalidQueueWithAcl() throws Exception {
        this.isQueueUser = true;
        SubmitApplicationRequest submitRequest = (SubmitApplicationRequest)this.recordFactory.newRecordInstance(SubmitApplicationRequest.class);
        ApplicationSubmissionContext context = (ApplicationSubmissionContext)this.recordFactory.newRecordInstance(ApplicationSubmissionContext.class);
        ApplicationId applicationId = this.rmClient.getNewApplication((GetNewApplicationRequest)this.recordFactory.newRecordInstance(GetNewApplicationRequest.class)).getApplicationId();
        context.setApplicationId(applicationId);
        HashMap acls = new HashMap();
        ContainerLaunchContext amContainer = (ContainerLaunchContext)this.recordFactory.newRecordInstance(ContainerLaunchContext.class);
        Resource resource = BuilderUtils.newResource((long)1024L, (int)1);
        context.setResource(resource);
        amContainer.setApplicationACLs(acls);
        context.setQueue("InvalidQueue");
        context.setAMContainerSpec(amContainer);
        submitRequest.setApplicationSubmissionContext(context);
        this.rmClient.submitApplication(submitRequest);
        this.resourceManager.waitForState(applicationId, RMAppState.FAILED);
        GetApplicationReportRequest appReportRequest = (GetApplicationReportRequest)this.recordFactory.newRecordInstance(GetApplicationReportRequest.class);
        appReportRequest.setApplicationId(applicationId);
        GetApplicationReportResponse applicationReport = this.rmClient.getApplicationReport(appReportRequest);
        ApplicationReport appReport = applicationReport.getApplicationReport();
        if (this.conf.get("yarn.resourcemanager.scheduler.class").equals(FairScheduler.class.getName())) {
            Assert.assertTrue((boolean)appReport.getDiagnostics().contains("user owner application rejected by placement rules."));
        } else {
            Assert.assertTrue((boolean)appReport.getDiagnostics().contains("submitted by user owner to unknown queue: InvalidQueue"));
        }
    }

    private void verifyAdministerQueueUserAccess() throws Exception {
        this.isQueueUser = true;
        AccessControlList viewACL = new AccessControlList("");
        viewACL.addGroup(FRIENDLY_GROUP);
        AccessControlList modifyACL = new AccessControlList("");
        modifyACL.addUser(FRIEND);
        ApplicationId applicationId = this.submitAppAndGetAppId(viewACL, modifyACL);
        GetApplicationReportRequest appReportRequest = (GetApplicationReportRequest)this.recordFactory.newRecordInstance(GetApplicationReportRequest.class);
        appReportRequest.setApplicationId(applicationId);
        KillApplicationRequest finishAppRequest = (KillApplicationRequest)this.recordFactory.newRecordInstance(KillApplicationRequest.class);
        finishAppRequest.setApplicationId(applicationId);
        ApplicationClientProtocol administerQueueUserRmClient = this.getRMClientForUser(QUEUE_ADMIN_USER);
        administerQueueUserRmClient.getApplicationReport(appReportRequest);
        Assert.assertEquals((String)"App view by queue-admin-user should list the apps!!", (long)5L, (long)administerQueueUserRmClient.getApplications((GetApplicationsRequest)this.recordFactory.newRecordInstance(GetApplicationsRequest.class)).getApplicationList().size());
        administerQueueUserRmClient.forceKillApplication(finishAppRequest);
        this.resourceManager.waitForState(applicationId, RMAppState.KILLED);
    }
}

