/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import com.google.inject.servlet.RequestScoped;
import java.util.Collection;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.FairSchedulerAppsBlock;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.MetricsOverviewTable;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RmView;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.SchedulerPageUtil;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.FairSchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.FairSchedulerLeafQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.FairSchedulerQueueInfo;
import org.apache.hadoop.yarn.server.webapp.WebPageUtils;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.ResponseInfo;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class FairSchedulerPage
extends RmView {
    static final String _Q = ".ui-state-default.ui-corner-all";
    static final float Q_MAX_WIDTH = 0.8f;
    static final float Q_STATS_POS = 0.85f;
    static final String Q_END = "left:101%";
    static final String Q_GIVEN = "left:0%;background:none;border:1px solid rgba(0,0,0,1)";
    static final String Q_INSTANTANEOUS_FS = "left:0%;background:none;border:1px dashed rgba(0,0,0,1)";
    static final String Q_OVER = "background:rgba(255, 140, 0, 0.8)";
    static final String Q_UNDER = "background:rgba(50, 205, 50, 0.8)";
    static final String STEADY_FAIR_SHARE = "Steady Fair Share";
    static final String INSTANTANEOUS_FAIR_SHARE = "Instantaneous Fair Share";

    protected void postHead(Hamlet.HTML<HtmlPage.__> html) {
        ((Hamlet.HTML)((Hamlet.HTML)html.style().$type("text/css").__(new Object[]{"#cs { padding: 0.5em 0 1em 0; margin-bottom: 1em; position: relative }", "#cs ul { list-style: none }", "#cs a { font-weight: normal; margin: 2px; position: relative }", "#cs a span { font-weight: normal; font-size: 80% }", "#cs-wrapper .ui-widget-header { padding: 0.2em 0.5em }", ".qstats { font-weight: normal; font-size: 80%; position: absolute }", ".qlegend { font-weight: normal; padding: 0 1em; margin: 1em }", "table.info tr th {width: 50%}"}).__()).script("/static/jt/jquery.jstree.js").script().$type("text/javascript").__(new Object[]{"$(function() {", "  $('#cs a span').addClass('ui-corner-all').css('position', 'absolute');", "  $('#cs').bind('loaded.jstree', function (e, data) {", "    var callback = { call:reopenQueryNodes }", "    data.inst.open_node('#pq', callback);", "   }).", "    jstree({", "    core: { animation: 188, html_titles: true },", "    plugins: ['themeroller', 'html_data', 'ui'],", "    themeroller: { item_open: 'ui-icon-minus',", "      item_clsd: 'ui-icon-plus', item_leaf: 'ui-icon-gear'", "    }", "  });", "  $('#cs').bind('select_node.jstree', function(e, data) {", "    var queues = $('.q', data.rslt.obj);", "    var q = '^' + queues.first().text();", "    q += queues.length == 1 ? '$' : '\\\\.';", "    $('#apps').dataTable().fnFilter(q, 4, true);", "  });", "  $('#cs').show();", "});"}).__()).__(SchedulerPageUtil.QueueBlockUtil.class);
    }

    @Override
    protected Class<? extends SubView> content() {
        return QueuesBlock.class;
    }

    @Override
    protected String initAppsTable() {
        return WebPageUtils.appsTableInit((boolean)true);
    }

    static String percent(float f) {
        return String.format("%.1f%%", Float.valueOf(f * 100.0f));
    }

    static String width(float f) {
        return String.format("width:%.1f%%", Float.valueOf(f * 100.0f));
    }

    static String left(float f) {
        return String.format("left:%.1f%%", Float.valueOf(f * 100.0f));
    }

    static class QueuesBlock
    extends HtmlBlock {
        final FairScheduler fs;
        final FSQInfo fsqinfo;

        @Inject
        QueuesBlock(ResourceManager rm, FSQInfo info) {
            this.fs = (FairScheduler)rm.getResourceScheduler();
            this.fsqinfo = info;
        }

        public void render(HtmlBlock.Block html) {
            html.__(MetricsOverviewTable.class);
            Hamlet.UL ul = ((Hamlet.DIV)html.div("#cs-wrapper.ui-widget").div(".ui-widget-header.ui-corner-top").__(new Object[]{"Application Queues"}).__()).div("#cs.ui-widget-content.ui-corner-bottom").ul();
            if (this.fs == null) {
                ((Hamlet.LI)((Hamlet.A)ul.li().a(FairSchedulerPage._Q).$style(FairSchedulerPage.width(0.8f)).span().$style(FairSchedulerPage.Q_END).__(new Object[]{"100% "}).__()).span(".q", "default").__()).__();
            } else {
                FairSchedulerInfo sinfo = new FairSchedulerInfo(this.fs);
                this.fsqinfo.qinfo = sinfo.getRootQueueInfo();
                float used = this.fsqinfo.qinfo.getUsedMemoryFraction();
                ((Hamlet.LI)((Hamlet.LI)((Hamlet.A)((Hamlet.UL)((Hamlet.LI)((Hamlet.LI)((Hamlet.LI)((Hamlet.LI)((Hamlet.LI)((Hamlet.LI)ul.li().$style("margin-bottom: 1em").span().$style("font-weight: bold").__(new Object[]{"Legend:"}).__()).span().$class("qlegend ui-corner-all").$style(FairSchedulerPage.Q_GIVEN).$title("The steady fair shares consider all queues, both active (with running applications) and inactive.").__(new Object[]{FairSchedulerPage.STEADY_FAIR_SHARE}).__()).span().$class("qlegend ui-corner-all").$style(FairSchedulerPage.Q_INSTANTANEOUS_FS).$title("The instantaneous fair shares consider only active queues (with running applications).").__(new Object[]{FairSchedulerPage.INSTANTANEOUS_FAIR_SHARE}).__()).span().$class("qlegend ui-corner-all").$style(FairSchedulerPage.Q_UNDER).__(new Object[]{"Used"}).__()).span().$class("qlegend ui-corner-all").$style(FairSchedulerPage.Q_OVER).__(new Object[]{"Used (over fair share)"}).__()).span().$class("qlegend ui-corner-all ui-state-default").__(new Object[]{"Max Capacity"}).__()).__()).li().a(FairSchedulerPage._Q).$style(FairSchedulerPage.width(0.8f)).span().$style(StringHelper.join((Object[])new Object[]{FairSchedulerPage.width(used), ";left:0%;", used > 1.0f ? FairSchedulerPage.Q_OVER : FairSchedulerPage.Q_UNDER})).__(new Object[]{"."}).__()).span(".q", "root").__()).span().$class("qstats").$style(FairSchedulerPage.left(0.85f)).__(new Object[]{StringHelper.join((Object[])new Object[]{FairSchedulerPage.percent(used), " used"})}).__()).__(QueueBlock.class).__();
            }
            ((Hamlet)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.DIV)ul.__()).__()).script().$type("text/javascript").__(new Object[]{"$('#cs').hide();"}).__()).__()).__(FairSchedulerAppsBlock.class);
        }
    }

    static class QueueBlock
    extends HtmlBlock {
        final FSQInfo fsqinfo;

        @Inject
        QueueBlock(FSQInfo info) {
            this.fsqinfo = info;
        }

        public void render(HtmlBlock.Block html) {
            Collection<FairSchedulerQueueInfo> subQueues = this.fsqinfo.qinfo.getChildQueues();
            Hamlet.UL ul = html.ul("#pq");
            for (FairSchedulerQueueInfo info : subQueues) {
                float capacity = info.getMaxResourcesFraction();
                float steadyFairShare = info.getSteadyFairShareMemoryFraction();
                float instantaneousFairShare = info.getFairShareMemoryFraction();
                float used = info.getUsedMemoryFraction();
                Hamlet.LI li = (Hamlet.LI)((Hamlet.LI)((Hamlet.A)((Hamlet.A)((Hamlet.A)ul.li().a(FairSchedulerPage._Q).$style(FairSchedulerPage.width(capacity * 0.8f)).$title(StringHelper.join((Object[])new Object[]{StringHelper.join((Object[])new Object[]{"Steady Fair Share:", FairSchedulerPage.percent(steadyFairShare)}), StringHelper.join((Object[])new Object[]{" Instantaneous Fair Share:", FairSchedulerPage.percent(instantaneousFairShare)})})).span().$style(StringHelper.join((Object[])new Object[]{FairSchedulerPage.Q_GIVEN, ";font-size:1px;", FairSchedulerPage.width(steadyFairShare / capacity)})).__(new Object[]{Character.valueOf('.')}).__()).span().$style(StringHelper.join((Object[])new Object[]{FairSchedulerPage.Q_INSTANTANEOUS_FS, ";font-size:1px;", FairSchedulerPage.width(instantaneousFairShare / capacity)})).__(new Object[]{Character.valueOf('.')}).__()).span().$style(StringHelper.join((Object[])new Object[]{FairSchedulerPage.width(used / capacity), ";font-size:1px;left:0%;", used > instantaneousFairShare ? FairSchedulerPage.Q_OVER : FairSchedulerPage.Q_UNDER})).__(new Object[]{Character.valueOf('.')}).__()).span(".q", info.getQueueName()).__()).span().$class("qstats").$style(FairSchedulerPage.left(0.85f)).__(new Object[]{StringHelper.join((Object[])new Object[]{FairSchedulerPage.percent(used), " used"})}).__();
                this.fsqinfo.qinfo = info;
                if (info instanceof FairSchedulerLeafQueueInfo) {
                    ((Hamlet.UL)li.ul("#lq").li().__(LeafQueueBlock.class).__()).__();
                } else {
                    li.__(QueueBlock.class);
                }
                li.__();
            }
            ul.__();
        }
    }

    static class LeafQueueBlock
    extends HtmlBlock {
        final FairSchedulerLeafQueueInfo qinfo;

        @Inject
        LeafQueueBlock(View.ViewContext ctx, FSQInfo info) {
            super(ctx);
            this.qinfo = (FairSchedulerLeafQueueInfo)info.qinfo;
        }

        protected void render(HtmlBlock.Block html) {
            ResponseInfo ri = this.info("'" + this.qinfo.getQueueName() + "' Queue Status").__("Used Resources:", (Object)this.qinfo.getUsedResources().toString()).__("Num Active Applications:", (Object)this.qinfo.getNumActiveApplications()).__("Num Pending Applications:", (Object)this.qinfo.getNumPendingApplications()).__("Min Resources:", (Object)this.qinfo.getMinResources().toString()).__("Max Resources:", (Object)this.qinfo.getMaxResources().toString()).__("Max Container Allocation:", (Object)this.qinfo.getMaxContainerAllocation().toString()).__("Queue Label:", (Object)this.qinfo.getLabel()).__("Queue Label Policy:", (Object)this.qinfo.getLabelPolicy());
            int maxApps = this.qinfo.getMaxApplications();
            if (maxApps < Integer.MAX_VALUE) {
                ri.__("Max Running Applications:", (Object)this.qinfo.getMaxApplications());
            }
            ri.__("Steady Fair Share:", (Object)this.qinfo.getSteadyFairShare().toString());
            ri.__("Instantaneous Fair Share:", (Object)this.qinfo.getFairShare().toString());
            html.__(InfoBlock.class);
            ri.clear();
        }
    }

    @RequestScoped
    static class FSQInfo {
        FairSchedulerQueueInfo qinfo;

        FSQInfo() {
        }
    }
}

