/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.mutable.MutableObject;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceWeights;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FSAppAttempt
extends SchedulerApplicationAttempt
implements Schedulable {
    private static final Logger LOG = LoggerFactory.getLogger(FSAppAttempt.class);
    private static final DefaultResourceCalculator RESOURCE_CALCULATOR = new DefaultResourceCalculator();
    private long startTime;
    private Priority priority;
    private ResourceWeights resourceWeights;
    private Resource demand = Resources.createResource((int)0);
    private FairScheduler scheduler;
    private Resource fairShare = Resources.createResource((int)0, (int)0);
    private Resource preemptedResources = Resources.createResource((int)0);
    private RMContainerComparator comparator = new RMContainerComparator();
    private final Map<RMContainer, Long> preemptionMap = new HashMap<RMContainer, Long>();
    final Set<RMContainer> noneligibleForPreemptionSet = new HashSet<RMContainer>();
    private List<NodeId> blacklistNodeIds = new ArrayList<NodeId>();
    private final Map<Priority, NodeType> allowedLocalityLevel = new HashMap<Priority, NodeType>();

    public FSAppAttempt(FairScheduler scheduler, ApplicationAttemptId applicationAttemptId, String user, FSLeafQueue queue, ActiveUsersManager activeUsersManager, RMContext rmContext) {
        super(applicationAttemptId, user, queue, activeUsersManager, rmContext);
        this.scheduler = scheduler;
        this.startTime = scheduler.getClock().getTime();
        this.priority = Priority.newInstance((int)1);
        this.resourceWeights = new ResourceWeights();
    }

    public ResourceWeights getResourceWeights() {
        return this.resourceWeights;
    }

    public QueueMetrics getMetrics() {
        return this.queue.getMetrics();
    }

    public synchronized void containerCompleted(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        Container container = rmContainer.getContainer();
        ContainerId containerId = container.getId();
        if (this.liveContainers.remove(containerId) == null) {
            LOG.info("Additional complete request on completed container " + rmContainer.getContainerId());
            return;
        }
        this.newlyAllocatedContainers.remove(rmContainer);
        rmContainer.handle((Event)new RMContainerFinishedEvent(containerId, containerStatus, event));
        LOG.info("Completed container: " + rmContainer.getContainerId() + " in state: " + rmContainer.getState() + " event:" + event);
        RMAuditLogger.logSuccess(this.getUser(), "AM Released Container", "SchedulerApp", this.getApplicationId(), containerId);
        Resource containerResource = rmContainer.getContainer().getResource();
        this.queue.getMetrics().releaseResources(this.getUser(), 1, containerResource);
        Resources.subtractFrom((Resource)this.currentConsumption, (Resource)containerResource);
        this.preemptionMap.remove(rmContainer);
        this.getQueue().decUsedResource(containerResource);
        this.lastMemoryAggregateAllocationUpdateTime = -1L;
    }

    private synchronized void unreserveInternal(Priority priority, FSSchedulerNode node) {
        Map reservedContainers = (Map)this.reservedContainers.get(priority);
        RMContainer reservedContainer = (RMContainer)reservedContainers.remove(node.getNodeID());
        if (reservedContainers.isEmpty()) {
            this.reservedContainers.remove(priority);
        }
        this.resetReReservations(priority);
        Resource resource = reservedContainer.getContainer().getResource();
        Resources.subtractFrom((Resource)this.currentReservation, (Resource)resource);
        LOG.info("Application " + this.getApplicationId() + " unreserved  on node " + node + ", currently has " + reservedContainers.size() + " at priority " + priority + "; currentReservation " + this.currentReservation);
    }

    private void subtractResourcesOnBlacklistedNodes(Resource availableResources) {
        if (this.appSchedulingInfo.getAndResetBlacklistChanged()) {
            this.blacklistNodeIds.clear();
            this.scheduler.addBlacklistedNodeIdsToList(this, this.blacklistNodeIds);
        }
        for (NodeId nodeId : this.blacklistNodeIds) {
            SchedulerNode node = this.scheduler.getSchedulerNode(nodeId);
            if (node == null) continue;
            Resources.subtractFromNonNegative((Resource)availableResources, (Resource)node.getAvailableResource());
        }
    }

    @Override
    public Resource getHeadroom() {
        FSQueue queue = (FSQueue)this.queue;
        SchedulingPolicy policy = queue.getPolicy();
        Resource queueFairShare = queue.getFairShare();
        Resource queueUsage = queue.getResourceUsage();
        Resource clusterResource = this.scheduler.getClusterResource();
        Resource clusterUsage = this.scheduler.getRootQueueMetrics().getAllocatedResources();
        Resource clusterAvailableResources = Resources.subtract((Resource)clusterResource, (Resource)clusterUsage);
        this.subtractResourcesOnBlacklistedNodes(clusterAvailableResources);
        Resource queueMaxAvailableResources = Resources.subtract((Resource)queue.getMaxShare(), (Resource)queueUsage);
        Resource maxAvailableResource = Resources.componentwiseMin((Resource)clusterAvailableResources, (Resource)queueMaxAvailableResources);
        Resource headroom = policy.getHeadroom(queueFairShare, queueUsage, maxAvailableResource);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Headroom calculation for " + this.getName() + ":Min((queueFairShare=" + queueFairShare + " - queueUsage=" + queueUsage + "), maxAvailableResource=" + maxAvailableResource + "Headroom=" + headroom);
        }
        return headroom;
    }

    public synchronized float getLocalityWaitFactor(Priority priority, int clusterNodes) {
        int requiredResources = Math.max(this.getResourceRequests(priority).size() - 1, 0);
        return Math.min((float)requiredResources / (float)clusterNodes, 1.0f);
    }

    public synchronized NodeType getAllowedLocalityLevel(Priority priority, int numNodes, double nodeLocalityThreshold, double rackLocalityThreshold) {
        double threshold;
        if (nodeLocalityThreshold > 1.0) {
            nodeLocalityThreshold = 1.0;
        }
        if (rackLocalityThreshold > 1.0) {
            rackLocalityThreshold = 1.0;
        }
        if (nodeLocalityThreshold < 0.0 || rackLocalityThreshold < 0.0) {
            return NodeType.OFF_SWITCH;
        }
        if (!this.allowedLocalityLevel.containsKey(priority)) {
            this.allowedLocalityLevel.put(priority, NodeType.NODE_LOCAL);
            return NodeType.NODE_LOCAL;
        }
        NodeType allowed = this.allowedLocalityLevel.get(priority);
        if (allowed.equals((Object)NodeType.OFF_SWITCH)) {
            return NodeType.OFF_SWITCH;
        }
        double d = threshold = allowed.equals((Object)NodeType.NODE_LOCAL) ? nodeLocalityThreshold : rackLocalityThreshold;
        if ((double)this.getSchedulingOpportunities(priority) > (double)numNodes * threshold) {
            if (allowed.equals((Object)NodeType.NODE_LOCAL)) {
                this.allowedLocalityLevel.put(priority, NodeType.RACK_LOCAL);
                this.resetSchedulingOpportunities(priority);
            } else if (allowed.equals((Object)NodeType.RACK_LOCAL)) {
                this.allowedLocalityLevel.put(priority, NodeType.OFF_SWITCH);
                this.resetSchedulingOpportunities(priority);
            }
        }
        return this.allowedLocalityLevel.get(priority);
    }

    public synchronized NodeType getAllowedLocalityLevelByTime(Priority priority, long nodeLocalityDelayMs, long rackLocalityDelayMs, long currentTimeMs) {
        long thresholdTime;
        if (nodeLocalityDelayMs < 0L || rackLocalityDelayMs < 0L) {
            return NodeType.OFF_SWITCH;
        }
        if (!this.allowedLocalityLevel.containsKey(priority)) {
            this.allowedLocalityLevel.put(priority, NodeType.NODE_LOCAL);
            return NodeType.NODE_LOCAL;
        }
        NodeType allowed = this.allowedLocalityLevel.get(priority);
        if (allowed.equals((Object)NodeType.OFF_SWITCH)) {
            return NodeType.OFF_SWITCH;
        }
        long waitTime = currentTimeMs;
        waitTime = this.lastScheduledContainer.containsKey(priority) ? (waitTime -= ((Long)this.lastScheduledContainer.get(priority)).longValue()) : (waitTime -= this.getStartTime());
        long l = thresholdTime = allowed.equals((Object)NodeType.NODE_LOCAL) ? nodeLocalityDelayMs : rackLocalityDelayMs;
        if (waitTime > thresholdTime) {
            if (allowed.equals((Object)NodeType.NODE_LOCAL)) {
                this.allowedLocalityLevel.put(priority, NodeType.RACK_LOCAL);
                this.resetSchedulingOpportunities(priority, currentTimeMs);
            } else if (allowed.equals((Object)NodeType.RACK_LOCAL)) {
                this.allowedLocalityLevel.put(priority, NodeType.OFF_SWITCH);
                this.resetSchedulingOpportunities(priority, currentTimeMs);
            }
        }
        return this.allowedLocalityLevel.get(priority);
    }

    public synchronized RMContainer allocate(NodeType type, FSSchedulerNode node, Priority priority, ResourceRequest request, Container container) {
        NodeType allowed = this.allowedLocalityLevel.get(priority);
        if (allowed != null) {
            if (allowed.equals((Object)NodeType.OFF_SWITCH) && (type.equals((Object)NodeType.NODE_LOCAL) || type.equals((Object)NodeType.RACK_LOCAL))) {
                this.resetAllowedLocalityLevel(priority, type);
            } else if (allowed.equals((Object)NodeType.RACK_LOCAL) && type.equals((Object)NodeType.NODE_LOCAL)) {
                this.resetAllowedLocalityLevel(priority, type);
            }
        }
        if (this.getTotalRequiredResources(priority) <= 0) {
            return null;
        }
        RMContainerImpl rmContainer = new RMContainerImpl(container, this.getApplicationAttemptId(), node.getNodeID(), this.appSchedulingInfo.getUser(), this.rmContext);
        this.newlyAllocatedContainers.add(rmContainer);
        this.liveContainers.put(container.getId(), rmContainer);
        List<ResourceRequest> resourceRequestList = this.appSchedulingInfo.allocate(type, node, priority, request, container);
        Resources.addTo((Resource)this.currentConsumption, (Resource)container.getResource());
        this.getQueue().incUsedResource(container.getResource());
        rmContainer.setResourceRequests(resourceRequestList);
        rmContainer.handle((Event)new RMContainerEvent(container.getId(), RMContainerEventType.START));
        if (LOG.isDebugEnabled()) {
            LOG.debug("allocate: applicationAttemptId=" + container.getId().getApplicationAttemptId() + " container=" + container.getId() + " host=" + container.getNodeId().getHost() + " type=" + type);
        }
        RMAuditLogger.logSuccess(this.getUser(), "AM Allocated Container", "SchedulerApp", this.getApplicationId(), container.getId());
        return rmContainer;
    }

    public synchronized void resetAllowedLocalityLevel(Priority priority, NodeType level) {
        NodeType old = this.allowedLocalityLevel.get(priority);
        LOG.info("Raising locality level from " + old + " to " + level + " at  priority " + priority);
        this.allowedLocalityLevel.put(priority, level);
    }

    public void addPreemption(RMContainer container, long time) {
        assert (this.preemptionMap.get(container) == null);
        this.preemptionMap.put(container, time);
        Resources.addTo((Resource)this.preemptedResources, (Resource)container.getAllocatedResource());
    }

    public void addNonEligibleForPreemption(RMContainer container) {
        this.noneligibleForPreemptionSet.add(container);
    }

    public Set<RMContainer> getNonEligibleForPreemptionSet() {
        return this.noneligibleForPreemptionSet;
    }

    public void resetNonEligibleForPreemptionSet() {
        this.noneligibleForPreemptionSet.clear();
    }

    public Long getContainerPreemptionTime(RMContainer container) {
        return this.preemptionMap.get(container);
    }

    public Set<RMContainer> getPreemptionContainers() {
        return this.preemptionMap.keySet();
    }

    @Override
    public FSLeafQueue getQueue() {
        return (FSLeafQueue)super.getQueue();
    }

    public Resource getPreemptedResources() {
        return this.preemptedResources;
    }

    public void resetPreemptedResources() {
        this.preemptedResources = Resources.createResource((int)0);
        for (RMContainer container : this.getPreemptionContainers()) {
            Resources.addTo((Resource)this.preemptedResources, (Resource)container.getAllocatedResource());
        }
    }

    public void clearPreemptedResources() {
        this.preemptedResources.setMemory(0);
        this.preemptedResources.setVirtualCores(0);
        this.preemptedResources.setDisks(0.0);
    }

    public Container createContainer(FSSchedulerNode node, Resource capability, Priority priority) {
        NodeId nodeId = node.getRMNode().getNodeID();
        ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)this.getApplicationAttemptId(), (long)this.getNewContainerId());
        Container container = BuilderUtils.newContainer((ContainerId)containerId, (NodeId)nodeId, (String)node.getRMNode().getHttpAddress(), (Resource)capability, (Priority)priority, null);
        return container;
    }

    @Override
    public void recoverContainer(RMContainer rmContainer) {
        super.recoverContainer(rmContainer);
        if (!rmContainer.getState().equals((Object)RMContainerState.COMPLETED)) {
            this.getQueue().incUsedResource(rmContainer.getContainer().getResource());
        }
        if (!this.isAmRunning() && !this.getUnmanagedAM()) {
            Resource resource = rmContainer.getAllocatedResource();
            this.setAMResource(resource);
            this.getQueue().addAMResourceUsage(resource);
            this.setAmRunning(true);
        }
    }

    private void reserve(Priority priority, FSSchedulerNode node, Container container, boolean alreadyReserved) {
        LOG.info("Making reservation: node=" + node.getNodeName() + " app_id=" + this.getApplicationId());
        if (!alreadyReserved) {
            this.getMetrics().reserveResource(this.getUser(), container.getResource());
            RMContainer rmContainer = super.reserve(node, priority, null, container);
            node.reserveResource(this, priority, rmContainer);
        } else {
            RMContainer rmContainer = node.getReservedContainer();
            super.reserve(node, priority, rmContainer, container);
            node.reserveResource(this, priority, rmContainer);
        }
    }

    public void unreserve(Priority priority, FSSchedulerNode node) {
        RMContainer rmContainer = node.getReservedContainer();
        this.unreserveInternal(priority, node);
        node.unreserveResource(this);
        this.getMetrics().unreserveResource(this.getUser(), rmContainer.getContainer().getResource());
    }

    private Resource assignContainer(FSSchedulerNode node, ResourceRequest request, NodeType type, boolean reserved, MutableObject createdContainer) {
        Resource capability = request.getCapability();
        Resource available = node.getAvailableResource();
        Container container = null;
        container = reserved ? node.getReservedContainer().getContainer() : this.createContainer(node, capability, request.getPriority());
        if (this.getQueue().fitsInMaxShare(capability) && Resources.fitsIn((Resource)capability, (Resource)available)) {
            RMContainer allocatedContainer = this.allocate(type, node, request.getPriority(), request, container);
            if (allocatedContainer == null) {
                if (reserved) {
                    this.unreserve(request.getPriority(), node);
                }
                return Resources.none();
            }
            if (reserved) {
                this.unreserve(request.getPriority(), node);
            }
            node.allocateContainer(allocatedContainer);
            if (!this.isAmRunning() && !this.getUnmanagedAM()) {
                this.setAMResource(container.getResource());
                this.getQueue().addAMResourceUsage(container.getResource());
                this.setAmRunning(true);
            }
            createdContainer.setValue((Object)allocatedContainer);
            return container.getResource();
        }
        this.reserve(request.getPriority(), node, container, reserved);
        return FairScheduler.CONTAINER_RESERVED;
    }

    private boolean hasNodeOrRackLocalRequests(Priority priority) {
        return this.getResourceRequests(priority).size() > 1;
    }

    private boolean isOverAMShareLimit() {
        List<ResourceRequest> ask;
        return !this.isAmRunning() && !this.getUnmanagedAM() && ((ask = this.appSchedulingInfo.getAllResourceRequests()).isEmpty() || !this.getQueue().canRunAppAM(ask.get(0).getCapability()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource assignContainer(FSSchedulerNode node, boolean reserved) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node offered to app: " + this.getName() + " reserved: " + reserved);
        }
        Collection<Priority> prioritiesToTry = reserved ? Arrays.asList(node.getReservedContainer().getReservedPriority()) : this.getPriorities();
        FSAppAttempt fSAppAttempt = this;
        synchronized (fSAppAttempt) {
            for (Priority priority : prioritiesToTry) {
                Resource assigned;
                if (!reserved && !this.hasContainerForNode(priority, node)) continue;
                this.addSchedulingOpportunity(priority);
                ResourceRequest rackLocalRequest = this.getResourceRequest(priority, node.getRackName());
                ResourceRequest localRequest = this.getResourceRequest(priority, node.getNodeName());
                if (localRequest != null && !localRequest.getRelaxLocality()) {
                    LOG.warn("Relax locality off is not supported on local request: " + localRequest);
                }
                NodeType allowedLocality = this.scheduler.isContinuousSchedulingEnabled() ? this.getAllowedLocalityLevelByTime(priority, this.scheduler.getNodeLocalityDelayMs(), this.scheduler.getRackLocalityDelayMs(), this.scheduler.getClock().getTime()) : this.getAllowedLocalityLevel(priority, this.scheduler.getNumClusterNodes(), this.scheduler.getNodeLocalityThreshold(), this.scheduler.getRackLocalityThreshold());
                MutableObject allocatedContainer = new MutableObject();
                if (rackLocalRequest != null && rackLocalRequest.getNumContainers() != 0 && localRequest != null && localRequest.getNumContainers() != 0) {
                    assigned = this.assignContainer(node, localRequest, NodeType.NODE_LOCAL, reserved, allocatedContainer);
                    if (Resources.greaterThan((ResourceCalculator)RESOURCE_CALCULATOR, null, (Resource)assigned, (Resource)Resources.none()) && allocatedContainer.getValue() != null) {
                        this.incNumAllocatedContainers(NodeType.NODE_LOCAL, NodeType.NODE_LOCAL);
                    }
                    return assigned;
                }
                if (rackLocalRequest != null && !rackLocalRequest.getRelaxLocality()) continue;
                if (rackLocalRequest != null && rackLocalRequest.getNumContainers() != 0 && (allowedLocality.equals((Object)NodeType.RACK_LOCAL) || allowedLocality.equals((Object)NodeType.OFF_SWITCH))) {
                    assigned = this.assignContainer(node, rackLocalRequest, NodeType.RACK_LOCAL, reserved, allocatedContainer);
                    if (Resources.greaterThan((ResourceCalculator)RESOURCE_CALCULATOR, null, (Resource)assigned, (Resource)Resources.none()) && allocatedContainer.getValue() != null) {
                        this.incNumAllocatedContainers(NodeType.RACK_LOCAL, NodeType.RACK_LOCAL);
                    }
                    return assigned;
                }
                ResourceRequest offSwitchRequest = this.getResourceRequest(priority, "*");
                if (offSwitchRequest != null && !offSwitchRequest.getRelaxLocality() || offSwitchRequest == null || offSwitchRequest.getNumContainers() == 0 || this.hasNodeOrRackLocalRequests(priority) && !allowedLocality.equals((Object)NodeType.OFF_SWITCH)) continue;
                Resource assigned2 = this.assignContainer(node, offSwitchRequest, NodeType.OFF_SWITCH, reserved, allocatedContainer);
                if (Resources.greaterThan((ResourceCalculator)RESOURCE_CALCULATOR, null, (Resource)assigned2, (Resource)Resources.none()) && allocatedContainer.getValue() != null) {
                    this.incNumAllocatedContainers(NodeType.OFF_SWITCH, NodeType.OFF_SWITCH);
                }
                return assigned2;
            }
        }
        return Resources.none();
    }

    private boolean hasContainerForNode(Priority prio, FSSchedulerNode node) {
        ResourceRequest anyRequest = this.getResourceRequest(prio, "*");
        ResourceRequest rackRequest = this.getResourceRequest(prio, node.getRackName());
        ResourceRequest nodeRequest = this.getResourceRequest(prio, node.getNodeName());
        return anyRequest != null && anyRequest.getNumContainers() > 0 && (anyRequest.getRelaxLocality() || rackRequest != null && rackRequest.getNumContainers() > 0) && (rackRequest == null || rackRequest.getRelaxLocality() || nodeRequest != null && nodeRequest.getNumContainers() > 0) && Resources.lessThanOrEqual((ResourceCalculator)RESOURCE_CALCULATOR, null, (Resource)anyRequest.getCapability(), (Resource)node.getRMNode().getTotalCapability()) && this.getQueue().fitsInMaxShare(anyRequest.getCapability());
    }

    private boolean isValidReservation(FSSchedulerNode node) {
        Priority reservedPriority = node.getReservedContainer().getReservedPriority();
        return this.hasContainerForNode(reservedPriority, node) && !this.isOverAMShareLimit();
    }

    public boolean assignReservedContainer(FSSchedulerNode node) {
        RMContainer rmContainer = node.getReservedContainer();
        Priority reservedPriority = rmContainer.getReservedPriority();
        if (!this.isValidReservation(node)) {
            LOG.info("Releasing reservation that cannot be satisfied for application " + this.getApplicationAttemptId() + " on node " + node);
            this.unreserve(reservedPriority, node);
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Trying to fulfill reservation for application " + this.getApplicationAttemptId() + " on node: " + node);
        }
        Resource reservedResource = node.getReservedContainer().getReservedResource();
        if (this.getQueue().fitsInMaxShare(reservedResource) && Resources.fitsIn((Resource)reservedResource, (Resource)node.getAvailableResource())) {
            this.assignContainer(node, true);
        }
        return true;
    }

    @Override
    public String getName() {
        return this.getApplicationId().toString();
    }

    @Override
    public Resource getDemand() {
        return this.demand;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public Resource getMinShare() {
        return Resources.none();
    }

    @Override
    public Resource getMaxShare() {
        return Resources.unbounded();
    }

    @Override
    public Resource getResourceUsage() {
        return this.getPreemptedResources().equals((Object)Resources.none()) ? this.getCurrentConsumption() : Resources.subtract((Resource)this.getCurrentConsumption(), (Resource)this.getPreemptedResources());
    }

    @Override
    public ResourceWeights getWeights() {
        return this.scheduler.getAppWeight(this);
    }

    @Override
    public Priority getPriority() {
        return this.priority;
    }

    @Override
    public Resource getFairShare() {
        return this.fairShare;
    }

    @Override
    public void setFairShare(Resource fairShare) {
        this.fairShare = fairShare;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDemand() {
        this.demand = Resources.createResource((int)0);
        Resources.addTo((Resource)this.demand, (Resource)this.getCurrentConsumption());
        FSAppAttempt fSAppAttempt = this;
        synchronized (fSAppAttempt) {
            for (Priority p : this.getPriorities()) {
                for (ResourceRequest r : this.getResourceRequests(p).values()) {
                    Resource total = Resources.multiply((Resource)r.getCapability(), (double)r.getNumContainers());
                    Resources.addTo((Resource)this.demand, (Resource)total);
                }
            }
        }
    }

    @Override
    public Resource assignContainer(FSSchedulerNode node) {
        if (this.isOverAMShareLimit()) {
            if (LOG.isDebugEnabled() || this.scheduler.getConfig().getBoolean("yarn.scheduler.fair.display.overAMinfo", false)) {
                LOG.info("Skipping allocation because maxAMShare limit would be exceeded for queue:" + this.getQueue().getName());
            }
            return Resources.none();
        }
        return this.assignContainer(node, false);
    }

    @Override
    public RMContainer preemptContainer() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("App " + this.getName() + " is going to preempt a running container");
        }
        RMContainer toBePreempted = null;
        Set<RMContainer> nonEligibleForPreemption = this.getNonEligibleForPreemptionSet();
        for (RMContainer container : this.getLiveContainers()) {
            if (this.getPreemptionContainers().contains(container) || nonEligibleForPreemption.contains(container) || toBePreempted != null && this.comparator.compare(toBePreempted, container) <= 0) continue;
            toBePreempted = container;
        }
        return toBePreempted;
    }

    static class RMContainerComparator
    implements Comparator<RMContainer>,
    Serializable {
        RMContainerComparator() {
        }

        @Override
        public int compare(RMContainer c1, RMContainer c2) {
            int ret = c1.getContainer().getPriority().compareTo(c2.getContainer().getPriority());
            if (ret == 0) {
                return c2.getContainerId().compareTo(c1.getContainerId());
            }
            return ret;
        }
    }
}

