/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.ZKUtil;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerRecoveryProtos;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.YARNDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.RMZKUtils;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.StoreFencedException;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.AMRMTokenSecretManagerState;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.Epoch;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.RMDelegationTokenIdentifierData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.AMRMTokenSecretManagerStatePBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationAttemptStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.EpochPBImpl;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ZKRMStateStore
extends RMStateStore {
    public static final Logger LOG = LoggerFactory.getLogger(ZKRMStateStore.class);
    private static final Marker FATAL = MarkerFactory.getMarker((String)"FATAL");
    private final SecureRandom random = new SecureRandom();
    protected static final String ROOT_ZNODE_NAME = "ZKRMStateRoot";
    protected static final Version CURRENT_VERSION_INFO = Version.newInstance((int)1, (int)2);
    private static final String RM_DELEGATION_TOKENS_ROOT_ZNODE_NAME = "RMDelegationTokensRoot";
    private static final String RM_DT_SEQUENTIAL_NUMBER_ZNODE_NAME = "RMDTSequentialNumber";
    private static final String RM_DT_MASTER_KEYS_ROOT_ZNODE_NAME = "RMDTMasterKeysRoot";
    private int numRetries;
    private String zkHostPort = null;
    private int zkSessionTimeout;
    private long zkResyncWaitTime;
    @VisibleForTesting
    long zkRetryInterval;
    private List<ACL> zkAcl;
    private List<ZKUtil.ZKAuthInfo> zkAuths;
    private String zkRootNodePath;
    private String rmAppRoot;
    private String rmDTSecretManagerRoot;
    private String dtMasterKeysRootPath;
    private String delegationTokensRootPath;
    private String dtSequenceNumberPath;
    private String amrmTokenSecretManagerRoot;
    @VisibleForTesting
    protected String znodeWorkingPath;
    @VisibleForTesting
    protected ZooKeeper zkClient;
    @VisibleForTesting
    ZooKeeper activeZkClient;
    private static final String FENCING_LOCK = "RM_ZK_FENCING_LOCK";
    private String fencingNodePath;
    private Op createFencingNodePathOp;
    private Op deleteFencingNodePathOp;
    private Thread verifyActiveStatusThread;
    private String zkRootNodeUsername;
    private final String zkRootNodePassword = Long.toString(this.random.nextLong());
    @VisibleForTesting
    List<ACL> zkRootNodeAcl;
    private boolean useDefaultFencingScheme = false;
    public static final int CREATE_DELETE_PERMS = 12;
    private final String zkRootNodeAuthScheme = new DigestAuthenticationProvider().getScheme();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    protected List<ACL> constructZkRootNodeACL(Configuration conf, List<ACL> sourceACLs) throws NoSuchAlgorithmException {
        ArrayList<ACL> zkRootNodeAcl = new ArrayList<ACL>();
        for (ACL acl : sourceACLs) {
            zkRootNodeAcl.add(new ACL(ZKUtil.removeSpecificPerms((int)acl.getPerms(), (int)12), acl.getId()));
        }
        this.zkRootNodeUsername = HAUtil.getConfValueForRMInstance((String)"yarn.resourcemanager.address", (String)"0.0.0.0:8032", (Configuration)conf);
        Id rmId = new Id(this.zkRootNodeAuthScheme, DigestAuthenticationProvider.generateDigest((String)(this.zkRootNodeUsername + ":" + this.zkRootNodePassword)));
        zkRootNodeAcl.add(new ACL(12, rmId));
        return zkRootNodeAcl;
    }

    @Override
    public synchronized void initInternal(Configuration conf) throws Exception {
        this.zkHostPort = conf.get("yarn.resourcemanager.zk-address");
        if (this.zkHostPort == null) {
            throw new YarnRuntimeException("No server address specified for zookeeper state store for Resource Manager recovery. yarn.resourcemanager.zk-address is not configured.");
        }
        this.numRetries = conf.getInt("yarn.resourcemanager.zk-num-retries", 1000);
        this.znodeWorkingPath = conf.get("yarn.resourcemanager.zk-state-store.parent-path", "/rmstore");
        this.zkSessionTimeout = conf.getInt("yarn.resourcemanager.zk-timeout-ms", 10000);
        this.zkRetryInterval = HAUtil.isHAEnabled((Configuration)conf) ? (long)(this.zkSessionTimeout / this.numRetries) : conf.getLong("yarn.resourcemanager.zk-retry-interval-ms", 1000L);
        this.zkResyncWaitTime = this.zkRetryInterval * (long)this.numRetries;
        this.zkAcl = RMZKUtils.getZKAcls(conf);
        this.zkAuths = RMZKUtils.getZKAuths(conf);
        this.zkRootNodePath = this.getNodePath(this.znodeWorkingPath, ROOT_ZNODE_NAME);
        this.rmAppRoot = this.getNodePath(this.zkRootNodePath, "RMAppRoot");
        this.fencingNodePath = this.getNodePath(this.zkRootNodePath, FENCING_LOCK);
        this.createFencingNodePathOp = Op.create((String)this.fencingNodePath, (byte[])new byte[0], this.zkAcl, (CreateMode)CreateMode.PERSISTENT);
        this.deleteFencingNodePathOp = Op.delete((String)this.fencingNodePath, (int)-1);
        if (HAUtil.isHAEnabled((Configuration)conf)) {
            String zkRootNodeAclConf = HAUtil.getConfValueForRMInstance((String)"yarn.resourcemanager.zk-state-store.root-node.acl", (Configuration)conf);
            if (zkRootNodeAclConf != null) {
                zkRootNodeAclConf = ZKUtil.resolveConfIndirection((String)zkRootNodeAclConf);
                try {
                    this.zkRootNodeAcl = ZKUtil.parseACLs((String)zkRootNodeAclConf);
                }
                catch (ZKUtil.BadAclFormatException bafe) {
                    LOG.error("Invalid format for yarn.resourcemanager.zk-state-store.root-node.acl");
                    throw bafe;
                }
            } else {
                this.useDefaultFencingScheme = true;
                this.zkRootNodeAcl = this.constructZkRootNodeACL(conf, this.zkAcl);
            }
        }
        this.rmDTSecretManagerRoot = this.getNodePath(this.zkRootNodePath, "RMDTSecretManagerRoot");
        this.dtMasterKeysRootPath = this.getNodePath(this.rmDTSecretManagerRoot, RM_DT_MASTER_KEYS_ROOT_ZNODE_NAME);
        this.delegationTokensRootPath = this.getNodePath(this.rmDTSecretManagerRoot, RM_DELEGATION_TOKENS_ROOT_ZNODE_NAME);
        this.dtSequenceNumberPath = this.getNodePath(this.rmDTSecretManagerRoot, RM_DT_SEQUENTIAL_NUMBER_ZNODE_NAME);
        this.amrmTokenSecretManagerRoot = this.getNodePath(this.zkRootNodePath, "AMRMTokenSecretManagerRoot");
    }

    @Override
    public synchronized void startInternal() throws Exception {
        this.createConnection();
        this.createRootDirRecursively(this.znodeWorkingPath);
        this.createRootDir(this.zkRootNodePath);
        if (HAUtil.isHAEnabled((Configuration)this.getConfig())) {
            this.fence();
            this.verifyActiveStatusThread = new VerifyActiveStatusThread();
            this.verifyActiveStatusThread.start();
        }
        this.createRootDir(this.rmAppRoot);
        this.createRootDir(this.rmDTSecretManagerRoot);
        this.createRootDir(this.dtMasterKeysRootPath);
        this.createRootDir(this.delegationTokensRootPath);
        this.createRootDir(this.dtSequenceNumberPath);
        this.createRootDir(this.amrmTokenSecretManagerRoot);
        this.syncInternal(this.zkRootNodePath);
    }

    private void createRootDir(final String rootPath) throws Exception {
        new ZKAction<String>(){

            @Override
            public String run() throws KeeperException, InterruptedException {
                try {
                    return ZKRMStateStore.this.zkClient.create(rootPath, null, ZKRMStateStore.this.zkAcl, CreateMode.PERSISTENT);
                }
                catch (KeeperException ke) {
                    if (ke.code() == KeeperException.Code.NODEEXISTS) {
                        LOG.debug(rootPath + "znode already exists!");
                        return null;
                    }
                    throw ke;
                }
            }
        }.runWithRetries();
    }

    private void logRootNodeAcls(String prefix) throws Exception {
        Stat getStat = new Stat();
        List<ACL> getAcls = this.getACLWithRetries(this.zkRootNodePath, getStat);
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        for (ACL acl : getAcls) {
            builder.append(acl.toString());
        }
        builder.append(getStat.toString());
        LOG.debug(builder.toString());
    }

    private synchronized void fence() throws Exception {
        if (LOG.isTraceEnabled()) {
            this.logRootNodeAcls("Before fencing\n");
        }
        new ZKAction<Void>(){

            @Override
            public Void run() throws KeeperException, InterruptedException {
                ZKRMStateStore.this.zkClient.setACL(ZKRMStateStore.this.zkRootNodePath, ZKRMStateStore.this.zkRootNodeAcl, -1);
                return null;
            }
        }.runWithRetries();
        new ZKAction<Void>(){

            @Override
            public Void run() throws KeeperException, InterruptedException {
                try {
                    ZKRMStateStore.this.zkClient.multi(Collections.singletonList(ZKRMStateStore.this.deleteFencingNodePathOp));
                }
                catch (KeeperException.NoNodeException nne) {
                    LOG.info("Fencing node " + ZKRMStateStore.this.fencingNodePath + " doesn't exist to delete");
                }
                return null;
            }
        }.runWithRetries();
        if (LOG.isTraceEnabled()) {
            this.logRootNodeAcls("After fencing\n");
        }
    }

    private synchronized void closeZkClients() throws IOException {
        this.zkClient = null;
        if (this.activeZkClient != null) {
            try {
                this.activeZkClient.close();
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while closing ZK", e);
            }
            this.activeZkClient = null;
        }
    }

    @Override
    protected void closeInternal() throws Exception {
        if (this.verifyActiveStatusThread != null) {
            this.verifyActiveStatusThread.interrupt();
            this.verifyActiveStatusThread.join(1000L);
        }
        this.closeZkClients();
    }

    @Override
    protected Version getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    @Override
    protected synchronized void storeVersion() throws Exception {
        String versionNodePath = this.getNodePath(this.zkRootNodePath, "RMVersionNode");
        byte[] data = ((VersionPBImpl)CURRENT_VERSION_INFO).getProto().toByteArray();
        if (this.existsWithRetries(versionNodePath, true) != null) {
            this.setDataWithRetries(versionNodePath, data, -1);
        } else {
            this.createWithRetries(versionNodePath, data, this.zkAcl, CreateMode.PERSISTENT);
        }
    }

    @Override
    protected synchronized Version loadVersion() throws Exception {
        String versionNodePath = this.getNodePath(this.zkRootNodePath, "RMVersionNode");
        if (this.existsWithRetries(versionNodePath, true) != null) {
            byte[] data = this.getDataWithRetries(versionNodePath, true);
            VersionPBImpl version = new VersionPBImpl(YarnServerCommonProtos.VersionProto.parseFrom((byte[])data));
            return version;
        }
        return null;
    }

    @Override
    public synchronized long getAndIncrementEpoch() throws Exception {
        String epochNodePath = this.getNodePath(this.zkRootNodePath, "EpochNode");
        long currentEpoch = 0L;
        if (this.existsWithRetries(epochNodePath, true) != null) {
            byte[] data = this.getDataWithRetries(epochNodePath, true);
            EpochPBImpl epoch = new EpochPBImpl(YarnServerResourceManagerRecoveryProtos.EpochProto.parseFrom(data));
            currentEpoch = ((Epoch)epoch).getEpoch();
            byte[] storeData = Epoch.newInstance(currentEpoch + 1L).getProto().toByteArray();
            this.setDataWithRetries(epochNodePath, storeData, -1);
        } else {
            byte[] storeData = Epoch.newInstance(currentEpoch + 1L).getProto().toByteArray();
            this.createWithRetries(epochNodePath, storeData, this.zkAcl, CreateMode.PERSISTENT);
        }
        return currentEpoch;
    }

    @Override
    public synchronized RMStateStore.RMState loadState() throws Exception {
        RMStateStore.RMState rmState = new RMStateStore.RMState();
        this.loadRMDTSecretManagerState(rmState);
        this.loadRMAppState(rmState);
        this.loadAMRMTokenSecretManagerState(rmState);
        return rmState;
    }

    private void loadAMRMTokenSecretManagerState(RMStateStore.RMState rmState) throws Exception {
        byte[] data = this.getDataWithRetries(this.amrmTokenSecretManagerRoot, true);
        if (data == null) {
            LOG.warn("There is no data saved");
            return;
        }
        AMRMTokenSecretManagerStatePBImpl stateData = new AMRMTokenSecretManagerStatePBImpl(YarnServerResourceManagerRecoveryProtos.AMRMTokenSecretManagerStateProto.parseFrom(data));
        rmState.amrmTokenSecretManagerState = AMRMTokenSecretManagerState.newInstance(stateData.getCurrentMasterKey(), stateData.getNextMasterKey());
    }

    private synchronized void loadRMDTSecretManagerState(RMStateStore.RMState rmState) throws Exception {
        this.loadRMDelegationKeyState(rmState);
        this.loadRMSequentialNumberState(rmState);
        this.loadRMDelegationTokenState(rmState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRMDelegationKeyState(RMStateStore.RMState rmState) throws Exception {
        List<String> childNodes = this.getChildrenWithRetries(this.dtMasterKeysRootPath, true);
        for (String childNodeName : childNodes) {
            String childNodePath = this.getNodePath(this.dtMasterKeysRootPath, childNodeName);
            byte[] childData = this.getDataWithRetries(childNodePath, true);
            if (childData == null) {
                LOG.warn("Content of " + childNodePath + " is broken.");
                continue;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(childData);
            DataInputStream fsIn = new DataInputStream(is);
            try {
                if (!childNodeName.startsWith("DelegationKey_")) continue;
                DelegationKey key = new DelegationKey();
                key.readFields((DataInput)fsIn);
                rmState.rmSecretManagerState.masterKeyState.add(key);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Loaded delegation key: keyId=" + key.getKeyId() + ", expirationDate=" + key.getExpiryDate());
            }
            finally {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRMSequentialNumberState(RMStateStore.RMState rmState) throws Exception {
        byte[] seqData = this.getDataWithRetries(this.dtSequenceNumberPath, false);
        if (seqData != null) {
            ByteArrayInputStream seqIs = new ByteArrayInputStream(seqData);
            try (DataInputStream seqIn = new DataInputStream(seqIs);){
                rmState.rmSecretManagerState.dtSequenceNumber = seqIn.readInt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRMDelegationTokenState(RMStateStore.RMState rmState) throws Exception {
        List<String> childNodes = this.getChildrenWithRetries(this.delegationTokensRootPath, true);
        for (String childNodeName : childNodes) {
            String childNodePath = this.getNodePath(this.delegationTokensRootPath, childNodeName);
            byte[] childData = this.getDataWithRetries(childNodePath, true);
            if (childData == null) {
                LOG.warn("Content of " + childNodePath + " is broken.");
                continue;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(childData);
            DataInputStream fsIn = new DataInputStream(is);
            try {
                if (!childNodeName.startsWith("RMDelegationToken_")) continue;
                RMDelegationTokenIdentifierData identifierData = new RMDelegationTokenIdentifierData();
                identifierData.readFields(fsIn);
                RMDelegationTokenIdentifier identifier = identifierData.getTokenIdentifier();
                long renewDate = identifierData.getRenewDate();
                rmState.rmSecretManagerState.delegationTokenState.put(identifier, renewDate);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Loaded RMDelegationTokenIdentifier: " + identifier + " renewDate=" + renewDate);
            }
            finally {
                is.close();
            }
        }
    }

    private synchronized void loadRMAppState(RMStateStore.RMState rmState) throws Exception {
        List<String> childNodes = this.getChildrenWithRetries(this.rmAppRoot, true);
        for (String childNodeName : childNodes) {
            String childNodePath = this.getNodePath(this.rmAppRoot, childNodeName);
            byte[] childData = this.getDataWithRetries(childNodePath, true);
            if (childNodeName.startsWith("application_")) {
                ApplicationStateDataPBImpl appState;
                ApplicationId appId;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Loading application from znode: " + childNodeName);
                }
                if (!(appId = ConverterUtils.toApplicationId((String)childNodeName)).equals((Object)(appState = new ApplicationStateDataPBImpl(YarnServerResourceManagerRecoveryProtos.ApplicationStateDataProto.parseFrom(childData))).getApplicationSubmissionContext().getApplicationId())) {
                    throw new YarnRuntimeException("The child node name is different from the application id");
                }
                rmState.appState.put(appId, appState);
                this.loadApplicationAttemptState(appState, appId);
                continue;
            }
            LOG.info("Unknown child node with name: " + childNodeName);
        }
    }

    private void loadApplicationAttemptState(ApplicationStateData appState, ApplicationId appId) throws Exception {
        String appPath = this.getNodePath(this.rmAppRoot, appId.toString());
        List<String> attempts = this.getChildrenWithRetries(appPath, false);
        for (String attemptIDStr : attempts) {
            if (!attemptIDStr.startsWith("appattempt_")) continue;
            String attemptPath = this.getNodePath(appPath, attemptIDStr);
            byte[] attemptData = this.getDataWithRetries(attemptPath, true);
            ApplicationAttemptStateDataPBImpl attemptState = new ApplicationAttemptStateDataPBImpl(YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProto.parseFrom(attemptData));
            appState.attempts.put(attemptState.getAttemptId(), attemptState);
        }
        LOG.debug("Done loading applications from ZK state store");
    }

    @Override
    public synchronized void storeApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateDataPB) throws Exception {
        String nodeCreatePath = this.getNodePath(this.rmAppRoot, appId.toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Storing info for app: " + appId + " at: " + nodeCreatePath);
        }
        byte[] appStateData = appStateDataPB.getProto().toByteArray();
        this.createWithRetries(nodeCreatePath, appStateData, this.zkAcl, CreateMode.PERSISTENT);
    }

    @Override
    public synchronized void updateApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateDataPB) throws Exception {
        String nodeUpdatePath = this.getNodePath(this.rmAppRoot, appId.toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Storing final state info for app: " + appId + " at: " + nodeUpdatePath);
        }
        byte[] appStateData = appStateDataPB.getProto().toByteArray();
        if (this.existsWithRetries(nodeUpdatePath, true) != null) {
            this.setDataWithRetries(nodeUpdatePath, appStateData, -1);
        } else {
            this.createWithRetries(nodeUpdatePath, appStateData, this.zkAcl, CreateMode.PERSISTENT);
            LOG.debug(appId + " znode didn't exist. Created a new znode to update the application state.");
        }
    }

    @Override
    public synchronized void storeApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptStateDataPB) throws Exception {
        String appDirPath = this.getNodePath(this.rmAppRoot, appAttemptId.getApplicationId().toString());
        String nodeCreatePath = this.getNodePath(appDirPath, appAttemptId.toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Storing info for attempt: " + appAttemptId + " at: " + nodeCreatePath);
        }
        byte[] attemptStateData = attemptStateDataPB.getProto().toByteArray();
        this.createWithRetries(nodeCreatePath, attemptStateData, this.zkAcl, CreateMode.PERSISTENT);
    }

    @Override
    public synchronized void updateApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptStateDataPB) throws Exception {
        String appIdStr = appAttemptId.getApplicationId().toString();
        String appAttemptIdStr = appAttemptId.toString();
        String appDirPath = this.getNodePath(this.rmAppRoot, appIdStr);
        String nodeUpdatePath = this.getNodePath(appDirPath, appAttemptIdStr);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Storing final state info for attempt: " + appAttemptIdStr + " at: " + nodeUpdatePath);
        }
        byte[] attemptStateData = attemptStateDataPB.getProto().toByteArray();
        if (this.existsWithRetries(nodeUpdatePath, true) != null) {
            this.setDataWithRetries(nodeUpdatePath, attemptStateData, -1);
        } else {
            this.createWithRetries(nodeUpdatePath, attemptStateData, this.zkAcl, CreateMode.PERSISTENT);
            LOG.debug(appAttemptId + " znode didn't exist. Created a new znode to update the application attempt state.");
        }
    }

    @Override
    public synchronized void removeApplicationAttemptInternal(ApplicationAttemptId appAttemptId) throws Exception {
        String appId = appAttemptId.getApplicationId().toString();
        String appIdRemovePath = this.getNodePath(this.rmAppRoot, appId);
        String attemptIdRemovePath = this.getNodePath(appIdRemovePath, appAttemptId.toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing info for attempt: " + appAttemptId + " at: " + attemptIdRemovePath);
        }
        if (this.existsWithRetries(attemptIdRemovePath, true) != null) {
            this.doDeleteMultiWithRetries(Op.delete((String)attemptIdRemovePath, (int)-1));
        } else {
            LOG.debug("Attempted to delete a non-existing attempt " + attemptIdRemovePath);
        }
    }

    @Override
    public synchronized void removeApplicationStateInternal(ApplicationStateData appState) throws Exception {
        String appId = appState.getApplicationSubmissionContext().getApplicationId().toString();
        String appIdRemovePath = this.getNodePath(this.rmAppRoot, appId);
        ArrayList<Op> opList = new ArrayList<Op>();
        for (ApplicationAttemptId attemptId : appState.attempts.keySet()) {
            String attemptRemovePath = this.getNodePath(appIdRemovePath, attemptId.toString());
            opList.add(Op.delete((String)attemptRemovePath, (int)-1));
        }
        opList.add(Op.delete((String)appIdRemovePath, (int)-1));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing info for app: " + appId + " at: " + appIdRemovePath + " and its attempts.");
        }
        this.doDeleteMultiWithRetries(opList);
    }

    @Override
    protected synchronized void storeRMDelegationTokenState(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate) throws Exception {
        ArrayList<Op> opList = new ArrayList<Op>();
        this.addStoreOrUpdateOps(opList, rmDTIdentifier, renewDate, false);
        this.doStoreMultiWithRetries(opList);
    }

    @Override
    protected synchronized void removeRMDelegationTokenState(RMDelegationTokenIdentifier rmDTIdentifier) throws Exception {
        String nodeRemovePath = this.getNodePath(this.delegationTokensRootPath, "RMDelegationToken_" + rmDTIdentifier.getSequenceNumber());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing RMDelegationToken_" + rmDTIdentifier.getSequenceNumber());
        }
        if (this.existsWithRetries(nodeRemovePath, true) != null) {
            ArrayList<Op> opList = new ArrayList<Op>();
            opList.add(Op.delete((String)nodeRemovePath, (int)-1));
            this.doDeleteMultiWithRetries(opList);
        } else {
            LOG.debug("Attempted to delete a non-existing znode " + nodeRemovePath);
        }
    }

    @Override
    protected synchronized void updateRMDelegationTokenState(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate) throws Exception {
        ArrayList<Op> opList = new ArrayList<Op>();
        String nodeRemovePath = this.getNodePath(this.delegationTokensRootPath, "RMDelegationToken_" + rmDTIdentifier.getSequenceNumber());
        if (this.existsWithRetries(nodeRemovePath, true) == null) {
            this.addStoreOrUpdateOps(opList, rmDTIdentifier, renewDate, false);
            LOG.debug("Attempted to update a non-existing znode " + nodeRemovePath);
        } else {
            this.addStoreOrUpdateOps(opList, rmDTIdentifier, renewDate, true);
        }
        this.doStoreMultiWithRetries(opList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStoreOrUpdateOps(ArrayList<Op> opList, RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate, boolean isUpdate) throws Exception {
        String nodeCreatePath = this.getNodePath(this.delegationTokensRootPath, "RMDelegationToken_" + rmDTIdentifier.getSequenceNumber());
        ByteArrayOutputStream seqOs = new ByteArrayOutputStream();
        DataOutputStream seqOut = new DataOutputStream(seqOs);
        RMDelegationTokenIdentifierData identifierData = new RMDelegationTokenIdentifierData((YARNDelegationTokenIdentifier)rmDTIdentifier, renewDate);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((isUpdate ? "Storing " : "Updating ") + "RMDelegationToken_" + rmDTIdentifier.getSequenceNumber());
            }
            if (isUpdate) {
                opList.add(Op.setData((String)nodeCreatePath, (byte[])identifierData.toByteArray(), (int)-1));
            } else {
                opList.add(Op.create((String)nodeCreatePath, (byte[])identifierData.toByteArray(), this.zkAcl, (CreateMode)CreateMode.PERSISTENT));
                seqOut.writeInt(rmDTIdentifier.getSequenceNumber());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((isUpdate ? "Storing " : "Updating ") + this.dtSequenceNumberPath + ". SequenceNumber: " + rmDTIdentifier.getSequenceNumber());
                }
                opList.add(Op.setData((String)this.dtSequenceNumberPath, (byte[])seqOs.toByteArray(), (int)-1));
            }
        }
        finally {
            seqOs.close();
        }
    }

    @Override
    protected synchronized void storeRMDTMasterKeyState(DelegationKey delegationKey) throws Exception {
        String nodeCreatePath = this.getNodePath(this.dtMasterKeysRootPath, "DelegationKey_" + delegationKey.getKeyId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Storing RMDelegationKey_" + delegationKey.getKeyId());
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (DataOutputStream fsOut = new DataOutputStream(os);){
            delegationKey.write((DataOutput)fsOut);
            this.createWithRetries(nodeCreatePath, os.toByteArray(), this.zkAcl, CreateMode.PERSISTENT);
        }
    }

    @Override
    protected synchronized void removeRMDTMasterKeyState(DelegationKey delegationKey) throws Exception {
        String nodeRemovePath = this.getNodePath(this.dtMasterKeysRootPath, "DelegationKey_" + delegationKey.getKeyId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing RMDelegationKey_" + delegationKey.getKeyId());
        }
        if (this.existsWithRetries(nodeRemovePath, true) != null) {
            this.doDeleteMultiWithRetries(Op.delete((String)nodeRemovePath, (int)-1));
        } else {
            LOG.debug("Attempted to delete a non-existing znode " + nodeRemovePath);
        }
    }

    @Override
    public synchronized void deleteStore() throws Exception {
        if (this.existsWithRetries(this.zkRootNodePath, true) != null) {
            this.deleteWithRetries(this.zkRootNodePath, true);
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    public synchronized void processWatchEvent(ZooKeeper zk, WatchedEvent event) throws Exception {
        if (zk != this.activeZkClient) {
            LOG.info("Ignore watcher event type: " + event.getType() + " with state:" + event.getState() + " for path:" + event.getPath() + " from old session");
            return;
        }
        Watcher.Event.EventType eventType = event.getType();
        LOG.info("Watcher event type: " + eventType + " with state:" + event.getState() + " for path:" + event.getPath() + " for " + this);
        if (eventType == Watcher.Event.EventType.None) {
            switch (event.getState()) {
                case SyncConnected: {
                    LOG.info("ZKRMStateStore Session connected");
                    if (this.zkClient != null) break;
                    this.zkClient = this.activeZkClient;
                    ((Object)((Object)this)).notifyAll();
                    LOG.info("ZKRMStateStore Session restored");
                    break;
                }
                case Disconnected: {
                    LOG.info("ZKRMStateStore Session disconnected");
                    this.zkClient = null;
                    break;
                }
                case Expired: {
                    LOG.info("ZKRMStateStore Session expired");
                    this.createConnection();
                    this.syncInternal(event.getPath());
                    break;
                }
                default: {
                    LOG.error("Unexpected Zookeeper watch event state: " + event.getState());
                }
            }
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    String getNodePath(String root, String nodeName) {
        return root + "/" + nodeName;
    }

    private void syncInternal(String path) throws InterruptedException {
        final ZKSyncOperationCallback cb = new ZKSyncOperationCallback();
        final String pathForSync = path != null ? path : this.zkRootNodePath;
        try {
            new ZKAction<Void>(){

                @Override
                Void run() throws KeeperException, InterruptedException {
                    ZKRMStateStore.this.zkClient.sync(pathForSync, (AsyncCallback.VoidCallback)cb, null);
                    return null;
                }
            }.runWithRetries();
        }
        catch (Exception e) {
            LOG.error(FATAL, "sync failed.");
        }
    }

    @VisibleForTesting
    synchronized void doStoreMultiWithRetries(List<Op> opList) throws Exception {
        final ArrayList<Op> execOpList = new ArrayList<Op>(opList.size() + 2);
        execOpList.add(this.createFencingNodePathOp);
        execOpList.addAll(opList);
        execOpList.add(this.deleteFencingNodePathOp);
        new ZKAction<Void>(){

            @Override
            public Void run() throws KeeperException, InterruptedException {
                ZKRMStateStore.this.zkClient.multi((Iterable)execOpList);
                return null;
            }
        }.runWithRetries();
    }

    private void doStoreMultiWithRetries(Op op) throws Exception {
        this.doStoreMultiWithRetries(Collections.singletonList(op));
    }

    private synchronized void doDeleteMultiWithRetries(List<Op> opList) throws Exception {
        final ArrayList<Op> execOpList = new ArrayList<Op>(opList.size() + 2);
        execOpList.add(this.createFencingNodePathOp);
        execOpList.addAll(opList);
        execOpList.add(this.deleteFencingNodePathOp);
        new ZKAction<Void>(){

            @Override
            public Void run() throws KeeperException, InterruptedException {
                this.setHasDeleteNodeOp(true);
                ZKRMStateStore.this.zkClient.multi((Iterable)execOpList);
                return null;
            }
        }.runWithRetries();
    }

    private void doDeleteMultiWithRetries(Op op) throws Exception {
        this.doDeleteMultiWithRetries(Collections.singletonList(op));
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    public void createWithRetries(String path, byte[] data, List<ACL> acl, CreateMode mode) throws Exception {
        this.doStoreMultiWithRetries(Op.create((String)path, (byte[])data, acl, (CreateMode)mode));
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    public void setDataWithRetries(String path, byte[] data, int version) throws Exception {
        this.doStoreMultiWithRetries(Op.setData((String)path, (byte[])data, (int)version));
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    public byte[] getDataWithRetries(final String path, final boolean watch) throws Exception {
        return (byte[])new ZKAction<byte[]>(){

            @Override
            public byte[] run() throws KeeperException, InterruptedException {
                return ZKRMStateStore.this.zkClient.getData(path, watch, null);
            }
        }.runWithRetries();
    }

    private List<ACL> getACLWithRetries(final String path, final Stat stat) throws Exception {
        return (List)new ZKAction<List<ACL>>(){

            @Override
            public List<ACL> run() throws KeeperException, InterruptedException {
                return ZKRMStateStore.this.zkClient.getACL(path, stat);
            }
        }.runWithRetries();
    }

    private List<String> getChildrenWithRetries(final String path, final boolean watch) throws Exception {
        return (List)new ZKAction<List<String>>(){

            @Override
            List<String> run() throws KeeperException, InterruptedException {
                return ZKRMStateStore.this.zkClient.getChildren(path, watch);
            }
        }.runWithRetries();
    }

    private Stat existsWithRetries(final String path, final boolean watch) throws Exception {
        return (Stat)new ZKAction<Stat>(){

            @Override
            Stat run() throws KeeperException, InterruptedException {
                return ZKRMStateStore.this.zkClient.exists(path, watch);
            }
        }.runWithRetries();
    }

    private void deleteWithRetries(final String path, final boolean watch) throws Exception {
        new ZKAction<Void>(){

            @Override
            Void run() throws KeeperException, InterruptedException {
                ZKRMStateStore.this.recursiveDeleteWithRetriesHelper(path, watch);
                return null;
            }
        }.runWithRetries();
    }

    private void recursiveDeleteWithRetriesHelper(String path, boolean watch) throws KeeperException, InterruptedException {
        List children = this.zkClient.getChildren(path, watch);
        for (String child : children) {
            this.recursiveDeleteWithRetriesHelper(path + "/" + child, false);
        }
        try {
            this.zkClient.delete(path, -1);
        }
        catch (KeeperException.NoNodeException nne) {
            LOG.info("Node " + path + " doesn't exist to delete");
        }
    }

    private synchronized void createConnection() throws IOException, InterruptedException {
        this.closeZkClients();
        for (int retries = 0; retries < this.numRetries && this.zkClient == null; ++retries) {
            try {
                this.zkClient = this.activeZkClient = this.getNewZooKeeper();
                for (ZKUtil.ZKAuthInfo zkAuth : this.zkAuths) {
                    this.zkClient.addAuthInfo(zkAuth.getScheme(), zkAuth.getAuth());
                }
                if (!this.useDefaultFencingScheme) continue;
                this.zkClient.addAuthInfo(this.zkRootNodeAuthScheme, (this.zkRootNodeUsername + ":" + this.zkRootNodePassword).getBytes(Charset.forName("UTF-8")));
                continue;
            }
            catch (IOException ioe) {
                LOG.info("Failed to connect to the ZooKeeper on attempt - " + (retries + 1));
                ioe.printStackTrace();
            }
        }
        if (this.zkClient == null) {
            LOG.error("Unable to connect to Zookeeper");
            throw new YarnRuntimeException("Unable to connect to Zookeeper");
        }
        ((Object)((Object)this)).notifyAll();
        LOG.info("Created new ZK connection");
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    protected synchronized ZooKeeper getNewZooKeeper() throws IOException, InterruptedException {
        ZooKeeper zk = new ZooKeeper(this.zkHostPort, this.zkSessionTimeout, null);
        zk.register((Watcher)new ForwardingWatcher(zk));
        return zk;
    }

    @Override
    public synchronized void storeOrUpdateAMRMTokenSecretManagerState(AMRMTokenSecretManagerState amrmTokenSecretManagerState, boolean isUpdate) throws Exception {
        AMRMTokenSecretManagerState data = AMRMTokenSecretManagerState.newInstance(amrmTokenSecretManagerState);
        byte[] stateData = data.getProto().toByteArray();
        this.setDataWithRetries(this.amrmTokenSecretManagerRoot, stateData, -1);
    }

    private void createRootDirRecursively(String path) throws Exception {
        String[] pathParts = path.split("/");
        Preconditions.checkArgument((pathParts.length >= 1 && pathParts[0].isEmpty() ? 1 : 0) != 0, (String)"Invalid path: %s", (Object)path);
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < pathParts.length; ++i) {
            sb.append("/").append(pathParts[i]);
            this.createRootDir(sb.toString());
        }
    }

    private abstract class ZKAction<T> {
        private boolean hasDeleteNodeOp = false;

        private ZKAction() {
        }

        void setHasDeleteNodeOp(boolean hasDeleteOp) {
            this.hasDeleteNodeOp = hasDeleteOp;
        }

        abstract T run() throws KeeperException, InterruptedException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        T runWithCheck() throws Exception {
            long startTime = System.currentTimeMillis();
            ZKRMStateStore zKRMStateStore = ZKRMStateStore.this;
            synchronized (zKRMStateStore) {
                while (ZKRMStateStore.this.zkClient == null) {
                    ((Object)((Object)ZKRMStateStore.this)).wait(ZKRMStateStore.this.zkResyncWaitTime);
                    if (ZKRMStateStore.this.zkClient != null) break;
                    if (System.currentTimeMillis() - startTime <= ZKRMStateStore.this.zkResyncWaitTime) continue;
                    throw new IOException("Wait for ZKClient creation timed out");
                }
                return this.run();
            }
        }

        private boolean shouldRetry(KeeperException.Code code) {
            switch (code) {
                case CONNECTIONLOSS: 
                case OPERATIONTIMEOUT: {
                    return true;
                }
            }
            return false;
        }

        private boolean shouldRetryWithNewConnection(KeeperException.Code code) {
            switch (code) {
                case SESSIONEXPIRED: 
                case SESSIONMOVED: {
                    return true;
                }
            }
            return false;
        }

        T runWithRetries() throws Exception {
            int retry = 0;
            while (true) {
                try {
                    return this.runWithCheck();
                }
                catch (KeeperException.NoAuthException nae) {
                    if (HAUtil.isHAEnabled((Configuration)ZKRMStateStore.this.getConfig())) {
                        throw new StoreFencedException();
                    }
                    throw nae;
                }
                catch (KeeperException ke) {
                    if (ke.code() == KeeperException.Code.NODEEXISTS) {
                        LOG.info("znode already exists!");
                        return null;
                    }
                    if (this.hasDeleteNodeOp && ke.code() == KeeperException.Code.NONODE) {
                        LOG.info("znode has already been deleted!");
                        return null;
                    }
                    LOG.info("Exception while executing a ZK operation.", (Throwable)ke);
                    if (this.shouldRetry(ke.code()) && ++retry < ZKRMStateStore.this.numRetries) {
                        LOG.info("Retrying operation on ZK. Retry no. " + retry);
                        Thread.sleep(ZKRMStateStore.this.zkRetryInterval);
                        continue;
                    }
                    if (this.shouldRetryWithNewConnection(ke.code()) && retry < ZKRMStateStore.this.numRetries) {
                        LOG.info("Retrying operation on ZK with new Connection. Retry no. " + retry);
                        Thread.sleep(ZKRMStateStore.this.zkRetryInterval);
                        ZKRMStateStore.this.createConnection();
                        ZKRMStateStore.this.syncInternal(ke.getPath());
                        continue;
                    }
                    LOG.info("Maxed out ZK retries. Giving up!");
                    throw ke;
                }
                break;
            }
        }
    }

    private class VerifyActiveStatusThread
    extends Thread {
        private List<Op> emptyOpList;

        VerifyActiveStatusThread() {
            super(VerifyActiveStatusThread.class.getName());
            this.emptyOpList = new ArrayList<Op>();
        }

        @Override
        public void run() {
            try {
                while (!ZKRMStateStore.this.isFencedState()) {
                    ZKRMStateStore.this.doStoreMultiWithRetries(this.emptyOpList);
                    Thread.sleep(ZKRMStateStore.this.zkSessionTimeout);
                }
            }
            catch (InterruptedException ie) {
                LOG.info(VerifyActiveStatusThread.class.getName() + " thread interrupted! Exiting!");
            }
            catch (Exception e) {
                ZKRMStateStore.this.notifyStoreOperationFailed((Exception)((Object)new StoreFencedException()));
            }
        }
    }

    private final class ForwardingWatcher
    implements Watcher {
        private ZooKeeper watchedZkClient;

        public ForwardingWatcher(ZooKeeper client) {
            this.watchedZkClient = client;
        }

        public void process(WatchedEvent event) {
            try {
                ZKRMStateStore.this.processWatchEvent(this.watchedZkClient, event);
            }
            catch (Throwable t) {
                LOG.error("Failed to process watcher event " + event + ": " + StringUtils.stringifyException((Throwable)t));
            }
        }
    }

    class ZKSyncOperationCallback
    implements AsyncCallback.VoidCallback {
        ZKSyncOperationCallback() {
        }

        public void processResult(int rc, String path, Object ctx) {
            if (rc == KeeperException.Code.OK.intValue()) {
                LOG.info("ZooKeeper sync operation succeeded. path: " + path);
            } else {
                LOG.error(FATAL, "ZooKeeper sync operation failed. Waiting for session timeout. path: " + path);
            }
        }
    }
}

