/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.amlauncher;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEvent;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationMasterLauncher
extends AbstractService
implements EventHandler<AMLauncherEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationMasterLauncher.class);
    private final ThreadPoolExecutor launcherPool;
    private LauncherThread launcherHandlingThread;
    private final BlockingQueue<Runnable> masterEvents = new LinkedBlockingQueue<Runnable>();
    protected final RMContext context;

    public ApplicationMasterLauncher(RMContext context) {
        super(ApplicationMasterLauncher.class.getName());
        this.context = context;
        this.launcherPool = new ThreadPoolExecutor(10, 10, 1L, TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>());
        this.launcherHandlingThread = new LauncherThread();
    }

    protected void serviceStart() throws Exception {
        this.launcherHandlingThread.start();
        super.serviceStart();
    }

    protected Runnable createRunnableLauncher(RMAppAttempt application, AMLauncherEventType event) {
        AMLauncher launcher = new AMLauncher(this.context, application, event, this.getConfig());
        return launcher;
    }

    private void launch(RMAppAttempt application) {
        Runnable launcher = this.createRunnableLauncher(application, AMLauncherEventType.LAUNCH);
        this.masterEvents.add(launcher);
    }

    protected void serviceStop() throws Exception {
        this.launcherHandlingThread.interrupt();
        try {
            this.launcherHandlingThread.join();
        }
        catch (InterruptedException ie) {
            LOG.info(this.launcherHandlingThread.getName() + " interrupted during join ", (Throwable)ie);
        }
        this.launcherPool.shutdown();
    }

    private void cleanup(RMAppAttempt application) {
        Runnable launcher = this.createRunnableLauncher(application, AMLauncherEventType.CLEANUP);
        this.masterEvents.add(launcher);
    }

    public synchronized void handle(AMLauncherEvent appEvent) {
        AMLauncherEventType event = (AMLauncherEventType)appEvent.getType();
        RMAppAttempt application = appEvent.getAppAttempt();
        switch (event) {
            case LAUNCH: {
                this.launch(application);
                break;
            }
            case CLEANUP: {
                this.cleanup(application);
                break;
            }
        }
    }

    private class LauncherThread
    extends Thread {
        public LauncherThread() {
            super("ApplicationMaster Launcher");
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    Runnable toLaunch = ApplicationMasterLauncher.this.masterEvents.take();
                    ApplicationMasterLauncher.this.launcherPool.execute(toLaunch);
                }
                catch (InterruptedException e) {
                    LOG.warn(this.getClass().getName() + " interrupted. Returning.");
                    return;
                }
            }
        }
    }
}

