/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMSecretManagerService;
import org.apache.hadoop.yarn.server.resourcemanager.TestRMRestart;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.event.Level;

public class TestRMDelegationTokens {
    private YarnConfiguration conf;

    @Before
    public void setup() {
        GenericTestUtils.setRootLogLevel((Level)Level.DEBUG);
        ExitUtil.disableSystemExit();
        this.conf = new YarnConfiguration();
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        this.conf.set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        this.conf.set("yarn.resourcemanager.scheduler.class", FairScheduler.class.getName());
    }

    @Test(timeout=15000L)
    public void testRMDTMasterKeyStateOnRollingMasterKey() throws Exception {
        MemoryRMStateStore memStore = new MemoryRMStateStore();
        memStore.init((Configuration)this.conf);
        RMStateStore.RMState rmState = memStore.getState();
        Map rmDTState = rmState.getRMDTSecretManagerState().getTokenState();
        Set rmDTMasterKeyState = rmState.getRMDTSecretManagerState().getMasterKeyState();
        MyMockRM rm1 = new MyMockRM((Configuration)this.conf, (RMStateStore)memStore);
        rm1.start();
        RMDelegationTokenSecretManager dtSecretManager = rm1.getRMContext().getRMDelegationTokenSecretManager();
        Assert.assertEquals((Object)dtSecretManager.getAllMasterKeys(), (Object)rmDTMasterKeyState);
        HashSet expiringKeys = new HashSet();
        expiringKeys.addAll(dtSecretManager.getAllMasterKeys());
        GetDelegationTokenRequest request = (GetDelegationTokenRequest)Mockito.mock(GetDelegationTokenRequest.class);
        Mockito.when((Object)request.getRenewer()).thenReturn((Object)"renewer1");
        GetDelegationTokenResponse response = rm1.getClientRMService().getDelegationToken(request);
        org.apache.hadoop.yarn.api.records.Token delegationToken = response.getRMDelegationToken();
        Token token1 = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)delegationToken, (Text)null);
        RMDelegationTokenIdentifier dtId1 = (RMDelegationTokenIdentifier)token1.decodeIdentifier();
        while (((TestRMDelegationTokenSecretManager)dtSecretManager).numUpdatedKeys.get() < 3) {
            ((TestRMDelegationTokenSecretManager)dtSecretManager).checkCurrentKeyInStateStore(rmDTMasterKeyState);
            Thread.sleep(100L);
        }
        for (int count = 0; rmDTState.containsKey(dtId1) && count < 100; ++count) {
            Thread.sleep(100L);
        }
        rm1.stop();
    }

    @Test(timeout=15000L)
    public void testRemoveExpiredMasterKeyInRMStateStore() throws Exception {
        MemoryRMStateStore memStore = new MemoryRMStateStore();
        memStore.init((Configuration)this.conf);
        RMStateStore.RMState rmState = memStore.getState();
        Set rmDTMasterKeyState = rmState.getRMDTSecretManagerState().getMasterKeyState();
        MyMockRM rm1 = new MyMockRM((Configuration)this.conf, (RMStateStore)memStore);
        rm1.start();
        RMDelegationTokenSecretManager dtSecretManager = rm1.getRMContext().getRMDelegationTokenSecretManager();
        Assert.assertEquals((Object)dtSecretManager.getAllMasterKeys(), (Object)rmDTMasterKeyState);
        HashSet expiringKeys = new HashSet();
        expiringKeys.addAll(dtSecretManager.getAllMasterKeys());
        while (true) {
            boolean allExpired = true;
            for (DelegationKey key : expiringKeys) {
                if (!rmDTMasterKeyState.contains(key)) continue;
                allExpired = false;
            }
            if (allExpired) break;
            Thread.sleep(500L);
        }
    }

    public class TestRMDelegationTokenSecretManager
    extends RMDelegationTokenSecretManager {
        public AtomicInteger numUpdatedKeys;

        public TestRMDelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval, RMContext rmContext) {
            super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval, rmContext);
            this.numUpdatedKeys = new AtomicInteger(0);
        }

        protected void storeNewMasterKey(DelegationKey newKey) {
            super.storeNewMasterKey(newKey);
            this.numUpdatedKeys.incrementAndGet();
        }

        public synchronized DelegationKey checkCurrentKeyInStateStore(Set<DelegationKey> rmDTMasterKeyState) {
            Iterator iterator = this.allKeys.keySet().iterator();
            while (iterator.hasNext()) {
                int keyId = (Integer)iterator.next();
                if (keyId != this.currentId) continue;
                DelegationKey currentKey = (DelegationKey)this.allKeys.get(keyId);
                Assert.assertTrue((boolean)rmDTMasterKeyState.contains(currentKey));
                return currentKey;
            }
            return null;
        }
    }

    class MyMockRM
    extends TestRMRestart.TestSecurityMockRM {
        public MyMockRM(Configuration conf, RMStateStore store) {
            super(conf, store);
        }

        protected RMSecretManagerService createRMSecretManagerService() {
            return new RMSecretManagerService((Configuration)TestRMDelegationTokens.this.conf, this.rmContext){

                protected RMDelegationTokenSecretManager createRMDelegationTokenSecretManager(Configuration conf, RMContext rmContext) {
                    return new TestRMDelegationTokenSecretManager(1000L, 1000L, 2000L, 1000L, rmContext);
                }
            };
        }
    }
}

