/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestFairSchedulerConfiguration {
    @Test
    public void testParseResourceConfigValue() throws Exception {
        Assert.assertEquals((Object)BuilderUtils.newResource((int)1024, (int)2, (double)1.0), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"2 vcores, 1024 mb, 1 disks"));
        Assert.assertEquals((Object)BuilderUtils.newResource((int)1024, (int)2, (double)1.0), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"1024 mb, 2 vcores, 1 disks"));
        Assert.assertEquals((Object)BuilderUtils.newResource((int)1024, (int)2, (double)1.0), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"2vcores,1024mb,1disks"));
        Assert.assertEquals((Object)BuilderUtils.newResource((int)1024, (int)2, (double)1.0), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"1024mb,2vcores,1disks"));
        Assert.assertEquals((Object)BuilderUtils.newResource((int)1024, (int)2, (double)1.0), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"1024   mb, 2    vcores, 1  disks"));
        Assert.assertEquals((Object)BuilderUtils.newResource((int)1024, (int)2, (double)1.0), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"1024 Mb, 2 vCores, 1 Disks"));
        Assert.assertEquals((Object)BuilderUtils.newResource((int)1024, (int)2, (double)1.0), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"  1024 mb, 2 vcores  ,  1 disks  "));
        Assert.assertEquals((Object)BuilderUtils.newResource((int)1024, (int)2, (double)1.3), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"  1024.3 mb, 2.35 vcores  , 1.3 disks"));
        Assert.assertEquals((Object)BuilderUtils.newResource((int)1024, (int)2, (double)1.0), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"  1024. mb, 2. vcores  , 1. disks"));
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testNoUnits() throws Exception {
        FairSchedulerConfiguration.parseResourceConfigValue((String)"1024");
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testOnlyMemory() throws Exception {
        FairSchedulerConfiguration.parseResourceConfigValue((String)"1024mb");
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testOnlyCPU() throws Exception {
        FairSchedulerConfiguration.parseResourceConfigValue((String)"1024vcores");
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testGibberish() throws Exception {
        FairSchedulerConfiguration.parseResourceConfigValue((String)"1o24vc0res");
    }
}

