/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.impl.MetricsCollectorImpl;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelManagementService;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelManager;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.MockRMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.TestSchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerExpiredSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerRescheduledEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SimpleGroupsMapping;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.DominantResourceFairnessPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.FifoPolicy;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.xml.sax.SAXException;

public class TestFairScheduler
extends FairSchedulerTestBase {
    private static final String ALLOC_FILE = new File(TEST_DIR, "test-queues").getAbsolutePath();
    private static final String LABEL_FILE = TEST_DIR + "/labelFile";
    private static final String STATIC_HOST = "127.0.0.1";

    @Before
    public void setUp() throws IOException {
        this.scheduler = new FairScheduler();
        this.conf = this.createConfiguration();
        this.resourceManager = new ResourceManager();
        this.resourceManager.init(this.conf);
        this.lbS = new LabelManagementService();
        ((AsyncDispatcher)this.resourceManager.getRMContext().getDispatcher()).start();
        this.resourceManager.getRMContext().getStateStore().start();
        this.resourceManager.getRMContext().getContainerTokenSecretManager().rollMasterKey();
        this.scheduler.setRMContext(this.resourceManager.getRMContext());
    }

    @After
    public void tearDown() throws IOException {
        if (this.scheduler != null) {
            this.scheduler.stop();
            this.scheduler = null;
        }
        if (this.resourceManager != null) {
            this.resourceManager.stop();
            this.resourceManager = null;
        }
        if (this.lbS != null) {
            this.lbS.stop();
            this.lbS = null;
        }
        QueueMetrics.clearQueueMetrics();
        DefaultMetricsSystem.shutdown();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        fs.delete(new Path(LABEL_FILE), false);
        LabelManager lb = LabelManager.getInstance();
        try {
            lb.refreshLabels(this.conf);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(timeout=30000L)
    public void testParallelChildQueuesAccess() throws Throwable {
        final UserGroupInformation user = UserGroupInformation.getLoginUser();
        this.scheduler.init(this.conf);
        final ArrayList exceptionsFromThreads = new ArrayList();
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread th, Throwable ex) {
                exceptionsFromThreads.add(ex);
            }
        };
        Thread readThread = new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 1000000; ++i) {
                    TestFairScheduler.this.scheduler.getQueueManager().getRootQueue().getQueueUserAclInfo(user);
                }
            }
        });
        readThread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
        final FSLeafQueue childQueue = new FSLeafQueue("test", this.scheduler, null);
        final FSParentQueue rootQueue = this.scheduler.getQueueManager().getRootQueue();
        Thread modifyThread = new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 1000000; ++i) {
                    rootQueue.addChildQueue((FSQueue)childQueue);
                    rootQueue.removeChildQueue((FSQueue)childQueue);
                }
            }
        });
        modifyThread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
        readThread.start();
        modifyThread.start();
        readThread.join();
        modifyThread.join();
        if (!exceptionsFromThreads.isEmpty()) {
            throw (Throwable)exceptionsFromThreads.get(0);
        }
    }

    @Test(timeout=30000L)
    public void testConfValidation() throws Exception {
        this.scheduler = new FairScheduler();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.scheduler.minimum-allocation-mb", 2048);
        conf.setInt("yarn.scheduler.maximum-allocation-mb", 1024);
        try {
            this.scheduler.serviceInit((Configuration)conf);
            Assert.fail((String)"Exception is expected because the min memory allocation is larger than the max memory allocation.");
        }
        catch (YarnRuntimeException e) {
            Assert.assertTrue((String)"The thrown exception is not the expected one.", (boolean)e.getMessage().startsWith("Invalid resource scheduler memory"));
        }
        conf = new YarnConfiguration();
        conf.setInt("yarn.scheduler.minimum-allocation-vcores", 2);
        conf.setInt("yarn.scheduler.maximum-allocation-vcores", 1);
        try {
            this.scheduler.serviceInit((Configuration)conf);
            Assert.fail((String)"Exception is expected because the min vcores allocation is larger than the max vcores allocation.");
        }
        catch (YarnRuntimeException e) {
            Assert.assertTrue((String)"The thrown exception is not the expected one.", (boolean)e.getMessage().startsWith("Invalid resource scheduler vcores"));
        }
    }

    @Test(timeout=2000L)
    public void testLoadConfigurationOnInitialize() throws IOException {
        this.conf.setBoolean("yarn.scheduler.fair.assignmultiple", true);
        this.conf.setInt("yarn.scheduler.fair.max.assign", 3);
        this.conf.setBoolean("yarn.scheduler.fair.sizebasedweight", true);
        this.conf.setFloat("yarn.scheduler.fair.locality.threshold.node", 0.5f);
        this.conf.setFloat("yarn.scheduler.fair.locality.threshold.rack", 0.7f);
        this.conf.setBoolean("yarn.scheduler.fair.continuous-scheduling-enabled", true);
        this.conf.setInt("yarn.scheduler.fair.continuous-scheduling-sleep-ms", 10);
        this.conf.setInt("yarn.scheduler.fair.locality-delay-rack-ms", 5000);
        this.conf.setInt("yarn.scheduler.fair.locality-delay-node-ms", 5000);
        this.conf.setInt("yarn.scheduler.maximum-allocation-mb", 1024);
        this.conf.setInt("yarn.scheduler.minimum-allocation-mb", 512);
        this.conf.setInt("yarn.scheduler.increment-allocation-mb", 128);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        Assert.assertEquals((Object)true, (Object)this.scheduler.assignMultiple);
        Assert.assertEquals((long)3L, (long)this.scheduler.maxAssign);
        Assert.assertEquals((Object)true, (Object)this.scheduler.sizeBasedWeight);
        Assert.assertEquals((double)0.5, (double)this.scheduler.nodeLocalityThreshold, (double)0.01);
        Assert.assertEquals((double)0.7, (double)this.scheduler.rackLocalityThreshold, (double)0.01);
        Assert.assertTrue((String)"The continuous scheduling should be enabled", (boolean)this.scheduler.continuousSchedulingEnabled);
        Assert.assertEquals((long)10L, (long)this.scheduler.continuousSchedulingSleepMs);
        Assert.assertEquals((long)5000L, (long)this.scheduler.nodeLocalityDelayMs);
        Assert.assertEquals((long)5000L, (long)this.scheduler.rackLocalityDelayMs);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getMaximumResourceCapability().getMemory());
        Assert.assertEquals((long)512L, (long)this.scheduler.getMinimumResourceCapability().getMemory());
        Assert.assertEquals((long)128L, (long)this.scheduler.getIncrementResourceCapability().getMemory());
    }

    @Test
    public void testNonMinZeroResourcesSettings() throws IOException {
        this.scheduler = new FairScheduler();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.scheduler.minimum-allocation-mb", 256);
        conf.setInt("yarn.scheduler.minimum-allocation-vcores", 1);
        conf.setInt("yarn.scheduler.increment-allocation-mb", 512);
        conf.setInt("yarn.scheduler.increment-allocation-vcores", 2);
        this.scheduler.init((Configuration)conf);
        this.scheduler.reinitialize((Configuration)conf, null);
        Assert.assertEquals((long)256L, (long)this.scheduler.getMinimumResourceCapability().getMemory());
        Assert.assertEquals((long)1L, (long)this.scheduler.getMinimumResourceCapability().getVirtualCores());
        Assert.assertEquals((long)512L, (long)this.scheduler.getIncrementResourceCapability().getMemory());
        Assert.assertEquals((long)2L, (long)this.scheduler.getIncrementResourceCapability().getVirtualCores());
    }

    @Test
    public void testMinZeroResourcesSettings() throws IOException {
        this.scheduler = new FairScheduler();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.scheduler.minimum-allocation-mb", 0);
        conf.setInt("yarn.scheduler.minimum-allocation-vcores", 0);
        conf.setInt("yarn.scheduler.increment-allocation-mb", 512);
        conf.setInt("yarn.scheduler.increment-allocation-vcores", 2);
        this.scheduler.init((Configuration)conf);
        this.scheduler.reinitialize((Configuration)conf, null);
        Assert.assertEquals((long)0L, (long)this.scheduler.getMinimumResourceCapability().getMemory());
        Assert.assertEquals((long)0L, (long)this.scheduler.getMinimumResourceCapability().getVirtualCores());
        Assert.assertEquals((long)512L, (long)this.scheduler.getIncrementResourceCapability().getMemory());
        Assert.assertEquals((long)2L, (long)this.scheduler.getIncrementResourceCapability().getVirtualCores());
    }

    @Test
    public void testAggregateCapacityTracking() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getClusterResource().getMemory());
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)512), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        Assert.assertEquals((long)1536L, (long)this.scheduler.getClusterResource().getMemory());
        NodeRemovedSchedulerEvent nodeEvent3 = new NodeRemovedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent3);
        Assert.assertEquals((long)512L, (long)this.scheduler.getClusterResource().getMemory());
    }

    @Test
    public void testSimpleFairShareCalculation() throws IOException {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)10240), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(10240, "queue1", "user1");
        this.createSchedulingRequest(10240, "queue2", "user1");
        this.createSchedulingRequest(10240, "root.default", "user1");
        this.scheduler.update();
        this.scheduler.getQueueManager().getRootQueue().setSteadyFairShare(this.scheduler.getClusterResource());
        this.scheduler.getQueueManager().getRootQueue().recomputeSteadyShares();
        Collection queues = this.scheduler.getQueueManager().getLeafQueues();
        Assert.assertEquals((long)3L, (long)queues.size());
        for (FSLeafQueue p : queues) {
            Assert.assertEquals((long)3414L, (long)p.getFairShare().getMemory());
            Assert.assertEquals((long)3414L, (long)p.getMetrics().getFairShareMB());
            Assert.assertEquals((long)3414L, (long)p.getSteadyFairShare().getMemory());
            Assert.assertEquals((long)3414L, (long)p.getMetrics().getSteadyFairShareMB());
        }
    }

    @Test
    public void testQueueMaximumCapacityAllocations() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        int RM_SCHEDULER_MAXIMUM_ALLOCATION_MB_VALUE = 10240;
        int tooHighQueueAllocation = RM_SCHEDULER_MAXIMUM_ALLOCATION_MB_VALUE + 1;
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("  <queue name=\"queueA\">");
        out.println("   <maxContainerAllocation>512 mb 1 vcores 1 disks</maxContainerAllocation>");
        out.println("  </queue>");
        out.println("  <queue name=\"queueB\">");
        out.println("  </queue>");
        out.println("  <queue name=\"queueC\">");
        out.println("   <maxContainerAllocation>2048 mb 3 vcores 2 disks</maxContainerAllocation>");
        out.println("    <queue name=\"queueD\">");
        out.println("    </queue>");
        out.println("  </queue>");
        out.println("  <queue name=\"queueE\">");
        out.println("    <maxContainerAllocation>" + tooHighQueueAllocation + " mb 1 vcores 1 disks</maxContainerAllocation>");
        out.println("  </queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        Assert.assertEquals((long)1L, (long)this.scheduler.getMaximumResourceCapability("root.queueA").getVirtualCores());
        Assert.assertEquals((long)512L, (long)this.scheduler.getMaximumResourceCapability("root.queueA").getMemory());
        Assert.assertEquals((double)1.0, (double)this.scheduler.getMaximumResourceCapability("root.queueA").getDisks(), (double)0.01);
        Assert.assertEquals((long)4L, (long)this.scheduler.getMaximumResourceCapability("root.queueB").getVirtualCores());
        Assert.assertEquals((long)RM_SCHEDULER_MAXIMUM_ALLOCATION_MB_VALUE, (long)this.scheduler.getMaximumResourceCapability("root.queueB").getMemory());
        Assert.assertEquals((double)4.0, (double)this.scheduler.getMaximumResourceCapability("root.queueB").getDisks(), (double)0.01);
        Assert.assertEquals((long)3L, (long)this.scheduler.getMaximumResourceCapability("root.queueC").getVirtualCores());
        Assert.assertEquals((long)2048L, (long)this.scheduler.getMaximumResourceCapability("root.queueC").getMemory());
        Assert.assertEquals((double)2.0, (double)this.scheduler.getMaximumResourceCapability("root.queueC").getDisks(), (double)0.01);
        Assert.assertEquals((long)3L, (long)this.scheduler.getMaximumResourceCapability("root.queueC.queueD").getVirtualCores());
        Assert.assertEquals((long)2048L, (long)this.scheduler.getMaximumResourceCapability("root.queueC.queueD").getMemory());
        Assert.assertEquals((double)2.0, (double)this.scheduler.getMaximumResourceCapability("root.queueC.queueD").getDisks(), (double)0.01);
        Assert.assertEquals((long)RM_SCHEDULER_MAXIMUM_ALLOCATION_MB_VALUE, (long)this.scheduler.getMaximumResourceCapability("root.queueE").getMemory());
    }

    @Test
    public void testNormalizationUsingQueueMaximumAllocation() throws IOException {
        int RM_SCHEDULER_MAXIMUM_ALLOCATION_MB_VALUE = 10240;
        int queueMaxAllocation = 4096;
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println(" <queue name=\"queueA\">");
        out.println("  <maxContainerAllocation>" + queueMaxAllocation + " mb 1 vcores 1 disks</maxContainerAllocation>");
        out.println(" </queue>");
        out.println(" <queue name=\"queueB\">");
        out.println(" </queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        this.allocateAppAttempt("root.queueA", 1, queueMaxAllocation + 1024);
        this.allocateAppAttempt("root.queueB", 2, RM_SCHEDULER_MAXIMUM_ALLOCATION_MB_VALUE + 1024);
        this.scheduler.update();
        FSQueue queueToCheckA = this.scheduler.getQueueManager().getQueue("root.queueA");
        FSQueue queueToCheckB = this.scheduler.getQueueManager().getQueue("root.queueB");
        Assert.assertEquals((long)queueMaxAllocation, (long)queueToCheckA.getDemand().getMemory());
        Assert.assertEquals((long)RM_SCHEDULER_MAXIMUM_ALLOCATION_MB_VALUE, (long)queueToCheckB.getDemand().getMemory());
    }

    private void allocateAppAttempt(String queueName, int id, int memorySize) {
        ApplicationAttemptId id11 = this.createAppAttemptId(id, id);
        this.createMockRMApp(id11);
        this.scheduler.addApplication(id11.getApplicationId(), queueName, "user1", false);
        this.scheduler.addApplicationAttempt(id11, false, false);
        ArrayList<ResourceRequest> ask1 = new ArrayList<ResourceRequest>();
        ResourceRequest request1 = this.createResourceRequest(memorySize, "*", 1, 1, true);
        ask1.add(request1);
        this.scheduler.allocate(id11, ask1, new ArrayList(), null, null);
    }

    @Test
    public void testFairShareBasedOnLabelsEnabled() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.conf.set("node.labels.file", LABEL_FILE);
        this.conf.setBoolean("yarn.scheduler.fair.resources-based-on-labels-enabled", true);
        PrintWriter out = new PrintWriter(new FileWriter(LABEL_FILE));
        out.println("node1  LabelA");
        out.println("node2  LabelB");
        out.close();
        out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("  <queue name=\"queue1\">");
        out.println("  <label>LabelA</label>");
        out.println("  </queue>");
        out.println("  <queue name=\"queue2\">");
        out.println("  <label>LabelB</label>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        this.lbS.init(this.conf);
        this.lbS.start();
        LabelManager lb = LabelManager.getInstance();
        lb.refreshLabels(this.conf);
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)10240), 1, "node1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)5120), 2, "node2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.createSchedulingRequest(1024, "queue1", "user1");
        this.createSchedulingRequest(1024, "queue2", "user1");
        QueueManager queueManager = this.scheduler.getQueueManager();
        this.scheduler.update();
        Collection leafQueues = queueManager.getLeafQueues();
        Assert.assertEquals((long)3L, (long)leafQueues.size());
        FSParentQueue root = queueManager.getParentQueue("root", false);
        FSLeafQueue defaultQueue = queueManager.getLeafQueue("default", false);
        FSLeafQueue queue1 = queueManager.getLeafQueue("queue1", false);
        FSLeafQueue queue2 = queueManager.getLeafQueue("queue2", false);
        Assert.assertEquals((long)15360L, (long)root.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)0L, (long)defaultQueue.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)10240L, (long)queue1.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)10240L, (long)queue1.getFairShare().getMemory());
        Assert.assertEquals((long)5120L, (long)queue2.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)5120L, (long)queue2.getFairShare().getMemory());
        this.tearDown();
        this.setUp();
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.createSchedulingRequest(1024, "queue1", "user1");
        this.createSchedulingRequest(1024, "queue2", "user1");
        this.scheduler.update();
        queueManager = this.scheduler.getQueueManager();
        root = queueManager.getParentQueue("root", false);
        defaultQueue = queueManager.getLeafQueue("default", false);
        queue1 = queueManager.getLeafQueue("queue1", false);
        queue2 = queueManager.getLeafQueue("queue2", false);
        Assert.assertEquals((long)15360L, (long)root.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)5120L, (long)defaultQueue.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)5120L, (long)queue1.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)7680L, (long)queue1.getFairShare().getMemory());
        Assert.assertEquals((long)5120L, (long)queue2.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)7680L, (long)queue2.getFairShare().getMemory());
        this.tearDown();
        this.setUp();
        out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("<label>LabelA</label>");
        out.println("  <queue name=\"queue1\">");
        out.println("  </queue>");
        out.println("  <queue name=\"queue2\">");
        out.println("  <label>LabelB</label>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.conf.setBoolean("yarn.scheduler.fair.resources-based-on-labels-enabled", false);
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.conf.set("node.labels.file", LABEL_FILE);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        out = new PrintWriter(new FileWriter(LABEL_FILE));
        out.println("node1  LabelA");
        out.println("node2  LabelB");
        out.close();
        this.lbS.init(this.conf);
        this.lbS.start();
        lb = LabelManager.getInstance();
        lb.refreshLabels(this.conf);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.createSchedulingRequest(1024, "queue1", "user1");
        this.createSchedulingRequest(1024, "queue2", "user1");
        this.scheduler.update();
        queueManager = this.scheduler.getQueueManager();
        root = queueManager.getParentQueue("root", false);
        defaultQueue = queueManager.getLeafQueue("default", false);
        queue1 = queueManager.getLeafQueue("queue1", false);
        queue2 = queueManager.getLeafQueue("queue2", false);
        Assert.assertEquals((long)15360L, (long)root.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)5120L, (long)defaultQueue.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)5120L, (long)queue1.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)7680L, (long)queue1.getFairShare().getMemory());
        Assert.assertEquals((long)5120L, (long)queue2.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)7680L, (long)queue2.getFairShare().getMemory());
        this.tearDown();
        this.setUp();
        this.conf.setBoolean("yarn.scheduler.fair.resources-based-on-labels-enabled", false);
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.conf.set("node.labels.file", LABEL_FILE);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        out = new PrintWriter(new FileWriter(LABEL_FILE));
        out.println("node1  LabelA");
        out.println("node2  LabelB");
        out.close();
        this.lbS.init(this.conf);
        this.lbS.start();
        lb = LabelManager.getInstance();
        lb.refreshLabels(this.conf);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.createSchedulingRequest(1024, "queue1", "user1");
        this.createSchedulingRequest(1024, "queue2", "user1");
        this.scheduler.update();
        queueManager = this.scheduler.getQueueManager();
        root = queueManager.getParentQueue("root", false);
        defaultQueue = queueManager.getLeafQueue("default", false);
        queue1 = queueManager.getLeafQueue("queue1", false);
        queue2 = queueManager.getLeafQueue("queue2", false);
        Assert.assertEquals((long)15360L, (long)root.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)5120L, (long)defaultQueue.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)5120L, (long)queue1.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)7680L, (long)queue1.getFairShare().getMemory());
        Assert.assertEquals((long)5120L, (long)queue2.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)7680L, (long)queue2.getFairShare().getMemory());
    }

    @Test
    public void testFairShareCalculation() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("  <queue name=\"queue1\">");
        out.println("    <queue name=\"queue11\">");
        out.println("    </queue>");
        out.println("    <queue name=\"queue12\">");
        out.println("    </queue>");
        out.println("  </queue>");
        out.println("  <queue name=\"queue2\">");
        out.println("    <queue name=\"queue21\">");
        out.println("    </queue>");
        out.println("    <queue name=\"queue22\">");
        out.println("    </queue>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)10240), 1, "node1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)5120), 2, "node2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.createSchedulingRequest(1024, "queue1.queue11", "user1");
        this.createSchedulingRequest(1024, "queue2.queue21", "user1");
        this.scheduler.update();
        this.scheduler.getQueueManager().getRootQueue().setSteadyFairShare(this.scheduler.getClusterResource());
        this.scheduler.getQueueManager().getRootQueue().recomputeSteadyShares();
        QueueManager queueManager = this.scheduler.getQueueManager();
        Collection leafQueues = queueManager.getLeafQueues();
        Assert.assertEquals((long)5L, (long)leafQueues.size());
        FSLeafQueue defaultQueue = queueManager.getLeafQueue("default", false);
        FSParentQueue root = queueManager.getParentQueue("root", false);
        FSParentQueue queue1 = queueManager.getParentQueue("queue1", false);
        FSLeafQueue queue11 = queueManager.getLeafQueue("queue1.queue11", false);
        FSLeafQueue queue12 = queueManager.getLeafQueue("queue1.queue12", false);
        FSParentQueue queue2 = queueManager.getParentQueue("queue2", false);
        FSLeafQueue queue21 = queueManager.getLeafQueue("queue2.queue21", false);
        FSLeafQueue queue22 = queueManager.getLeafQueue("queue2.queue22", false);
        Assert.assertEquals((long)15360L, (long)root.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)5120L, (long)defaultQueue.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)5120L, (long)queue1.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)7680L, (long)queue1.getFairShare().getMemory());
        Assert.assertEquals((long)2560L, (long)queue11.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)7680L, (long)queue11.getFairShare().getMemory());
        Assert.assertEquals((long)2560L, (long)queue12.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)0L, (long)queue12.getFairShare().getMemory());
        Assert.assertEquals((long)5120L, (long)queue2.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)7680L, (long)queue2.getFairShare().getMemory());
        Assert.assertEquals((long)2560L, (long)queue21.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)7680L, (long)queue21.getFairShare().getMemory());
        Assert.assertEquals((long)2560L, (long)queue22.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)0L, (long)queue22.getFairShare().getMemory());
    }

    @Test
    public void testFairShareCalculationWithLbs() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.conf.set("node.labels.file", LABEL_FILE);
        this.conf.setBoolean("yarn.scheduler.fair.resources-based-on-labels-enabled", true);
        PrintWriter out = new PrintWriter(new FileWriter(LABEL_FILE));
        out.println("node1  LabelA");
        out.println("node2  LabelB");
        out.close();
        out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("  <queue name=\"queue1\">");
        out.println("  <label>LabelA</label>");
        out.println("    <queue name=\"queue11\">");
        out.println("    </queue>");
        out.println("    <queue name=\"queue12\">");
        out.println("    </queue>");
        out.println("  </queue>");
        out.println("  <queue name=\"queue2\">");
        out.println("  <label>LabelB</label>");
        out.println("    <queue name=\"queue21\">");
        out.println("    </queue>");
        out.println("    <queue name=\"queue22\">");
        out.println("    </queue>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        this.lbS.init(this.conf);
        this.lbS.start();
        LabelManager lb = LabelManager.getInstance();
        lb.refreshLabels(this.conf);
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)10240), 1, "node1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)5120), 2, "node2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.createSchedulingRequest(1024, "queue1.queue11", "user1");
        this.createSchedulingRequest(1024, "queue2.queue21", "user1");
        this.scheduler.update();
        this.scheduler.getQueueManager().getRootQueue().setSteadyFairShare(this.scheduler.getClusterResource());
        this.scheduler.getQueueManager().getRootQueue().recomputeSteadyShares();
        QueueManager queueManager = this.scheduler.getQueueManager();
        Collection leafQueues = queueManager.getLeafQueues();
        Assert.assertEquals((long)5L, (long)leafQueues.size());
        FSLeafQueue defaultQueue = queueManager.getLeafQueue("default", false);
        FSParentQueue root = queueManager.getParentQueue("root", false);
        FSParentQueue queue1 = queueManager.getParentQueue("queue1", false);
        FSLeafQueue queue11 = queueManager.getLeafQueue("queue1.queue11", false);
        FSLeafQueue queue12 = queueManager.getLeafQueue("queue1.queue12", false);
        FSParentQueue queue2 = queueManager.getParentQueue("queue2", false);
        FSLeafQueue queue21 = queueManager.getLeafQueue("queue2.queue21", false);
        FSLeafQueue queue22 = queueManager.getLeafQueue("queue2.queue22", false);
        Assert.assertEquals((long)15360L, (long)root.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)0L, (long)defaultQueue.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)10240L, (long)queue1.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)10240L, (long)queue1.getFairShare().getMemory());
        Assert.assertEquals((long)5120L, (long)queue11.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)10240L, (long)queue11.getFairShare().getMemory());
        Assert.assertEquals((long)5120L, (long)queue12.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)0L, (long)queue12.getFairShare().getMemory());
        Assert.assertEquals((long)5120L, (long)queue2.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)5120L, (long)queue2.getFairShare().getMemory());
        Assert.assertEquals((long)2560L, (long)queue21.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)5120L, (long)queue21.getFairShare().getMemory());
        Assert.assertEquals((long)2560L, (long)queue22.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)0L, (long)queue22.getFairShare().getMemory());
    }

    @Test
    public void testFairShareForDifferentLabelsInHierarchy() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.conf.set("node.labels.file", LABEL_FILE);
        this.conf.setBoolean("yarn.scheduler.fair.resources-based-on-labels-enabled", true);
        PrintWriter out = new PrintWriter(new FileWriter(LABEL_FILE));
        out.println("node1  LabelA");
        out.println("node2  LabelB");
        out.close();
        out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("<label>LabelA</label>");
        out.println("  <queue name=\"queue1\">");
        out.println("    <queue name=\"queue11\">");
        out.println("    </queue>");
        out.println("    <queue name=\"queue12\">");
        out.println("    </queue>");
        out.println("  </queue>");
        out.println("  <queue name=\"queue2\">");
        out.println("  <label>LabelB</label>");
        out.println("    <queue name=\"queue21\">");
        out.println("    <label>LabelA</label>");
        out.println("    </queue>");
        out.println("    <queue name=\"queue22\">");
        out.println("    </queue>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        this.lbS.init(this.conf);
        this.lbS.start();
        LabelManager lb = LabelManager.getInstance();
        lb.refreshLabels(this.conf);
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)10240), 1, "node1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)5120), 2, "node2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.createSchedulingRequest(1024, "queue1.queue11", "user1");
        this.createSchedulingRequest(1024, "queue2.queue21", "user1");
        this.scheduler.update();
        this.scheduler.getQueueManager().getRootQueue().setSteadyFairShare(this.scheduler.getClusterResource());
        this.scheduler.getQueueManager().getRootQueue().recomputeSteadyShares();
        QueueManager queueManager = this.scheduler.getQueueManager();
        Collection leafQueues = queueManager.getLeafQueues();
        Assert.assertEquals((long)5L, (long)leafQueues.size());
        FSLeafQueue defaultQueue = queueManager.getLeafQueue("default", false);
        FSParentQueue root = queueManager.getParentQueue("root", false);
        FSParentQueue queue1 = queueManager.getParentQueue("queue1", false);
        FSLeafQueue queue11 = queueManager.getLeafQueue("queue1.queue11", false);
        FSLeafQueue queue12 = queueManager.getLeafQueue("queue1.queue12", false);
        FSParentQueue queue2 = queueManager.getParentQueue("queue2", false);
        FSLeafQueue queue21 = queueManager.getLeafQueue("queue2.queue21", false);
        FSLeafQueue queue22 = queueManager.getLeafQueue("queue2.queue22", false);
        Assert.assertEquals((long)10240L, (long)root.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)5120L, (long)defaultQueue.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)5120L, (long)queue1.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)10240L, (long)queue1.getFairShare().getMemory());
        Assert.assertEquals((long)2560L, (long)queue11.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)10240L, (long)queue11.getFairShare().getMemory());
        Assert.assertEquals((long)2560L, (long)queue12.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)0L, (long)queue12.getFairShare().getMemory());
        Assert.assertEquals((long)0L, (long)queue2.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)0L, (long)queue2.getFairShare().getMemory());
        Assert.assertEquals((long)0L, (long)queue21.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)0L, (long)queue21.getFairShare().getMemory());
        Assert.assertEquals((long)0L, (long)queue22.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)0L, (long)queue22.getFairShare().getMemory());
    }

    @Test
    public void testConfigureDefaultQueueLabel() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("  <queue name=\"queue1\">");
        out.println("    <label>LabelA</label>");
        out.println("  </queue>");
        out.println("  <queue name=\"queue2\">");
        out.println("    <queue name=\"queue21\">");
        out.println("    </queue>");
        out.println("  </queue>");
        out.println("  <queue name=\"queue3\">");
        out.println("    <queue name=\"queue31\">");
        out.println("    <label>LabelA</label>");
        out.println("    </queue>");
        out.println("  </queue>");
        out.println("  <queue name=\"queue4\">");
        out.println("    <label>LabelA</label>");
        out.println("    <queue name=\"queue41\">");
        out.println("    </queue>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("<defaultQueueLabel>LabelB</defaultQueueLabel>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueManager = this.scheduler.getQueueManager();
        FSParentQueue root = queueManager.getRootQueue();
        Assert.assertNull((Object)root.getLabel());
        FSLeafQueue queue1 = queueManager.getLeafQueue("queue1", false);
        Assert.assertEquals((Object)"(LabelA)", (Object)queue1.getLabel().toString());
        FSParentQueue queue2 = queueManager.getParentQueue("queue2", false);
        FSLeafQueue queue21 = queueManager.getLeafQueue("queue2.queue21", false);
        Assert.assertEquals((Object)"(LabelB)", (Object)queue2.getLabel().toString());
        Assert.assertEquals((Object)"(LabelB)", (Object)queue21.getLabel().toString());
        FSParentQueue queue3 = queueManager.getParentQueue("queue3", false);
        FSLeafQueue queue31 = queueManager.getLeafQueue("queue3.queue31", false);
        Assert.assertEquals((Object)"(LabelB)", (Object)queue3.getLabel().toString());
        Assert.assertEquals((Object)"(LabelA)", (Object)queue31.getLabel().toString());
        FSParentQueue queue4 = queueManager.getParentQueue("queue4", false);
        FSLeafQueue queue41 = queueManager.getLeafQueue("queue4.queue41", false);
        Assert.assertEquals((Object)"(LabelA)", (Object)queue4.getLabel().toString());
        Assert.assertEquals((Object)"(LabelA)", (Object)queue41.getLabel().toString());
    }

    @Test
    public void testFairShareWithDefaultQueueLabel() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.conf.set("node.labels.file", LABEL_FILE);
        this.conf.setBoolean("yarn.scheduler.fair.resources-based-on-labels-enabled", true);
        PrintWriter out = new PrintWriter(new FileWriter(LABEL_FILE));
        out.println("node1  LabelA");
        out.println("node2  LabelB");
        out.close();
        out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("  <queue name=\"queue1\">");
        out.println("    <label>LabelA</label>");
        out.println("  </queue>");
        out.println("  <queue name=\"queue2\">");
        out.println("    <queue name=\"queue21\">");
        out.println("    </queue>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("<defaultQueueLabel>LabelB</defaultQueueLabel>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        this.lbS.init(this.conf);
        this.lbS.start();
        LabelManager lb = LabelManager.getInstance();
        lb.refreshLabels(this.conf);
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)10240), 1, "node1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)5120), 2, "node2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.createSchedulingRequest(1024, "queue2.queue21", "user1");
        this.scheduler.update();
        this.scheduler.getQueueManager().getRootQueue().setSteadyFairShare(this.scheduler.getClusterResource());
        this.scheduler.getQueueManager().getRootQueue().recomputeSteadyShares();
        QueueManager queueManager = this.scheduler.getQueueManager();
        Collection leafQueues = queueManager.getLeafQueues();
        Assert.assertEquals((long)3L, (long)leafQueues.size());
        FSLeafQueue defaultQueue = queueManager.getLeafQueue("default", false);
        FSParentQueue root = queueManager.getParentQueue("root", false);
        FSLeafQueue queue1 = queueManager.getLeafQueue("queue1", false);
        FSParentQueue queue2 = queueManager.getParentQueue("queue2", false);
        FSLeafQueue queue21 = queueManager.getLeafQueue("queue2.queue21", false);
        FSLeafQueue userQueue = queueManager.getLeafQueue("userqueue", true);
        Assert.assertEquals((long)15360L, (long)root.getSteadyFairShare().getMemory());
        Assert.assertNull((String)"Label for the root queue shouldn't be set to the default label", (Object)root.getLabel());
        Assert.assertEquals((long)1707L, (long)defaultQueue.getSteadyFairShare().getMemory());
        Assert.assertEquals((Object)"(LabelB)", (Object)defaultQueue.getLabel().toString());
        Assert.assertEquals((long)10240L, (long)queue1.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)0L, (long)queue1.getFairShare().getMemory());
        Assert.assertEquals((long)1707L, (long)queue2.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)5120L, (long)queue2.getFairShare().getMemory());
        Assert.assertEquals((Object)"(LabelB)", (Object)queue2.getLabel().toString());
        Assert.assertEquals((long)1707L, (long)queue21.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)5120L, (long)queue21.getFairShare().getMemory());
        Assert.assertEquals((Object)"(LabelB)", (Object)queue21.getLabel().toString());
        Assert.assertEquals((long)1707L, (long)userQueue.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)0L, (long)userQueue.getFairShare().getMemory());
        Assert.assertEquals((Object)"(LabelB)", (Object)userQueue.getLabel().toString());
    }

    @Test
    public void testPreemptionWithLbs() throws Exception {
        this.conf.setLong("yarn.scheduler.fair.preemptionInterval", 5000L);
        this.conf.setLong("yarn.scheduler.fair.waitTimeBeforeKill", 10000L);
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.conf.set("yarn.scheduler.fair.user-as-default-queue", "false");
        this.conf.setBoolean("yarn.scheduler.fair.resources-based-on-labels-enabled", true);
        this.conf.setBoolean("yarn.scheduler.fair.preemption.cluster-utilization-threshold.based-on-labels-enabled", true);
        this.conf.set("node.labels.file", LABEL_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(LABEL_FILE));
        out.println("node1  Plain");
        out.println("node2  Large");
        out.close();
        ControlledClock clock = new ControlledClock();
        this.scheduler.setClock((Clock)clock);
        out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"plain1\">");
        out.println("<label>Plain</label>");
        out.println("</queue>");
        out.println("<queue name=\"plain2\">");
        out.println("<label>Plain</label>");
        out.println("</queue>");
        out.println("<queue name=\"large\">");
        out.println("<label>Large</label>");
        out.println("</queue>");
        out.println("<schedulingPolicy>drf</schedulingPolicy>");
        out.println("<defaultFairSharePreemptionTimeout>10</defaultFairSharePreemptionTimeout>");
        out.println("<defaultFairSharePreemptionThreshold>.5</defaultFairSharePreemptionThreshold>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        this.lbS.init(this.conf);
        this.lbS.start();
        LabelManager lb = LabelManager.getInstance();
        lb.refreshLabels(this.conf);
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)5120, (int)5), 1, "node1");
        NetUtils.addStaticResolution((String)node1.getHostName(), (String)STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)15360, (int)5), 1, "node2");
        NetUtils.addStaticResolution((String)node2.getHostName(), (String)STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId app1 = this.createSchedulingRequest(1024, 1, "plain1", "user1", 5, 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent nodeUpdate1 = new NodeUpdateSchedulerEvent(node1);
        for (int i = 0; i < 5; ++i) {
            this.scheduler.handle((SchedulerEvent)nodeUpdate1);
        }
        Assert.assertEquals((long)5L, (long)this.scheduler.getSchedulerApp(app1).getLiveContainers().size());
        ApplicationAttemptId app2 = this.createSchedulingRequest(1024, 1, "plain2", "user2", 1, 1);
        this.scheduler.update();
        clock.tickSec(11);
        this.scheduler.update();
        Map toPreempt = this.scheduler.resToPreempt(this.scheduler.getQueueManager().getLeafQueue("plain2", false), clock.getTime());
        Assert.assertEquals((long)1024L, (long)this.computeTotalResource(toPreempt).getMemory());
        this.scheduler.preemptResources(toPreempt);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(app1).getPreemptionContainers().size());
    }

    @Test
    public void testFairShareWithMaxResources() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<maxResources>1073741824 mb 1000 vcores 50 disks</maxResources>");
        out.println("<weight>.25</weight>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<maxResources>1073741824 mb 1000 vcores 50 disks</maxResources>");
        out.println("<weight>.75</weight>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(1024, "queueA", "user1");
        this.createSchedulingRequest(6144, "queueB", "user1");
        this.scheduler.update();
        FSLeafQueue queue = this.scheduler.getQueueManager().getLeafQueue("queueA", false);
        Assert.assertEquals((long)2048L, (long)queue.getFairShare().getMemory());
        queue = this.scheduler.getQueueManager().getLeafQueue("queueB", false);
        Assert.assertEquals((long)6144L, (long)queue.getFairShare().getMemory());
    }

    @Test
    public void testFairShareWithZeroWeight() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<weight>0.0</weight>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<weight>0.0</weight>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(2048, "queueA", "user1");
        this.createSchedulingRequest(6144, "queueB", "user1");
        this.scheduler.update();
        FSLeafQueue queue = this.scheduler.getQueueManager().getLeafQueue("queueA", false);
        Assert.assertEquals((long)0L, (long)queue.getFairShare().getMemory());
        queue = this.scheduler.getQueueManager().getLeafQueue("queueB", false);
        Assert.assertEquals((long)0L, (long)queue.getFairShare().getMemory());
    }

    @Test
    public void testFairShareWithZeroWeightNoneZeroMinRes() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<minResources>1 mb 1 vcores 1 disks</minResources>");
        out.println("<weight>0.0</weight>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<minResources>1 mb 1 vcores 1 disks</minResources>");
        out.println("<weight>0.0</weight>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(2048, "queueA", "user1");
        this.createSchedulingRequest(6144, "queueB", "user1");
        this.scheduler.update();
        FSLeafQueue queue = this.scheduler.getQueueManager().getLeafQueue("queueA", false);
        Assert.assertEquals((long)1L, (long)queue.getFairShare().getMemory());
        queue = this.scheduler.getQueueManager().getLeafQueue("queueB", false);
        Assert.assertEquals((long)1L, (long)queue.getFairShare().getMemory());
    }

    @Test
    public void testFairShareWithNoneZeroWeightNoneZeroMinRes() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<minResources>1024 mb 1 vcores 1 disks</minResources>");
        out.println("<weight>0.5</weight>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<minResources>1024 mb 1 vcores 1 disks</minResources>");
        out.println("<weight>0.5</weight>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(4096, "queueA", "user1");
        this.createSchedulingRequest(4096, "queueB", "user1");
        this.scheduler.update();
        FSLeafQueue queue = this.scheduler.getQueueManager().getLeafQueue("queueA", false);
        Assert.assertEquals((long)4096L, (long)queue.getFairShare().getMemory());
        queue = this.scheduler.getQueueManager().getLeafQueue("queueB", false);
        Assert.assertEquals((long)4096L, (long)queue.getFairShare().getMemory());
    }

    @Test
    public void testQueueInfo() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<weight>.25</weight>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<weight>.75</weight>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(1024, "queueA", "user1");
        this.createSchedulingRequest(6144, "queueB", "user1");
        this.scheduler.update();
        QueueInfo queueInfo = this.scheduler.getQueueInfo("queueA", false, false);
        Assert.assertEquals((float)0.25f, (float)queueInfo.getCapacity(), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)queueInfo.getCurrentCapacity(), (float)0.0f);
        queueInfo = this.scheduler.getQueueInfo("queueB", false, false);
        Assert.assertEquals((float)0.75f, (float)queueInfo.getCapacity(), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)queueInfo.getCurrentCapacity(), (float)0.0f);
        NodeUpdateSchedulerEvent nodeEvent2 = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        queueInfo = this.scheduler.getQueueInfo("queueA", false, false);
        Assert.assertEquals((float)0.25f, (float)queueInfo.getCapacity(), (float)0.0f);
        Assert.assertEquals((float)0.5f, (float)queueInfo.getCurrentCapacity(), (float)0.0f);
        queueInfo = this.scheduler.getQueueInfo("queueB", false, false);
        Assert.assertEquals((float)0.75f, (float)queueInfo.getCapacity(), (float)0.0f);
        Assert.assertEquals((float)1.0f, (float)queueInfo.getCurrentCapacity(), (float)0.0f);
    }

    @Test
    public void testSimpleHierarchicalFairShareCalculation() throws IOException {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        int capacity = 240;
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)capacity), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(10240, "parent.queue2", "user1");
        this.createSchedulingRequest(10240, "parent.queue3", "user1");
        this.createSchedulingRequest(10240, "root.default", "user1");
        this.scheduler.update();
        this.scheduler.getQueueManager().getRootQueue().setSteadyFairShare(this.scheduler.getClusterResource());
        this.scheduler.getQueueManager().getRootQueue().recomputeSteadyShares();
        QueueManager queueManager = this.scheduler.getQueueManager();
        Collection queues = queueManager.getLeafQueues();
        Assert.assertEquals((long)3L, (long)queues.size());
        FSLeafQueue queue1 = queueManager.getLeafQueue("default", true);
        FSLeafQueue queue2 = queueManager.getLeafQueue("parent.queue2", true);
        FSLeafQueue queue3 = queueManager.getLeafQueue("parent.queue3", true);
        Assert.assertEquals((long)(capacity / 2), (long)queue1.getFairShare().getMemory());
        Assert.assertEquals((long)(capacity / 2), (long)queue1.getMetrics().getFairShareMB());
        Assert.assertEquals((long)(capacity / 2), (long)queue1.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)(capacity / 2), (long)queue1.getMetrics().getSteadyFairShareMB());
        Assert.assertEquals((long)(capacity / 4), (long)queue2.getFairShare().getMemory());
        Assert.assertEquals((long)(capacity / 4), (long)queue2.getMetrics().getFairShareMB());
        Assert.assertEquals((long)(capacity / 4), (long)queue2.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)(capacity / 4), (long)queue2.getMetrics().getSteadyFairShareMB());
        Assert.assertEquals((long)(capacity / 4), (long)queue3.getFairShare().getMemory());
        Assert.assertEquals((long)(capacity / 4), (long)queue3.getMetrics().getFairShareMB());
        Assert.assertEquals((long)(capacity / 4), (long)queue3.getSteadyFairShare().getMemory());
        Assert.assertEquals((long)(capacity / 4), (long)queue3.getMetrics().getSteadyFairShareMB());
    }

    @Test
    public void testHierarchicalQueuesSimilarParents() throws IOException {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueManager = this.scheduler.getQueueManager();
        FSLeafQueue leafQueue = queueManager.getLeafQueue("parent.child", true);
        Assert.assertEquals((long)2L, (long)queueManager.getLeafQueues().size());
        Assert.assertNotNull((Object)leafQueue);
        Assert.assertEquals((Object)"root.parent.child", (Object)leafQueue.getName());
        FSLeafQueue leafQueue2 = queueManager.getLeafQueue("parent", true);
        Assert.assertNull((Object)leafQueue2);
        Assert.assertEquals((long)2L, (long)queueManager.getLeafQueues().size());
        FSLeafQueue leafQueue3 = queueManager.getLeafQueue("parent.child.grandchild", true);
        Assert.assertNull((Object)leafQueue3);
        Assert.assertEquals((long)2L, (long)queueManager.getLeafQueues().size());
        FSLeafQueue leafQueue4 = queueManager.getLeafQueue("parent.sister", true);
        Assert.assertNotNull((Object)leafQueue4);
        Assert.assertEquals((Object)"root.parent.sister", (Object)leafQueue4.getName());
        Assert.assertEquals((long)3L, (long)queueManager.getLeafQueues().size());
    }

    @Test
    public void testSchedulerRootQueueMetrics() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024));
        NetUtils.addStaticResolution((String)node1.getHostName(), (String)STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        this.createSchedulingRequest(1024, "queue2", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.rootMetrics.getReservedMB());
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024));
        NetUtils.addStaticResolution((String)node2.getHostName(), (String)STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        NodeUpdateSchedulerEvent updateEvent2 = new NodeUpdateSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.scheduler.handle((SchedulerEvent)updateEvent2);
        Assert.assertEquals((long)1024L, (long)this.scheduler.rootMetrics.getReservedMB());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.rootMetrics.getReservedMB());
    }

    @Test(timeout=5000L)
    public void testSimpleContainerAllocation() throws IOException {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024, (int)4), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)512, (int)2), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.createSchedulingRequest(512, 2, "queue1", "user1", 2);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemory());
        NodeUpdateSchedulerEvent updateEvent2 = new NodeUpdateSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)updateEvent2);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemory());
        Assert.assertEquals((long)2L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getVirtualCores());
        FSQueueMetrics queue1Metrics = this.scheduler.getQueueManager().getQueue("queue1").getMetrics();
        Assert.assertEquals((long)1024L, (long)queue1Metrics.getAllocatedMB());
        Assert.assertEquals((long)2L, (long)queue1Metrics.getAllocatedVirtualCores());
        Assert.assertEquals((long)1024L, (long)this.scheduler.getRootQueueMetrics().getAllocatedMB());
        Assert.assertEquals((long)2L, (long)this.scheduler.getRootQueueMetrics().getAllocatedVirtualCores());
        Assert.assertEquals((long)512L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)4L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
    }

    @Test(timeout=5000L)
    public void testSimpleContainerReservation() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemory());
        ApplicationAttemptId attId = this.createSchedulingRequest(1024, "queue2", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getQueueManager().getQueue("queue2").getResourceUsage().getMemory());
        Assert.assertEquals((long)1024L, (long)this.scheduler.getSchedulerApp(attId).getCurrentReservation().getMemory());
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        NodeUpdateSchedulerEvent updateEvent2 = new NodeUpdateSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.scheduler.handle((SchedulerEvent)updateEvent2);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getQueueManager().getQueue("queue2").getResourceUsage().getMemory());
        Assert.assertEquals((long)1024L, (long)this.scheduler.getSchedulerApp(attId).getCurrentReservation().getMemory());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId).getCurrentReservation().getMemory());
    }

    @Test(timeout=500000L)
    public void testContainerReservationAttemptExceedingQueueMax() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("<queue name=\"queue1\">");
        out.println("<maxResources>2048mb,5vcores,0.5disks</maxResources>");
        out.println("</queue>");
        out.println("<queue name=\"queue2\">");
        out.println("<maxResources>2048mb,10vcores,0.5disks</maxResources>");
        out.println("</queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)3072, (int)5), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(2048, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2048L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemory());
        this.createSchedulingRequest(1024, "queue2", "user2", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getQueueManager().getQueue("queue2").getResourceUsage().getMemory());
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId1).getCurrentReservation().getMemory());
    }

    @Test(timeout=500000L)
    public void testContainerReservationNotExceedingQueueMax() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("<queue name=\"queue1\">");
        out.println("<maxResources>3072mb,10vcores,0.5disks</maxResources>");
        out.println("</queue>");
        out.println("<queue name=\"queue2\">");
        out.println("<maxResources>2048mb,10vcores,0.5disks</maxResources>");
        out.println("</queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)3072, (int)5), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(2048, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2048L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemory());
        this.createSchedulingRequest(1024, "queue2", "user2", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getQueueManager().getQueue("queue2").getResourceUsage().getMemory());
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getSchedulerApp(attId1).getCurrentReservation().getMemory());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getSchedulerApp(attId1).getCurrentReservation().getMemory());
        out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("<queue name=\"queue1\">");
        out.println("<maxResources>2048mb,10vcores,0disks</maxResources>");
        out.println("</queue>");
        out.println("<queue name=\"queue2\">");
        out.println("<maxResources>2048mb,10vcores,0disks</maxResources>");
        out.println("</queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        this.createSchedulingRequest(1024, "queue2", "user2", 1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2048L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemory());
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId1).getCurrentReservation().getMemory());
        Assert.assertEquals((long)1024L, (long)this.scheduler.getQueueManager().getQueue("queue2").getResourceUsage().getMemory());
    }

    @Test
    public void testUserAsDefaultQueue() throws Exception {
        this.conf.set("yarn.scheduler.fair.user-as-default-queue", "true");
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ApplicationAttemptId appAttemptId = this.createAppAttemptId(1, 1);
        this.createApplicationWithAMResource(appAttemptId, "default", "user1", null);
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueue("user1", true).getNumRunnableApps());
        Assert.assertEquals((long)0L, (long)this.scheduler.getQueueManager().getLeafQueue("default", true).getNumRunnableApps());
        Assert.assertEquals((Object)"root.user1", (Object)((RMApp)this.resourceManager.getRMContext().getRMApps().get(appAttemptId.getApplicationId())).getQueue());
    }

    @Test
    public void testNotUserAsDefaultQueue() throws Exception {
        this.conf.set("yarn.scheduler.fair.user-as-default-queue", "false");
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ApplicationAttemptId appAttemptId = this.createAppAttemptId(1, 1);
        this.createApplicationWithAMResource(appAttemptId, "default", "user2", null);
        Assert.assertEquals((long)0L, (long)this.scheduler.getQueueManager().getLeafQueue("user1", true).getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueue("default", true).getNumRunnableApps());
        Assert.assertEquals((long)0L, (long)this.scheduler.getQueueManager().getLeafQueue("user2", true).getNumRunnableApps());
    }

    @Test
    public void testEmptyQueueName() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        ApplicationAttemptId appAttemptId = this.createAppAttemptId(1, 1);
        AppAddedSchedulerEvent appAddedEvent = new AppAddedSchedulerEvent(appAttemptId.getApplicationId(), "", "user1");
        this.scheduler.handle((SchedulerEvent)appAddedEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        Assert.assertNull((Object)this.scheduler.getSchedulerApp(appAttemptId));
        Assert.assertEquals((long)0L, (long)this.resourceManager.getRMContext().getRMApps().size());
        ApplicationAttemptId appAttemptId2 = this.createAppAttemptId(2, 1);
        AppAddedSchedulerEvent appAddedEvent2 = new AppAddedSchedulerEvent(appAttemptId2.getApplicationId(), "  ", "user1");
        this.scheduler.handle((SchedulerEvent)appAddedEvent2);
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        Assert.assertNull((Object)this.scheduler.getSchedulerApp(appAttemptId2));
        Assert.assertEquals((long)0L, (long)this.resourceManager.getRMContext().getRMApps().size());
    }

    @Test
    public void testQueueNameWithSpace() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.conf.setClass("hadoop.security.group.mapping", SimpleGroupsMapping.class, GroupMappingServiceProvider.class);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"adhoc\" type=\"parent\">");
        out.println("<weight>10</weight>");
        out.println("<maxRunningApps>300</maxRunningApps>");
        out.println("</queue>");
        out.println("<queue name=\"default\">");
        out.println("<weight>1</weight>");
        out.println("</queue>");
        out.println("<queue name=\"emergencyuseonly\">");
        out.println("<weight>1</weight>");
        out.println("</queue>");
        out.println("<queuePlacementPolicy>");
        out.println("<rule name=\"nestedUserQueue\">");
        out.println("     <rule name=\"specified\" create=\"false\" />");
        out.println("</rule>");
        out.println("<rule name=\"specified\" create=\"false\" />");
        out.println("<rule name=\"reject\" />");
        out.println("</queuePlacementPolicy>");
        out.println("<userMaxAppsDefault>20</userMaxAppsDefault>");
        out.println("<fairSharePreemptionTimeout>60</fairSharePreemptionTimeout>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        MockRMApp rmApp1 = new MockRMApp(0, 0L, RMAppState.NEW);
        String queueName = "adhoc";
        String username1 = "birvine";
        AppAddedSchedulerEvent appAddedEvent1 = new AppAddedSchedulerEvent(rmApp1.getApplicationId(), queueName, username1);
        this.scheduler.handle((SchedulerEvent)appAddedEvent1);
        QueueManager queueManager = this.scheduler.getQueueManager();
        FSLeafQueue user1Leaf = queueManager.getLeafQueue(queueName + "." + username1, false);
        Assert.assertEquals((Object)"root.adhoc.birvine", (Object)user1Leaf.getName());
        String usernameWithEmptySpace = "birvine ";
        MockRMApp rmApp2 = new MockRMApp(2, 0L, RMAppState.NEW);
        AppAddedSchedulerEvent appAddedEvent2 = new AppAddedSchedulerEvent(rmApp2.getApplicationId(), queueName, usernameWithEmptySpace);
        this.scheduler.handle((SchedulerEvent)appAddedEvent2);
        FSLeafQueue user2Leaf = queueManager.getLeafQueue(queueName + "." + usernameWithEmptySpace.trim(), false);
        Assert.assertEquals((Object)"root.adhoc.birvine", (Object)user2Leaf.getName());
    }

    @Test
    public void testQueueuNameWithPeriods() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        ApplicationAttemptId appAttemptId1 = this.createAppAttemptId(1, 1);
        AppAddedSchedulerEvent appAddedEvent1 = new AppAddedSchedulerEvent(appAttemptId1.getApplicationId(), ".A", "user1");
        this.scheduler.handle((SchedulerEvent)appAddedEvent1);
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        Assert.assertNull((Object)this.scheduler.getSchedulerApp(appAttemptId1));
        Assert.assertEquals((long)0L, (long)this.resourceManager.getRMContext().getRMApps().size());
        ApplicationAttemptId appAttemptId2 = this.createAppAttemptId(2, 1);
        AppAddedSchedulerEvent appAddedEvent2 = new AppAddedSchedulerEvent(appAttemptId2.getApplicationId(), "A.", "user1");
        this.scheduler.handle((SchedulerEvent)appAddedEvent2);
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        Assert.assertNull((Object)this.scheduler.getSchedulerApp(appAttemptId2));
        Assert.assertEquals((long)0L, (long)this.resourceManager.getRMContext().getRMApps().size());
        ApplicationAttemptId appAttemptId3 = this.createAppAttemptId(3, 1);
        AppAddedSchedulerEvent appAddedEvent3 = new AppAddedSchedulerEvent(appAttemptId3.getApplicationId(), "A.B", "user1");
        this.scheduler.handle((SchedulerEvent)appAddedEvent3);
        Assert.assertEquals((long)2L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        Assert.assertNull((Object)this.scheduler.getSchedulerApp(appAttemptId3));
        Assert.assertEquals((long)0L, (long)this.resourceManager.getRMContext().getRMApps().size());
    }

    @Test
    public void testAssignToQueue() throws Exception {
        this.conf.set("yarn.scheduler.fair.user-as-default-queue", "true");
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        MockRMApp rmApp1 = new MockRMApp(0, 0L, RMAppState.NEW);
        MockRMApp rmApp2 = new MockRMApp(1, 1L, RMAppState.NEW);
        FSLeafQueue queue1 = this.scheduler.assignToQueue((RMApp)rmApp1, "default", "asterix");
        FSLeafQueue queue2 = this.scheduler.assignToQueue((RMApp)rmApp2, "notdefault", "obelix");
        Assert.assertEquals((Object)rmApp1.getQueue(), (Object)queue1.getName());
        Assert.assertEquals((Object)"root.asterix", (Object)rmApp1.getQueue());
        Assert.assertEquals((Object)rmApp2.getQueue(), (Object)queue2.getName());
        Assert.assertEquals((Object)"root.notdefault", (Object)rmApp2.getQueue());
    }

    @Test
    public void testAssignToNonLeafQueueReturnsNull() throws Exception {
        this.conf.set("yarn.scheduler.fair.user-as-default-queue", "true");
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        this.scheduler.getQueueManager().getLeafQueue("root.child1.granchild", true);
        this.scheduler.getQueueManager().getLeafQueue("root.child2", true);
        MockRMApp rmApp1 = new MockRMApp(0, 0L, RMAppState.NEW);
        MockRMApp rmApp2 = new MockRMApp(1, 1L, RMAppState.NEW);
        Assert.assertNull((Object)this.scheduler.assignToQueue((RMApp)rmApp1, "root.child1", "tintin"));
        Assert.assertNotNull((Object)this.scheduler.assignToQueue((RMApp)rmApp2, "root.child2", "snowy"));
    }

    @Test
    public void testQueuePlacementWithPolicy() throws Exception {
        this.conf.setClass("hadoop.security.group.mapping", SimpleGroupsMapping.class, GroupMappingServiceProvider.class);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ArrayList<QueuePlacementRule> rules = new ArrayList<QueuePlacementRule>();
        rules.add(new QueuePlacementRule.Specified().initialize(true, null));
        rules.add(new QueuePlacementRule.User().initialize(false, null));
        rules.add(new QueuePlacementRule.PrimaryGroup().initialize(false, null));
        rules.add(new QueuePlacementRule.SecondaryGroupExistingQueue().initialize(false, null));
        rules.add(new QueuePlacementRule.Default().initialize(true, null));
        HashSet queues = Sets.newHashSet((Object[])new String[]{"root.user1", "root.user3group", "root.user4subgroup1", "root.user4subgroup2", "root.user5subgroup2"});
        HashMap configuredQueues = new HashMap();
        configuredQueues.put(FSQueueType.LEAF, queues);
        configuredQueues.put(FSQueueType.PARENT, new HashSet());
        this.scheduler.getAllocationConfiguration().placementPolicy = new QueuePlacementPolicy(rules, configuredQueues, this.conf);
        ApplicationAttemptId appId = this.createSchedulingRequest(1024, "somequeue", "user1");
        Assert.assertEquals((Object)"root.somequeue", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
        appId = this.createSchedulingRequest(1024, "default", "user1");
        Assert.assertEquals((Object)"root.user1", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
        appId = this.createSchedulingRequest(1024, "default", "user3");
        Assert.assertEquals((Object)"root.user3group", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
        appId = this.createSchedulingRequest(1024, "default", "user4");
        Assert.assertEquals((Object)"root.user4subgroup1", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
        appId = this.createSchedulingRequest(1024, "default", "user5");
        Assert.assertEquals((Object)"root.user5subgroup2", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
        appId = this.createSchedulingRequest(1024, "default", "otheruser");
        Assert.assertEquals((Object)"root.default", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
        rules = new ArrayList();
        rules.add(new QueuePlacementRule.User().initialize(false, null));
        rules.add(new QueuePlacementRule.Specified().initialize(true, null));
        rules.add(new QueuePlacementRule.Default().initialize(true, null));
        this.scheduler.getAllocationConfiguration().placementPolicy = new QueuePlacementPolicy(rules, configuredQueues, this.conf);
        appId = this.createSchedulingRequest(1024, "somequeue", "user1");
        Assert.assertEquals((Object)"root.user1", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
        appId = this.createSchedulingRequest(1024, "somequeue", "otheruser");
        Assert.assertEquals((Object)"root.somequeue", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
        appId = this.createSchedulingRequest(1024, "default", "otheruser");
        Assert.assertEquals((Object)"root.default", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
    }

    @Test
    public void testFairShareWithMinAlloc() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<minResources>1024mb,0vcores,0disks</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<minResources>2048mb,0vcores,0disks</minResources>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)3072), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(2048, "queueA", "user1");
        this.createSchedulingRequest(2048, "queueB", "user1");
        this.scheduler.update();
        Collection queues = this.scheduler.getQueueManager().getLeafQueues();
        Assert.assertEquals((long)3L, (long)queues.size());
        for (FSLeafQueue p : queues) {
            if (p.getName().equals("root.queueA")) {
                Assert.assertEquals((long)1024L, (long)p.getFairShare().getMemory());
                continue;
            }
            if (!p.getName().equals("root.queueB")) continue;
            Assert.assertEquals((long)2048L, (long)p.getFairShare().getMemory());
        }
    }

    @Test
    public void testNestedUserQueue() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.conf.setClass("hadoop.security.group.mapping", SimpleGroupsMapping.class, GroupMappingServiceProvider.class);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"user1group\" type=\"parent\">");
        out.println("<minResources>1024mb,0vcores,0disks</minResources>");
        out.println("</queue>");
        out.println("<queuePlacementPolicy>");
        out.println("<rule name=\"specified\" create=\"false\" />");
        out.println("<rule name=\"nestedUserQueue\">");
        out.println("     <rule name=\"primaryGroup\" create=\"false\" />");
        out.println("</rule>");
        out.println("<rule name=\"default\" />");
        out.println("</queuePlacementPolicy>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        MockRMApp rmApp1 = new MockRMApp(0, 0L, RMAppState.NEW);
        FSLeafQueue user1Leaf = this.scheduler.assignToQueue((RMApp)rmApp1, "root.default", "user1");
        Assert.assertEquals((Object)"root.user1group.user1", (Object)user1Leaf.getName());
    }

    @Test
    public void testFairShareAndWeightsInNestedUserQueueRule() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"parentq\" type=\"parent\">");
        out.println("<minResources>1024mb,0vcores,0disks</minResources>");
        out.println("</queue>");
        out.println("<queuePlacementPolicy>");
        out.println("<rule name=\"nestedUserQueue\">");
        out.println("     <rule name=\"specified\" create=\"false\" />");
        out.println("</rule>");
        out.println("<rule name=\"default\" />");
        out.println("</queuePlacementPolicy>");
        out.println("</allocations>");
        out.close();
        MockRMApp rmApp1 = new MockRMApp(0, 0L, RMAppState.NEW);
        MockRMApp rmApp2 = new MockRMApp(1, 1L, RMAppState.NEW);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        int capacity = 16384;
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)capacity), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(10240, "root.parentq", "user1");
        this.createSchedulingRequest(10240, "root.parentq", "user2");
        this.createSchedulingRequest(10240, "root.default", "user3");
        this.scheduler.update();
        this.scheduler.getQueueManager().getRootQueue().setSteadyFairShare(this.scheduler.getClusterResource());
        this.scheduler.getQueueManager().getRootQueue().recomputeSteadyShares();
        Collection leafQueues = this.scheduler.getQueueManager().getLeafQueues();
        for (FSLeafQueue leaf : leafQueues) {
            if (!leaf.getName().equals("root.parentq.user1") && !leaf.getName().equals("root.parentq.user2")) continue;
            Assert.assertEquals((long)(capacity / 4), (long)leaf.getFairShare().getMemory());
            Assert.assertEquals((long)(capacity / 4), (long)leaf.getSteadyFairShare().getMemory());
            Assert.assertEquals((double)1.0, (double)leaf.getWeights().getWeight(ResourceType.MEMORY), (double)0.0);
        }
    }

    @Test
    public void testSteadyFairShareWithReloadAndNodeAddRemove() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<defaultQueueSchedulingPolicy>fair</defaultQueueSchedulingPolicy>");
        out.println("<queue name=\"root\">");
        out.println("  <schedulingPolicy>drf</schedulingPolicy>");
        out.println("  <queue name=\"child1\">");
        out.println("    <weight>1</weight>");
        out.println("  </queue>");
        out.println("  <queue name=\"child2\">");
        out.println("    <weight>1</weight>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueManager = this.scheduler.getQueueManager();
        Assert.assertEquals((long)0L, (long)queueManager.getLeafQueue("child1", false).getSteadyFairShare().getMemory());
        Assert.assertEquals((long)0L, (long)queueManager.getLeafQueue("child2", false).getSteadyFairShare().getMemory());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)6144), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        Assert.assertEquals((long)6144L, (long)this.scheduler.getClusterResource().getMemory());
        Assert.assertEquals((long)2048L, (long)queueManager.getLeafQueue("child1", false).getSteadyFairShare().getMemory());
        Assert.assertEquals((long)2048L, (long)queueManager.getLeafQueue("child2", false).getSteadyFairShare().getMemory());
        out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<defaultQueueSchedulingPolicy>fair</defaultQueueSchedulingPolicy>");
        out.println("<queue name=\"root\">");
        out.println("  <schedulingPolicy>drf</schedulingPolicy>");
        out.println("  <queue name=\"child1\">");
        out.println("    <weight>1</weight>");
        out.println("  </queue>");
        out.println("  <queue name=\"child2\">");
        out.println("    <weight>2</weight>");
        out.println("  </queue>");
        out.println("  <queue name=\"child3\">");
        out.println("    <weight>2</weight>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        Assert.assertEquals((long)1024L, (long)queueManager.getLeafQueue("child1", false).getSteadyFairShare().getMemory());
        Assert.assertEquals((long)2048L, (long)queueManager.getLeafQueue("child2", false).getSteadyFairShare().getMemory());
        Assert.assertEquals((long)2048L, (long)queueManager.getLeafQueue("child3", false).getSteadyFairShare().getMemory());
        NodeRemovedSchedulerEvent nodeEvent2 = new NodeRemovedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        Assert.assertEquals((long)0L, (long)this.scheduler.getClusterResource().getMemory());
        Assert.assertEquals((long)0L, (long)queueManager.getLeafQueue("child1", false).getSteadyFairShare().getMemory());
        Assert.assertEquals((long)0L, (long)queueManager.getLeafQueue("child2", false).getSteadyFairShare().getMemory());
    }

    @Test
    public void testSteadyFairShareWithQueueCreatedRuntime() throws Exception {
        this.conf.setClass("hadoop.security.group.mapping", SimpleGroupsMapping.class, GroupMappingServiceProvider.class);
        this.conf.set("yarn.scheduler.fair.user-as-default-queue", "true");
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)6144), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        Assert.assertEquals((long)6144L, (long)this.scheduler.getClusterResource().getMemory());
        Assert.assertEquals((long)6144L, (long)this.scheduler.getQueueManager().getRootQueue().getSteadyFairShare().getMemory());
        Assert.assertEquals((long)6144L, (long)this.scheduler.getQueueManager().getLeafQueue("default", false).getSteadyFairShare().getMemory());
        ApplicationAttemptId appAttemptId1 = this.createAppAttemptId(1, 1);
        this.createApplicationWithAMResource(appAttemptId1, "default", "user1", null);
        Assert.assertEquals((long)3072L, (long)this.scheduler.getQueueManager().getLeafQueue("default", false).getSteadyFairShare().getMemory());
        Assert.assertEquals((long)3072L, (long)this.scheduler.getQueueManager().getLeafQueue("user1", false).getSteadyFairShare().getMemory());
    }

    @Test
    public void testQueueDemandCalculation() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        int minReqSize = 1024;
        ApplicationAttemptId id11 = this.createAppAttemptId(1, 1);
        this.createMockRMApp(id11);
        this.scheduler.addApplication(id11.getApplicationId(), "root.queue1", "user1", false);
        this.scheduler.addApplicationAttempt(id11, false, false);
        ArrayList<ResourceRequest> ask1 = new ArrayList<ResourceRequest>();
        ResourceRequest request1 = this.createResourceRequest(minReqSize * 2, "*", 1, 1, true);
        ask1.add(request1);
        this.scheduler.allocate(id11, ask1, new ArrayList(), null, null);
        ApplicationAttemptId id21 = this.createAppAttemptId(2, 1);
        this.createMockRMApp(id21);
        this.scheduler.addApplication(id21.getApplicationId(), "root.queue2", "user1", false);
        this.scheduler.addApplicationAttempt(id21, false, false);
        ArrayList<ResourceRequest> ask2 = new ArrayList<ResourceRequest>();
        ResourceRequest request2 = this.createResourceRequest(2 * minReqSize, "foo", 1, 1, false);
        ResourceRequest request3 = this.createResourceRequest(minReqSize, "*", 1, 2, false);
        ask2.add(request2);
        ask2.add(request3);
        this.scheduler.allocate(id21, ask2, new ArrayList(), null, null);
        ApplicationAttemptId id22 = this.createAppAttemptId(2, 2);
        this.createMockRMApp(id22);
        this.scheduler.addApplication(id22.getApplicationId(), "root.queue2", "user1", false);
        this.scheduler.addApplicationAttempt(id22, false, false);
        ArrayList<ResourceRequest> ask3 = new ArrayList<ResourceRequest>();
        ResourceRequest request4 = this.createResourceRequest(2 * minReqSize, "*", 1, 1, true);
        ask3.add(request4);
        this.scheduler.allocate(id22, ask3, new ArrayList(), null, null);
        this.scheduler.update();
        Assert.assertEquals((long)(2 * minReqSize), (long)this.scheduler.getQueueManager().getQueue("root.queue1").getDemand().getMemory());
        Assert.assertEquals((long)(2 * minReqSize + 2 * minReqSize + 2 * minReqSize), (long)this.scheduler.getQueueManager().getQueue("root.queue2").getDemand().getMemory());
    }

    @Test
    public void testAppAdditionAndRemoval() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ApplicationAttemptId attemptId = this.createAppAttemptId(1, 1);
        AppAddedSchedulerEvent appAddedEvent = new AppAddedSchedulerEvent(attemptId.getApplicationId(), "default", "user1");
        this.scheduler.handle((SchedulerEvent)appAddedEvent);
        AppAttemptAddedSchedulerEvent attemptAddedEvent = new AppAttemptAddedSchedulerEvent(this.createAppAttemptId(1, 1), false);
        this.scheduler.handle((SchedulerEvent)attemptAddedEvent);
        Assert.assertEquals((long)2L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueue("user1", true).getNumRunnableApps());
        AppAttemptRemovedSchedulerEvent appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(this.createAppAttemptId(1, 1), RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent1);
        Assert.assertEquals((long)0L, (long)this.scheduler.getQueueManager().getLeafQueue("user1", true).getNumRunnableApps());
    }

    @Test
    public void testHierarchicalQueueAllocationFileParsing() throws IOException, SAXException, AllocationConfigurationException, ParserConfigurationException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<minResources>2048mb,0vcores,0disks</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<minResources>2048mb,0vcores,0disks</minResources>");
        out.println("<queue name=\"queueC\">");
        out.println("<minResources>2048mb,0vcores,0disks</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueD\">");
        out.println("<minResources>2048mb,0vcores,0disks</minResources>");
        out.println("</queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueManager = this.scheduler.getQueueManager();
        Collection leafQueues = queueManager.getLeafQueues();
        Assert.assertEquals((long)4L, (long)leafQueues.size());
        Assert.assertNotNull((Object)queueManager.getLeafQueue("queueA", false));
        Assert.assertNotNull((Object)queueManager.getLeafQueue("queueB.queueC", false));
        Assert.assertNotNull((Object)queueManager.getLeafQueue("queueB.queueD", false));
        Assert.assertNotNull((Object)queueManager.getLeafQueue("default", false));
        Assert.assertEquals((long)4L, (long)leafQueues.size());
    }

    @Test
    public void testConfigureRootQueue() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<defaultQueueSchedulingPolicy>fair</defaultQueueSchedulingPolicy>");
        out.println("<queue name=\"root\">");
        out.println("  <schedulingPolicy>drf</schedulingPolicy>");
        out.println("  <queue name=\"child1\">");
        out.println("    <minResources>1024mb,1vcores,0disks</minResources>");
        out.println("  </queue>");
        out.println("  <queue name=\"child2\">");
        out.println("    <minResources>1024mb,4vcores,0disks</minResources>");
        out.println("  </queue>");
        out.println("  <fairSharePreemptionTimeout>100</fairSharePreemptionTimeout>");
        out.println("  <minSharePreemptionTimeout>120</minSharePreemptionTimeout>");
        out.println("  <fairSharePreemptionThreshold>.5</fairSharePreemptionThreshold>");
        out.println("</queue>");
        out.println("<defaultFairSharePreemptionTimeout>300</defaultFairSharePreemptionTimeout>");
        out.println("<defaultMinSharePreemptionTimeout>200</defaultMinSharePreemptionTimeout>");
        out.println("<defaultFairSharePreemptionThreshold>.6</defaultFairSharePreemptionThreshold>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueManager = this.scheduler.getQueueManager();
        FSParentQueue root = queueManager.getRootQueue();
        Assert.assertTrue((boolean)(root.getPolicy() instanceof DominantResourceFairnessPolicy));
        Assert.assertNotNull((Object)queueManager.getLeafQueue("child1", false));
        Assert.assertNotNull((Object)queueManager.getLeafQueue("child2", false));
        Assert.assertEquals((long)100000L, (long)root.getFairSharePreemptionTimeout());
        Assert.assertEquals((long)120000L, (long)root.getMinSharePreemptionTimeout());
        Assert.assertEquals((double)0.5, (double)root.getFairSharePreemptionThreshold(), (double)0.01);
    }

    @Test(timeout=5000L)
    public void tesPreemptionOnBlacklistedNodes() throws Exception {
        this.conf.setLong("yarn.scheduler.fair.preemptionInterval", 5000L);
        this.conf.setLong("yarn.scheduler.fair.waitTimeBeforeKill", 10000L);
        this.conf.set("yarn.scheduler.fair.allocation.file.allocation.file", ALLOC_FILE);
        this.conf.set("yarn.scheduler.fair.user-as-default-queue", "false");
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024, (int)1), 1, STATIC_HOST);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024, (int)1), 2, "127.0.0.2");
        this.scheduler.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node1));
        this.scheduler.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node2));
        ApplicationAttemptId appAttemptId1 = this.createSchedulingRequest(1024, 1, "queueA", "user1", 2, 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent nodeUpdate1 = new NodeUpdateSchedulerEvent(node1);
        NodeUpdateSchedulerEvent nodeUpdate2 = new NodeUpdateSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeUpdate1);
        this.scheduler.handle((SchedulerEvent)nodeUpdate2);
        Assert.assertEquals((long)2L, (long)this.scheduler.getSchedulerApp(appAttemptId1).getLiveContainers().size());
        ApplicationAttemptId appAttemptId2 = this.createSchedulingRequest(1024, 1, "queueB", "user1", 2, 1);
        this.scheduler.update();
        this.addNodeToBlackListForApp(node1, appAttemptId1);
        this.addNodeToBlackListForApp(node2, appAttemptId1);
        this.scheduler.update();
        HashMap<FSAppAttempt, Resource> toPreempt = new HashMap<FSAppAttempt, Resource>();
        FSAppAttempt appAttempt1 = this.scheduler.getSchedulerApp(appAttemptId1);
        toPreempt.put(appAttempt1, Resources.createResource((int)1024));
        this.scheduler.preemptResources(toPreempt);
        Assert.assertTrue((String)"App1 shouldn't have container to be preempted", (boolean)Collections.disjoint(this.scheduler.getSchedulerApp(appAttemptId1).getLiveContainers(), this.scheduler.getSchedulerApp(appAttemptId1).getPreemptionContainers()));
    }

    private void addNodeToBlackListForApp(RMNode node, ApplicationAttemptId id) {
        FSAppAttempt appAttempt1 = this.scheduler.getSchedulerApp(id);
        this.scheduler.allocate(id, Collections.emptyList(), Collections.emptyList(), Collections.singletonList(node.getHostName()), null);
        Assert.assertTrue((boolean)appAttempt1.isBlacklisted(node.getHostName()));
    }

    @Test
    public void testResourceUsageByMoveApp() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024, (int)4), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId appAttId = this.createSchedulingRequest(1024, 2, "parent1.queue1", "user1", 2);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        QueueManager queueMgr = this.scheduler.getQueueManager();
        FSParentQueue parent1 = queueMgr.getParentQueue("parent1", true);
        FSParentQueue parent2 = queueMgr.getParentQueue("parent2", true);
        FSLeafQueue queue2 = queueMgr.getLeafQueue("parent2.queue2", true);
        FSLeafQueue queue1 = queueMgr.getLeafQueue("parent1.queue1", true);
        Assert.assertEquals((long)parent2.getResourceUsage().getMemory(), (long)0L);
        Assert.assertEquals((long)queue2.getResourceUsage().getMemory(), (long)0L);
        Assert.assertEquals((long)parent1.getResourceUsage().getMemory(), (long)1024L);
        Assert.assertEquals((long)queue1.getResourceUsage().getMemory(), (long)1024L);
        this.scheduler.moveApplication(appAttId.getApplicationId(), "parent2.queue2");
        Assert.assertEquals((long)parent2.getResourceUsage().getMemory(), (long)1024L);
        Assert.assertEquals((long)queue2.getResourceUsage().getMemory(), (long)1024L);
        Assert.assertEquals((long)parent1.getResourceUsage().getMemory(), (long)0L);
        Assert.assertEquals((long)queue1.getResourceUsage().getMemory(), (long)0L);
    }

    @Test
    public void testRemovingContainersFromPreemptMapping() throws Exception {
        this.conf.setLong("yarn.scheduler.fair.preemptionInterval", 5000L);
        this.conf.setLong("yarn.scheduler.fair.waitTimeBeforeKill", 10000L);
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.conf.set("yarn.scheduler.fair.user-as-default-queue", "false");
        ControlledClock clock = new ControlledClock();
        this.scheduler.setClock((Clock)clock);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<weight>8</weight>");
        out.println("<queue name=\"queueA1\" />");
        out.println("<queue name=\"queueA2\" />");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<weight>2</weight>");
        out.println("</queue>");
        out.println("<defaultFairSharePreemptionTimeout>10</defaultFairSharePreemptionTimeout>");
        out.println("<defaultFairSharePreemptionThreshold>.5</defaultFairSharePreemptionThreshold>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId app1 = this.createSchedulingRequest(1024, 1, "queueA.queueA1", "user1", 7, 1);
        ApplicationAttemptId app2 = this.createSchedulingRequest(1024, 1, "queueB", "user2", 1, 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent nodeUpdate1 = new NodeUpdateSchedulerEvent(node1);
        for (int i = 0; i < 8; ++i) {
            this.scheduler.handle((SchedulerEvent)nodeUpdate1);
        }
        Assert.assertEquals((long)7L, (long)this.scheduler.getSchedulerApp(app1).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(app2).getLiveContainers().size());
        ApplicationAttemptId app3 = this.createSchedulingRequest(1024, 1, "queueA.queueA2", "user3", 7, 1);
        this.scheduler.update();
        clock.tickSec(11);
        this.scheduler.update();
        Map toPreempt = this.scheduler.resToPreempt(this.scheduler.getQueueManager().getLeafQueue("queueA.queueA2", false), clock.getTime());
        this.scheduler.preemptResources(toPreempt);
        Field preemptMappingField = this.scheduler.getClass().getDeclaredField("preemptMapping");
        preemptMappingField.setAccessible(true);
        Map preemptMapping = (Map)preemptMappingField.get(this.scheduler);
        Field warnedContainersField = this.scheduler.getClass().getDeclaredField("warnedContainers");
        warnedContainersField.setAccessible(true);
        List warnedContainers = (List)warnedContainersField.get(this.scheduler);
        Assert.assertTrue((preemptMapping.keySet().size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"preemptMapping should contains all containers from warnedContainers list", (boolean)preemptMapping.keySet().containsAll(warnedContainers));
        clock.tickSec(11);
        this.scheduler.update();
        toPreempt = this.scheduler.resToPreempt(this.scheduler.getQueueManager().getLeafQueue("queueA.queueA2", false), clock.getTime());
        Set preemptionContainers = this.scheduler.getSchedulerApp(app1).getPreemptionContainers();
        HashSet preemptionContainersCopy = new HashSet(preemptionContainers);
        for (RMContainer container : preemptionContainersCopy) {
            this.scheduler.completedContainer(container, SchedulerUtils.createPreemptedContainerStatus((ContainerId)container.getContainerId(), (String)"Container preempted by scheduler"), RMContainerEventType.KILL);
        }
        this.scheduler.preemptResources(toPreempt);
        Assert.assertTrue((String)"Containers should be removed from preemptMapping as well as from warnedContainers", (preemptMapping.size() == 0 ? 1 : 0) != 0);
    }

    @Test(timeout=5000L)
    public void testPreemptionDecision() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        ControlledClock clock = new ControlledClock();
        this.scheduler.setClock((Clock)clock);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"default\">");
        out.println("<maxResources>0mb,0vcores,0disks</maxResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueA\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,0vcores,0disks</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,0vcores,0disks</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueC\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,0vcores,0disks</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueD\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,0vcores,0disks</minResources>");
        out.println("</queue>");
        out.println("<defaultMinSharePreemptionTimeout>5</defaultMinSharePreemptionTimeout>");
        out.println("<defaultFairSharePreemptionTimeout>10</defaultFairSharePreemptionTimeout>");
        out.println("<defaultFairSharePreemptionThreshold>.5</defaultFairSharePreemptionThreshold>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)2048, (int)2), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)2048, (int)2), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        RMNode node3 = MockNodes.newNodeInfo(1, Resources.createResource((int)2048, (int)2), 3, "127.0.0.3");
        NodeAddedSchedulerEvent nodeEvent3 = new NodeAddedSchedulerEvent(node3);
        this.scheduler.handle((SchedulerEvent)nodeEvent3);
        ApplicationAttemptId app1 = this.createSchedulingRequest(1024, "queueA", "user1", 1, 1);
        ApplicationAttemptId app2 = this.createSchedulingRequest(1024, "queueA", "user1", 1, 2);
        ApplicationAttemptId app3 = this.createSchedulingRequest(1024, "queueA", "user1", 1, 3);
        ApplicationAttemptId app4 = this.createSchedulingRequest(1024, "queueB", "user1", 1, 1);
        ApplicationAttemptId app5 = this.createSchedulingRequest(1024, "queueB", "user1", 1, 2);
        ApplicationAttemptId app6 = this.createSchedulingRequest(1024, "queueB", "user1", 1, 3);
        this.scheduler.update();
        for (int i = 0; i < 2; ++i) {
            NodeUpdateSchedulerEvent nodeUpdate1 = new NodeUpdateSchedulerEvent(node1);
            this.scheduler.handle((SchedulerEvent)nodeUpdate1);
            NodeUpdateSchedulerEvent nodeUpdate2 = new NodeUpdateSchedulerEvent(node2);
            this.scheduler.handle((SchedulerEvent)nodeUpdate2);
            NodeUpdateSchedulerEvent nodeUpdate3 = new NodeUpdateSchedulerEvent(node3);
            this.scheduler.handle((SchedulerEvent)nodeUpdate3);
        }
        ApplicationAttemptId app7 = this.createSchedulingRequest(1024, "queueC", "user1", 1, 1);
        ApplicationAttemptId app8 = this.createSchedulingRequest(1024, "queueC", "user1", 1, 2);
        ApplicationAttemptId app9 = this.createSchedulingRequest(1024, "queueC", "user1", 1, 3);
        ApplicationAttemptId app10 = this.createSchedulingRequest(1024, "queueD", "user1", 1, 1);
        ApplicationAttemptId app11 = this.createSchedulingRequest(1024, "queueD", "user1", 1, 2);
        ApplicationAttemptId app12 = this.createSchedulingRequest(1024, "queueD", "user1", 1, 3);
        this.scheduler.update();
        FSLeafQueue schedC = this.scheduler.getQueueManager().getLeafQueue("queueC", true);
        FSLeafQueue schedD = this.scheduler.getQueueManager().getLeafQueue("queueD", true);
        Assert.assertTrue((boolean)Resources.equals((Resource)Resources.none(), (Resource)this.computeTotalResource(this.scheduler.resToPreempt(schedC, clock.getTime()))));
        Assert.assertTrue((boolean)Resources.equals((Resource)Resources.none(), (Resource)this.computeTotalResource(this.scheduler.resToPreempt(schedD, clock.getTime()))));
        clock.tickSec(6);
        Assert.assertEquals((long)1024L, (long)this.computeTotalResource(this.scheduler.resToPreempt(schedC, clock.getTime())).getMemory());
        Assert.assertEquals((long)1024L, (long)this.computeTotalResource(this.scheduler.resToPreempt(schedD, clock.getTime())).getMemory());
        this.scheduler.update();
        clock.tickSec(6);
        Assert.assertEquals((long)1536L, (long)this.computeTotalResource(this.scheduler.resToPreempt(schedC, clock.getTime())).getMemory());
        Assert.assertEquals((long)1536L, (long)this.computeTotalResource(this.scheduler.resToPreempt(schedD, clock.getTime())).getMemory());
    }

    @Test
    public void testPreemptionDecisionWithVariousTimeout() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        ControlledClock clock = new ControlledClock();
        this.scheduler.setClock((Clock)clock);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"default\">");
        out.println("<maxResources>0mb,0vcores,0disks</maxResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueA\">");
        out.println("<weight>1</weight>");
        out.println("<minResources>1024mb,0vcores,0disks</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<weight>2</weight>");
        out.println("<minSharePreemptionTimeout>10</minSharePreemptionTimeout>");
        out.println("<fairSharePreemptionTimeout>25</fairSharePreemptionTimeout>");
        out.println("<queue name=\"queueB1\">");
        out.println("<minResources>1024mb,0vcores,0disks</minResources>");
        out.println("<minSharePreemptionTimeout>5</minSharePreemptionTimeout>");
        out.println("</queue>");
        out.println("<queue name=\"queueB2\">");
        out.println("<minResources>1024mb,0vcores,0disks</minResources>");
        out.println("<fairSharePreemptionTimeout>20</fairSharePreemptionTimeout>");
        out.println("</queue>");
        out.println("</queue>");
        out.println("<queue name=\"queueC\">");
        out.println("<weight>1</weight>");
        out.println("<minResources>1024mb,0vcores,0disks</minResources>");
        out.println("</queue>");
        out.print("<defaultMinSharePreemptionTimeout>15</defaultMinSharePreemptionTimeout>");
        out.print("<defaultFairSharePreemptionTimeout>30</defaultFairSharePreemptionTimeout>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueMgr = this.scheduler.getQueueManager();
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("root").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("default").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("queueA").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)25000L, (long)queueMgr.getQueue("queueB").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)25000L, (long)queueMgr.getQueue("queueB.queueB1").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)20000L, (long)queueMgr.getQueue("queueB.queueB2").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("queueC").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("root").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("default").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("queueA").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)10000L, (long)queueMgr.getQueue("queueB").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)5000L, (long)queueMgr.getQueue("queueB.queueB1").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)10000L, (long)queueMgr.getQueue("queueB.queueB2").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("queueC").getMinSharePreemptionTimeout());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)6144, (int)6), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        for (int i = 0; i < 6; ++i) {
            this.createSchedulingRequest(1024, "queueA", "user1", 1, 1);
        }
        this.scheduler.update();
        NodeUpdateSchedulerEvent nodeUpdate1 = new NodeUpdateSchedulerEvent(node1);
        for (int i = 0; i < 6; ++i) {
            this.scheduler.handle((SchedulerEvent)nodeUpdate1);
        }
        this.createSchedulingRequest(1024, "queueB.queueB1", "user1", 1, 1);
        this.createSchedulingRequest(1024, "queueB.queueB1", "user1", 1, 2);
        this.createSchedulingRequest(1024, "queueB.queueB1", "user1", 1, 3);
        this.createSchedulingRequest(1024, "queueB.queueB2", "user1", 1, 1);
        this.createSchedulingRequest(1024, "queueB.queueB2", "user1", 1, 2);
        this.createSchedulingRequest(1024, "queueB.queueB2", "user1", 1, 3);
        this.createSchedulingRequest(1024, "queueC", "user1", 1, 1);
        this.createSchedulingRequest(1024, "queueC", "user1", 1, 2);
        this.createSchedulingRequest(1024, "queueC", "user1", 1, 3);
        this.scheduler.update();
        FSLeafQueue queueB1 = queueMgr.getLeafQueue("queueB.queueB1", true);
        FSLeafQueue queueB2 = queueMgr.getLeafQueue("queueB.queueB2", true);
        FSLeafQueue queueC = queueMgr.getLeafQueue("queueC", true);
        Assert.assertTrue((boolean)Resources.equals((Resource)Resources.none(), (Resource)this.computeTotalResource(this.scheduler.resToPreempt(queueB1, clock.getTime()))));
        Assert.assertTrue((boolean)Resources.equals((Resource)Resources.none(), (Resource)this.computeTotalResource(this.scheduler.resToPreempt(queueB2, clock.getTime()))));
        Assert.assertTrue((boolean)Resources.equals((Resource)Resources.none(), (Resource)this.computeTotalResource(this.scheduler.resToPreempt(queueC, clock.getTime()))));
        this.scheduler.update();
        clock.tickSec(6);
        Assert.assertEquals((long)1024L, (long)this.computeTotalResource(this.scheduler.resToPreempt(queueB1, clock.getTime())).getMemory());
        Assert.assertEquals((long)0L, (long)this.computeTotalResource(this.scheduler.resToPreempt(queueB2, clock.getTime())).getMemory());
        Assert.assertEquals((long)0L, (long)this.computeTotalResource(this.scheduler.resToPreempt(queueC, clock.getTime())).getMemory());
        this.scheduler.update();
        clock.tickSec(5);
        Assert.assertEquals((long)1024L, (long)this.computeTotalResource(this.scheduler.resToPreempt(queueB1, clock.getTime())).getMemory());
        Assert.assertEquals((long)1024L, (long)this.computeTotalResource(this.scheduler.resToPreempt(queueB2, clock.getTime())).getMemory());
        Assert.assertEquals((long)0L, (long)this.computeTotalResource(this.scheduler.resToPreempt(queueC, clock.getTime())).getMemory());
        this.scheduler.update();
        clock.tickSec(5);
        Assert.assertEquals((long)1024L, (long)this.computeTotalResource(this.scheduler.resToPreempt(queueB1, clock.getTime())).getMemory());
        Assert.assertEquals((long)1024L, (long)this.computeTotalResource(this.scheduler.resToPreempt(queueB2, clock.getTime())).getMemory());
        Assert.assertEquals((long)1024L, (long)this.computeTotalResource(this.scheduler.resToPreempt(queueC, clock.getTime())).getMemory());
        this.scheduler.update();
        clock.tickSec(5);
        Assert.assertEquals((long)1024L, (long)this.computeTotalResource(this.scheduler.resToPreempt(queueB1, clock.getTime())).getMemory());
        Assert.assertEquals((long)1536L, (long)this.computeTotalResource(this.scheduler.resToPreempt(queueB2, clock.getTime())).getMemory());
        Assert.assertEquals((long)1024L, (long)this.computeTotalResource(this.scheduler.resToPreempt(queueC, clock.getTime())).getMemory());
        this.scheduler.update();
        clock.tickSec(5);
        Assert.assertEquals((long)1536L, (long)this.computeTotalResource(this.scheduler.resToPreempt(queueB1, clock.getTime())).getMemory());
        Assert.assertEquals((long)1536L, (long)this.computeTotalResource(this.scheduler.resToPreempt(queueB2, clock.getTime())).getMemory());
        Assert.assertEquals((long)1024L, (long)this.computeTotalResource(this.scheduler.resToPreempt(queueC, clock.getTime())).getMemory());
        this.scheduler.update();
        clock.tickSec(5);
        Assert.assertEquals((long)1536L, (long)this.computeTotalResource(this.scheduler.resToPreempt(queueB1, clock.getTime())).getMemory());
        Assert.assertEquals((long)1536L, (long)this.computeTotalResource(this.scheduler.resToPreempt(queueB2, clock.getTime())).getMemory());
        Assert.assertEquals((long)1536L, (long)this.computeTotalResource(this.scheduler.resToPreempt(queueC, clock.getTime())).getMemory());
    }

    @Test
    public void testBackwardsCompatiblePreemptionConfiguration() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"default\">");
        out.println("</queue>");
        out.println("<queue name=\"queueA\">");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<queue name=\"queueB1\">");
        out.println("<minSharePreemptionTimeout>5</minSharePreemptionTimeout>");
        out.println("</queue>");
        out.println("<queue name=\"queueB2\">");
        out.println("</queue>");
        out.println("</queue>");
        out.println("<queue name=\"queueC\">");
        out.println("</queue>");
        out.print("<defaultMinSharePreemptionTimeout>15</defaultMinSharePreemptionTimeout>");
        out.print("<defaultFairSharePreemptionTimeout>30</defaultFairSharePreemptionTimeout>");
        out.print("<fairSharePreemptionTimeout>40</fairSharePreemptionTimeout>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueMgr = this.scheduler.getQueueManager();
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("root").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("default").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("queueA").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("queueB").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("queueB.queueB1").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("queueB.queueB2").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("queueC").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("root").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("default").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("queueA").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("queueB").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)5000L, (long)queueMgr.getQueue("queueB.queueB1").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("queueB.queueB2").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("queueC").getMinSharePreemptionTimeout());
        out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"default\">");
        out.println("</queue>");
        out.println("<queue name=\"queueA\">");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<queue name=\"queueB1\">");
        out.println("<minSharePreemptionTimeout>5</minSharePreemptionTimeout>");
        out.println("</queue>");
        out.println("<queue name=\"queueB2\">");
        out.println("</queue>");
        out.println("</queue>");
        out.println("<queue name=\"queueC\">");
        out.println("</queue>");
        out.print("<defaultMinSharePreemptionTimeout>15</defaultMinSharePreemptionTimeout>");
        out.print("<defaultFairSharePreemptionTimeout>25</defaultFairSharePreemptionTimeout>");
        out.print("<fairSharePreemptionTimeout>30</fairSharePreemptionTimeout>");
        out.println("</allocations>");
        out.close();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        Assert.assertEquals((long)25000L, (long)queueMgr.getQueue("root").getFairSharePreemptionTimeout());
    }

    @Test
    public void testPreemptionVariablesForQueueCreatedRuntime() throws Exception {
        this.conf.set("yarn.scheduler.fair.user-as-default-queue", "true");
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        FSParentQueue root = this.scheduler.getQueueManager().getRootQueue();
        root.setMinSharePreemptionTimeout(10000L);
        root.setFairSharePreemptionTimeout(15000L);
        root.setFairSharePreemptionThreshold(0.6f);
        ApplicationAttemptId appAttemptId = this.createAppAttemptId(1, 1);
        this.createApplicationWithAMResource(appAttemptId, "default", "user1", null);
        FSLeafQueue userQueue = this.scheduler.getQueueManager().getLeafQueue("user1", true);
        Assert.assertEquals((long)1L, (long)userQueue.getNumRunnableApps());
        Assert.assertEquals((long)10000L, (long)userQueue.getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)userQueue.getFairSharePreemptionTimeout());
        Assert.assertEquals((double)0.6f, (double)userQueue.getFairSharePreemptionThreshold(), (double)0.001);
    }

    private Resource computeTotalResource(Map<FSAppAttempt, Resource> resToPreempt) {
        Resource totalResource = Resources.createResource((int)0);
        for (Resource resource : resToPreempt.values()) {
            totalResource = Resources.add((Resource)totalResource, (Resource)resource);
        }
        return totalResource;
    }

    @Test(timeout=5000L)
    public void testMultipleContainersWaitingForReservation() throws IOException {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue2", "user2", 1);
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue3", "user3", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getSchedulerApp(attId1).getCurrentReservation().getMemory());
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId2).getCurrentReservation().getMemory());
    }

    @Test(timeout=5000L)
    public void testUserMaxRunningApps() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<user name=\"user1\">");
        out.println("<maxRunningApps>1</maxRunningApps>");
        out.println("</user>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attId1).getLiveContainers().size());
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId2).getLiveContainers().size());
        this.createSchedulingRequestExistingApplication(1024, 1, attId1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2L, (long)this.scheduler.getSchedulerApp(attId1).getLiveContainers().size());
    }

    @Test(timeout=5000L)
    public void testIncreaseQueueMaxRunningAppsOnTheFly() throws Exception {
        String allocBefore = "<?xml version=\"1.0\"?><allocations><queue name=\"root\"><queue name=\"queue1\"><maxRunningApps>1</maxRunningApps></queue></queue></allocations>";
        String allocAfter = "<?xml version=\"1.0\"?><allocations><queue name=\"root\"><queue name=\"queue1\"><maxRunningApps>3</maxRunningApps></queue></queue></allocations>";
        this.testIncreaseQueueSettingOnTheFlyInternal(allocBefore, allocAfter);
    }

    @Test(timeout=5000L)
    public void testIncreaseUserMaxRunningAppsOnTheFly() throws Exception {
        String allocBefore = "<?xml version=\"1.0\"?><allocations><queue name=\"root\"><queue name=\"queue1\"><maxRunningApps>10</maxRunningApps></queue></queue><user name=\"user1\"><maxRunningApps>1</maxRunningApps></user></allocations>";
        String allocAfter = "<?xml version=\"1.0\"?><allocations><queue name=\"root\"><queue name=\"queue1\"><maxRunningApps>10</maxRunningApps></queue></queue><user name=\"user1\"><maxRunningApps>3</maxRunningApps></user></allocations>";
        this.testIncreaseQueueSettingOnTheFlyInternal(allocBefore, allocAfter);
    }

    private void testIncreaseQueueSettingOnTheFlyInternal(String allocBefore, String allocAfter) throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println(allocBefore);
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attId1).getLiveContainers().size());
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        ApplicationAttemptId attId3 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        ApplicationAttemptId attId4 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId2).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId3).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId4).getLiveContainers().size());
        out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println(allocAfter);
        out.close();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attId2).getLiveContainers().size());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attId3).getLiveContainers().size());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId4).getLiveContainers().size());
        AppAttemptRemovedSchedulerEvent appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(attId1, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attId4).getLiveContainers().size());
    }

    @Test(timeout=5000L)
    public void testDecreaseQueueMaxRunningAppsOnTheFly() throws Exception {
        String allocBefore = "<?xml version=\"1.0\"?><allocations><queue name=\"root\"><queue name=\"queue1\"><maxRunningApps>3</maxRunningApps></queue></queue></allocations>";
        String allocAfter = "<?xml version=\"1.0\"?><allocations><queue name=\"root\"><queue name=\"queue1\"><maxRunningApps>1</maxRunningApps></queue></queue></allocations>";
        this.testDecreaseQueueSettingOnTheFlyInternal(allocBefore, allocAfter);
    }

    @Test(timeout=5000L)
    public void testDecreaseUserMaxRunningAppsOnTheFly() throws Exception {
        String allocBefore = "<?xml version=\"1.0\"?><allocations><queue name=\"root\"><queue name=\"queue1\"><maxRunningApps>10</maxRunningApps></queue></queue><user name=\"user1\"><maxRunningApps>3</maxRunningApps></user></allocations>";
        String allocAfter = "<?xml version=\"1.0\"?><allocations><queue name=\"root\"><queue name=\"queue1\"><maxRunningApps>10</maxRunningApps></queue></queue><user name=\"user1\"><maxRunningApps>1</maxRunningApps></user></allocations>";
        this.testDecreaseQueueSettingOnTheFlyInternal(allocBefore, allocAfter);
    }

    private void testDecreaseQueueSettingOnTheFlyInternal(String allocBefore, String allocAfter) throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println(allocBefore);
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attId1).getLiveContainers().size());
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        ApplicationAttemptId attId3 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        ApplicationAttemptId attId4 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attId2).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attId3).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId4).getLiveContainers().size());
        out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println(allocAfter);
        out.close();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attId2).getLiveContainers().size());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attId3).getLiveContainers().size());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId4).getLiveContainers().size());
        AppAttemptRemovedSchedulerEvent appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(attId1, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId4).getLiveContainers().size());
        appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(attId2, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId4).getLiveContainers().size());
        appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(attId3, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attId4).getLiveContainers().size());
    }

    @Test(timeout=5000L)
    public void testReservationWhileMultiplePriorities() throws IOException {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024, (int)4), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId attId = this.createSchedulingRequest(1024, 4, "queue1", "user1", 1, 2);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        FSAppAttempt app = this.scheduler.getSchedulerApp(attId);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
        ContainerId containerId = ((RMContainer)this.scheduler.getSchedulerApp(attId).getLiveContainers().iterator().next()).getContainerId();
        this.createSchedulingRequestExistingApplication(1024, 4, 2, attId);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
        this.createSchedulingRequestExistingApplication(1024, 4, 1, attId);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
        for (RMContainer container : app.getReservedContainers()) {
            Assert.assertEquals((long)2L, (long)container.getReservedPriority().getPriority());
        }
        this.scheduler.allocate(attId, new ArrayList(), Arrays.asList(containerId), null, null);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)4L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Collection liveContainers = app.getLiveContainers();
        Assert.assertEquals((long)1L, (long)liveContainers.size());
        for (RMContainer liveContainer : liveContainers) {
            Assert.assertEquals((long)2L, (long)liveContainer.getContainer().getPriority().getPriority());
        }
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
    }

    @Test
    public void testAclSubmitApplication() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("  <aclSubmitApps> </aclSubmitApps>");
        out.println("  <aclAdministerApps> </aclAdministerApps>");
        out.println("  <queue name=\"queue1\">");
        out.println("    <aclSubmitApps>norealuserhasthisname</aclSubmitApps>");
        out.println("    <aclAdministerApps>norealuserhasthisname</aclAdministerApps>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "norealuserhasthisname", 1);
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue1", "norealuserhasthisname2", 1);
        FSAppAttempt app1 = this.scheduler.getSchedulerApp(attId1);
        Assert.assertNotNull((String)"The application was not allowed", (Object)app1);
        FSAppAttempt app2 = this.scheduler.getSchedulerApp(attId2);
        Assert.assertNull((String)"The application was allowed", (Object)app2);
    }

    @Test(timeout=5000L)
    public void testMultipleNodesSingleRackRequest() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 1, STATIC_HOST);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 2, "127.0.0.2");
        RMNode node3 = MockNodes.newNodeInfo(2, Resources.createResource((int)1024), 3, "127.0.0.3");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId attemptId = this.createAppAttemptId(this.APP_ID++, this.ATTEMPT_ID++);
        this.createMockRMApp(attemptId);
        this.scheduler.addApplication(attemptId.getApplicationId(), "queue1", "user1", false);
        this.scheduler.addApplicationAttempt(attemptId, false, false);
        ArrayList<ResourceRequest> asks = new ArrayList<ResourceRequest>();
        asks.add(this.createResourceRequest(1024, node1.getHostName(), 1, 1, true));
        asks.add(this.createResourceRequest(1024, node2.getHostName(), 1, 1, true));
        asks.add(this.createResourceRequest(1024, node3.getHostName(), 1, 1, true));
        asks.add(this.createResourceRequest(1024, node1.getRackName(), 1, 1, true));
        asks.add(this.createResourceRequest(1024, node3.getRackName(), 1, 1, true));
        asks.add(this.createResourceRequest(1024, "*", 1, 2, true));
        this.scheduler.allocate(attemptId, asks, new ArrayList(), null, null);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent1 = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent1);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attemptId).getLiveContainers().size());
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent2 = new NodeUpdateSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)updateEvent2);
        Assert.assertEquals((long)2L, (long)this.scheduler.getSchedulerApp(attemptId).getLiveContainers().size());
    }

    @Test(timeout=5000L)
    public void testFifoWithinQueue() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)3072, (int)3), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 2);
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue1", "user1", 2);
        FSAppAttempt app1 = this.scheduler.getSchedulerApp(attId1);
        FSAppAttempt app2 = this.scheduler.getSchedulerApp(attId2);
        FSLeafQueue queue1 = this.scheduler.getQueueManager().getLeafQueue("queue1", true);
        queue1.setPolicy((SchedulingPolicy)new FifoPolicy());
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)app2.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)app2.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)app2.getLiveContainers().size());
    }

    @Test(timeout=3000L)
    public void testMaxAssign() throws Exception {
        this.conf.setBoolean("yarn.scheduler.fair.assignmultiple", true);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node = MockNodes.newNodeInfo(1, Resources.createResource((int)16384, (int)16), 0, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        ApplicationAttemptId attId = this.createSchedulingRequest(1024, "root.default", "user", 8);
        FSAppAttempt app = this.scheduler.getSchedulerApp(attId);
        this.scheduler.maxAssign = 2;
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Incorrect number of containers allocated", (long)2L, (long)app.getLiveContainers().size());
        this.scheduler.maxAssign = -1;
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Incorrect number of containers allocated", (long)8L, (long)app.getLiveContainers().size());
    }

    @Test(timeout=3000L)
    public void testMaxAssignWithZeroMemoryContainers() throws Exception {
        this.conf.setBoolean("yarn.scheduler.fair.assignmultiple", true);
        this.conf.setInt("yarn.scheduler.minimum-allocation-mb", 0);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node = MockNodes.newNodeInfo(1, Resources.createResource((int)16384, (int)16), 0, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        ApplicationAttemptId attId = this.createSchedulingRequest(0, 1, "root.default", "user", 8);
        FSAppAttempt app = this.scheduler.getSchedulerApp(attId);
        this.scheduler.maxAssign = 2;
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Incorrect number of containers allocated", (long)2L, (long)app.getLiveContainers().size());
        this.scheduler.maxAssign = -1;
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Incorrect number of containers allocated", (long)8L, (long)app.getLiveContainers().size());
    }

    @Test(timeout=5000L)
    public void testAssignContainerToQueueWithZeroDisks() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        String user = "user1";
        String fooQueue = "foo";
        this.scheduler.getAllocationConfiguration().maxQueueResources.put("root.foo", Resource.newInstance((int)2048, (int)1, (double)0.0));
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "foo", "user1", 1);
        FSAppAttempt app1 = this.scheduler.getSchedulerApp(attId1);
        this.scheduler.getQueueManager().getLeafQueue("foo", true).setPolicy(SchedulingPolicy.parse((String)"fifo"));
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent1 = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent1);
        Assert.assertTrue((app1.getLiveContainers().size() == 1 ? 1 : 0) != 0);
    }

    @Test(timeout=5000L)
    public void testAssignContainer() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        String user = "user1";
        String fifoQueue = "fifo";
        String fairParent = "fairParent";
        String fairChild1 = "fairParent.fairChild1";
        String fairChild2 = "fairParent.fairChild2";
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, STATIC_HOST);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "fifo", "user1", 4);
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "fairParent.fairChild1", "user1", 4);
        ApplicationAttemptId attId3 = this.createSchedulingRequest(1024, "fairParent.fairChild2", "user1", 4);
        ApplicationAttemptId attId4 = this.createSchedulingRequest(1024, "fifo", "user1", 4);
        FSAppAttempt app1 = this.scheduler.getSchedulerApp(attId1);
        FSAppAttempt app2 = this.scheduler.getSchedulerApp(attId2);
        FSAppAttempt app3 = this.scheduler.getSchedulerApp(attId3);
        FSAppAttempt app4 = this.scheduler.getSchedulerApp(attId4);
        this.scheduler.getQueueManager().getLeafQueue("fifo", true).setPolicy(SchedulingPolicy.parse((String)"fifo"));
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent1 = new NodeUpdateSchedulerEvent(node1);
        NodeUpdateSchedulerEvent updateEvent2 = new NodeUpdateSchedulerEvent(node2);
        for (int i = 0; i < 8; ++i) {
            this.scheduler.handle((SchedulerEvent)updateEvent1);
            this.scheduler.handle((SchedulerEvent)updateEvent2);
            if ((i + 1) % 2 != 0) continue;
            String ERR = "Wrong number of assigned containers after " + (i + 1) + " updates";
            if (i < 4) {
                Assert.assertEquals((String)ERR, (long)(i + 1), (long)app1.getLiveContainers().size());
                Assert.assertEquals((String)ERR, (long)0L, (long)app4.getLiveContainers().size());
            } else {
                Assert.assertEquals((String)ERR, (long)4L, (long)app1.getLiveContainers().size());
                Assert.assertEquals((String)ERR, (long)(i - 3), (long)app4.getLiveContainers().size());
            }
            Assert.assertEquals((String)ERR, (long)((i + 1) / 2), (long)app2.getLiveContainers().size());
            Assert.assertEquals((String)ERR, (long)((i + 1) / 2), (long)app3.getLiveContainers().size());
        }
    }

    @Test
    public void testNotAllowSubmitApplication() throws Exception {
        int numTries;
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("  <aclSubmitApps> </aclSubmitApps>");
        out.println("  <aclAdministerApps> </aclAdministerApps>");
        out.println("  <queue name=\"queue1\">");
        out.println("    <aclSubmitApps>userallow</aclSubmitApps>");
        out.println("    <aclAdministerApps>userallow</aclAdministerApps>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        int appId = this.APP_ID++;
        String user = "usernotallow";
        String queue = "queue1";
        ApplicationId applicationId = MockApps.newAppID((int)appId);
        String name = MockApps.newAppName();
        ApplicationMasterService masterService = new ApplicationMasterService(this.resourceManager.getRMContext(), (YarnScheduler)this.scheduler);
        ApplicationSubmissionContextPBImpl submissionContext = new ApplicationSubmissionContextPBImpl();
        ContainerLaunchContext clc = BuilderUtils.newContainerLaunchContext(null, null, null, null, null, null);
        submissionContext.setApplicationId(applicationId);
        submissionContext.setAMContainerSpec(clc);
        RMAppImpl application = new RMAppImpl(applicationId, this.resourceManager.getRMContext(), this.conf, name, user, queue, (ApplicationSubmissionContext)submissionContext, (YarnScheduler)this.scheduler, masterService, System.currentTimeMillis(), "YARN", null, null);
        this.resourceManager.getRMContext().getRMApps().putIfAbsent(applicationId, application);
        application.handle((Event)new RMAppEvent(applicationId, RMAppEventType.START));
        int MAX_TRIES = 20;
        for (numTries = 0; !application.getState().equals((Object)RMAppState.SUBMITTED) && numTries < 20; ++numTries) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        Assert.assertEquals((String)"The application doesn't reach SUBMITTED.", (Object)RMAppState.SUBMITTED, (Object)application.getState());
        ApplicationAttemptId attId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)this.ATTEMPT_ID++);
        this.scheduler.addApplication(attId.getApplicationId(), queue, user, false);
        for (numTries = 0; application.getFinishTime() == 0L && numTries < 20; ++numTries) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        Assert.assertEquals((Object)FinalApplicationStatus.FAILED, (Object)application.getFinalApplicationStatus());
    }

    @Test
    public void testRemoveNodeUpdatesRootQueueMetrics() throws IOException {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024, (int)4), 1, STATIC_HOST);
        NodeAddedSchedulerEvent addEvent = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)addEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)4L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
        this.scheduler.update();
        Assert.assertEquals((long)1024L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)4L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
        NodeRemovedSchedulerEvent removeEvent = new NodeRemovedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)removeEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
        this.scheduler.update();
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
    }

    @Test
    public void testStrictLocality() throws IOException {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 0);
        ResourceRequest nodeRequest = this.createResourceRequest(1024, node1.getHostName(), 1, 1, true);
        ResourceRequest rackRequest = this.createResourceRequest(1024, node1.getRackName(), 1, 1, false);
        ResourceRequest anyRequest = this.createResourceRequest(1024, "*", 1, 1, false);
        this.createSchedulingRequestExistingApplication(nodeRequest, attId1);
        this.createSchedulingRequestExistingApplication(rackRequest, attId1);
        this.createSchedulingRequestExistingApplication(anyRequest, attId1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent node1UpdateEvent = new NodeUpdateSchedulerEvent(node1);
        NodeUpdateSchedulerEvent node2UpdateEvent = new NodeUpdateSchedulerEvent(node2);
        FSAppAttempt app = this.scheduler.getSchedulerApp(attId1);
        for (int i = 0; i < 10; ++i) {
            this.scheduler.handle((SchedulerEvent)node2UpdateEvent);
            Assert.assertEquals((long)0L, (long)app.getLiveContainers().size());
            Assert.assertEquals((long)0L, (long)app.getReservedContainers().size());
        }
        this.scheduler.handle((SchedulerEvent)node1UpdateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
    }

    @Test
    public void testCancelStrictLocality() throws IOException {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 0);
        ResourceRequest nodeRequest = this.createResourceRequest(1024, node1.getHostName(), 1, 1, true);
        ResourceRequest rackRequest = this.createResourceRequest(1024, "rack1", 1, 1, false);
        ResourceRequest anyRequest = this.createResourceRequest(1024, "*", 1, 1, false);
        this.createSchedulingRequestExistingApplication(nodeRequest, attId1);
        this.createSchedulingRequestExistingApplication(rackRequest, attId1);
        this.createSchedulingRequestExistingApplication(anyRequest, attId1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent node2UpdateEvent = new NodeUpdateSchedulerEvent(node2);
        FSAppAttempt app = this.scheduler.getSchedulerApp(attId1);
        for (int i = 0; i < 10; ++i) {
            this.scheduler.handle((SchedulerEvent)node2UpdateEvent);
            Assert.assertEquals((long)0L, (long)app.getLiveContainers().size());
        }
        List<ResourceRequest> update = Arrays.asList(this.createResourceRequest(1024, node1.getHostName(), 1, 0, true), this.createResourceRequest(1024, "rack1", 1, 0, true), this.createResourceRequest(1024, "*", 1, 1, true));
        this.scheduler.allocate(attId1, update, new ArrayList(), null, null);
        this.scheduler.handle((SchedulerEvent)node2UpdateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
    }

    @Test
    public void testReservationsStrictLocality() throws IOException {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 1, STATIC_HOST);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId attId = this.createSchedulingRequest(1024, "queue1", "user1", 0);
        FSAppAttempt app = this.scheduler.getSchedulerApp(attId);
        ResourceRequest nodeRequest = this.createResourceRequest(1024, node2.getHostName(), 1, 2, true);
        ResourceRequest rackRequest = this.createResourceRequest(1024, "rack1", 1, 2, true);
        ResourceRequest anyRequest = this.createResourceRequest(1024, "*", 1, 2, false);
        this.createSchedulingRequestExistingApplication(nodeRequest, attId);
        this.createSchedulingRequestExistingApplication(rackRequest, attId);
        this.createSchedulingRequestExistingApplication(anyRequest, attId);
        this.scheduler.update();
        NodeUpdateSchedulerEvent nodeUpdateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeUpdateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)nodeUpdateEvent);
        Assert.assertEquals((long)1L, (long)app.getReservedContainers().size());
        rackRequest = this.createResourceRequest(1024, "rack1", 1, 1, false);
        anyRequest = this.createResourceRequest(1024, "*", 1, 1, false);
        this.scheduler.allocate(attId, Arrays.asList(rackRequest, anyRequest), new ArrayList(), null, null);
        this.scheduler.handle((SchedulerEvent)nodeUpdateEvent);
        Assert.assertEquals((long)0L, (long)app.getReservedContainers().size());
    }

    @Test
    public void testNoMoreCpuOnNode() throws IOException {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)2048, (int)1), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId attId = this.createSchedulingRequest(1024, 1, "default", "user1", 2);
        FSAppAttempt app = this.scheduler.getSchedulerApp(attId);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
    }

    @Test
    public void testBasicDRFAssignment() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node = MockNodes.newNodeInfo(1, BuilderUtils.newResource((int)8192, (int)5));
        NetUtils.addStaticResolution((String)node.getHostName(), (String)STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        ApplicationAttemptId appAttId1 = this.createSchedulingRequest(2048, 1, "queue1", "user1", 2);
        FSAppAttempt app1 = this.scheduler.getSchedulerApp(appAttId1);
        ApplicationAttemptId appAttId2 = this.createSchedulingRequest(1024, 2, "queue1", "user1", 2);
        FSAppAttempt app2 = this.scheduler.getSchedulerApp(appAttId2);
        DominantResourceFairnessPolicy drfPolicy = new DominantResourceFairnessPolicy();
        drfPolicy.initialize(this.scheduler.getClusterResource());
        this.scheduler.getQueueManager().getQueue("queue1").setPolicy((SchedulingPolicy)drfPolicy);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)app2.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)app2.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)app2.getLiveContainers().size());
    }

    @Test
    public void testBasicDRFWithQueues() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node = MockNodes.newNodeInfo(1, BuilderUtils.newResource((int)8192, (int)7), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        ApplicationAttemptId appAttId1 = this.createSchedulingRequest(3072, 1, "queue1", "user1", 2);
        FSAppAttempt app1 = this.scheduler.getSchedulerApp(appAttId1);
        ApplicationAttemptId appAttId2 = this.createSchedulingRequest(2048, 2, "queue1", "user1", 2);
        FSAppAttempt app2 = this.scheduler.getSchedulerApp(appAttId2);
        ApplicationAttemptId appAttId3 = this.createSchedulingRequest(1024, 2, "queue2", "user1", 2);
        FSAppAttempt app3 = this.scheduler.getSchedulerApp(appAttId3);
        DominantResourceFairnessPolicy drfPolicy = new DominantResourceFairnessPolicy();
        drfPolicy.initialize(this.scheduler.getClusterResource());
        this.scheduler.getQueueManager().getQueue("root").setPolicy((SchedulingPolicy)drfPolicy);
        this.scheduler.getQueueManager().getQueue("queue1").setPolicy((SchedulingPolicy)drfPolicy);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app1.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app3.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2L, (long)app3.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app2.getLiveContainers().size());
    }

    @Test
    public void testDRFHierarchicalQueues() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node = MockNodes.newNodeInfo(1, BuilderUtils.newResource((int)12288, (int)12), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        ApplicationAttemptId appAttId1 = this.createSchedulingRequest(3074, 1, "queue1.subqueue1", "user1", 2);
        Thread.sleep(3L);
        FSAppAttempt app1 = this.scheduler.getSchedulerApp(appAttId1);
        ApplicationAttemptId appAttId2 = this.createSchedulingRequest(1024, 3, "queue1.subqueue1", "user1", 2);
        Thread.sleep(3L);
        FSAppAttempt app2 = this.scheduler.getSchedulerApp(appAttId2);
        ApplicationAttemptId appAttId3 = this.createSchedulingRequest(2048, 2, "queue1.subqueue2", "user1", 2);
        Thread.sleep(3L);
        FSAppAttempt app3 = this.scheduler.getSchedulerApp(appAttId3);
        ApplicationAttemptId appAttId4 = this.createSchedulingRequest(1024, 2, "queue2", "user1", 2);
        Thread.sleep(3L);
        FSAppAttempt app4 = this.scheduler.getSchedulerApp(appAttId4);
        DominantResourceFairnessPolicy drfPolicy = new DominantResourceFairnessPolicy();
        drfPolicy.initialize(this.scheduler.getClusterResource());
        this.scheduler.getQueueManager().getQueue("root").setPolicy((SchedulingPolicy)drfPolicy);
        this.scheduler.getQueueManager().getQueue("queue1").setPolicy((SchedulingPolicy)drfPolicy);
        this.scheduler.getQueueManager().getQueue("queue1.subqueue1").setPolicy((SchedulingPolicy)drfPolicy);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app1.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app4.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2L, (long)app4.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app3.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2L, (long)app3.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app2.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)app2.getLiveContainers().size());
        Assert.assertEquals((long)2L, (long)app3.getLiveContainers().size());
        Assert.assertEquals((long)2L, (long)app4.getLiveContainers().size());
    }

    @Test(timeout=30000L)
    public void testHostPortNodeName() throws Exception {
        this.conf.setBoolean("yarn.scheduler.include-port-in-node-name", true);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 1, STATIC_HOST, 1);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 2, STATIC_HOST, 2);
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 0);
        ResourceRequest nodeRequest = this.createResourceRequest(1024, node1.getNodeID().getHost() + ":" + node1.getNodeID().getPort(), 1, 1, true);
        ResourceRequest rackRequest = this.createResourceRequest(1024, node1.getRackName(), 1, 1, false);
        ResourceRequest anyRequest = this.createResourceRequest(1024, "*", 1, 1, false);
        this.createSchedulingRequestExistingApplication(nodeRequest, attId1);
        this.createSchedulingRequestExistingApplication(rackRequest, attId1);
        this.createSchedulingRequestExistingApplication(anyRequest, attId1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent node1UpdateEvent = new NodeUpdateSchedulerEvent(node1);
        NodeUpdateSchedulerEvent node2UpdateEvent = new NodeUpdateSchedulerEvent(node2);
        FSAppAttempt app = this.scheduler.getSchedulerApp(attId1);
        for (int i = 0; i < 10; ++i) {
            this.scheduler.handle((SchedulerEvent)node2UpdateEvent);
            Assert.assertEquals((long)0L, (long)app.getLiveContainers().size());
            Assert.assertEquals((long)0L, (long)app.getReservedContainers().size());
        }
        this.scheduler.handle((SchedulerEvent)node1UpdateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
    }

    private void verifyAppRunnable(ApplicationAttemptId attId, boolean runnable) {
        FSAppAttempt app = this.scheduler.getSchedulerApp(attId);
        FSLeafQueue queue = app.getQueue();
        Assert.assertEquals((Object)runnable, (Object)queue.isRunnableApp(app));
        Assert.assertEquals((Object)(!runnable ? 1 : 0), (Object)queue.isNonRunnableApp(app));
    }

    private void verifyQueueNumRunnable(String queueName, int numRunnableInQueue, int numNonRunnableInQueue) {
        FSLeafQueue queue = this.scheduler.getQueueManager().getLeafQueue(queueName, false);
        Assert.assertEquals((long)numRunnableInQueue, (long)queue.getNumRunnableApps());
        Assert.assertEquals((long)numNonRunnableInQueue, (long)queue.getNumNonRunnableApps());
    }

    @Test
    public void testUserAndQueueMaxRunningApps() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queue1\">");
        out.println("<maxRunningApps>2</maxRunningApps>");
        out.println("</queue>");
        out.println("<user name=\"user1\">");
        out.println("<maxRunningApps>1</maxRunningApps>");
        out.println("</user>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1");
        this.verifyAppRunnable(attId1, true);
        this.verifyQueueNumRunnable("queue1", 1, 0);
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue2", "user1");
        this.verifyAppRunnable(attId2, false);
        this.verifyQueueNumRunnable("queue2", 0, 1);
        ApplicationAttemptId attId3 = this.createSchedulingRequest(1024, "queue1", "user2");
        this.verifyAppRunnable(attId3, true);
        this.verifyQueueNumRunnable("queue1", 2, 0);
        ApplicationAttemptId attId4 = this.createSchedulingRequest(1024, "queue1", "user2");
        this.verifyAppRunnable(attId4, false);
        this.verifyQueueNumRunnable("queue1", 2, 1);
        AppAttemptRemovedSchedulerEvent appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(attId1, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent1);
        this.verifyAppRunnable(attId2, true);
        this.verifyQueueNumRunnable("queue2", 1, 0);
        this.verifyAppRunnable(attId4, true);
        this.verifyQueueNumRunnable("queue1", 2, 0);
        ApplicationAttemptId attId5 = this.createSchedulingRequest(1024, "queue1", "user2");
        this.verifyAppRunnable(attId5, false);
        this.verifyQueueNumRunnable("queue1", 2, 1);
    }

    @Test
    public void testMultipleCompletedEvent() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queue1\">");
        out.println("<maxAMShare>0.2</maxAMShare>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node = MockNodes.newNodeInfo(1, Resources.createResource((int)20480, (int)20), 0, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        this.scheduler.update();
        ApplicationAttemptId attId1 = this.createAppAttemptId(1, 1);
        this.createApplicationWithAMResource(attId1, "queue1", "user1", Resource.newInstance((int)1024, (int)1));
        this.createSchedulingRequestExistingApplication(1024, 1, RMAppAttemptImpl.AM_CONTAINER_PRIORITY.getPriority(), attId1);
        FSAppAttempt app1 = this.scheduler.getSchedulerApp(attId1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        RMContainer container = (RMContainer)app1.getLiveContainersMap().values().iterator().next();
        this.scheduler.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus((ContainerId)container.getContainerId(), (String)"Container released on a *lost* node"), RMContainerEventType.KILL);
        this.scheduler.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus((ContainerId)container.getContainerId(), (String)"Container of a completed application"), RMContainerEventType.FINISHED);
        Assert.assertEquals((Object)Resources.none(), (Object)app1.getResourceUsage());
    }

    @Test
    public void testQueueMaxAMShare() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queue1\">");
        out.println("<maxAMShare>0.2</maxAMShare>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node = MockNodes.newNodeInfo(1, Resources.createResource((int)20480, (int)20), 0, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        this.scheduler.update();
        FSLeafQueue queue1 = this.scheduler.getQueueManager().getLeafQueue("queue1", true);
        Assert.assertEquals((String)"Queue queue1's fair share should be 0", (long)0L, (long)queue1.getFairShare().getMemory());
        this.createSchedulingRequest(1024, "root.default", "user1");
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Resource amResource1 = Resource.newInstance((int)1024, (int)1);
        Resource amResource2 = Resource.newInstance((int)2048, (int)2);
        Resource amResource3 = Resource.newInstance((int)1860, (int)2);
        int amPriority = RMAppAttemptImpl.AM_CONTAINER_PRIORITY.getPriority();
        ApplicationAttemptId attId1 = this.createAppAttemptId(1, 1);
        this.createApplicationWithAMResource(attId1, "queue1", "user1", amResource1);
        this.createSchedulingRequestExistingApplication(1024, 1, amPriority, attId1);
        FSAppAttempt app1 = this.scheduler.getSchedulerApp(attId1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application1's AM requests 1024 MB memory", (long)1024L, (long)app1.getAMResource().getMemory());
        Assert.assertEquals((String)"Application1's AM should be running", (long)1L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 1024 MB memory", (long)1024L, (long)queue1.getAmResourceUsage().getMemory());
        ApplicationAttemptId attId2 = this.createAppAttemptId(2, 1);
        this.createApplicationWithAMResource(attId2, "queue1", "user1", amResource1);
        this.createSchedulingRequestExistingApplication(1024, 1, amPriority, attId2);
        FSAppAttempt app2 = this.scheduler.getSchedulerApp(attId2);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application2's AM requests 1024 MB memory", (long)1024L, (long)app2.getAMResource().getMemory());
        Assert.assertEquals((String)"Application2's AM should be running", (long)1L, (long)app2.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemory());
        ApplicationAttemptId attId3 = this.createAppAttemptId(3, 1);
        this.createApplicationWithAMResource(attId3, "queue1", "user1", amResource1);
        this.createSchedulingRequestExistingApplication(1024, 1, amPriority, attId3);
        FSAppAttempt app3 = this.scheduler.getSchedulerApp(attId3);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application3's AM resource shouldn't be updated", (long)0L, (long)app3.getAMResource().getMemory());
        Assert.assertEquals((String)"Application3's AM should not be running", (long)0L, (long)app3.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemory());
        this.createSchedulingRequestExistingApplication(1024, 1, attId1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application1 should have two running containers", (long)2L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemory());
        AppAttemptRemovedSchedulerEvent appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(attId1, RMAppAttemptState.FINISHED, false);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)appRemovedEvent1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application1's AM should be finished", (long)0L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((String)"Application3's AM should be running", (long)1L, (long)app3.getLiveContainers().size());
        Assert.assertEquals((String)"Application3's AM requests 1024 MB memory", (long)1024L, (long)app3.getAMResource().getMemory());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemory());
        ApplicationAttemptId attId4 = this.createAppAttemptId(4, 1);
        this.createApplicationWithAMResource(attId4, "queue1", "user1", amResource2);
        this.createSchedulingRequestExistingApplication(2048, 2, amPriority, attId4);
        FSAppAttempt app4 = this.scheduler.getSchedulerApp(attId4);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application4's AM resource shouldn't be updated", (long)0L, (long)app4.getAMResource().getMemory());
        Assert.assertEquals((String)"Application4's AM should not be running", (long)0L, (long)app4.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemory());
        ApplicationAttemptId attId5 = this.createAppAttemptId(5, 1);
        this.createApplicationWithAMResource(attId5, "queue1", "user1", amResource2);
        this.createSchedulingRequestExistingApplication(2048, 2, amPriority, attId5);
        FSAppAttempt app5 = this.scheduler.getSchedulerApp(attId5);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application5's AM resource shouldn't be updated", (long)0L, (long)app5.getAMResource().getMemory());
        Assert.assertEquals((String)"Application5's AM should not be running", (long)0L, (long)app5.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemory());
        AppAttemptRemovedSchedulerEvent appRemovedEvent4 = new AppAttemptRemovedSchedulerEvent(attId4, RMAppAttemptState.KILLED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent4);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application5's AM should not be running", (long)0L, (long)app5.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemory());
        AppAttemptRemovedSchedulerEvent appRemovedEvent2 = new AppAttemptRemovedSchedulerEvent(attId2, RMAppAttemptState.FINISHED, false);
        AppAttemptRemovedSchedulerEvent appRemovedEvent3 = new AppAttemptRemovedSchedulerEvent(attId3, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent2);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent3);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application2's AM should be finished", (long)0L, (long)app2.getLiveContainers().size());
        Assert.assertEquals((String)"Application3's AM should be finished", (long)0L, (long)app3.getLiveContainers().size());
        Assert.assertEquals((String)"Application5's AM should be running", (long)1L, (long)app5.getLiveContainers().size());
        Assert.assertEquals((String)"Application5's AM requests 2048 MB memory", (long)2048L, (long)app5.getAMResource().getMemory());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemory());
        this.createSchedulingRequestExistingApplication(1024, 1, attId5);
        Assert.assertEquals((String)"Application5's AM should have 1 container", (long)1L, (long)app5.getLiveContainers().size());
        RMContainer amContainer5 = (RMContainer)app5.getLiveContainers().toArray()[0];
        ContainerExpiredSchedulerEvent containerExpired = new ContainerExpiredSchedulerEvent(amContainer5.getContainerId());
        this.scheduler.handle((SchedulerEvent)containerExpired);
        Assert.assertEquals((String)"Application5's AM should have 0 container", (long)0L, (long)app5.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemory());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application5 should have 1 container", (long)1L, (long)app5.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemory());
        ApplicationAttemptId attId6 = this.createAppAttemptId(6, 1);
        this.createApplicationWithAMResource(attId6, "queue1", "user1", amResource3);
        this.createSchedulingRequestExistingApplication(1860, 2, amPriority, attId6);
        FSAppAttempt app6 = this.scheduler.getSchedulerApp(attId6);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application6's AM should not be running", (long)0L, (long)app6.getLiveContainers().size());
        Assert.assertEquals((String)"Application6's AM resource shouldn't be updated", (long)0L, (long)app6.getAMResource().getMemory());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemory());
        AppAttemptRemovedSchedulerEvent appRemovedEvent5 = new AppAttemptRemovedSchedulerEvent(attId5, RMAppAttemptState.FINISHED, false);
        AppAttemptRemovedSchedulerEvent appRemovedEvent6 = new AppAttemptRemovedSchedulerEvent(attId6, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent5);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent6);
        this.scheduler.update();
        Assert.assertEquals((String)"Queue1's AM resource usage should be 0", (long)0L, (long)queue1.getAmResourceUsage().getMemory());
    }

    @Test
    public void testQueueMaxAMShareDefault() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queue1\">");
        out.println("</queue>");
        out.println("<queue name=\"queue2\">");
        out.println("<maxAMShare>0.4</maxAMShare>");
        out.println("</queue>");
        out.println("<queue name=\"queue3\">");
        out.println("</queue>");
        out.println("<queue name=\"queue4\">");
        out.println("</queue>");
        out.println("<queue name=\"queue5\">");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)20), 0, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        this.scheduler.update();
        FSLeafQueue queue1 = this.scheduler.getQueueManager().getLeafQueue("queue1", true);
        Assert.assertEquals((String)"Queue queue1's fair share should be 0", (long)0L, (long)queue1.getFairShare().getMemory());
        FSLeafQueue queue2 = this.scheduler.getQueueManager().getLeafQueue("queue2", true);
        Assert.assertEquals((String)"Queue queue2's fair share should be 0", (long)0L, (long)queue2.getFairShare().getMemory());
        FSLeafQueue queue3 = this.scheduler.getQueueManager().getLeafQueue("queue3", true);
        Assert.assertEquals((String)"Queue queue3's fair share should be 0", (long)0L, (long)queue3.getFairShare().getMemory());
        FSLeafQueue queue4 = this.scheduler.getQueueManager().getLeafQueue("queue4", true);
        Assert.assertEquals((String)"Queue queue4's fair share should be 0", (long)0L, (long)queue4.getFairShare().getMemory());
        FSLeafQueue queue5 = this.scheduler.getQueueManager().getLeafQueue("queue5", true);
        Assert.assertEquals((String)"Queue queue5's fair share should be 0", (long)0L, (long)queue5.getFairShare().getMemory());
        List<String> queues = Arrays.asList("root.queue3", "root.queue4", "root.queue5");
        for (String queue : queues) {
            this.createSchedulingRequest(1024, queue, "user1");
            this.scheduler.update();
            this.scheduler.handle((SchedulerEvent)updateEvent);
        }
        Resource amResource1 = Resource.newInstance((int)1024, (int)1);
        int amPriority = RMAppAttemptImpl.AM_CONTAINER_PRIORITY.getPriority();
        ApplicationAttemptId attId1 = this.createAppAttemptId(1, 1);
        this.createApplicationWithAMResource(attId1, "queue1", "test1", amResource1);
        this.createSchedulingRequestExistingApplication(1024, 1, amPriority, attId1);
        FSAppAttempt app1 = this.scheduler.getSchedulerApp(attId1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application1's AM requests 1024 MB memory", (long)1024L, (long)app1.getAMResource().getMemory());
        Assert.assertEquals((String)"Application1's AM should be running", (long)1L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 1024 MB memory", (long)1024L, (long)queue1.getAmResourceUsage().getMemory());
        ApplicationAttemptId attId2 = this.createAppAttemptId(2, 1);
        this.createApplicationWithAMResource(attId2, "queue2", "test1", amResource1);
        this.createSchedulingRequestExistingApplication(1024, 1, amPriority, attId2);
        FSAppAttempt app2 = this.scheduler.getSchedulerApp(attId2);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application2's AM resource shouldn't be updated", (long)0L, (long)app2.getAMResource().getMemory());
        Assert.assertEquals((String)"Application2's AM should not be running", (long)0L, (long)app2.getLiveContainers().size());
        Assert.assertEquals((String)"Queue2's AM resource usage should be 0 MB memory", (long)0L, (long)queue2.getAmResourceUsage().getMemory());
    }

    @Test
    public void testQueueMaxAMShareWithContainerReservation() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queue1\">");
        out.println("<maxAMShare>0.5</maxAMShare>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)10240, (int)10), 1, STATIC_HOST);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)10240, (int)10), 2, "127.0.0.2");
        RMNode node3 = MockNodes.newNodeInfo(1, Resources.createResource((int)5120, (int)5), 3, "127.0.0.3");
        NodeAddedSchedulerEvent nodeE1 = new NodeAddedSchedulerEvent(node1);
        NodeUpdateSchedulerEvent updateE1 = new NodeUpdateSchedulerEvent(node1);
        NodeAddedSchedulerEvent nodeE2 = new NodeAddedSchedulerEvent(node2);
        NodeUpdateSchedulerEvent updateE2 = new NodeUpdateSchedulerEvent(node2);
        NodeAddedSchedulerEvent nodeE3 = new NodeAddedSchedulerEvent(node3);
        NodeUpdateSchedulerEvent updateE3 = new NodeUpdateSchedulerEvent(node3);
        this.scheduler.handle((SchedulerEvent)nodeE1);
        this.scheduler.handle((SchedulerEvent)nodeE2);
        this.scheduler.handle((SchedulerEvent)nodeE3);
        this.scheduler.update();
        FSLeafQueue queue1 = this.scheduler.getQueueManager().getLeafQueue("queue1", true);
        Resource amResource1 = Resource.newInstance((int)1024, (int)1);
        Resource amResource2 = Resource.newInstance((int)1024, (int)1);
        Resource amResource3 = Resource.newInstance((int)10240, (int)1);
        Resource amResource4 = Resource.newInstance((int)5120, (int)1);
        Resource amResource5 = Resource.newInstance((int)1024, (int)1);
        Resource amResource6 = Resource.newInstance((int)10240, (int)1);
        Resource amResource7 = Resource.newInstance((int)1024, (int)1);
        Resource amResource8 = Resource.newInstance((int)1024, (int)1);
        int amPriority = RMAppAttemptImpl.AM_CONTAINER_PRIORITY.getPriority();
        ApplicationAttemptId attId1 = this.createAppAttemptId(1, 1);
        this.createApplicationWithAMResource(attId1, "queue1", "user1", amResource1);
        this.createSchedulingRequestExistingApplication(1024, 1, amPriority, attId1);
        FSAppAttempt app1 = this.scheduler.getSchedulerApp(attId1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE1);
        Assert.assertEquals((String)"Application1's AM requests 1024 MB memory", (long)1024L, (long)app1.getAMResource().getMemory());
        Assert.assertEquals((String)"Application1's AM should be running", (long)1L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 1024 MB memory", (long)1024L, (long)queue1.getAmResourceUsage().getMemory());
        ApplicationAttemptId attId2 = this.createAppAttemptId(2, 1);
        this.createApplicationWithAMResource(attId2, "queue1", "user1", amResource2);
        this.createSchedulingRequestExistingApplication(1024, 1, amPriority, attId2);
        FSAppAttempt app2 = this.scheduler.getSchedulerApp(attId2);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE2);
        Assert.assertEquals((String)"Application2's AM requests 1024 MB memory", (long)1024L, (long)app2.getAMResource().getMemory());
        Assert.assertEquals((String)"Application2's AM should be running", (long)1L, (long)app2.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemory());
        ApplicationAttemptId attId3 = this.createAppAttemptId(3, 1);
        this.createApplicationWithAMResource(attId3, "queue1", "user1", amResource3);
        this.createSchedulingRequestExistingApplication(10240, 1, amPriority, attId3);
        FSAppAttempt app3 = this.scheduler.getSchedulerApp(attId3);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE1);
        this.scheduler.handle((SchedulerEvent)updateE2);
        Assert.assertEquals((String)"Application3's AM resource shouldn't be updated", (long)0L, (long)app3.getAMResource().getMemory());
        Assert.assertEquals((String)"Application3's AM should not be running", (long)0L, (long)app3.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemory());
        ApplicationAttemptId attId4 = this.createAppAttemptId(4, 1);
        this.createApplicationWithAMResource(attId4, "queue1", "user1", amResource4);
        this.createSchedulingRequestExistingApplication(5120, 1, amPriority, attId4);
        FSAppAttempt app4 = this.scheduler.getSchedulerApp(attId4);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE1);
        Assert.assertEquals((String)"Application4's AM resource shouldn't be updated", (long)0L, (long)app4.getAMResource().getMemory());
        Assert.assertEquals((String)"Application4's AM should not be running", (long)0L, (long)app4.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemory());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE3);
        Assert.assertEquals((String)"Application4's AM requests 5120 MB memory", (long)5120L, (long)app4.getAMResource().getMemory());
        Assert.assertEquals((String)"Application4's AM should be running", (long)1L, (long)app4.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 7168 MB memory", (long)7168L, (long)queue1.getAmResourceUsage().getMemory());
        AppAttemptRemovedSchedulerEvent appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(attId1, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent1);
        Assert.assertEquals((String)"Queue1's AM resource usage should be 6144 MB memory", (long)6144L, (long)queue1.getAmResourceUsage().getMemory());
        ApplicationAttemptId attId5 = this.createAppAttemptId(5, 1);
        this.createApplicationWithAMResource(attId5, "queue1", "user1", amResource5);
        this.createSchedulingRequestExistingApplication(1024, 1, amPriority, attId5);
        FSAppAttempt app5 = this.scheduler.getSchedulerApp(attId5);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE1);
        Assert.assertEquals((String)"Application5's AM requests 1024 MB memory", (long)1024L, (long)app5.getAMResource().getMemory());
        Assert.assertEquals((String)"Application5's AM should be running", (long)1L, (long)app5.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 7168 MB memory", (long)7168L, (long)queue1.getAmResourceUsage().getMemory());
        AppAttemptRemovedSchedulerEvent appRemovedEvent3 = new AppAttemptRemovedSchedulerEvent(attId3, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent3);
        Assert.assertEquals((String)"Queue1's AM resource usage should be 7168 MB memory", (long)7168L, (long)queue1.getAmResourceUsage().getMemory());
        ApplicationAttemptId attId6 = this.createAppAttemptId(6, 1);
        this.createApplicationWithAMResource(attId6, "queue1", "user1", amResource6);
        this.createSchedulingRequestExistingApplication(10240, 1, amPriority, attId6);
        FSAppAttempt app6 = this.scheduler.getSchedulerApp(attId6);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE1);
        Assert.assertEquals((String)"Application6's AM resource shouldn't be updated", (long)0L, (long)app6.getAMResource().getMemory());
        Assert.assertEquals((String)"Application6's AM should not be running", (long)0L, (long)app6.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 7168 MB memory", (long)7168L, (long)queue1.getAmResourceUsage().getMemory());
        ApplicationAttemptId attId7 = this.createAppAttemptId(7, 1);
        this.createApplicationWithAMResource(attId7, "queue1", "user1", amResource7);
        this.createSchedulingRequestExistingApplication(1024, 1, amPriority, attId7);
        FSAppAttempt app7 = this.scheduler.getSchedulerApp(attId7);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE1);
        Assert.assertEquals((String)"Application7's AM requests 1024 MB memory", (long)1024L, (long)app7.getAMResource().getMemory());
        Assert.assertEquals((String)"Application7's AM should be running", (long)1L, (long)app7.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 8192 MB memory", (long)8192L, (long)queue1.getAmResourceUsage().getMemory());
        AppAttemptRemovedSchedulerEvent appRemovedEvent4 = new AppAttemptRemovedSchedulerEvent(attId4, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent4);
        Assert.assertEquals((String)"Queue1's AM resource usage should be 3072 MB memory", (long)3072L, (long)queue1.getAmResourceUsage().getMemory());
        AppAttemptRemovedSchedulerEvent appRemovedEvent5 = new AppAttemptRemovedSchedulerEvent(attId5, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent5);
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemory());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE1);
        this.scheduler.handle((SchedulerEvent)updateE2);
        ApplicationAttemptId attId8 = this.createAppAttemptId(8, 1);
        this.createApplicationWithAMResource(attId8, "queue1", "user1", amResource8);
        this.createSchedulingRequestExistingApplication(1024, 1, amPriority, attId8);
        FSAppAttempt app8 = this.scheduler.getSchedulerApp(attId8);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE1);
        Assert.assertEquals((String)"Application8's AM resource shouldn't be updated", (long)0L, (long)app8.getAMResource().getMemory());
        Assert.assertEquals((String)"Application8's AM should not be running", (long)0L, (long)app8.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemory());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE2);
        Assert.assertEquals((String)"Application8's AM resource shouldn't be updated", (long)0L, (long)app8.getAMResource().getMemory());
        Assert.assertEquals((String)"Application8's AM should not be running", (long)0L, (long)app8.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemory());
        AppAttemptRemovedSchedulerEvent appRemovedEvent2 = new AppAttemptRemovedSchedulerEvent(attId2, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent2);
        Assert.assertEquals((String)"Queue1's AM resource usage should be 1024 MB memory", (long)1024L, (long)queue1.getAmResourceUsage().getMemory());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE2);
        Assert.assertEquals((String)"Application6's AM requests 10240 MB memory", (long)10240L, (long)app6.getAMResource().getMemory());
        Assert.assertEquals((String)"Application6's AM should be running", (long)1L, (long)app6.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 11264 MB memory", (long)11264L, (long)queue1.getAmResourceUsage().getMemory());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE1);
        Assert.assertEquals((String)"Application8's AM requests 1024 MB memory", (long)1024L, (long)app8.getAMResource().getMemory());
        Assert.assertEquals((String)"Application8's AM should be running", (long)1L, (long)app8.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 12288 MB memory", (long)12288L, (long)queue1.getAmResourceUsage().getMemory());
    }

    @Test
    public void testMaxRunningAppsHierarchicalQueues() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        ControlledClock clock = new ControlledClock();
        this.scheduler.setClock((Clock)clock);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queue1\">");
        out.println("  <maxRunningApps>3</maxRunningApps>");
        out.println("  <queue name=\"sub1\"></queue>");
        out.println("  <queue name=\"sub2\"></queue>");
        out.println("  <queue name=\"sub3\">");
        out.println("    <maxRunningApps>1</maxRunningApps>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1.sub1", "user1");
        this.verifyAppRunnable(attId1, true);
        this.verifyQueueNumRunnable("queue1.sub1", 1, 0);
        clock.tickSec(10);
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue1.sub3", "user1");
        this.verifyAppRunnable(attId2, true);
        this.verifyQueueNumRunnable("queue1.sub3", 1, 0);
        clock.tickSec(10);
        ApplicationAttemptId attId3 = this.createSchedulingRequest(1024, "queue1.sub2", "user1");
        this.verifyAppRunnable(attId3, true);
        this.verifyQueueNumRunnable("queue1.sub2", 1, 0);
        clock.tickSec(10);
        ApplicationAttemptId attId4 = this.createSchedulingRequest(1024, "queue1.sub2", "user1");
        this.verifyAppRunnable(attId4, false);
        this.verifyQueueNumRunnable("queue1.sub2", 1, 1);
        clock.tickSec(10);
        ApplicationAttemptId attId5 = this.createSchedulingRequest(1024, "queue1.sub3", "user1");
        this.verifyAppRunnable(attId5, false);
        this.verifyQueueNumRunnable("queue1.sub3", 1, 1);
        clock.tickSec(10);
        AppAttemptRemovedSchedulerEvent appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(attId2, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent1);
        this.verifyAppRunnable(attId4, true);
        this.verifyQueueNumRunnable("queue1.sub2", 2, 0);
        this.verifyAppRunnable(attId5, false);
        this.verifyQueueNumRunnable("queue1.sub3", 0, 1);
        AppAttemptRemovedSchedulerEvent appRemovedEvent2 = new AppAttemptRemovedSchedulerEvent(attId5, RMAppAttemptState.KILLED, true);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent2);
        Assert.assertEquals((long)0L, (long)this.scheduler.maxRunningEnforcer.usersNonRunnableApps.get((Object)"user1").size());
        this.verifyQueueNumRunnable("queue1.sub3", 0, 0);
        AppAttemptRemovedSchedulerEvent appRemovedEvent3 = new AppAttemptRemovedSchedulerEvent(attId4, RMAppAttemptState.FINISHED, true);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent3);
        this.verifyQueueNumRunnable("queue1.sub2", 1, 0);
        this.verifyQueueNumRunnable("queue1.sub3", 0, 0);
    }

    @Test(timeout=10000L)
    public void testContinuousScheduling() throws Exception {
        this.scheduler = new FairScheduler();
        Configuration conf = this.createConfiguration();
        conf.setBoolean("yarn.scheduler.fair.continuous-scheduling-enabled", true);
        this.scheduler.setRMContext(this.resourceManager.getRMContext());
        this.scheduler.init(conf);
        this.scheduler.start();
        this.scheduler.reinitialize(conf, this.resourceManager.getRMContext());
        Assert.assertTrue((String)"Continuous scheduling should be enabled.", (boolean)this.scheduler.isContinuousSchedulingEnabled());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        Assert.assertEquals((long)this.scheduler.getClusterResource().getMemory(), (long)16384L);
        Assert.assertEquals((long)this.scheduler.getClusterResource().getVirtualCores(), (long)16L);
        ApplicationAttemptId appAttemptId = this.createAppAttemptId(this.APP_ID++, this.ATTEMPT_ID++);
        this.createMockRMApp(appAttemptId);
        this.scheduler.addApplication(appAttemptId.getApplicationId(), "queue11", "user11", false);
        this.scheduler.addApplicationAttempt(appAttemptId, false, false);
        ArrayList<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        ResourceRequest request = this.createResourceRequest(1024, 1, "*", 1, 1, true);
        ask.add(request);
        this.scheduler.allocate(appAttemptId, ask, new ArrayList(), null, null);
        Thread.sleep(this.scheduler.getConf().getContinuousSchedulingSleepMs() + 500);
        FSAppAttempt app = this.scheduler.getSchedulerApp(appAttemptId);
        while (app.getCurrentConsumption().equals((Object)Resources.none())) {
        }
        Assert.assertEquals((long)1024L, (long)app.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)1L, (long)app.getCurrentConsumption().getVirtualCores());
        request = this.createResourceRequest(1024, 1, "*", 2, 1, true);
        ask.clear();
        ask.add(request);
        this.scheduler.allocate(appAttemptId, ask, new ArrayList(), null, null);
        while (app.getCurrentConsumption().equals((Object)Resources.createResource((int)1024, (int)1))) {
        }
        Assert.assertEquals((long)2048L, (long)app.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)2L, (long)app.getCurrentConsumption().getVirtualCores());
        HashSet<NodeId> nodes = new HashSet<NodeId>();
        Iterator it = app.getLiveContainers().iterator();
        while (it.hasNext()) {
            nodes.add(((RMContainer)it.next()).getContainer().getNodeId());
        }
        Assert.assertEquals((long)2L, (long)nodes.size());
    }

    @Test
    public void testContinuousSchedulingWithNodeRemoved() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        Assert.assertTrue((String)"Continuous scheduling should be disabled.", (!this.scheduler.isContinuousSchedulingEnabled() ? 1 : 0) != 0);
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        Assert.assertEquals((String)"We should have two alive nodes.", (long)2L, (long)this.scheduler.getNumClusterNodes());
        NodeRemovedSchedulerEvent removeNode1 = new NodeRemovedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)removeNode1);
        Assert.assertEquals((String)"We should only have one alive node.", (long)1L, (long)this.scheduler.getNumClusterNodes());
        try {
            this.scheduler.continuousSchedulingAttempt();
        }
        catch (Exception e) {
            Assert.fail((String)("Exception happened when doing continuous scheduling. " + e.toString()));
        }
    }

    @Test
    public void testContinuousSchedulingInterruptedException() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        FairScheduler spyScheduler = (FairScheduler)Mockito.spy((Object)this.scheduler);
        Assert.assertTrue((String)"Continuous scheduling should be disabled.", (!spyScheduler.isContinuousSchedulingEnabled() ? 1 : 0) != 0);
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        spyScheduler.handle((SchedulerEvent)nodeEvent1);
        Assert.assertEquals((String)"We should have one alive node.", (long)1L, (long)spyScheduler.getNumClusterNodes());
        InterruptedException ie = new InterruptedException();
        ((FairScheduler)Mockito.doThrow((Throwable)new YarnRuntimeException((Throwable)ie)).when((Object)spyScheduler)).attemptScheduling((FSSchedulerNode)Matchers.isA(FSSchedulerNode.class));
        try {
            spyScheduler.continuousSchedulingAttempt();
            Assert.fail((String)"Expected InterruptedException to stop schedulingThread");
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)ie, (Object)e);
        }
    }

    @Test
    public void testDontAllowUndeclaredPools() throws Exception {
        this.conf.setBoolean("yarn.scheduler.fair.allow-undeclared-pools", false);
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"jerry\">");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueManager = this.scheduler.getQueueManager();
        FSLeafQueue jerryQueue = queueManager.getLeafQueue("jerry", false);
        FSLeafQueue defaultQueue = queueManager.getLeafQueue("default", false);
        this.createSchedulingRequest(1024, "jerry", "someuser");
        Assert.assertEquals((long)1L, (long)jerryQueue.getNumRunnableApps());
        this.createSchedulingRequest(1024, "newqueue", "someuser");
        Assert.assertEquals((long)1L, (long)jerryQueue.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)defaultQueue.getNumRunnableApps());
        this.createSchedulingRequest(1024, "default", "someuser");
        Assert.assertEquals((long)1L, (long)jerryQueue.getNumRunnableApps());
        Assert.assertEquals((long)2L, (long)defaultQueue.getNumRunnableApps());
        this.createSchedulingRequest(1024, "default", "jerry");
        Assert.assertEquals((long)2L, (long)jerryQueue.getNumRunnableApps());
        Assert.assertEquals((long)2L, (long)defaultQueue.getNumRunnableApps());
    }

    @Test
    public void testSchedulingOnRemovedNode() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        Assert.assertTrue((String)"Continuous scheduling should be disabled.", (!this.scheduler.isContinuousSchedulingEnabled() ? 1 : 0) != 0);
        ApplicationAttemptId id11 = this.createAppAttemptId(1, 1);
        this.createMockRMApp(id11);
        this.scheduler.addApplication(id11.getApplicationId(), "root.queue1", "user1", false);
        this.scheduler.addApplicationAttempt(id11, false, false);
        ArrayList<ResourceRequest> ask1 = new ArrayList<ResourceRequest>();
        ResourceRequest request1 = this.createResourceRequest(1024, 8, "*", 1, 1, true);
        ask1.add(request1);
        this.scheduler.allocate(id11, ask1, new ArrayList(), null, null);
        String hostName = STATIC_HOST;
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, hostName);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        FSSchedulerNode node = (FSSchedulerNode)this.scheduler.getSchedulerNode(node1.getNodeID());
        NodeRemovedSchedulerEvent removeNode1 = new NodeRemovedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)removeNode1);
        this.scheduler.attemptScheduling(node);
        AppAttemptRemovedSchedulerEvent appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(id11, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent1);
    }

    @Test
    public void testDefaultRuleInitializesProperlyWhenPolicyNotConfigured() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.conf.setBoolean("yarn.scheduler.fair.allow-undeclared-pools", false);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        List rules = this.scheduler.allocConf.placementPolicy.getRules();
        for (QueuePlacementRule rule : rules) {
            if (!(rule instanceof QueuePlacementRule.Default)) continue;
            QueuePlacementRule.Default defaultRule = (QueuePlacementRule.Default)rule;
            Assert.assertNotNull((Object)defaultRule.defaultQueueName);
        }
    }

    @Test(timeout=5000L)
    public void testRecoverRequestAfterPreemption() throws Exception {
        this.conf.setLong("yarn.scheduler.fair.waitTimeBeforeKill", 10L);
        ControlledClock clock = new ControlledClock();
        this.scheduler.setClock((Clock)clock);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        Priority priority2 = Priority.newInstance((int)20);
        String host = STATIC_HOST;
        int GB = 1024;
        RMNode node = MockNodes.newNodeInfo(1, Resources.createResource((int)16384, (int)4), 0, host);
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        ArrayList<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        ResourceRequest nodeLocalRequest = this.createResourceRequest(GB, 1, host, priority2.getPriority(), 1, true);
        ResourceRequest rackLocalRequest = this.createResourceRequest(GB, 1, node.getRackName(), priority2.getPriority(), 1, true);
        ResourceRequest offRackRequest = this.createResourceRequest(GB, 1, "*", priority2.getPriority(), 1, true);
        ask.add(nodeLocalRequest);
        ask.add(rackLocalRequest);
        ask.add(offRackRequest);
        ApplicationAttemptId appAttemptId = this.createSchedulingRequest("queueA", "user1", ask);
        this.scheduler.update();
        NodeUpdateSchedulerEvent nodeUpdate = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeUpdate);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(appAttemptId).getLiveContainers().size());
        FSAppAttempt app = this.scheduler.getSchedulerApp(appAttemptId);
        Assert.assertNull((Object)app.getResourceRequest(priority2, host));
        ContainerId containerId1 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        RMContainer rmContainer = app.getRMContainer(containerId1);
        this.scheduler.warnOrKillContainer(rmContainer);
        clock.tickSec(5);
        this.scheduler.warnOrKillContainer(rmContainer);
        this.scheduler.handle((SchedulerEvent)new ContainerRescheduledEvent(rmContainer));
        List requests = rmContainer.getResourceRequests();
        Assert.assertEquals((long)3L, (long)requests.size());
        for (ResourceRequest request : requests) {
            Assert.assertEquals((long)1L, (long)app.getResourceRequest(priority2, request.getResourceName()).getNumContainers());
        }
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)nodeUpdate);
        List containers = this.scheduler.allocate(appAttemptId, Collections.emptyList(), Collections.emptyList(), null, null).getContainers();
        Assert.assertTrue((containers.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testBlacklistNodes() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        int GB = 1024;
        String host = STATIC_HOST;
        RMNode node = MockNodes.newNodeInfo(1, Resources.createResource((int)16384, (int)16), 0, host);
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        ApplicationAttemptId appAttemptId = this.createSchedulingRequest(1024, "root.default", "user", 1);
        FSAppAttempt app = this.scheduler.getSchedulerApp(appAttemptId);
        this.scheduler.allocate(appAttemptId, Collections.emptyList(), Collections.emptyList(), Collections.singletonList(host), null);
        Assert.assertTrue((boolean)app.isBlacklisted(host));
        this.scheduler.allocate(appAttemptId, Collections.emptyList(), Collections.emptyList(), null, Collections.singletonList(host));
        Assert.assertFalse((boolean)this.scheduler.getSchedulerApp(appAttemptId).isBlacklisted(host));
        List<ResourceRequest> update = Arrays.asList(this.createResourceRequest(1024, node.getHostName(), 1, 0, true));
        this.scheduler.allocate(appAttemptId, update, Collections.emptyList(), Collections.singletonList(host), null);
        Assert.assertTrue((boolean)app.isBlacklisted(host));
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Incorrect number of containers allocated", (long)0L, (long)app.getLiveContainers().size());
        this.scheduler.allocate(appAttemptId, update, Collections.emptyList(), null, Collections.singletonList(host));
        Assert.assertFalse((boolean)app.isBlacklisted(host));
        this.createSchedulingRequest(1024, "root.default", "user", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Incorrect number of containers allocated", (long)1L, (long)app.getLiveContainers().size());
    }

    @Test
    public void testGetAppsInQueue() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ApplicationAttemptId appAttId1 = this.createSchedulingRequest(1024, 1, "queue1.subqueue1", "user1");
        ApplicationAttemptId appAttId2 = this.createSchedulingRequest(1024, 1, "queue1.subqueue2", "user1");
        ApplicationAttemptId appAttId3 = this.createSchedulingRequest(1024, 1, "default", "user1");
        List apps = this.scheduler.getAppsInQueue("queue1.subqueue1");
        Assert.assertEquals((long)1L, (long)apps.size());
        Assert.assertEquals((Object)appAttId1, apps.get(0));
        apps = this.scheduler.getAppsInQueue("root.queue1.subqueue1");
        Assert.assertEquals((long)1L, (long)apps.size());
        Assert.assertEquals((Object)appAttId1, apps.get(0));
        apps = this.scheduler.getAppsInQueue("user1");
        Assert.assertEquals((long)1L, (long)apps.size());
        Assert.assertEquals((Object)appAttId3, apps.get(0));
        apps = this.scheduler.getAppsInQueue("root.user1");
        Assert.assertEquals((long)1L, (long)apps.size());
        Assert.assertEquals((Object)appAttId3, apps.get(0));
        apps = this.scheduler.getAppsInQueue("queue1");
        Assert.assertEquals((long)2L, (long)apps.size());
        HashSet appAttIds = Sets.newHashSet((Object[])new ApplicationAttemptId[]{(ApplicationAttemptId)apps.get(0), (ApplicationAttemptId)apps.get(1)});
        Assert.assertTrue((boolean)appAttIds.contains(appAttId1));
        Assert.assertTrue((boolean)appAttIds.contains(appAttId2));
    }

    @Test
    public void testAddAndRemoveAppFromFairScheduler() throws Exception {
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)this.resourceManager.getResourceScheduler();
        TestSchedulerUtils.verifyAppAddedAndRemovedFromScheduler(scheduler.getSchedulerApplications(), (EventHandler<SchedulerEvent>)scheduler, "default");
    }

    @Test
    public void testMoveRunnableApp() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueMgr = this.scheduler.getQueueManager();
        FSLeafQueue oldQueue = queueMgr.getLeafQueue("queue1", true);
        FSLeafQueue targetQueue = queueMgr.getLeafQueue("queue2", true);
        ApplicationAttemptId appAttId = this.createSchedulingRequest(1024, 1, "queue1", "user1", 3);
        ApplicationId appId = appAttId.getApplicationId();
        RMNode node = MockNodes.newNodeInfo(1, Resources.createResource((int)1024));
        NetUtils.addStaticResolution((String)node.getHostName(), (String)STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((Object)Resource.newInstance((int)1024, (int)1), (Object)oldQueue.getResourceUsage());
        this.scheduler.update();
        Assert.assertEquals((Object)Resource.newInstance((int)3072, (int)3), (Object)oldQueue.getDemand());
        this.scheduler.moveApplication(appId, "queue2");
        FSAppAttempt app = this.scheduler.getSchedulerApp(appAttId);
        Assert.assertSame((Object)targetQueue, (Object)app.getQueue());
        Assert.assertFalse((boolean)oldQueue.isRunnableApp(app));
        Assert.assertTrue((boolean)targetQueue.isRunnableApp(app));
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)oldQueue.getResourceUsage());
        Assert.assertEquals((Object)Resource.newInstance((int)1024, (int)1), (Object)targetQueue.getResourceUsage());
        Assert.assertEquals((long)0L, (long)oldQueue.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)targetQueue.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)queueMgr.getRootQueue().getNumRunnableApps());
        this.scheduler.update();
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)oldQueue.getDemand());
        Assert.assertEquals((Object)Resource.newInstance((int)3072, (int)3), (Object)targetQueue.getDemand());
    }

    @Test
    public void testMoveNonRunnableApp() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueMgr = this.scheduler.getQueueManager();
        FSLeafQueue oldQueue = queueMgr.getLeafQueue("queue1", true);
        FSLeafQueue targetQueue = queueMgr.getLeafQueue("queue2", true);
        this.scheduler.getAllocationConfiguration().queueMaxApps.put("root.queue1", 0);
        this.scheduler.getAllocationConfiguration().queueMaxApps.put("root.queue2", 0);
        ApplicationAttemptId appAttId = this.createSchedulingRequest(1024, 1, "queue1", "user1", 3);
        Assert.assertEquals((long)0L, (long)oldQueue.getNumRunnableApps());
        this.scheduler.moveApplication(appAttId.getApplicationId(), "queue2");
        Assert.assertEquals((long)0L, (long)oldQueue.getNumRunnableApps());
        Assert.assertEquals((long)0L, (long)targetQueue.getNumRunnableApps());
        Assert.assertEquals((long)0L, (long)queueMgr.getRootQueue().getNumRunnableApps());
    }

    @Test
    public void testMoveMakesAppRunnable() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueMgr = this.scheduler.getQueueManager();
        FSLeafQueue oldQueue = queueMgr.getLeafQueue("queue1", true);
        FSLeafQueue targetQueue = queueMgr.getLeafQueue("queue2", true);
        this.scheduler.getAllocationConfiguration().queueMaxApps.put("root.queue1", 0);
        ApplicationAttemptId appAttId = this.createSchedulingRequest(1024, 1, "queue1", "user1", 3);
        FSAppAttempt app = this.scheduler.getSchedulerApp(appAttId);
        Assert.assertTrue((boolean)oldQueue.isNonRunnableApp(app));
        this.scheduler.moveApplication(appAttId.getApplicationId(), "queue2");
        Assert.assertFalse((boolean)oldQueue.isNonRunnableApp(app));
        Assert.assertFalse((boolean)targetQueue.isNonRunnableApp(app));
        Assert.assertTrue((boolean)targetQueue.isRunnableApp(app));
        Assert.assertEquals((long)1L, (long)targetQueue.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)queueMgr.getRootQueue().getNumRunnableApps());
    }

    @Test(expected=YarnException.class)
    public void testMoveWouldViolateMaxAppsConstraints() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueMgr = this.scheduler.getQueueManager();
        queueMgr.getLeafQueue("queue2", true);
        this.scheduler.getAllocationConfiguration().queueMaxApps.put("root.queue2", 0);
        ApplicationAttemptId appAttId = this.createSchedulingRequest(1024, 1, "queue1", "user1", 3);
        this.scheduler.moveApplication(appAttId.getApplicationId(), "queue2");
    }

    @Test(expected=YarnException.class)
    public void testMoveWouldViolateMaxResourcesConstraints() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueMgr = this.scheduler.getQueueManager();
        FSLeafQueue oldQueue = queueMgr.getLeafQueue("queue1", true);
        queueMgr.getLeafQueue("queue2", true);
        this.scheduler.getAllocationConfiguration().maxQueueResources.put("root.queue2", Resource.newInstance((int)1024, (int)1));
        ApplicationAttemptId appAttId = this.createSchedulingRequest(1024, 1, "queue1", "user1", 3);
        RMNode node = MockNodes.newNodeInfo(1, Resources.createResource((int)2048, (int)2));
        NetUtils.addStaticResolution((String)node.getHostName(), (String)STATIC_HOST);
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((Object)Resource.newInstance((int)2048, (int)2), (Object)oldQueue.getResourceUsage());
        this.scheduler.moveApplication(appAttId.getApplicationId(), "queue2");
    }

    @Test(expected=YarnException.class)
    public void testMoveToNonexistentQueue() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        this.scheduler.getQueueManager().getLeafQueue("queue1", true);
        ApplicationAttemptId appAttId = this.createSchedulingRequest(1024, 1, "queue1", "user1", 3);
        this.scheduler.moveApplication(appAttId.getApplicationId(), "queue2");
    }

    @Test
    public void testLowestCommonAncestorForNonRootParent() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        FSLeafQueue aQueue = (FSLeafQueue)Mockito.mock(FSLeafQueue.class);
        FSLeafQueue bQueue = (FSLeafQueue)Mockito.mock(FSLeafQueue.class);
        Mockito.when((Object)aQueue.getName()).thenReturn((Object)"root.queue1.a");
        Mockito.when((Object)bQueue.getName()).thenReturn((Object)"root.queue1.b");
        QueueManager queueManager = this.scheduler.getQueueManager();
        FSParentQueue queue1 = queueManager.getParentQueue("queue1", true);
        queue1.addChildQueue((FSQueue)aQueue);
        queue1.addChildQueue((FSQueue)bQueue);
        FSQueue ancestorQueue = this.scheduler.findLowestCommonAncestorQueue((FSQueue)aQueue, (FSQueue)bQueue);
        Assert.assertEquals((Object)ancestorQueue, (Object)queue1);
    }

    @Test
    public void testLowestCommonAncestorRootParent() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        FSLeafQueue aQueue = (FSLeafQueue)Mockito.mock(FSLeafQueue.class);
        FSLeafQueue bQueue = (FSLeafQueue)Mockito.mock(FSLeafQueue.class);
        Mockito.when((Object)aQueue.getName()).thenReturn((Object)"root.a");
        Mockito.when((Object)bQueue.getName()).thenReturn((Object)"root.b");
        QueueManager queueManager = this.scheduler.getQueueManager();
        FSParentQueue queue1 = queueManager.getParentQueue("root", false);
        queue1.addChildQueue((FSQueue)aQueue);
        queue1.addChildQueue((FSQueue)bQueue);
        FSQueue ancestorQueue = this.scheduler.findLowestCommonAncestorQueue((FSQueue)aQueue, (FSQueue)bQueue);
        Assert.assertEquals((Object)ancestorQueue, (Object)queue1);
    }

    @Test
    public void testLowestCommonAncestorDeeperHierarchy() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        FSQueue aQueue = (FSQueue)Mockito.mock(FSLeafQueue.class);
        FSQueue bQueue = (FSQueue)Mockito.mock(FSLeafQueue.class);
        FSQueue a1Queue = (FSQueue)Mockito.mock(FSLeafQueue.class);
        FSQueue b1Queue = (FSQueue)Mockito.mock(FSLeafQueue.class);
        Mockito.when((Object)a1Queue.getName()).thenReturn((Object)"root.queue1.a.a1");
        Mockito.when((Object)b1Queue.getName()).thenReturn((Object)"root.queue1.b.b1");
        Mockito.when((Object)aQueue.getChildQueues()).thenReturn(Arrays.asList(a1Queue));
        Mockito.when((Object)bQueue.getChildQueues()).thenReturn(Arrays.asList(b1Queue));
        QueueManager queueManager = this.scheduler.getQueueManager();
        FSParentQueue queue1 = queueManager.getParentQueue("queue1", true);
        queue1.addChildQueue(aQueue);
        queue1.addChildQueue(bQueue);
        FSQueue ancestorQueue = this.scheduler.findLowestCommonAncestorQueue(a1Queue, b1Queue);
        Assert.assertEquals((Object)ancestorQueue, (Object)queue1);
    }

    @Test
    public void testThreadLifeCycle() throws InterruptedException {
        this.conf.setBoolean("yarn.scheduler.fair.continuous-scheduling-enabled", true);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        Thread updateThread = this.scheduler.updateThread;
        Thread schedulingThread = this.scheduler.schedulingThread;
        Assert.assertTrue((boolean)updateThread.isAlive());
        Assert.assertTrue((boolean)schedulingThread.isAlive());
        this.scheduler.stop();
        int numRetries = 100;
        while (numRetries-- > 0 && (updateThread.isAlive() || schedulingThread.isAlive())) {
            Thread.sleep(50L);
        }
        Assert.assertNotEquals((String)"One of the threads is still alive", (long)0L, (long)numRetries);
    }

    @Test
    public void testDoubleRemoval() throws Exception {
        String testUser = "user1";
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ApplicationAttemptId attemptId = this.createAppAttemptId(1, 1);
        AppAddedSchedulerEvent appAddedEvent = new AppAddedSchedulerEvent(attemptId.getApplicationId(), testUser, testUser);
        this.scheduler.handle((SchedulerEvent)appAddedEvent);
        AppAttemptAddedSchedulerEvent attemptAddedEvent = new AppAttemptAddedSchedulerEvent(this.createAppAttemptId(1, 1), false);
        this.scheduler.handle((SchedulerEvent)attemptAddedEvent);
        FSAppAttempt attempt = this.scheduler.getSchedulerApp(attemptId);
        AppAttemptRemovedSchedulerEvent attemptRemovedEvent = new AppAttemptRemovedSchedulerEvent(this.createAppAttemptId(1, 1), RMAppAttemptState.FINISHED, false);
        List attemptList = this.scheduler.getAppsInQueue(testUser);
        Assert.assertNotNull((String)"Queue missing", (Object)attemptList);
        Assert.assertTrue((String)"Attempt should be in the queue", (boolean)attemptList.contains(attemptId));
        Assert.assertFalse((String)"Attempt is stopped", (boolean)attempt.isStopped());
        this.scheduler.handle((SchedulerEvent)attemptRemovedEvent);
        attemptList = this.scheduler.getAppsInQueue(testUser);
        Assert.assertFalse((String)"Attempt should not be in the queue", (boolean)attemptList.contains(attemptId));
        Assert.assertTrue((String)"Attempt should have been stopped", (boolean)attempt.isStopped());
        this.scheduler.handle((SchedulerEvent)attemptRemovedEvent);
        Assert.assertTrue((String)"Attempt queue has changed", (boolean)attempt.getQueue().getName().endsWith(testUser));
    }

    @Test(expected=YarnException.class)
    public void testMoveAfterRemoval() throws Exception {
        String testUser = "user1";
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ApplicationAttemptId attemptId = this.createAppAttemptId(1, 1);
        AppAddedSchedulerEvent appAddedEvent = new AppAddedSchedulerEvent(attemptId.getApplicationId(), testUser, testUser);
        this.scheduler.handle((SchedulerEvent)appAddedEvent);
        AppAttemptAddedSchedulerEvent attemptAddedEvent = new AppAttemptAddedSchedulerEvent(this.createAppAttemptId(1, 1), false);
        this.scheduler.handle((SchedulerEvent)attemptAddedEvent);
        FSAppAttempt attempt = this.scheduler.getSchedulerApp(attemptId);
        AppAttemptRemovedSchedulerEvent attemptRemovedEvent = new AppAttemptRemovedSchedulerEvent(this.createAppAttemptId(1, 1), RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)attemptRemovedEvent);
        List attemptList = this.scheduler.getAppsInQueue(testUser);
        Assert.assertNotNull((String)"Queue missing", (Object)attemptList);
        Assert.assertFalse((String)"Attempt should not be in the queue", (boolean)attemptList.contains(attemptId));
        Assert.assertTrue((String)"Attempt should have been stopped", (boolean)attempt.isStopped());
        Assert.assertTrue((String)"Attempt queue has changed", (boolean)attempt.getQueue().getName().endsWith(testUser));
        this.scheduler.moveApplication(attemptId.getApplicationId(), "default");
    }

    @Test
    public void testPerfMetricsInited() {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        MetricsCollectorImpl collector = new MetricsCollectorImpl();
        this.scheduler.fsOpDurations.getMetrics((MetricsCollector)collector, true);
        Assert.assertEquals((String)"Incorrect number of perf metrics", (long)1L, (long)collector.getRecords().size());
    }

    @Test
    public void testContainerAllocationWithUnresolvedNodeAddress() throws Exception {
        SecurityUtil.setTokenServiceUseIp((boolean)true);
        String user = "user1";
        String queue = "queue1";
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, "unresolved");
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, STATIC_HOST);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(4096, "queue1", "user1", 3);
        this.scheduler.update();
        FSAppAttempt app1 = this.scheduler.getSchedulerApp(attId1);
        NodeUpdateSchedulerEvent updateEvent1 = new NodeUpdateSchedulerEvent(node1);
        NodeUpdateSchedulerEvent updateEvent2 = new NodeUpdateSchedulerEvent(node2);
        for (int i = 0; i < 3; ++i) {
            ArrayList<ResourceRequest> ask1 = new ArrayList<ResourceRequest>();
            ResourceRequest request1 = this.createResourceRequest(256, "*", 1, 1, true);
            ask1.add(request1);
            this.scheduler.allocate(attId1, ask1, new ArrayList(), null, null);
            this.scheduler.handle((SchedulerEvent)updateEvent1);
            this.scheduler.handle((SchedulerEvent)updateEvent2);
        }
        Collection liveContainers = app1.getLiveContainers();
        for (RMContainer liveContainer : liveContainers) {
            System.out.println(liveContainer.getAllocatedNode());
        }
    }

    @Test
    public void testQueueNameWithTrailingSpace() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        ApplicationAttemptId appAttemptId1 = this.createAppAttemptId(1, 1);
        AppAddedSchedulerEvent appAddedEvent1 = new AppAddedSchedulerEvent(appAttemptId1.getApplicationId(), "A", "user1");
        this.scheduler.handle((SchedulerEvent)appAddedEvent1);
        Assert.assertEquals((long)2L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        Assert.assertNotNull(this.scheduler.getSchedulerApplications().get(appAttemptId1.getApplicationId()));
        AppAttemptAddedSchedulerEvent attempAddedEvent = new AppAttemptAddedSchedulerEvent(appAttemptId1, false);
        this.scheduler.handle((SchedulerEvent)attempAddedEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueue("A", true).getNumRunnableApps());
        Assert.assertNotNull((Object)this.scheduler.getSchedulerApp(appAttemptId1));
        ApplicationAttemptId appAttemptId2 = this.createAppAttemptId(2, 1);
        AppAddedSchedulerEvent appAddedEvent2 = new AppAddedSchedulerEvent(appAttemptId2.getApplicationId(), "A ", "user1");
        this.scheduler.handle((SchedulerEvent)appAddedEvent2);
        Assert.assertEquals((long)2L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        Assert.assertNotNull(this.scheduler.getSchedulerApplications().get(appAttemptId2.getApplicationId()));
        attempAddedEvent = new AppAttemptAddedSchedulerEvent(appAttemptId2, false);
        this.scheduler.handle((SchedulerEvent)attempAddedEvent);
        Assert.assertEquals((long)2L, (long)this.scheduler.getQueueManager().getLeafQueue("A", true).getNumRunnableApps());
        Assert.assertNotNull((Object)this.scheduler.getSchedulerApp(appAttemptId2));
        ApplicationAttemptId appAttemptId3 = this.createAppAttemptId(3, 1);
        AppAddedSchedulerEvent appAddedEvent3 = new AppAddedSchedulerEvent(appAttemptId3.getApplicationId(), "B.C", "user1");
        this.scheduler.handle((SchedulerEvent)appAddedEvent3);
        Assert.assertEquals((long)3L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        Assert.assertNotNull(this.scheduler.getSchedulerApplications().get(appAttemptId3.getApplicationId()));
        attempAddedEvent = new AppAttemptAddedSchedulerEvent(appAttemptId3, false);
        this.scheduler.handle((SchedulerEvent)attempAddedEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueue("B.C", true).getNumRunnableApps());
        Assert.assertNotNull((Object)this.scheduler.getSchedulerApp(appAttemptId3));
    }

    @Test
    public void testEmptyQueueNameInConfigFile() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"\">");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        try {
            this.scheduler.init(this.conf);
            Assert.fail((String)"scheduler init should fail because empty queue name.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Failed to initialize FairScheduler"));
        }
    }
}

