/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.util.SystemClock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFSParentQueue {
    private FairSchedulerConfiguration conf;
    private QueueManager queueManager;
    private Set<FSQueue> notEmptyQueues;

    @Before
    public void setUp() throws Exception {
        this.conf = new FairSchedulerConfiguration();
        FairScheduler scheduler = (FairScheduler)Mockito.mock(FairScheduler.class);
        AllocationConfiguration allocConf = new AllocationConfiguration((Configuration)this.conf);
        Mockito.when((Object)scheduler.getAllocationConfiguration()).thenReturn((Object)allocConf);
        Mockito.when((Object)scheduler.getConf()).thenReturn((Object)this.conf);
        SystemClock clock = new SystemClock();
        Mockito.when((Object)scheduler.getClock()).thenReturn((Object)clock);
        this.notEmptyQueues = new HashSet<FSQueue>();
        this.queueManager = new QueueManager(scheduler){

            public boolean isEmpty(FSQueue queue) {
                return !TestFSParentQueue.this.notEmptyQueues.contains(queue);
            }
        };
        FSQueueMetrics.forQueue((String)"root", null, (boolean)true, (Configuration)this.conf);
        this.queueManager.initialize((Configuration)this.conf);
    }

    @Test
    public void testConcurrentChangeToGetChildQueue() {
        this.queueManager.getLeafQueue("parent.child", true);
        this.queueManager.getLeafQueue("parent.child2", true);
        FSParentQueue test = this.queueManager.getParentQueue("parent", false);
        Assert.assertEquals((long)2L, (long)test.getChildQueues().size());
        boolean first = true;
        int childQueuesFound = 0;
        for (FSQueue childQueue : test.getChildQueues()) {
            if (first) {
                first = false;
                this.queueManager.getLeafQueue("parent.child3", true);
            }
            ++childQueuesFound;
        }
        Assert.assertEquals((long)2L, (long)childQueuesFound);
        Assert.assertEquals((long)3L, (long)test.getChildQueues().size());
    }
}

