/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerTestBase;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestContinuousScheduling
extends FairSchedulerTestBase {
    private ControlledClock mockClock;

    @Override
    public Configuration createConfiguration() {
        Configuration conf = super.createConfiguration();
        conf.setBoolean("yarn.scheduler.fair.continuous-scheduling-enabled", true);
        conf.setInt("yarn.scheduler.fair.locality-delay-node-ms", 100);
        conf.setInt("yarn.scheduler.fair.locality-delay-rack-ms", 100);
        return conf;
    }

    @Before
    public void setup() {
        this.mockClock = new ControlledClock();
        this.conf = this.createConfiguration();
        this.resourceManager = new MockRM(this.conf);
        this.resourceManager.start();
        this.scheduler = (FairScheduler)this.resourceManager.getResourceScheduler();
        this.scheduler.setClock((Clock)this.mockClock);
        Assert.assertTrue((boolean)this.scheduler.isContinuousSchedulingEnabled());
        Assert.assertEquals((long)5L, (long)this.scheduler.getContinuousSchedulingSleepMs());
        Assert.assertEquals((Object)this.mockClock, (Object)this.scheduler.getClock());
    }

    @After
    public void teardown() {
        if (this.resourceManager != null) {
            this.resourceManager.stop();
            this.resourceManager = null;
        }
    }

    @Test(timeout=60000L)
    public void testSchedulingDelay() throws InterruptedException {
        String host = "127.0.0.1";
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)4096, (int)4), 1, host);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        NodeUpdateSchedulerEvent nodeUpdateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeUpdateEvent);
        ApplicationAttemptId appAttemptId = this.createAppAttemptId(this.APP_ID++, this.ATTEMPT_ID++);
        this.createMockRMApp(appAttemptId);
        this.scheduler.addApplication(appAttemptId.getApplicationId(), "queue11", "user11", false);
        this.scheduler.addApplicationAttempt(appAttemptId, false, false);
        ArrayList<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        ask.add(this.createResourceRequest(1024, 1, "*", 1, 1, true));
        this.scheduler.allocate(appAttemptId, ask, new ArrayList(), null, null);
        FSAppAttempt app = this.scheduler.getSchedulerApp(appAttemptId);
        this.mockClock.tickSec(1);
        while (1024 != app.getCurrentConsumption().getMemory()) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)1024L, (long)app.getCurrentConsumption().getMemory());
    }
}

