/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.PlanQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ReservationQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.QueueEntitlement;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestReservationQueue {
    CapacitySchedulerConfiguration csConf;
    CapacitySchedulerContext csContext;
    static final int GB = 1024;
    private final ResourceCalculator resourceCalculator = new DefaultResourceCalculator();
    ReservationQueue reservationQueue;

    @Before
    public void setup() throws IOException {
        this.csConf = new CapacitySchedulerConfiguration();
        YarnConfiguration conf = new YarnConfiguration();
        this.csContext = (CapacitySchedulerContext)Mockito.mock(CapacitySchedulerContext.class);
        Mockito.when((Object)this.csContext.getConfiguration()).thenReturn((Object)this.csConf);
        Mockito.when((Object)this.csContext.getConf()).thenReturn((Object)conf);
        Mockito.when((Object)this.csContext.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024, (int)1));
        Mockito.when((Object)this.csContext.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)16384, (int)32));
        Mockito.when((Object)this.csContext.getClusterResource()).thenReturn((Object)Resources.createResource((int)0x190000, (int)3200));
        Mockito.when((Object)this.csContext.getResourceCalculator()).thenReturn((Object)this.resourceCalculator);
        RMContext mockRMContext = TestUtils.getMockRMContext();
        Mockito.when((Object)this.csContext.getRMContext()).thenReturn((Object)mockRMContext);
        PlanQueue pq = new PlanQueue(this.csContext, "root", null, null);
        this.reservationQueue = new ReservationQueue(this.csContext, "a", pq);
    }

    @Test
    public void testAddSubtractCapacity() throws Exception {
        this.reservationQueue.setCapacity(1.0f);
        Assert.assertTrue((String)(" actual capacity: " + this.reservationQueue.getCapacity()), (this.reservationQueue.getCapacity() - 1.0f < 1.0E-4f ? 1 : 0) != 0);
        this.reservationQueue.setEntitlement(new QueueEntitlement(0.9f, 1.0f));
        Assert.assertTrue((String)(" actual capacity: " + this.reservationQueue.getCapacity()), ((double)this.reservationQueue.getCapacity() - 0.9 < (double)1.0E-4f ? 1 : 0) != 0);
        this.reservationQueue.setEntitlement(new QueueEntitlement(1.0f, 1.0f));
        Assert.assertTrue((String)(" actual capacity: " + this.reservationQueue.getCapacity()), (this.reservationQueue.getCapacity() - 1.0f < 1.0E-4f ? 1 : 0) != 0);
        this.reservationQueue.setEntitlement(new QueueEntitlement(0.0f, 1.0f));
        Assert.assertTrue((String)(" actual capacity: " + this.reservationQueue.getCapacity()), (this.reservationQueue.getCapacity() < 1.0E-4f ? 1 : 0) != 0);
        try {
            this.reservationQueue.setEntitlement(new QueueEntitlement(1.1f, 1.0f));
            Assert.fail();
        }
        catch (SchedulerDynamicEditException iae) {
            Assert.assertTrue((String)(" actual capacity: " + this.reservationQueue.getCapacity()), (this.reservationQueue.getCapacity() - 1.0f < 1.0E-4f ? 1 : 0) != 0);
        }
        try {
            this.reservationQueue.setEntitlement(new QueueEntitlement(-0.1f, 1.0f));
            Assert.fail();
        }
        catch (SchedulerDynamicEditException iae) {
            Assert.assertTrue((String)(" actual capacity: " + this.reservationQueue.getCapacity()), (this.reservationQueue.getCapacity() - 1.0f < 1.0E-4f ? 1 : 0) != 0);
        }
    }
}

