/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.AbstractSchedulerPlanFollower;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.CapacityOverTimePolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryPlan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAgent;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.SharingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.junit.Assert;
import org.mockito.Mockito;

public abstract class TestSchedulerPlanFollowerBase {
    static final int GB = 1024;
    protected Clock mClock = null;
    protected ResourceScheduler scheduler = null;
    protected ReservationAgent mAgent;
    protected Resource minAlloc = Resource.newInstance((int)1024, (int)1);
    protected Resource maxAlloc = Resource.newInstance((int)8192, (int)8);
    protected CapacityOverTimePolicy policy = new CapacityOverTimePolicy();
    protected Plan plan;
    private ResourceCalculator res = new DefaultResourceCalculator();

    protected void testPlanFollower(boolean isMove) throws PlanningException, InterruptedException, AccessControlException {
        this.plan = new InMemoryPlan(this.scheduler.getRootQueueMetrics(), (SharingPolicy)this.policy, this.mAgent, this.scheduler.getClusterResource(), 1L, this.res, this.scheduler.getMinimumResourceCapability(), this.maxAlloc, "dedicated", null, isMove);
        long ts = System.currentTimeMillis();
        ReservationId r1 = ReservationId.newInstance((long)ts, (long)1L);
        int[] f1 = new int[]{10, 10, 10, 10, 10};
        Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(r1, null, "u3", "dedicated", 0L, (long)(0 + f1.length), ReservationSystemTestUtil.generateAllocation(0L, 1L, f1), this.res, this.minAlloc)));
        ReservationId r2 = ReservationId.newInstance((long)ts, (long)2L);
        Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(r2, null, "u3", "dedicated", 3L, (long)(3 + f1.length), ReservationSystemTestUtil.generateAllocation(3L, 1L, f1), this.res, this.minAlloc)));
        ReservationId r3 = ReservationId.newInstance((long)ts, (long)3L);
        int[] f2 = new int[]{0, 10, 20, 10, 0};
        Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(r3, null, "u4", "dedicated", 10L, (long)(10 + f2.length), ReservationSystemTestUtil.generateAllocation(10L, 1L, f2), this.res, this.minAlloc)));
        AbstractSchedulerPlanFollower planFollower = this.createPlanFollower();
        Mockito.when((Object)this.mClock.getTime()).thenReturn((Object)0L);
        planFollower.run();
        Queue q = this.getReservationQueue(r1.toString());
        this.assertReservationQueueExists(r1);
        String user_0 = "test-user";
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId_0 = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        AppAddedSchedulerEvent addAppEvent = new AppAddedSchedulerEvent(appId, q.getQueueName(), user_0);
        this.scheduler.handle((Event)addAppEvent);
        AppAttemptAddedSchedulerEvent appAttemptAddedEvent = new AppAttemptAddedSchedulerEvent(appAttemptId_0, false);
        this.scheduler.handle((Event)appAttemptAddedEvent);
        Queue defQ = this.getDefaultQueue();
        Assert.assertEquals((long)0L, (long)this.getNumberOfApplications(defQ));
        this.assertReservationQueueExists(r1, 0.1, 0.1);
        Assert.assertEquals((long)1L, (long)this.getNumberOfApplications(q));
        this.assertReservationQueueDoesNotExist(r2);
        this.assertReservationQueueDoesNotExist(r3);
        Mockito.when((Object)this.mClock.getTime()).thenReturn((Object)3L);
        planFollower.run();
        Assert.assertEquals((long)0L, (long)this.getNumberOfApplications(defQ));
        this.assertReservationQueueExists(r1, 0.1, 0.1);
        Assert.assertEquals((long)1L, (long)this.getNumberOfApplications(q));
        this.assertReservationQueueExists(r2, 0.1, 0.1);
        this.assertReservationQueueDoesNotExist(r3);
        Mockito.when((Object)this.mClock.getTime()).thenReturn((Object)10L);
        planFollower.run();
        q = this.getReservationQueue(r1.toString());
        if (isMove) {
            Assert.assertEquals((long)1L, (long)this.getNumberOfApplications(defQ));
            Assert.assertNull((Object)q);
        } else {
            Assert.assertEquals((long)0L, (long)this.getNumberOfApplications(defQ));
            Assert.assertNotNull((Object)q);
            AppAttemptRemovedSchedulerEvent appAttemptRemovedEvent = new AppAttemptRemovedSchedulerEvent(appAttemptId_0, RMAppAttemptState.KILLED, false);
            this.scheduler.handle((Event)appAttemptRemovedEvent);
        }
        this.assertReservationQueueDoesNotExist(r2);
        this.assertReservationQueueExists(r3, 0.0, 1.0);
        Mockito.when((Object)this.mClock.getTime()).thenReturn((Object)11L);
        planFollower.run();
        if (isMove) {
            Assert.assertEquals((long)1L, (long)this.getNumberOfApplications(defQ));
        } else {
            Assert.assertEquals((long)0L, (long)this.getNumberOfApplications(defQ));
        }
        this.assertReservationQueueDoesNotExist(r1);
        this.assertReservationQueueDoesNotExist(r2);
        this.assertReservationQueueExists(r3, 0.1, 0.1);
        Mockito.when((Object)this.mClock.getTime()).thenReturn((Object)12L);
        planFollower.run();
        this.assertReservationQueueDoesNotExist(r1);
        this.assertReservationQueueDoesNotExist(r2);
        this.assertReservationQueueExists(r3, 0.2, 0.2);
        Mockito.when((Object)this.mClock.getTime()).thenReturn((Object)16L);
        planFollower.run();
        this.assertReservationQueueDoesNotExist(r1);
        this.assertReservationQueueDoesNotExist(r2);
        this.assertReservationQueueDoesNotExist(r3);
        this.verifyCapacity(defQ);
    }

    protected abstract Queue getReservationQueue(String var1);

    protected abstract void verifyCapacity(Queue var1);

    protected abstract Queue getDefaultQueue();

    protected abstract int getNumberOfApplications(Queue var1);

    protected abstract AbstractSchedulerPlanFollower createPlanFollower();

    protected abstract void assertReservationQueueExists(ReservationId var1);

    protected abstract void assertReservationQueueExists(ReservationId var1, double var2, double var4);

    protected abstract void assertReservationQueueDoesNotExist(ReservationId var1);
}

