/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.AbstractReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.FairReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFairReservationSystem {
    private static final String ALLOC_FILE = new File(FairSchedulerTestBase.TEST_DIR, TestFairReservationSystem.class.getName() + ".xml").getAbsolutePath();
    private Configuration conf;
    private FairScheduler scheduler;
    private FairSchedulerTestBase testHelper = new FairSchedulerTestBase();

    protected Configuration createConfiguration() {
        Configuration conf = this.testHelper.createConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FairScheduler.class, ResourceScheduler.class);
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        return conf;
    }

    @Before
    public void setup() throws IOException {
        this.conf = this.createConfiguration();
    }

    @After
    public void teardown() {
        this.conf = null;
    }

    @Test
    public void testFairReservationSystemInitialize() throws IOException {
        ReservationSystemTestUtil.setupFSAllocationFile(ALLOC_FILE);
        ReservationSystemTestUtil testUtil = new ReservationSystemTestUtil();
        RMContext mockRMContext = ReservationSystemTestUtil.createRMContext(this.conf);
        this.scheduler = ReservationSystemTestUtil.setupFairScheduler(testUtil, mockRMContext, this.conf, 10);
        FairReservationSystem reservationSystem = new FairReservationSystem();
        reservationSystem.setRMContext(mockRMContext);
        try {
            reservationSystem.reinitialize((Configuration)this.scheduler.getConf(), mockRMContext);
        }
        catch (YarnException e) {
            Assert.fail((String)e.getMessage());
        }
        ReservationSystemTestUtil.validateReservationQueue((AbstractReservationSystem)reservationSystem, testUtil.getFullReservationQueueName());
    }

    @Test
    public void testFairReservationSystemReinitialize() throws IOException {
        ReservationSystemTestUtil.setupFSAllocationFile(ALLOC_FILE);
        ReservationSystemTestUtil testUtil = new ReservationSystemTestUtil();
        RMContext mockRMContext = ReservationSystemTestUtil.createRMContext(this.conf);
        this.scheduler = ReservationSystemTestUtil.setupFairScheduler(testUtil, mockRMContext, this.conf, 10);
        FairReservationSystem reservationSystem = new FairReservationSystem();
        reservationSystem.setRMContext(mockRMContext);
        try {
            reservationSystem.reinitialize((Configuration)this.scheduler.getConf(), mockRMContext);
        }
        catch (YarnException e) {
            Assert.fail((String)e.getMessage());
        }
        String planQNam = testUtil.getFullReservationQueueName();
        ReservationSystemTestUtil.validateReservationQueue((AbstractReservationSystem)reservationSystem, planQNam);
        ReservationSystemTestUtil.updateFSAllocationFile(ALLOC_FILE);
        this.scheduler.reinitialize(this.conf, mockRMContext);
        try {
            reservationSystem.reinitialize(this.conf, mockRMContext);
        }
        catch (YarnException e) {
            Assert.fail((String)e.getMessage());
        }
        String newQueue = "root.reservation";
        ReservationSystemTestUtil.validateNewReservationQueue((AbstractReservationSystem)reservationSystem, newQueue);
    }
}

