/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.CapacitySchedulerPlanFollower;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAgent;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.TestSchedulerPlanFollowerBase;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestCapacitySchedulerPlanFollower
extends TestSchedulerPlanFollowerBase {
    private RMContext rmContext;
    private RMContext spyRMContext;
    private CapacitySchedulerContext csContext;
    private CapacityScheduler cs;
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() throws Exception {
        CapacityScheduler spyCs = new CapacityScheduler();
        this.cs = (CapacityScheduler)Mockito.spy((Object)spyCs);
        this.scheduler = this.cs;
        this.rmContext = TestUtils.getMockRMContext();
        this.spyRMContext = (RMContext)Mockito.spy((Object)this.rmContext);
        ConcurrentMap spyApps = (ConcurrentMap)Mockito.spy(new ConcurrentHashMap());
        RMApp rmApp = (RMApp)Mockito.mock(RMApp.class);
        Mockito.when((Object)rmApp.getRMAppAttempt((ApplicationAttemptId)Matchers.any())).thenReturn(null);
        ((ConcurrentMap)Mockito.doReturn((Object)rmApp).when((Object)spyApps)).get((ApplicationId)Matchers.any());
        Mockito.when((Object)this.spyRMContext.getRMApps()).thenReturn((Object)spyApps);
        Mockito.when((Object)this.spyRMContext.getScheduler()).thenReturn((Object)this.scheduler);
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        ReservationSystemTestUtil.setupQueueConfiguration(csConf);
        this.cs.setConf((Configuration)csConf);
        this.csContext = (CapacitySchedulerContext)Mockito.mock(CapacitySchedulerContext.class);
        Mockito.when((Object)this.csContext.getConfiguration()).thenReturn((Object)csConf);
        Mockito.when((Object)this.csContext.getConf()).thenReturn((Object)csConf);
        Mockito.when((Object)this.csContext.getMinimumResourceCapability()).thenReturn((Object)this.minAlloc);
        Mockito.when((Object)this.csContext.getMaximumResourceCapability()).thenReturn((Object)this.maxAlloc);
        Mockito.when((Object)this.csContext.getClusterResource()).thenReturn((Object)Resources.createResource((int)0x190000, (int)3200));
        Mockito.when((Object)this.scheduler.getClusterResource()).thenReturn((Object)Resources.createResource((int)128000, (int)125));
        Mockito.when((Object)this.csContext.getResourceCalculator()).thenReturn((Object)new DefaultResourceCalculator());
        RMContainerTokenSecretManager containerTokenSecretManager = new RMContainerTokenSecretManager((Configuration)csConf);
        containerTokenSecretManager.rollMasterKey();
        Mockito.when((Object)this.csContext.getContainerTokenSecretManager()).thenReturn((Object)containerTokenSecretManager);
        this.cs.setRMContext(this.spyRMContext);
        this.cs.init((Configuration)csConf);
        this.cs.start();
        this.setupPlanFollower();
    }

    private void setupPlanFollower() throws Exception {
        ReservationSystemTestUtil testUtil = new ReservationSystemTestUtil();
        this.mClock = (Clock)Mockito.mock(Clock.class);
        this.mAgent = (ReservationAgent)Mockito.mock(ReservationAgent.class);
        String reservationQ = testUtil.getFullReservationQueueName();
        CapacitySchedulerConfiguration csConf = this.cs.getConfiguration();
        csConf.setReservationWindow(reservationQ, 20L);
        csConf.setMaximumCapacity(reservationQ, 40.0f);
        csConf.setAverageCapacity(reservationQ, 20.0f);
        this.policy.init(reservationQ, (ReservationSchedulerConfiguration)csConf);
    }

    @Test
    public void testWithMoveOnExpiry() throws PlanningException, InterruptedException, AccessControlException {
        this.testPlanFollower(true);
    }

    @Test
    public void testWithKillOnExpiry() throws PlanningException, InterruptedException, AccessControlException {
        this.testPlanFollower(false);
    }

    @Override
    protected void verifyCapacity(Queue defQ) {
        CSQueue csQueue = (CSQueue)defQ;
        Assert.assertTrue(((double)csQueue.getCapacity() > 0.9 ? 1 : 0) != 0);
    }

    @Override
    protected Queue getDefaultQueue() {
        return this.cs.getQueue("dedicated-default");
    }

    @Override
    protected int getNumberOfApplications(Queue queue) {
        CSQueue csQueue = (CSQueue)queue;
        int numberOfApplications = csQueue.getNumApplications();
        return numberOfApplications;
    }

    protected CapacitySchedulerPlanFollower createPlanFollower() {
        CapacitySchedulerPlanFollower planFollower = new CapacitySchedulerPlanFollower();
        planFollower.init(this.mClock, this.scheduler, Collections.singletonList(this.plan));
        return planFollower;
    }

    @Override
    protected void assertReservationQueueExists(ReservationId r) {
        CSQueue q = this.cs.getQueue(r.toString());
        Assert.assertNotNull((Object)q);
    }

    @Override
    protected void assertReservationQueueExists(ReservationId r2, double expectedCapacity, double expectedMaxCapacity) {
        CSQueue q = this.cs.getQueue(r2.toString());
        Assert.assertNotNull((Object)q);
        Assert.assertEquals((double)expectedCapacity, (double)q.getCapacity(), (double)0.01);
        Assert.assertEquals((double)expectedMaxCapacity, (double)q.getMaximumCapacity(), (double)1.0);
    }

    @Override
    protected void assertReservationQueueDoesNotExist(ReservationId r2) {
        CSQueue q2 = this.cs.getQueue(r2.toString());
        Assert.assertNull((Object)q2);
    }

    public static ApplicationACLsManager mockAppACLsManager() {
        Configuration conf = new Configuration();
        return new ApplicationACLsManager(conf);
    }

    @After
    public void tearDown() throws Exception {
        if (this.scheduler != null) {
            this.cs.stop();
        }
    }

    @Override
    protected Queue getReservationQueue(String reservationId) {
        return this.cs.getQueue(reservationId);
    }
}

