/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.applicationsmanager;

import java.security.PrivilegedExceptionAction;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAMRMRPCNodeUpdates {
    private MockRM rm;
    ApplicationMasterService amService = null;
    DrainDispatcher dispatcher = null;

    @Before
    public void setUp() {
        this.dispatcher = new DrainDispatcher();
        this.rm = new MockRM(){

            public void init(Configuration conf) {
                conf.set("yarn.scheduler.capacity.maximum-am-resource-percent", "1.0");
                super.init(conf);
            }

            protected EventHandler<SchedulerEvent> createSchedulerEventDispatcher() {
                return new ResourceManager.SchedulerEventDispatcher(this.scheduler){

                    public void handle(SchedulerEvent event) {
                        scheduler.handle((Event)event);
                    }
                };
            }

            @Override
            protected Dispatcher createDispatcher() {
                return TestAMRMRPCNodeUpdates.this.dispatcher;
            }
        };
        this.rm.start();
        this.amService = this.rm.getApplicationMasterService();
    }

    @After
    public void tearDown() {
        if (this.rm != null) {
            this.rm.stop();
        }
    }

    private void syncNodeHeartbeat(MockNM nm, boolean health) throws Exception {
        nm.nodeHeartbeat(health);
        this.dispatcher.await();
    }

    private void syncNodeLost(MockNM nm) throws Exception {
        this.rm.sendNodeStarted(nm);
        this.rm.NMwaitForState(nm.getNodeId(), NodeState.RUNNING);
        this.rm.sendNodeLost(nm);
        this.dispatcher.await();
    }

    private AllocateResponse allocate(ApplicationAttemptId attemptId, final AllocateRequest req) throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)attemptId.toString());
        Token token = ((RMApp)this.rm.getRMContext().getRMApps().get(attemptId.getApplicationId())).getRMAppAttempt(attemptId).getAMRMToken();
        ugi.addTokenIdentifier(token.decodeIdentifier());
        return (AllocateResponse)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<AllocateResponse>(){

            @Override
            public AllocateResponse run() throws Exception {
                return TestAMRMRPCNodeUpdates.this.amService.allocate(req);
            }
        });
    }

    @Test
    public void testAMRMUnusableNodes() throws Exception {
        MockNM nm1 = this.rm.registerNode("127.0.0.1:1234", 10000);
        MockNM nm2 = this.rm.registerNode("127.0.0.2:1234", 10000);
        MockNM nm3 = this.rm.registerNode("127.0.0.3:1234", 10000);
        MockNM nm4 = this.rm.registerNode("127.0.0.4:1234", 10000);
        this.dispatcher.await();
        RMApp app1 = this.rm.submitApp(2000);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = this.rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        AllocateRequest allocateRequest1 = AllocateRequest.newInstance((int)0, (float)0.0f, null, null, null);
        AllocateResponse response1 = this.allocate(attempt1.getAppAttemptId(), allocateRequest1);
        List updatedNodes = response1.getUpdatedNodes();
        Assert.assertEquals((long)0L, (long)updatedNodes.size());
        this.syncNodeHeartbeat(nm4, false);
        allocateRequest1 = AllocateRequest.newInstance((int)response1.getResponseId(), (float)0.0f, null, null, null);
        response1 = this.allocate(attempt1.getAppAttemptId(), allocateRequest1);
        updatedNodes = response1.getUpdatedNodes();
        Assert.assertEquals((long)1L, (long)updatedNodes.size());
        NodeReport nr = (NodeReport)updatedNodes.iterator().next();
        Assert.assertEquals((Object)nm4.getNodeId(), (Object)nr.getNodeId());
        Assert.assertEquals((Object)NodeState.UNHEALTHY, (Object)nr.getNodeState());
        response1 = this.allocate(attempt1.getAppAttemptId(), allocateRequest1);
        updatedNodes = response1.getUpdatedNodes();
        Assert.assertEquals((long)1L, (long)updatedNodes.size());
        nr = (NodeReport)updatedNodes.iterator().next();
        Assert.assertEquals((Object)nm4.getNodeId(), (Object)nr.getNodeId());
        Assert.assertEquals((Object)NodeState.UNHEALTHY, (Object)nr.getNodeState());
        this.syncNodeLost(nm3);
        allocateRequest1 = AllocateRequest.newInstance((int)response1.getResponseId(), (float)0.0f, null, null, null);
        response1 = this.allocate(attempt1.getAppAttemptId(), allocateRequest1);
        updatedNodes = response1.getUpdatedNodes();
        Assert.assertEquals((long)1L, (long)updatedNodes.size());
        nr = (NodeReport)updatedNodes.iterator().next();
        Assert.assertEquals((Object)nm3.getNodeId(), (Object)nr.getNodeId());
        Assert.assertEquals((Object)NodeState.LOST, (Object)nr.getNodeState());
        RMApp app2 = this.rm.submitApp(2000);
        nm2.nodeHeartbeat(true);
        RMAppAttempt attempt2 = app2.getCurrentAppAttempt();
        MockAM am2 = this.rm.sendAMLaunched(attempt2.getAppAttemptId());
        am2.registerAppAttempt();
        AllocateRequest allocateRequest2 = AllocateRequest.newInstance((int)0, (float)0.0f, null, null, null);
        AllocateResponse response2 = this.allocate(attempt2.getAppAttemptId(), allocateRequest2);
        updatedNodes = response2.getUpdatedNodes();
        Assert.assertEquals((long)0L, (long)updatedNodes.size());
        this.syncNodeHeartbeat(nm4, true);
        allocateRequest1 = AllocateRequest.newInstance((int)response1.getResponseId(), (float)0.0f, null, null, null);
        response1 = this.allocate(attempt1.getAppAttemptId(), allocateRequest1);
        updatedNodes = response1.getUpdatedNodes();
        Assert.assertEquals((long)1L, (long)updatedNodes.size());
        nr = (NodeReport)updatedNodes.iterator().next();
        Assert.assertEquals((Object)nm4.getNodeId(), (Object)nr.getNodeId());
        Assert.assertEquals((Object)NodeState.RUNNING, (Object)nr.getNodeState());
        allocateRequest2 = AllocateRequest.newInstance((int)response2.getResponseId(), (float)0.0f, null, null, null);
        response2 = this.allocate(attempt2.getAppAttemptId(), allocateRequest2);
        updatedNodes = response2.getUpdatedNodes();
        Assert.assertEquals((long)1L, (long)updatedNodes.size());
        nr = (NodeReport)updatedNodes.iterator().next();
        Assert.assertEquals((Object)nm4.getNodeId(), (Object)nr.getNodeId());
        Assert.assertEquals((Object)NodeState.RUNNING, (Object)nr.getNodeState());
        allocateRequest2 = AllocateRequest.newInstance((int)response2.getResponseId(), (float)0.0f, null, null, null);
        response2 = this.allocate(attempt2.getAppAttemptId(), allocateRequest2);
        updatedNodes = response2.getUpdatedNodes();
        Assert.assertEquals((long)0L, (long)updatedNodes.size());
    }
}

