/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.api.records.NodeAction;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.YarnVersionInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestResourceTrackerService {
    private static final File TEMP_DIR = new File(System.getProperty("test.build.data", "/tmp"), "decommision");
    private final File hostFile = new File(TEMP_DIR + File.separator + "hostFile.txt");
    private MockRM rm;

    @Test(timeout=50000L)
    public void testGetNextHeartBeatInterval() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodemanagers.heartbeat-interval-ms", "4000");
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertEquals((long)4000L, (long)nodeHeartbeat.getNextHeartBeatInterval());
        NodeHeartbeatResponse nodeHeartbeat2 = nm2.nodeHeartbeat(true);
        Assert.assertEquals((long)4000L, (long)nodeHeartbeat2.getNextHeartBeatInterval());
    }

    @Test
    public void testDecommissionWithIncludeHosts() throws Exception {
        this.writeToHostsFile("localhost", "host1", "host2");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        MockNM nm3 = this.rm.registerNode("localhost:4433", 1024);
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        assert (metrics != null);
        int metricCount = metrics.getNumDecommisionedNMs();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm3.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        String ip = NetUtils.normalizeHostName((String)"localhost");
        this.writeToHostsFile("host1", ip);
        this.rm.getNodesListManager().refreshNodes(conf);
        this.checkDecommissionedNMCount(this.rm, ++metricCount);
        nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        Assert.assertEquals((long)1L, (long)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertTrue((String)"Node is not decommisioned.", (boolean)NodeAction.SHUTDOWN.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm3.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        Assert.assertEquals((long)metricCount, (long)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
    }

    @Test
    public void testDecommissionWithExcludeHosts() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.exclude-path", this.hostFile.getAbsolutePath());
        this.writeToHostsFile("");
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        MockNM nm3 = this.rm.registerNode("localhost:4433", 1024);
        this.rm.drainEvents();
        int metricCount = ClusterMetrics.getMetrics().getNumDecommisionedNMs();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        this.rm.drainEvents();
        String ip = NetUtils.normalizeHostName((String)"localhost");
        this.writeToHostsFile("host2", ip);
        this.rm.getNodesListManager().refreshNodes(conf);
        this.checkDecommissionedNMCount(this.rm, metricCount + 2);
        nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertTrue((String)"The decommisioned metrics are not updated", (boolean)NodeAction.SHUTDOWN.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm3.nodeHeartbeat(true);
        Assert.assertTrue((String)"The decommisioned metrics are not updated", (boolean)NodeAction.SHUTDOWN.equals((Object)nodeHeartbeat.getNodeAction()));
        this.rm.drainEvents();
        this.writeToHostsFile("");
        this.rm.getNodesListManager().refreshNodes(conf);
        nm3 = this.rm.registerNode("localhost:4433", 1024);
        this.rm.drainEvents();
        nodeHeartbeat = nm3.nodeHeartbeat(true);
        this.rm.drainEvents();
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        this.checkDecommissionedNMCount(this.rm, metricCount + 1);
    }

    @Test
    public void testAddNewIncludePathToConfiguration() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        assert (metrics != null);
        int initialMetricCount = metrics.getNumDecommisionedNMs();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        this.writeToHostsFile("host1");
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        this.rm.getNodesListManager().refreshNodes(conf);
        this.checkDecommissionedNMCount(this.rm, ++initialMetricCount);
        nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertEquals((String)"Node should not have been decomissioned.", (Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertEquals((String)("Node should have been decomissioned but is in state" + nodeHeartbeat.getNodeAction()), (Object)NodeAction.SHUTDOWN, (Object)nodeHeartbeat.getNodeAction());
    }

    @Test
    public void testAddNewExcludePathToConfiguration() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        assert (metrics != null);
        int initialMetricCount = metrics.getNumDecommisionedNMs();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        this.writeToHostsFile("host2");
        conf.set("yarn.resourcemanager.nodes.exclude-path", this.hostFile.getAbsolutePath());
        this.rm.getNodesListManager().refreshNodes(conf);
        this.checkDecommissionedNMCount(this.rm, ++initialMetricCount);
        nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertEquals((String)"Node should not have been decomissioned.", (Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertEquals((String)("Node should have been decomissioned but is in state" + nodeHeartbeat.getNodeAction()), (Object)NodeAction.SHUTDOWN, (Object)nodeHeartbeat.getNodeAction());
    }

    @Test
    public void testNodeRegistrationSuccess() throws Exception {
        this.writeToHostsFile("host2");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        this.rm = new MockRM(conf);
        this.rm.start();
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        Resource capability = BuilderUtils.newResource((int)1024, (int)1);
        req.setResource(capability);
        req.setNodeId(nodeId);
        req.setHttpPort(1234);
        req.setNMVersion(YarnVersionInfo.getVersion());
        RegisterNodeManagerResponse response = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)response.getNodeAction());
    }

    @Test
    public void testNodeRegistrationVersionLessThanRM() throws Exception {
        this.writeToHostsFile("host2");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        conf.set("yarn.resourcemanager.nodemanager.minimum.version", "EqualToRM");
        this.rm = new MockRM(conf);
        this.rm.start();
        String nmVersion = "1.9.9";
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        Resource capability = BuilderUtils.newResource((int)1024, (int)1);
        req.setResource(capability);
        req.setNodeId(nodeId);
        req.setHttpPort(1234);
        req.setNMVersion(nmVersion);
        RegisterNodeManagerResponse response = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)response.getNodeAction());
        Assert.assertTrue((String)("Diagnostic message did not contain: 'Disallowed NodeManager Version " + nmVersion + ", is less than the minimum version'"), (boolean)response.getDiagnosticsMessage().contains("Disallowed NodeManager Version " + nmVersion + ", is less than the minimum version "));
    }

    @Test
    public void testNodeRegistrationFailure() throws Exception {
        this.writeToHostsFile("host1");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        this.rm = new MockRM(conf);
        this.rm.start();
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        req.setNodeId(nodeId);
        req.setHttpPort(1234);
        RegisterNodeManagerResponse response = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)response.getNodeAction());
        Assert.assertEquals((Object)"Disallowed NodeManager from  host2, Sending SHUTDOWN signal to the NodeManager.", (Object)response.getDiagnosticsMessage());
    }

    @Test
    public void testSetRMIdentifierInRegistration() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm = new MockNM("host1:1234", 5120, this.rm.getResourceTrackerService());
        RegisterNodeManagerResponse response = nm.registerNode();
        Assert.assertEquals((long)ResourceManager.getClusterTimeStamp(), (long)response.getRMIdentifier());
    }

    @Test
    public void testNodeRegistrationWithMinimumAllocations() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.minimum-allocation-mb", "2048");
        conf.set("yarn.scheduler.minimum-allocation-vcores", "4");
        this.rm = new MockRM(conf);
        this.rm.start();
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = BuilderUtils.newNodeId((String)"host", (int)1234);
        req.setNodeId(nodeId);
        Resource capability = BuilderUtils.newResource((int)1024, (int)1);
        req.setResource(capability);
        RegisterNodeManagerResponse response1 = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)response1.getNodeAction());
        capability.setMemory(2048);
        capability.setVirtualCores(1);
        req.setResource(capability);
        RegisterNodeManagerResponse response2 = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)response2.getNodeAction());
        capability.setMemory(1024);
        capability.setVirtualCores(4);
        req.setResource(capability);
        RegisterNodeManagerResponse response3 = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)response3.getNodeAction());
        capability.setMemory(2048);
        capability.setVirtualCores(4);
        req.setResource(capability);
        RegisterNodeManagerResponse response4 = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)response4.getNodeAction());
    }

    @Test
    public void testReboot() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:1234", 2048);
        int initialMetricCount = ClusterMetrics.getMetrics().getNumRebootedNMs();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm2.nodeHeartbeat(new HashMap<ApplicationId, List<ContainerStatus>>(), true, -100);
        Assert.assertTrue((boolean)NodeAction.RESYNC.equals((Object)nodeHeartbeat.getNodeAction()));
        Assert.assertEquals((Object)"Too far behind rm response id:0 nm response id:-100", (Object)nodeHeartbeat.getDiagnosticsMessage());
        this.checkRebootedNMCount(this.rm, ++initialMetricCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRebootedNMCount(MockRM rm2, int count) throws InterruptedException {
        int waitCount = 0;
        while (ClusterMetrics.getMetrics().getNumRebootedNMs() != count && waitCount++ < 20) {
            TestResourceTrackerService testResourceTrackerService = this;
            synchronized (testResourceTrackerService) {
                this.wait(100L);
            }
        }
        Assert.assertEquals((String)"The rebooted metrics are not updated", (long)count, (long)ClusterMetrics.getMetrics().getNumRebootedNMs());
    }

    @Test
    public void testUnhealthyNodeStatus() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.exclude-path", this.hostFile.getAbsolutePath());
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        Assert.assertEquals((long)0L, (long)ClusterMetrics.getMetrics().getUnhealthyNMs());
        nm1.nodeHeartbeat(true);
        nm1.nodeHeartbeat(false);
        this.checkUnealthyNMCount(this.rm, nm1, true, 1);
        nm1.nodeHeartbeat(true);
        this.checkUnealthyNMCount(this.rm, nm1, false, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUnealthyNMCount(MockRM rm, MockNM nm1, boolean health, int count) throws Exception {
        int waitCount = 0;
        while (((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())).getState() != NodeState.UNHEALTHY == health && waitCount++ < 20) {
            TestResourceTrackerService testResourceTrackerService = this;
            synchronized (testResourceTrackerService) {
                this.wait(100L);
            }
        }
        Assert.assertFalse((((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())).getState() != NodeState.UNHEALTHY == health ? 1 : 0) != 0);
        Assert.assertEquals((String)"Unhealthy metrics not incremented", (long)count, (long)ClusterMetrics.getMetrics().getUnhealthyNMs());
    }

    @Test
    public void testHandleContainerStatusInvalidCompletions() throws Exception {
        this.rm = new MockRM((Configuration)new YarnConfiguration());
        this.rm.start();
        EventHandler handler = (EventHandler)Mockito.spy((Object)this.rm.getRMContext().getDispatcher().getEventHandler());
        RMApp app = this.rm.submitApp(1024, true);
        NMContainerStatus report = NMContainerStatus.newInstance((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)app.getApplicationId(), (int)2), (long)1L), (ContainerState)ContainerState.COMPLETE, (Resource)Resource.newInstance((int)1024, (int)1), (String)"Dummy Completed", (int)0, (Priority)Priority.newInstance((int)10), (long)1234L);
        this.rm.getResourceTrackerService().handleNMContainerStatus(report, null);
        ((EventHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).handle((Event)Matchers.any());
        RMAppAttemptImpl currentAttempt = (RMAppAttemptImpl)app.getCurrentAppAttempt();
        currentAttempt.setMasterContainer(null);
        report = NMContainerStatus.newInstance((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)currentAttempt.getAppAttemptId(), (long)0L), (ContainerState)ContainerState.COMPLETE, (Resource)Resource.newInstance((int)1024, (int)1), (String)"Dummy Completed", (int)0, (Priority)Priority.newInstance((int)10), (long)1234L);
        this.rm.getResourceTrackerService().handleNMContainerStatus(report, null);
        ((EventHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).handle((Event)Matchers.any());
        app = this.rm.submitApp(1024);
        report = NMContainerStatus.newInstance((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)app.getApplicationId(), (int)2), (long)1L), (ContainerState)ContainerState.COMPLETE, (Resource)Resource.newInstance((int)1024, (int)1), (String)"Dummy Completed", (int)0, (Priority)Priority.newInstance((int)10), (long)1234L);
        try {
            this.rm.getResourceTrackerService().handleNMContainerStatus(report, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((EventHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).handle((Event)Matchers.any());
        currentAttempt = (RMAppAttemptImpl)app.getCurrentAppAttempt();
        currentAttempt.setMasterContainer(null);
        report = NMContainerStatus.newInstance((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)currentAttempt.getAppAttemptId(), (long)0L), (ContainerState)ContainerState.COMPLETE, (Resource)Resource.newInstance((int)1024, (int)1), (String)"Dummy Completed", (int)0, (Priority)Priority.newInstance((int)10), (long)1234L);
        try {
            this.rm.getResourceTrackerService().handleNMContainerStatus(report, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((EventHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).handle((Event)Matchers.any());
    }

    @Test
    public void testReconnectNode() throws Exception {
        this.rm = new MockRM(){

            protected EventHandler<SchedulerEvent> createSchedulerEventDispatcher() {
                return new ResourceManager.SchedulerEventDispatcher(this.scheduler){

                    public void handle(SchedulerEvent event) {
                        scheduler.handle((Event)event);
                    }
                };
            }
        };
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 5120);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(false);
        this.rm.drainEvents();
        this.checkUnealthyNMCount(this.rm, nm2, true, 1);
        int expectedNMs = ClusterMetrics.getMetrics().getNumActiveNMs();
        QueueMetrics metrics = this.rm.getResourceScheduler().getRootQueueMetrics();
        Assert.assertEquals((long)5120L, (long)metrics.getAvailableMB());
        nm1 = this.rm.registerNode("host1:1234", 5120);
        NodeHeartbeatResponse response = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)response.getNodeAction()));
        this.rm.drainEvents();
        Assert.assertEquals((long)expectedNMs, (long)ClusterMetrics.getMetrics().getNumActiveNMs());
        this.checkUnealthyNMCount(this.rm, nm2, true, 1);
        nm2 = this.rm.registerNode("host2:5678", 5120);
        response = nm2.nodeHeartbeat(false);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)response.getNodeAction()));
        this.rm.drainEvents();
        Assert.assertEquals((long)expectedNMs, (long)ClusterMetrics.getMetrics().getNumActiveNMs());
        this.checkUnealthyNMCount(this.rm, nm2, true, 1);
        nm2 = this.rm.registerNode("host2:5678", 5120);
        this.rm.drainEvents();
        response = nm2.nodeHeartbeat(true);
        response = nm2.nodeHeartbeat(true);
        this.rm.drainEvents();
        Assert.assertEquals((long)10240L, (long)metrics.getAvailableMB());
        nm1 = this.rm.registerNode("host2:5678", 10240);
        this.rm.drainEvents();
        response = nm1.nodeHeartbeat(true);
        this.rm.drainEvents();
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)response.getNodeAction()));
        Assert.assertEquals((long)15360L, (long)metrics.getAvailableMB());
        ArrayList<ApplicationId> runningApps = new ArrayList<ApplicationId>();
        runningApps.add(ApplicationId.newInstance((long)1L, (int)0));
        nm1 = this.rm.registerNode("host2:5678", 15360, 2, runningApps);
        this.rm.drainEvents();
        response = nm1.nodeHeartbeat(true);
        this.rm.drainEvents();
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)response.getNodeAction()));
        Assert.assertEquals((long)20480L, (long)metrics.getAvailableMB());
        nm1 = new MockNM("host1:1234", 5120, this.rm.getResourceTrackerService());
        nm1.setHttpPort(3);
        nm1.registerNode();
        this.rm.drainEvents();
        response = nm1.nodeHeartbeat(true);
        response = nm1.nodeHeartbeat(true);
        this.rm.drainEvents();
        RMNode rmNode = (RMNode)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId());
        Assert.assertEquals((long)3L, (long)rmNode.getHttpPort());
        Assert.assertEquals((long)5120L, (long)rmNode.getTotalCapability().getMemory());
        Assert.assertEquals((long)20480L, (long)metrics.getAvailableMB());
    }

    @Test(timeout=30000L)
    public void testInitDecommMetric() throws Exception {
        this.testInitDecommMetricHelper(true);
        this.testInitDecommMetricHelper(false);
    }

    public void testInitDecommMetricHelper(boolean hasIncludeList) throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        File excludeHostFile = new File(TEMP_DIR + File.separator + "excludeHostFile.txt");
        this.writeToHostsFile(excludeHostFile, "host1");
        conf.set("yarn.resourcemanager.nodes.exclude-path", excludeHostFile.getAbsolutePath());
        if (hasIncludeList) {
            this.writeToHostsFile(this.hostFile, "host1", "host2");
            conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        }
        this.rm.getNodesListManager().refreshNodes(conf);
        this.rm.drainEvents();
        this.rm.stop();
        MockRM rm1 = new MockRM(conf);
        rm1.start();
        nm1 = rm1.registerNode("host1:1234", 5120);
        nm2 = rm1.registerNode("host2:5678", 10240);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        rm1.drainEvents();
        Assert.assertEquals((String)"Number of Decommissioned nodes should be 1", (long)1L, (long)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
        Assert.assertEquals((String)"The inactiveRMNodes should contain an entry for thedecommissioned node", (long)1L, (long)rm1.getRMContext().getInactiveRMNodes().size());
        excludeHostFile = new File(TEMP_DIR + File.separator + "excludeHostFile.txt");
        this.writeToHostsFile(excludeHostFile, "");
        conf.set("yarn.resourcemanager.nodes.exclude-path", excludeHostFile.getAbsolutePath());
        rm1.getNodesListManager().refreshNodes(conf);
        nm1 = rm1.registerNode("host1:1234", 5120);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        rm1.drainEvents();
        Assert.assertEquals((String)"The decommissioned nodes metric should have decremented to 0", (long)0L, (long)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
        Assert.assertEquals((String)"The active nodes metric should be 2", (long)2L, (long)ClusterMetrics.getMetrics().getNumActiveNMs());
        Assert.assertEquals((String)"The inactive RMNodes entry should have been removed", (long)0L, (long)rm1.getRMContext().getInactiveRMNodes().size());
        rm1.drainEvents();
        rm1.stop();
    }

    @Test(timeout=30000L)
    public void testInitDecommMetricNoRegistration() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        File excludeHostFile = new File(TEMP_DIR + File.separator + "excludeHostFile.txt");
        this.writeToHostsFile(excludeHostFile, "host3", "host2");
        conf.set("yarn.resourcemanager.nodes.exclude-path", excludeHostFile.getAbsolutePath());
        this.writeToHostsFile(this.hostFile, "host1", "host2");
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        this.rm.getNodesListManager().refreshNodes(conf);
        this.rm.drainEvents();
        Assert.assertEquals((String)"The decommissioned nodes metric should be 1 ", (long)1L, (long)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
        this.rm.stop();
        MockRM rm1 = new MockRM(conf);
        rm1.start();
        rm1.getNodesListManager().refreshNodes(conf);
        rm1.drainEvents();
        Assert.assertEquals((String)"The decommissioned nodes metric should be 2 ", (long)2L, (long)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
        rm1.stop();
    }

    private void writeToHostsFile(String ... hosts) throws IOException {
        this.writeToHostsFile(this.hostFile, hosts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToHostsFile(File file, String ... hosts) throws IOException {
        if (!file.exists()) {
            TEMP_DIR.mkdirs();
            file.createNewFile();
        }
        FileOutputStream fStream = null;
        try {
            fStream = new FileOutputStream(file);
            for (int i = 0; i < hosts.length; ++i) {
                fStream.write(hosts[i].getBytes());
                fStream.write("\n".getBytes());
            }
        }
        finally {
            if (fStream != null) {
                IOUtils.closeStream((Closeable)fStream);
                fStream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDecommissionedNMCount(MockRM rm, int count) throws InterruptedException {
        int waitCount = 0;
        while (ClusterMetrics.getMetrics().getNumDecommisionedNMs() != count && waitCount++ < 20) {
            TestResourceTrackerService testResourceTrackerService = this;
            synchronized (testResourceTrackerService) {
                this.wait(100L);
            }
        }
        Assert.assertEquals((long)count, (long)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
        Assert.assertEquals((String)"The decommisioned metrics are not updated", (long)count, (long)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
    }

    @After
    public void tearDown() {
        MetricsSystem ms;
        if (this.hostFile != null && this.hostFile.exists()) {
            this.hostFile.delete();
        }
        ClusterMetrics.destroy();
        if (this.rm != null) {
            this.rm.stop();
        }
        if ((ms = DefaultMetricsSystem.instance()).getSource("ClusterMetrics") != null) {
            DefaultMetricsSystem.shutdown();
        }
    }
}

