/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.ClientBaseWithFixes;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.resourcemanager.EmbeddedElectorService;
import org.apache.hadoop.yarn.server.resourcemanager.HATestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRMEmbeddedElector
extends ClientBaseWithFixes {
    private static final Logger LOG = LoggerFactory.getLogger((String)TestRMEmbeddedElector.class.getName());
    private static final String RM1_NODE_ID = "rm1";
    private static final int RM1_PORT_BASE = 10000;
    private static final String RM2_NODE_ID = "rm2";
    private static final int RM2_PORT_BASE = 20000;
    private Configuration conf;
    private AtomicBoolean callbackCalled;

    @Before
    public void setup() throws IOException {
        this.conf = new YarnConfiguration();
        this.conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        this.conf.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", true);
        this.conf.setBoolean("yarn.resourcemanager.ha.automatic-failover.embedded", true);
        this.conf.set("yarn.resourcemanager.cluster-id", "yarn-test-cluster");
        this.conf.set("yarn.resourcemanager.zk-address", this.hostPort);
        this.conf.setInt("yarn.resourcemanager.zk-timeout-ms", 2000);
        this.conf.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2");
        this.conf.set("yarn.resourcemanager.ha.id", RM1_NODE_ID);
        HATestUtil.setRpcAddressForRM(RM1_NODE_ID, 10000, this.conf);
        HATestUtil.setRpcAddressForRM(RM2_NODE_ID, 20000, this.conf);
        this.conf.setLong("yarn.client.failover-sleep-base-ms", 100L);
        System.setProperty("zookeeper.sasl.client", "false");
        this.callbackCalled = new AtomicBoolean(false);
    }

    @Test(timeout=10000L)
    public void testDeadlockShutdownBecomeActive() throws InterruptedException {
        MockRMWithElector rm = new MockRMWithElector(this.conf, 1000L);
        rm.start();
        LOG.info("Waiting for callback");
        while (!this.callbackCalled.get()) {
        }
        LOG.info("Stopping RM");
        rm.stop();
        LOG.info("Stopped RM");
    }

    private class MockRMWithElector
    extends MockRM {
        private long delayMs;

        MockRMWithElector(Configuration conf) {
            super(conf);
            this.delayMs = 0L;
        }

        MockRMWithElector(Configuration conf, long delayMs) {
            this(conf);
            this.delayMs = delayMs;
        }

        @Override
        protected AdminService createAdminService() {
            return new AdminService(this, this.getRMContext()){

                protected EmbeddedElectorService createEmbeddedElectorService() {
                    return new EmbeddedElectorService(MockRMWithElector.this.getRMContext()){

                        public void becomeActive() throws ServiceFailedException {
                            try {
                                TestRMEmbeddedElector.this.callbackCalled.set(true);
                                LOG.info("Callback called. Sleeping now");
                                Thread.sleep(MockRMWithElector.this.delayMs);
                                LOG.info("Sleep done");
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            super.becomeActive();
                        }
                    };
                }
            };
        }
    }
}

