/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.exceptions.ApplicationAttemptNotFoundException;
import org.apache.hadoop.yarn.exceptions.ApplicationMasterNotRegisteredException;
import org.apache.hadoop.yarn.exceptions.NMNotYetReadyException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMWithCustomAMLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEventType;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.ApplicationMasterLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestApplicationMasterLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(TestApplicationMasterLauncher.class);
    private static final String HOST = "127.0.0.1";

    @Test
    public void testAMLaunchAndCleanup() throws Exception {
        GenericTestUtils.setRootLogLevel((Level)Level.DEBUG);
        MyContainerManagerImpl containerManager = new MyContainerManagerImpl();
        MockRMWithCustomAMLauncher rm = new MockRMWithCustomAMLauncher(containerManager);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 5120);
        RMApp app = rm.submitApp(2000);
        nm1.nodeHeartbeat(true);
        int waitCount = 0;
        while (!containerManager.launched && waitCount++ < 20) {
            LOG.info("Waiting for AM Launch to happen..");
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)containerManager.launched);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        ApplicationAttemptId appAttemptId = attempt.getAppAttemptId();
        Assert.assertEquals((Object)appAttemptId.toString(), (Object)containerManager.attemptIdAtContainerManager);
        Assert.assertEquals((long)app.getSubmitTime(), (long)containerManager.submitTimeAtContainerManager);
        Assert.assertEquals((Object)app.getRMAppAttempt(appAttemptId).getMasterContainer().getId().toString(), (Object)containerManager.containerIdAtContainerManager);
        Assert.assertEquals((Object)nm1.getNodeId().toString(), (Object)containerManager.nmHostAtContainerManager);
        Assert.assertEquals((long)2L, (long)containerManager.maxAppAttempts);
        MockAM am = new MockAM(rm.getRMContext(), (ApplicationMasterProtocol)rm.getApplicationMasterService(), appAttemptId);
        am.registerAppAttempt();
        am.unregisterAppAttempt();
        nm1.nodeHeartbeat(attempt.getAppAttemptId(), 1L, ContainerState.COMPLETE);
        am.waitForState(RMAppAttemptState.FINISHED);
        waitCount = 0;
        while (!containerManager.cleanedup && waitCount++ < 20) {
            LOG.info("Waiting for AM Cleanup to happen..");
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)containerManager.cleanedup);
        am.waitForState(RMAppAttemptState.FINISHED);
        rm.stop();
    }

    @Test
    public void testRetriesOnFailures() throws Exception {
        final ContainerManagementProtocol mockProxy = (ContainerManagementProtocol)Mockito.mock(ContainerManagementProtocol.class);
        StartContainersResponse mockResponse = (StartContainersResponse)Mockito.mock(StartContainersResponse.class);
        Mockito.when((Object)mockProxy.startContainers((StartContainersRequest)Matchers.any(StartContainersRequest.class))).thenThrow(new Throwable[]{new NMNotYetReadyException("foo")}).thenReturn((Object)mockResponse);
        Configuration conf = new Configuration();
        conf.setInt("yarn.resourcemanager.am.max-attempts", 1);
        conf.setInt("yarn.client.nodemanager-connect.retry-interval-ms", 1);
        final DrainDispatcher dispatcher = new DrainDispatcher();
        MockRMWithCustomAMLauncher rm = new MockRMWithCustomAMLauncher(conf, null){

            @Override
            protected ApplicationMasterLauncher createAMLauncher() {
                return new ApplicationMasterLauncher(this.getRMContext()){

                    protected Runnable createRunnableLauncher(RMAppAttempt application, AMLauncherEventType event) {
                        return new AMLauncher(this.context, application, event, this.getConfig()){

                            protected YarnRPC getYarnRPC() {
                                YarnRPC mockRpc = (YarnRPC)Mockito.mock(YarnRPC.class);
                                Mockito.when((Object)mockRpc.getProxy((Class)Matchers.any(Class.class), (InetSocketAddress)Matchers.any(InetSocketAddress.class), (Configuration)Matchers.any(Configuration.class))).thenReturn((Object)mockProxy);
                                return mockRpc;
                            }
                        };
                    }
                };
            }

            @Override
            protected Dispatcher createDispatcher() {
                return dispatcher;
            }
        };
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 5120);
        RMApp app = rm.submitApp(2000);
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        nm1.nodeHeartbeat(true);
        dispatcher.await();
        rm.waitForState(appAttemptId, RMAppAttemptState.LAUNCHED, 500);
    }

    @Test(timeout=100000L)
    public void testallocateBeforeAMRegistration() throws Exception {
        boolean thrown = false;
        GenericTestUtils.setRootLogLevel((Level)Level.DEBUG);
        MockRM rm = new MockRM();
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 5000);
        NetUtils.addStaticResolution((String)"h1", (String)HOST);
        RMApp app = rm.submitApp(2000);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        MockAM am = rm.sendAMLaunched(attempt.getAppAttemptId());
        int request = 2;
        AllocateResponse ar = null;
        try {
            ar = am.allocate("h1", 1000, request, new ArrayList<ContainerId>());
            Assert.fail();
        }
        catch (ApplicationMasterNotRegisteredException applicationMasterNotRegisteredException) {
            // empty catch block
        }
        nm1.nodeHeartbeat(true);
        AllocateResponse amrs = null;
        try {
            amrs = am.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>());
            Assert.fail();
        }
        catch (ApplicationMasterNotRegisteredException applicationMasterNotRegisteredException) {
            // empty catch block
        }
        am.registerAppAttempt();
        try {
            am.registerAppAttempt(false);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)("Application Master is already registered : " + attempt.getAppAttemptId().getApplicationId()), (Object)e.getMessage());
        }
        am.unregisterAppAttempt();
        nm1.nodeHeartbeat(attempt.getAppAttemptId(), 1L, ContainerState.COMPLETE);
        am.waitForState(RMAppAttemptState.FINISHED);
        try {
            amrs = am.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>());
            Assert.fail();
        }
        catch (ApplicationAttemptNotFoundException applicationAttemptNotFoundException) {
            // empty catch block
        }
    }

    private static final class MyContainerManagerImpl
    implements ContainerManagementProtocol {
        boolean launched = false;
        boolean cleanedup = false;
        String attemptIdAtContainerManager = null;
        String containerIdAtContainerManager = null;
        String nmHostAtContainerManager = null;
        long submitTimeAtContainerManager;
        int maxAppAttempts;

        private MyContainerManagerImpl() {
        }

        public StartContainersResponse startContainers(StartContainersRequest requests) throws YarnException {
            StartContainerRequest request = (StartContainerRequest)requests.getStartContainerRequests().get(0);
            LOG.info("Container started by MyContainerManager: " + request);
            this.launched = true;
            Map env = request.getContainerLaunchContext().getEnvironment();
            Token containerToken = request.getContainerToken();
            ContainerTokenIdentifier tokenId = null;
            try {
                tokenId = BuilderUtils.newContainerTokenIdentifier((Token)containerToken);
            }
            catch (IOException e) {
                throw RPCUtil.getRemoteException((Throwable)e);
            }
            ContainerId containerId = tokenId.getContainerID();
            this.containerIdAtContainerManager = containerId.toString();
            this.attemptIdAtContainerManager = containerId.getApplicationAttemptId().toString();
            this.nmHostAtContainerManager = tokenId.getNmHostAddress();
            this.submitTimeAtContainerManager = Long.parseLong((String)env.get("APP_SUBMIT_TIME_ENV"));
            this.maxAppAttempts = Integer.parseInt((String)env.get("MAX_APP_ATTEMPTS"));
            return StartContainersResponse.newInstance(new HashMap(), new ArrayList(), new HashMap());
        }

        public StopContainersResponse stopContainers(StopContainersRequest request) throws YarnException {
            LOG.info("Container cleaned up by MyContainerManager");
            this.cleanedup = true;
            return null;
        }

        public GetContainerStatusesResponse getContainerStatuses(GetContainerStatusesRequest request) throws YarnException {
            return null;
        }
    }
}

