/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.yarn.proto.YarnSecurityTestClientAMTokenProtos;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;

public class RMDelegationTokenIdentifierForTest
extends RMDelegationTokenIdentifier {
    private YarnSecurityTestClientAMTokenProtos.RMDelegationTokenIdentifierForTestProto.Builder builder = YarnSecurityTestClientAMTokenProtos.RMDelegationTokenIdentifierForTestProto.newBuilder();

    public RMDelegationTokenIdentifierForTest() {
    }

    public RMDelegationTokenIdentifierForTest(RMDelegationTokenIdentifier token, String message) {
        if (token.getOwner() != null) {
            this.setOwner(new Text(token.getOwner()));
        }
        if (token.getRenewer() != null) {
            this.setRenewer(new Text(token.getRenewer()));
        }
        if (token.getRealUser() != null) {
            this.setRealUser(new Text(token.getRealUser()));
        }
        this.setIssueDate(token.getIssueDate());
        this.setMaxDate(token.getMaxDate());
        this.setSequenceNumber(token.getSequenceNumber());
        this.setMasterKeyId(token.getMasterKeyId());
        this.builder.setMessage(message);
    }

    public void write(DataOutput out) throws IOException {
        this.builder.setOwner(this.getOwner().toString());
        this.builder.setRenewer(this.getRenewer().toString());
        this.builder.setRealUser(this.getRealUser().toString());
        this.builder.setIssueDate(this.getIssueDate());
        this.builder.setMaxDate(this.getMaxDate());
        this.builder.setSequenceNumber(this.getSequenceNumber());
        this.builder.setMasterKeyId(this.getMasterKeyId());
        this.builder.setMessage(this.getMessage());
        this.builder.build().writeTo((OutputStream)((DataOutputStream)out));
    }

    public void readFields(DataInput in) throws IOException {
        this.builder.mergeFrom((InputStream)((DataInputStream)in));
        if (this.builder.getOwner() != null) {
            this.setOwner(new Text(this.builder.getOwner()));
        }
        if (this.builder.getRenewer() != null) {
            this.setRenewer(new Text(this.builder.getRenewer()));
        }
        if (this.builder.getRealUser() != null) {
            this.setRealUser(new Text(this.builder.getRealUser()));
        }
        this.setIssueDate(this.builder.getIssueDate());
        this.setMaxDate(this.builder.getMaxDate());
        this.setSequenceNumber(this.builder.getSequenceNumber());
        this.setMasterKeyId(this.builder.getMasterKeyId());
    }

    public String getMessage() {
        return this.builder.getMessage();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RMDelegationTokenIdentifierForTest) {
            RMDelegationTokenIdentifierForTest that = (RMDelegationTokenIdentifierForTest)((Object)obj);
            return this.getSequenceNumber() == that.getSequenceNumber() && this.getIssueDate() == that.getIssueDate() && this.getMaxDate() == that.getMaxDate() && this.getMasterKeyId() == that.getMasterKeyId() && RMDelegationTokenIdentifierForTest.isEqual((Object)this.getOwner(), (Object)that.getOwner()) && RMDelegationTokenIdentifierForTest.isEqual((Object)this.getRenewer(), (Object)that.getRenewer()) && RMDelegationTokenIdentifierForTest.isEqual((Object)this.getRealUser(), (Object)that.getRealUser()) && RMDelegationTokenIdentifierForTest.isEqual((Object)this.getMessage(), (Object)that.getMessage());
        }
        return false;
    }
}

