/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;

public class MockAM {
    private volatile int responseId = 0;
    private final ApplicationAttemptId attemptId;
    private RMContext context;
    private ApplicationMasterProtocol amRMProtocol;
    private UserGroupInformation ugi;
    private volatile AllocateResponse lastResponse;
    private final List<ResourceRequest> requests = new ArrayList<ResourceRequest>();
    private final List<ContainerId> releases = new ArrayList<ContainerId>();

    public MockAM(RMContext context, ApplicationMasterProtocol amRMProtocol, ApplicationAttemptId attemptId) {
        this.context = context;
        this.amRMProtocol = amRMProtocol;
        this.attemptId = attemptId;
    }

    public void setAMRMProtocol(ApplicationMasterProtocol amRMProtocol, RMContext context) {
        this.context = context;
        this.amRMProtocol = amRMProtocol;
    }

    public void waitForState(RMAppAttemptState finalState) throws Exception {
        RMApp app = (RMApp)this.context.getRMApps().get(this.attemptId.getApplicationId());
        RMAppAttempt attempt = app.getRMAppAttempt(this.attemptId);
        int timeoutSecs = 0;
        while (!finalState.equals((Object)attempt.getAppAttemptState()) && timeoutSecs++ < 40) {
            System.out.println("AppAttempt : " + this.attemptId + " State is : " + attempt.getAppAttemptState() + " Waiting for state : " + finalState);
            Thread.sleep(1000L);
        }
        System.out.println("AppAttempt State is : " + attempt.getAppAttemptState());
        Assert.assertEquals((String)"AppAttempt state is not correct (timedout)", (Object)finalState, (Object)attempt.getAppAttemptState());
    }

    public RegisterApplicationMasterResponse registerAppAttempt() throws Exception {
        return this.registerAppAttempt(true);
    }

    public RegisterApplicationMasterResponse registerAppAttempt(boolean wait) throws Exception {
        if (wait) {
            this.waitForState(RMAppAttemptState.LAUNCHED);
        }
        this.responseId = 0;
        final RegisterApplicationMasterRequest req = (RegisterApplicationMasterRequest)Records.newRecord(RegisterApplicationMasterRequest.class);
        req.setHost("");
        req.setRpcPort(1);
        req.setTrackingUrl("");
        if (this.ugi == null) {
            this.ugi = UserGroupInformation.createRemoteUser((String)this.attemptId.toString());
            Token token = ((RMApp)this.context.getRMApps().get(this.attemptId.getApplicationId())).getRMAppAttempt(this.attemptId).getAMRMToken();
            this.ugi.addTokenIdentifier(token.decodeIdentifier());
        }
        try {
            return (RegisterApplicationMasterResponse)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<RegisterApplicationMasterResponse>(){

                @Override
                public RegisterApplicationMasterResponse run() throws Exception {
                    return MockAM.this.amRMProtocol.registerApplicationMaster(req);
                }
            });
        }
        catch (UndeclaredThrowableException e) {
            throw (Exception)e.getCause();
        }
    }

    public void addRequests(String[] hosts, int memory, int priority2, int containers) throws Exception {
        this.requests.addAll(this.createReq(hosts, memory, 0, 0.0, priority2, containers));
    }

    public AllocateResponse schedule() throws Exception {
        AllocateResponse response = this.allocate(this.requests, this.releases);
        this.requests.clear();
        this.releases.clear();
        return response;
    }

    public void addContainerToBeReleased(ContainerId containerId) {
        this.releases.add(containerId);
    }

    public AllocateResponse allocate(String host, int memory, int numContainers, List<ContainerId> releases) throws Exception {
        return this.allocate(host, memory, 0, 0.0, numContainers, releases, null);
    }

    public AllocateResponse allocate(String host, int memory, int numContainers, List<ContainerId> releases, String labelExpression) throws Exception {
        List<ResourceRequest> reqs = this.createReq(new String[]{host}, memory, 0, 0.0, 1, numContainers, labelExpression);
        return this.allocate(reqs, releases);
    }

    public AllocateResponse allocate(String host, int memory, int vCores, double discs, int numContainers, List<ContainerId> releases) throws Exception {
        return this.allocate(host, memory, vCores, discs, numContainers, releases, null);
    }

    public AllocateResponse allocate(String host, int memory, int vCores, double discs, int numContainers, List<ContainerId> releases, String labelExpression) throws Exception {
        List<ResourceRequest> reqs = this.createReq(new String[]{host}, memory, vCores, discs, 1, numContainers, labelExpression);
        return this.allocate(reqs, releases);
    }

    public List<ResourceRequest> createReq(String[] hosts, int memory, int vCores, double discs, int priority2, int containers) throws Exception {
        return this.createReq(hosts, memory, vCores, discs, priority2, containers, null);
    }

    public List<ResourceRequest> createReq(String[] hosts, int memory, int vCores, double discs, int priority2, int containers, String labelExpression) throws Exception {
        ArrayList<ResourceRequest> reqs = new ArrayList<ResourceRequest>();
        for (String host : hosts) {
            if (host.equals("*")) continue;
            ResourceRequest hostReq = this.createResourceReq(host, memory, vCores, discs, priority2, containers, labelExpression);
            reqs.add(hostReq);
            ResourceRequest rackReq = this.createResourceReq("/default-rack", memory, vCores, discs, priority2, containers, labelExpression);
            reqs.add(rackReq);
        }
        ResourceRequest offRackReq = this.createResourceReq("*", memory, vCores, discs, priority2, containers, labelExpression);
        reqs.add(offRackReq);
        return reqs;
    }

    public ResourceRequest createResourceReq(String resource, int memory, int priority2, int containers) throws Exception {
        return this.createResourceReq(resource, memory, 0, 0.0, priority2, containers, null);
    }

    public ResourceRequest createResourceReq(String resource, int memory, int vCores, double discs, int priority2, int containers, String labelExpression) throws Exception {
        ResourceRequest req = (ResourceRequest)Records.newRecord(ResourceRequest.class);
        req.setResourceName(resource);
        req.setNumContainers(containers);
        Priority pri = (Priority)Records.newRecord(Priority.class);
        pri.setPriority(priority2);
        req.setPriority(pri);
        Resource capability = (Resource)Records.newRecord(Resource.class);
        capability.setMemory(memory);
        capability.setVirtualCores(vCores);
        capability.setDisks(discs);
        req.setCapability(capability);
        if (labelExpression != null) {
            req.setNodeLabelExpression(labelExpression);
        }
        return req;
    }

    public AllocateResponse allocate(List<ResourceRequest> resourceRequest, List<ContainerId> releases) throws Exception {
        AllocateRequest req = AllocateRequest.newInstance((int)0, (float)0.0f, resourceRequest, releases, null);
        return this.allocate(req);
    }

    public AllocateResponse allocate(AllocateRequest allocateRequest) throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)this.attemptId.toString());
        Token token = ((RMApp)this.context.getRMApps().get(this.attemptId.getApplicationId())).getRMAppAttempt(this.attemptId).getAMRMToken();
        ugi.addTokenIdentifier(token.decodeIdentifier());
        this.lastResponse = this.doAllocateAs(ugi, allocateRequest);
        return this.lastResponse;
    }

    public AllocateResponse doAllocateAs(UserGroupInformation ugi, final AllocateRequest req) throws Exception {
        req.setResponseId(++this.responseId);
        try {
            return (AllocateResponse)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<AllocateResponse>(){

                @Override
                public AllocateResponse run() throws Exception {
                    return MockAM.this.amRMProtocol.allocate(req);
                }
            });
        }
        catch (UndeclaredThrowableException e) {
            throw (Exception)e.getCause();
        }
    }

    public AllocateResponse doHeartbeat() throws Exception {
        return this.allocate(null, null);
    }

    public void unregisterAppAttempt() throws Exception {
        this.waitForState(RMAppAttemptState.RUNNING);
        this.unregisterAppAttempt(true);
    }

    public void unregisterAppAttempt(boolean waitForStateRunning) throws Exception {
        FinishApplicationMasterRequest req = FinishApplicationMasterRequest.newInstance((FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, (String)"", (String)"");
        this.unregisterAppAttempt(req, waitForStateRunning);
    }

    public void unregisterAppAttempt(final FinishApplicationMasterRequest req, boolean waitForStateRunning) throws Exception {
        if (waitForStateRunning) {
            this.waitForState(RMAppAttemptState.RUNNING);
        }
        if (this.ugi == null) {
            this.ugi = UserGroupInformation.createRemoteUser((String)this.attemptId.toString());
            Token token = ((RMApp)this.context.getRMApps().get(this.attemptId.getApplicationId())).getRMAppAttempt(this.attemptId).getAMRMToken();
            this.ugi.addTokenIdentifier(token.decodeIdentifier());
        }
        try {
            this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    MockAM.this.amRMProtocol.finishApplicationMaster(req);
                    return null;
                }
            });
        }
        catch (UndeclaredThrowableException e) {
            throw (Exception)e.getCause();
        }
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.attemptId;
    }

    public List<Container> allocateAndWaitForContainers(int nContainer, int memory, MockNM nm) throws Exception {
        return this.allocateAndWaitForContainers(nContainer, memory, 0, 0.0, nm);
    }

    public List<Container> allocateAndWaitForContainers(int nContainer, int memory, int vCores, double discs, MockNM nm) throws Exception {
        this.allocate("ANY", memory, vCores, discs, nContainer, null);
        nm.nodeHeartbeat(true);
        List conts = this.allocate(new ArrayList<ResourceRequest>(), null).getAllocatedContainers();
        while (conts.size() < nContainer) {
            nm.nodeHeartbeat(true);
            conts.addAll(this.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
            Thread.sleep(500L);
        }
        return conts;
    }
}

