/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AppManagerTestBase {

    protected class TestRMAppManager
    extends RMAppManager {
        private final RMStateStore stateStore;

        public TestRMAppManager(RMContext context, Configuration conf) {
            super(context, null, null, new ApplicationACLsManager(conf), conf);
            this.stateStore = context.getStateStore();
        }

        public TestRMAppManager(RMContext context, ClientToAMTokenSecretManagerInRM clientToAMSecretManager, YarnScheduler scheduler, ApplicationMasterService masterService, ApplicationACLsManager applicationACLsManager, Configuration conf) {
            super(context, scheduler, masterService, applicationACLsManager, conf);
            this.stateStore = context.getStateStore();
        }

        public void checkAppNumCompletedLimit() {
            super.checkAppNumCompletedLimit();
        }

        public void finishApplication(ApplicationId appId) {
            super.finishApplication(appId);
        }

        public int getCompletedAppsListSize() {
            return super.getCompletedAppsListSize();
        }

        public int getCompletedAppsInStateStore() {
            return this.completedAppsInStateStore;
        }

        public List<ApplicationId> getCompletedApps() {
            return this.completedApps;
        }

        public Set<ApplicationId> getFirstNCompletedApps(int n) {
            return this.getCompletedApps().stream().limit(n).collect(Collectors.toSet());
        }

        public Set<ApplicationId> getCompletedAppsWithEvenIdsInRange(int n) {
            return this.getCompletedApps().stream().limit(n).filter(app -> app.getId() % 2 == 0).collect(Collectors.toSet());
        }

        public Set<ApplicationId> getRemovedAppsFromStateStore(int numRemoves) {
            ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(RMApp.class);
            ((RMStateStore)Mockito.verify((Object)this.stateStore, (VerificationMode)Mockito.times((int)numRemoves))).removeApplication((RMApp)argumentCaptor.capture());
            return argumentCaptor.getAllValues().stream().map(RMApp::getApplicationId).collect(Collectors.toSet());
        }

        public void submitApplication(ApplicationSubmissionContext submissionContext, String user) throws YarnException {
            super.submitApplication(submissionContext, System.currentTimeMillis(), user);
        }
    }
}

