/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.numa;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumaNodeResource {
    private String nodeId;
    private long totalMemory;
    private int totalCpus;
    private long usedMemory;
    private int usedCpus;
    private static final Logger LOG = LoggerFactory.getLogger(NumaNodeResource.class);
    private Map<ContainerId, Long> containerVsMemUsage = new ConcurrentHashMap<ContainerId, Long>();
    private Map<ContainerId, Integer> containerVsCpusUsage = new ConcurrentHashMap<ContainerId, Integer>();

    public NumaNodeResource(String nodeId, long totalMemory, int totalCpus) {
        this.nodeId = nodeId;
        this.totalMemory = totalMemory;
        this.totalCpus = totalCpus;
    }

    public boolean isResourcesAvailable(Resource resource) {
        LOG.debug("Memory available:" + (this.totalMemory - this.usedMemory) + ", CPUs available:" + (this.totalCpus - this.usedCpus) + ", requested:" + resource);
        return this.totalMemory - this.usedMemory >= resource.getMemorySize() && this.totalCpus - this.usedCpus >= resource.getVirtualCores();
    }

    public long assignAvailableMemory(long memreq, ContainerId containerId) {
        long memAvailable = this.totalMemory - this.usedMemory;
        if (memAvailable >= memreq) {
            this.containerVsMemUsage.put(containerId, memreq);
            this.usedMemory += memreq;
            return 0L;
        }
        this.usedMemory += memAvailable;
        this.containerVsMemUsage.put(containerId, memAvailable);
        return memreq - memAvailable;
    }

    public int assignAvailableCpus(int cpusreq, ContainerId containerId) {
        int cpusAvailable = this.totalCpus - this.usedCpus;
        if (cpusAvailable >= cpusreq) {
            this.containerVsCpusUsage.put(containerId, cpusreq);
            this.usedCpus += cpusreq;
            return 0;
        }
        this.usedCpus += cpusAvailable;
        this.containerVsCpusUsage.put(containerId, cpusAvailable);
        return cpusreq - cpusAvailable;
    }

    public void assignResources(Resource resource, ContainerId containerId) {
        this.containerVsMemUsage.put(containerId, resource.getMemorySize());
        this.containerVsCpusUsage.put(containerId, resource.getVirtualCores());
        this.usedMemory += resource.getMemorySize();
        this.usedCpus += resource.getVirtualCores();
    }

    public void releaseResources(ContainerId containerId) {
        if (this.containerVsMemUsage.containsKey(containerId)) {
            this.usedMemory -= this.containerVsMemUsage.get(containerId).longValue();
            this.containerVsMemUsage.remove(containerId);
        }
        if (this.containerVsCpusUsage.containsKey(containerId)) {
            this.usedCpus -= this.containerVsCpusUsage.get(containerId).intValue();
            this.containerVsCpusUsage.remove(containerId);
        }
    }

    public void recoverMemory(ContainerId containerId, long memory) {
        this.containerVsMemUsage.put(containerId, memory);
        this.usedMemory += memory;
    }

    public void recoverCpus(ContainerId containerId, int cpus) {
        this.containerVsCpusUsage.put(containerId, cpus);
        this.usedCpus += cpus;
    }

    public String toString() {
        return "Node Id:" + this.nodeId + "\tMemory:" + this.totalMemory + "\tCPus:" + this.totalCpus;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        result = 31 * result + (int)(this.totalMemory ^ this.totalMemory >>> 32);
        result = 31 * result + this.totalCpus;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NumaNodeResource other = (NumaNodeResource)obj;
        if (this.nodeId == null ? other.nodeId != null : !this.nodeId.equals(other.nodeId)) {
            return false;
        }
        if (this.totalMemory != other.totalMemory) {
            return false;
        }
        return this.totalCpus == other.totalCpus;
    }

    public String getNodeId() {
        return this.nodeId;
    }
}

