/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.globalpolicygenerator;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;

public final class GPGUtils {
    private GPGUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T invokeRMWebService(String webAddr, String path, Class<T> returnType, Configuration conf, String selectParam) {
        Client client = GPGUtils.createJerseyClient(conf);
        InetSocketAddress socketAddress = NetUtils.getConnectAddress((InetSocketAddress)NetUtils.createSocketAddr((String)webAddr));
        String scheme = YarnConfiguration.useHttps((Configuration)conf) ? "https://" : "http://";
        String webAddress = scheme + socketAddress.getHostName() + ":" + socketAddress.getPort();
        WebResource webResource = client.resource(webAddress);
        if (selectParam != null) {
            webResource = webResource.queryParam("deSelects", selectParam);
        }
        ClientResponse response = null;
        try {
            response = (ClientResponse)webResource.path("/ws/v1/cluster").path(path).accept(new String[]{"application/xml"}).get(ClientResponse.class);
            if (response.getStatus() != 200) {
                throw new YarnRuntimeException("Bad response from remote web service: " + response.getStatus());
            }
            Object obj = response.getEntity(returnType);
            Object object = obj;
            return (T)object;
        }
        finally {
            if (response != null) {
                response.close();
                response = null;
            }
            client.destroy();
        }
    }

    public static <T> T invokeRMWebService(String webAddr, String path, Class<T> returnType, Configuration config) {
        return GPGUtils.invokeRMWebService(webAddr, path, returnType, config, null);
    }

    public static Map<SubClusterIdInfo, Float> createUniformWeights(Set<SubClusterId> ids) {
        HashMap<SubClusterIdInfo, Float> weights = new HashMap<SubClusterIdInfo, Float>();
        for (SubClusterId id : ids) {
            weights.put(new SubClusterIdInfo(id), Float.valueOf(1.0f));
        }
        return weights;
    }

    public static Client createJerseyClient(Configuration conf) {
        Client client = Client.create();
        int connectTimeOut = (int)conf.getTimeDuration("yarn.federation.gpg.webapp.connect-timeout", YarnConfiguration.DEFAULT_GPG_WEBAPP_CONNECT_TIMEOUT, TimeUnit.MILLISECONDS);
        client.setConnectTimeout(Integer.valueOf(connectTimeOut));
        int readTimeout = (int)conf.getTimeDuration("yarn.federation.gpg.webapp.read-timeout", YarnConfiguration.DEFAULT_GPG_WEBAPP_READ_TIMEOUT, TimeUnit.MILLISECONDS);
        client.setReadTimeout(Integer.valueOf(readTimeout));
        return client;
    }
}

