/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies;

import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.RouterPolicyFacade;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.policies.manager.PriorityBroadcastPolicyManager;
import org.apache.hadoop.yarn.server.federation.policies.manager.UniformBroadcastPolicyManager;
import org.apache.hadoop.yarn.server.federation.policies.router.PriorityRouterPolicy;
import org.apache.hadoop.yarn.server.federation.policies.router.UniformRandomRouterPolicy;
import org.apache.hadoop.yarn.server.federation.resolver.SubClusterResolver;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.impl.MemoryFederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.records.SetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.apache.hadoop.yarn.server.federation.utils.FederationPoliciesTestUtil;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreTestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRouterPolicyFacade {
    private RouterPolicyFacade routerFacade;
    private List<SubClusterId> subClusterIds;
    private FederationStateStore store;
    private String queue1 = "queue1";
    private String defQueueKey = "*";

    @Before
    public void setup() throws YarnException {
        FederationStateStoreFacade fedFacade = FederationStateStoreFacade.getInstance();
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.federation.cache-ttl.secs", "0");
        this.store = new MemoryFederationStateStore();
        this.store.init((Configuration)conf);
        fedFacade.reinitialize(this.store, (Configuration)conf);
        FederationStateStoreTestUtil storeTestUtil = new FederationStateStoreTestUtil(this.store);
        storeTestUtil.registerSubClusters(10);
        this.subClusterIds = storeTestUtil.getAllSubClusterIds(true);
        this.store.setPolicyConfiguration(SetSubClusterPolicyConfigurationRequest.newInstance((SubClusterPolicyConfiguration)TestRouterPolicyFacade.getUniformPolicy(this.queue1)));
        SubClusterResolver resolver = FederationPoliciesTestUtil.initResolver();
        this.routerFacade = new RouterPolicyFacade((Configuration)new YarnConfiguration(), fedFacade, resolver, this.subClusterIds.get(0));
    }

    @Test
    public void testConfigurationUpdate() throws YarnException {
        ApplicationSubmissionContext applicationSubmissionContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        Mockito.when((Object)applicationSubmissionContext.getQueue()).thenReturn((Object)this.queue1);
        SubClusterId chosen = this.routerFacade.getHomeSubcluster(applicationSubmissionContext, null);
        Assert.assertTrue((boolean)this.subClusterIds.contains(chosen));
        Assert.assertTrue((boolean)(this.routerFacade.globalPolicyMap.get(this.queue1) instanceof UniformRandomRouterPolicy));
        this.store.setPolicyConfiguration(SetSubClusterPolicyConfigurationRequest.newInstance((SubClusterPolicyConfiguration)this.getPriorityPolicy(this.queue1)));
        chosen = this.routerFacade.getHomeSubcluster(applicationSubmissionContext, null);
        Assert.assertTrue((boolean)chosen.equals((Object)this.subClusterIds.get(0)));
        Assert.assertTrue((boolean)(this.routerFacade.globalPolicyMap.get(this.queue1) instanceof PriorityRouterPolicy));
    }

    @Test
    public void testGetHomeSubcluster() throws YarnException {
        ApplicationSubmissionContext applicationSubmissionContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        Mockito.when((Object)applicationSubmissionContext.getQueue()).thenReturn((Object)this.queue1);
        Assert.assertTrue((this.routerFacade.globalPolicyMap.containsKey(this.defQueueKey) && this.routerFacade.globalPolicyMap.size() == 1 ? 1 : 0) != 0);
        SubClusterId chosen = this.routerFacade.getHomeSubcluster(applicationSubmissionContext, null);
        Assert.assertTrue((boolean)this.subClusterIds.contains(chosen));
        Assert.assertTrue((this.routerFacade.globalPolicyMap.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(this.routerFacade.globalPolicyMap.get(this.queue1) instanceof UniformRandomRouterPolicy));
        this.routerFacade.reset();
        Assert.assertTrue((this.routerFacade.globalPolicyMap.containsKey(this.defQueueKey) && this.routerFacade.globalPolicyMap.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testFallbacks() throws YarnException {
        ApplicationSubmissionContext applicationSubmissionContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        String uninitQueue = "non-initialized-queue";
        Mockito.when((Object)applicationSubmissionContext.getQueue()).thenReturn((Object)uninitQueue);
        SubClusterId chosen = this.routerFacade.getHomeSubcluster(applicationSubmissionContext, null);
        Assert.assertTrue((boolean)this.subClusterIds.contains(chosen));
        Assert.assertFalse((boolean)this.routerFacade.globalPolicyMap.containsKey(uninitQueue));
        Mockito.when((Object)applicationSubmissionContext.getQueue()).thenReturn((Object)"");
        chosen = this.routerFacade.getHomeSubcluster(applicationSubmissionContext, null);
        Assert.assertTrue((boolean)this.subClusterIds.contains(chosen));
        Assert.assertFalse((boolean)this.routerFacade.globalPolicyMap.containsKey(uninitQueue));
        Mockito.when((Object)applicationSubmissionContext.getQueue()).thenReturn(null);
        chosen = this.routerFacade.getHomeSubcluster(applicationSubmissionContext, null);
        Assert.assertTrue((boolean)this.subClusterIds.contains(chosen));
        Assert.assertFalse((boolean)this.routerFacade.globalPolicyMap.containsKey(uninitQueue));
    }

    public static SubClusterPolicyConfiguration getUniformPolicy(String queue) throws FederationPolicyInitializationException {
        UniformBroadcastPolicyManager wfp = new UniformBroadcastPolicyManager();
        wfp.setQueue(queue);
        SubClusterPolicyConfiguration fpc = wfp.serializeConf();
        return fpc;
    }

    public SubClusterPolicyConfiguration getPriorityPolicy(String queue) throws FederationPolicyInitializationException {
        PriorityBroadcastPolicyManager wfp = new PriorityBroadcastPolicyManager();
        HashMap<SubClusterIdInfo, Float> routerWeights = new HashMap<SubClusterIdInfo, Float>();
        for (SubClusterId s : this.subClusterIds) {
            routerWeights.put(new SubClusterIdInfo(s), Float.valueOf(0.9f / (float)this.subClusterIds.size()));
        }
        SubClusterIdInfo favorite = new SubClusterIdInfo(this.subClusterIds.get(0));
        routerWeights.put(favorite, Float.valueOf(0.1f + 0.9f / (float)this.subClusterIds.size()));
        WeightedPolicyInfo policyInfo = new WeightedPolicyInfo();
        policyInfo.setRouterPolicyWeights(routerWeights);
        wfp.setWeightedPolicyInfo(policyInfo);
        wfp.setQueue(queue);
        SubClusterPolicyConfiguration fpc = wfp.serializeConf();
        return fpc;
    }
}

