/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.ConfigurableFederationPolicy;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContext;
import org.apache.hadoop.yarn.server.federation.policies.amrmproxy.FederationAMRMProxyPolicy;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyException;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.policies.router.FederationRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.federation.utils.FederationPoliciesTestUtil;
import org.junit.Test;
import org.mockito.Mockito;

public abstract class BaseFederationPoliciesTest {
    private ConfigurableFederationPolicy policy;
    private WeightedPolicyInfo policyInfo = (WeightedPolicyInfo)Mockito.mock(WeightedPolicyInfo.class);
    private Map<SubClusterId, SubClusterInfo> activeSubclusters = new HashMap<SubClusterId, SubClusterInfo>();
    private FederationPolicyInitializationContext federationPolicyContext;
    private ApplicationSubmissionContext applicationSubmissionContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
    private Random rand = new Random();
    private SubClusterId homeSubCluster;

    @Test
    public void testReinitilialize() throws YarnException {
        FederationPolicyInitializationContext fpc = new FederationPolicyInitializationContext();
        ByteBuffer buf = this.getPolicyInfo().toByteBuffer();
        fpc.setSubClusterPolicyConfiguration(SubClusterPolicyConfiguration.newInstance((String)"queue1", (String)this.getPolicy().getClass().getCanonicalName(), (ByteBuffer)buf));
        fpc.setFederationSubclusterResolver(FederationPoliciesTestUtil.initResolver());
        fpc.setFederationStateStoreFacade(FederationPoliciesTestUtil.initFacade());
        this.getPolicy().reinitialize(fpc);
    }

    @Test(expected=FederationPolicyInitializationException.class)
    public void testReinitilializeBad1() throws YarnException {
        this.getPolicy().reinitialize(null);
    }

    @Test(expected=FederationPolicyInitializationException.class)
    public void testReinitilializeBad2() throws YarnException {
        FederationPolicyInitializationContext fpc = new FederationPolicyInitializationContext();
        this.getPolicy().reinitialize(fpc);
    }

    @Test(expected=FederationPolicyInitializationException.class)
    public void testReinitilializeBad3() throws YarnException {
        FederationPolicyInitializationContext fpc = new FederationPolicyInitializationContext();
        ByteBuffer buf = (ByteBuffer)Mockito.mock(ByteBuffer.class);
        fpc.setSubClusterPolicyConfiguration(SubClusterPolicyConfiguration.newInstance((String)"queue1", (String)"WrongPolicyName", (ByteBuffer)buf));
        fpc.setFederationSubclusterResolver(FederationPoliciesTestUtil.initResolver());
        fpc.setFederationStateStoreFacade(FederationPoliciesTestUtil.initFacade());
        this.getPolicy().reinitialize(fpc);
    }

    @Test(expected=FederationPolicyException.class)
    public void testNoSubclusters() throws YarnException {
        FederationPoliciesTestUtil.initializePolicyContext(this.getPolicy(), this.getPolicyInfo(), new HashMap<SubClusterId, SubClusterInfo>());
        ConfigurableFederationPolicy localPolicy = this.getPolicy();
        if (localPolicy instanceof FederationRouterPolicy) {
            ((FederationRouterPolicy)localPolicy).getHomeSubcluster(this.getApplicationSubmissionContext(), null);
        } else {
            String[] hosts = new String[]{"host1", "host2"};
            List<ResourceRequest> resourceRequests = FederationPoliciesTestUtil.createResourceRequests(hosts, 2048, 2, 1, 3, null, false);
            ((FederationAMRMProxyPolicy)localPolicy).splitResourceRequests(resourceRequests, new HashSet());
        }
    }

    public ConfigurableFederationPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(ConfigurableFederationPolicy policy) {
        this.policy = policy;
    }

    public WeightedPolicyInfo getPolicyInfo() {
        return this.policyInfo;
    }

    public void setPolicyInfo(WeightedPolicyInfo policyInfo) {
        this.policyInfo = policyInfo;
    }

    public Map<SubClusterId, SubClusterInfo> getActiveSubclusters() {
        return this.activeSubclusters;
    }

    public void setActiveSubclusters(Map<SubClusterId, SubClusterInfo> activeSubclusters) {
        this.activeSubclusters = activeSubclusters;
    }

    public FederationPolicyInitializationContext getFederationPolicyContext() {
        return this.federationPolicyContext;
    }

    public void setFederationPolicyContext(FederationPolicyInitializationContext federationPolicyContext) {
        this.federationPolicyContext = federationPolicyContext;
    }

    public ApplicationSubmissionContext getApplicationSubmissionContext() {
        return this.applicationSubmissionContext;
    }

    public void setApplicationSubmissionContext(ApplicationSubmissionContext applicationSubmissionContext) {
        this.applicationSubmissionContext = applicationSubmissionContext;
    }

    public Random getRand() {
        return this.rand;
    }

    public void setRand(long seed) {
        this.rand.setSeed(seed);
    }

    public SubClusterId getHomeSubCluster() {
        return this.homeSubCluster;
    }

    public void setHomeSubCluster(SubClusterId homeSubCluster) {
        this.homeSubCluster = homeSubCluster;
    }

    public void setMockActiveSubclusters(int numSubclusters) {
        for (int i = 1; i <= numSubclusters; ++i) {
            SubClusterIdInfo sc = new SubClusterIdInfo("sc" + i);
            SubClusterInfo sci = (SubClusterInfo)Mockito.mock(SubClusterInfo.class);
            Mockito.when((Object)sci.getState()).thenReturn((Object)SubClusterState.SC_RUNNING);
            Mockito.when((Object)sci.getSubClusterId()).thenReturn((Object)sc.toId());
            this.getActiveSubclusters().put(sc.toId(), sci);
        }
    }
}

