/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.scheduler;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoteNode;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.metrics.OpportunisticSchedulerMetrics;
import org.apache.hadoop.yarn.server.scheduler.DistributedOpportunisticContainerAllocator;
import org.apache.hadoop.yarn.server.scheduler.OpportunisticContainerContext;
import org.apache.hadoop.yarn.server.security.BaseContainerTokenSecretManager;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDistributedOpportunisticContainerAllocator {
    private static final Logger LOG = LoggerFactory.getLogger(TestDistributedOpportunisticContainerAllocator.class);
    private static final int GB = 1024;
    private DistributedOpportunisticContainerAllocator allocator = null;
    private OpportunisticContainerContext oppCntxt = null;
    private static final Priority PRIORITY_NORMAL = Priority.newInstance((int)1);
    private static final Resource CAPABILITY_1GB = Resources.createResource((int)1024);
    private static final ExecutionTypeRequest OPPORTUNISTIC_REQ = ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.OPPORTUNISTIC, (boolean)true);

    @Before
    public void setup() {
        SecurityUtil.setTokenServiceUseIp((boolean)false);
        final MasterKey mKey = new MasterKey(){

            public int getKeyId() {
                return 1;
            }

            public void setKeyId(int keyId) {
            }

            public ByteBuffer getBytes() {
                return ByteBuffer.allocate(8);
            }

            public void setBytes(ByteBuffer bytes) {
            }
        };
        BaseContainerTokenSecretManager secMan = new BaseContainerTokenSecretManager(new Configuration()){

            public MasterKey getCurrentKey() {
                return mKey;
            }

            public byte[] createPassword(ContainerTokenIdentifier identifier) {
                return new byte[]{1, 2};
            }
        };
        this.allocator = new DistributedOpportunisticContainerAllocator(secMan);
        this.oppCntxt = new OpportunisticContainerContext();
        this.oppCntxt.getAppParams().setMinResource(Resource.newInstance((int)1024, (int)1));
        this.oppCntxt.getAppParams().setIncrementResource(Resource.newInstance((int)512, (int)1));
        this.oppCntxt.getAppParams().setMaxResource(Resource.newInstance((int)1024, (int)10));
    }

    @Test
    public void testSimpleAllocation() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());
        List<ResourceRequest> reqs = Arrays.asList(ResourceRequest.newInstance((Priority)PRIORITY_NORMAL, (String)"*", (Resource)CAPABILITY_1GB, (int)1, (boolean)true, null, (ExecutionTypeRequest)OPPORTUNISTIC_REQ));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h1", (int)1234), (String)"h1:1234", (String)"/r1")));
        List containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "luser");
        Assert.assertEquals((long)1L, (long)containers.size());
        Assert.assertEquals((long)0L, (long)this.oppCntxt.getOutstandingOpReqs().size());
    }

    @Test
    public void testBlacklistRejection() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(Arrays.asList("h1", "h2"), new ArrayList());
        List<ResourceRequest> reqs = Arrays.asList(ResourceRequest.newInstance((Priority)PRIORITY_NORMAL, (String)"*", (Resource)CAPABILITY_1GB, (int)1, (boolean)true, null, (ExecutionTypeRequest)OPPORTUNISTIC_REQ));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h1", (int)1234), (String)"h1:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h2", (int)1234), (String)"h2:1234", (String)"/r2")));
        List containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "luser");
        Assert.assertEquals((long)0L, (long)containers.size());
        Assert.assertEquals((long)1L, (long)this.oppCntxt.getOutstandingOpReqs().size());
    }

    @Test
    public void testRoundRobinSimpleAllocation() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());
        List<ResourceRequest> reqs = Arrays.asList(ResourceRequest.newBuilder().allocationRequestId(1L).priority(PRIORITY_NORMAL).resourceName("*").capability(CAPABILITY_1GB).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(2L).priority(PRIORITY_NORMAL).resourceName("*").capability(CAPABILITY_1GB).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(3L).priority(PRIORITY_NORMAL).resourceName("*").capability(CAPABILITY_1GB).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build());
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h1", (int)1234), (String)"h1:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h2", (int)1234), (String)"h2:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h3", (int)1234), (String)"h3:1234", (String)"/r1")));
        List containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "luser");
        LOG.info("Containers: {}", (Object)containers);
        HashSet<String> allocatedHosts = new HashSet<String>();
        for (Container c : containers) {
            allocatedHosts.add(c.getNodeHttpAddress());
        }
        Assert.assertTrue((boolean)allocatedHosts.contains("h1:1234"));
        Assert.assertTrue((boolean)allocatedHosts.contains("h2:1234"));
        Assert.assertTrue((boolean)allocatedHosts.contains("h3:1234"));
        Assert.assertEquals((long)3L, (long)containers.size());
    }

    @Test
    public void testNodeLocalAllocation() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());
        List<ResourceRequest> reqs = Arrays.asList(ResourceRequest.newBuilder().allocationRequestId(1L).priority(PRIORITY_NORMAL).resourceName("*").capability(CAPABILITY_1GB).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(2L).priority(PRIORITY_NORMAL).resourceName("/r1").capability(CAPABILITY_1GB).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(2L).priority(PRIORITY_NORMAL).resourceName("h1").capability(CAPABILITY_1GB).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(2L).priority(PRIORITY_NORMAL).resourceName("*").capability(CAPABILITY_1GB).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(3L).priority(PRIORITY_NORMAL).resourceName("/r1").capability(CAPABILITY_1GB).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(3L).priority(PRIORITY_NORMAL).resourceName("h1").capability(CAPABILITY_1GB).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(3L).priority(PRIORITY_NORMAL).resourceName("*").capability(CAPABILITY_1GB).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build());
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h1", (int)1234), (String)"h1:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h2", (int)1234), (String)"h2:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h3", (int)1234), (String)"h3:1234", (String)"/r1")));
        List containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "luser");
        LOG.info("Containers: {}", (Object)containers);
        Assert.assertEquals((long)3L, (long)containers.size());
        for (Container c : containers) {
            if (c.getAllocationRequestId() != 2L && c.getAllocationRequestId() != 3L) continue;
            Assert.assertEquals((Object)"h1:1234", (Object)c.getNodeHttpAddress());
        }
    }

    @Test
    public void testNodeLocalAllocationSameSchedKey() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());
        List<ResourceRequest> reqs = Arrays.asList(ResourceRequest.newBuilder().allocationRequestId(2L).numContainers(2).priority(PRIORITY_NORMAL).resourceName("/r1").capability(CAPABILITY_1GB).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(2L).numContainers(2).priority(PRIORITY_NORMAL).resourceName("h1").capability(CAPABILITY_1GB).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(2L).numContainers(2).priority(PRIORITY_NORMAL).resourceName("*").capability(CAPABILITY_1GB).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build());
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h1", (int)1234), (String)"h1:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h2", (int)1234), (String)"h2:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h3", (int)1234), (String)"h3:1234", (String)"/r1")));
        List containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "luser");
        LOG.info("Containers: {}", (Object)containers);
        HashSet<String> allocatedHosts = new HashSet<String>();
        for (Container c : containers) {
            allocatedHosts.add(c.getNodeHttpAddress());
        }
        Assert.assertEquals((long)2L, (long)containers.size());
        Assert.assertTrue((boolean)allocatedHosts.contains("h1:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h2:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h3:1234"));
    }

    @Test
    public void testSimpleRackLocalAllocation() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());
        List<ResourceRequest> reqs = Arrays.asList(ResourceRequest.newInstance((Priority)PRIORITY_NORMAL, (String)"*", (Resource)CAPABILITY_1GB, (int)1, (boolean)true, null, (ExecutionTypeRequest)OPPORTUNISTIC_REQ), ResourceRequest.newInstance((Priority)PRIORITY_NORMAL, (String)"h1", (Resource)CAPABILITY_1GB, (int)1, (boolean)true, null, (ExecutionTypeRequest)OPPORTUNISTIC_REQ), ResourceRequest.newInstance((Priority)PRIORITY_NORMAL, (String)"/r1", (Resource)CAPABILITY_1GB, (int)1, (boolean)true, null, (ExecutionTypeRequest)OPPORTUNISTIC_REQ));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h3", (int)1234), (String)"h3:1234", (String)"/r2"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h2", (int)1234), (String)"h2:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h4", (int)1234), (String)"h4:1234", (String)"/r2")));
        List containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "luser");
        HashSet<String> allocatedHosts = new HashSet<String>();
        for (Container c : containers) {
            allocatedHosts.add(c.getNodeHttpAddress());
        }
        Assert.assertTrue((boolean)allocatedHosts.contains("h2:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h3:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h4:1234"));
        Assert.assertEquals((long)1L, (long)containers.size());
    }

    @Test
    public void testRoundRobinRackLocalAllocation() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());
        List<ResourceRequest> reqs = Arrays.asList(ResourceRequest.newBuilder().allocationRequestId(1L).priority(PRIORITY_NORMAL).resourceName("/r1").capability(CAPABILITY_1GB).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(1L).priority(PRIORITY_NORMAL).resourceName("h1").capability(CAPABILITY_1GB).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(1L).priority(PRIORITY_NORMAL).resourceName("*").capability(CAPABILITY_1GB).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(2L).priority(PRIORITY_NORMAL).resourceName("/r1").capability(CAPABILITY_1GB).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(2L).priority(PRIORITY_NORMAL).resourceName("h1").capability(CAPABILITY_1GB).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(2L).priority(PRIORITY_NORMAL).resourceName("*").capability(CAPABILITY_1GB).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build());
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h3", (int)1234), (String)"h3:1234", (String)"/r2"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h2", (int)1234), (String)"h2:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h5", (int)1234), (String)"h5:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h4", (int)1234), (String)"h4:1234", (String)"/r2")));
        List containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "luser");
        HashSet<String> allocatedHosts = new HashSet<String>();
        for (Container c : containers) {
            allocatedHosts.add(c.getNodeHttpAddress());
        }
        LOG.info("Containers: {}", (Object)containers);
        Assert.assertTrue((boolean)allocatedHosts.contains("h2:1234"));
        Assert.assertTrue((boolean)allocatedHosts.contains("h5:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h3:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h4:1234"));
        Assert.assertEquals((long)2L, (long)containers.size());
    }

    @Test
    public void testRoundRobinRackLocalAllocationSameSchedKey() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());
        List<ResourceRequest> reqs = Arrays.asList(ResourceRequest.newInstance((Priority)PRIORITY_NORMAL, (String)"*", (Resource)CAPABILITY_1GB, (int)2, (boolean)true, null, (ExecutionTypeRequest)OPPORTUNISTIC_REQ), ResourceRequest.newInstance((Priority)PRIORITY_NORMAL, (String)"h1", (Resource)CAPABILITY_1GB, (int)2, (boolean)true, null, (ExecutionTypeRequest)OPPORTUNISTIC_REQ), ResourceRequest.newInstance((Priority)PRIORITY_NORMAL, (String)"/r1", (Resource)CAPABILITY_1GB, (int)2, (boolean)true, null, (ExecutionTypeRequest)OPPORTUNISTIC_REQ));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h3", (int)1234), (String)"h3:1234", (String)"/r2"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h2", (int)1234), (String)"h2:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h5", (int)1234), (String)"h5:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h4", (int)1234), (String)"h4:1234", (String)"/r2")));
        List containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "luser");
        HashSet<String> allocatedHosts = new HashSet<String>();
        for (Container c : containers) {
            allocatedHosts.add(c.getNodeHttpAddress());
        }
        LOG.info("Containers: {}", (Object)containers);
        Assert.assertTrue((boolean)allocatedHosts.contains("h2:1234"));
        Assert.assertTrue((boolean)allocatedHosts.contains("h5:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h3:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h4:1234"));
        Assert.assertEquals((long)2L, (long)containers.size());
    }

    @Test
    public void testOffSwitchAllocationWhenNoNodeOrRack() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());
        List<ResourceRequest> reqs = Arrays.asList(ResourceRequest.newInstance((Priority)PRIORITY_NORMAL, (String)"*", (Resource)CAPABILITY_1GB, (int)2, (boolean)true, null, (ExecutionTypeRequest)OPPORTUNISTIC_REQ), ResourceRequest.newInstance((Priority)PRIORITY_NORMAL, (String)"h6", (Resource)CAPABILITY_1GB, (int)2, (boolean)true, null, (ExecutionTypeRequest)OPPORTUNISTIC_REQ), ResourceRequest.newInstance((Priority)PRIORITY_NORMAL, (String)"/r3", (Resource)CAPABILITY_1GB, (int)2, (boolean)true, null, (ExecutionTypeRequest)OPPORTUNISTIC_REQ));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h3", (int)1234), (String)"h3:1234", (String)"/r2"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h2", (int)1234), (String)"h2:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h5", (int)1234), (String)"h5:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h4", (int)1234), (String)"h4:1234", (String)"/r2")));
        List containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "luser");
        LOG.info("Containers: {}", (Object)containers);
        Assert.assertEquals((long)2L, (long)containers.size());
    }

    @Test
    public void testLotsOfContainersRackLocalAllocationSameSchedKey() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());
        List<ResourceRequest> reqs = Arrays.asList(ResourceRequest.newInstance((Priority)PRIORITY_NORMAL, (String)"*", (Resource)CAPABILITY_1GB, (int)1000, (boolean)true, null, (ExecutionTypeRequest)OPPORTUNISTIC_REQ), ResourceRequest.newInstance((Priority)PRIORITY_NORMAL, (String)"h1", (Resource)CAPABILITY_1GB, (int)1000, (boolean)true, null, (ExecutionTypeRequest)OPPORTUNISTIC_REQ), ResourceRequest.newInstance((Priority)PRIORITY_NORMAL, (String)"/r1", (Resource)CAPABILITY_1GB, (int)1000, (boolean)true, null, (ExecutionTypeRequest)OPPORTUNISTIC_REQ));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h3", (int)1234), (String)"h3:1234", (String)"/r2"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h2", (int)1234), (String)"h2:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h5", (int)1234), (String)"h5:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h4", (int)1234), (String)"h4:1234", (String)"/r2")));
        ArrayList containers = new ArrayList();
        for (int i = 0; i < 250; ++i) {
            containers.addAll(this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "luser"));
        }
        Assert.assertEquals((long)1000L, (long)containers.size());
    }

    @Test
    public void testLotsOfContainersRackLocalAllocation() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());
        ArrayList<ResourceRequest> reqs = new ArrayList<ResourceRequest>();
        for (int i = 0; i < 100; ++i) {
            reqs.add(ResourceRequest.newBuilder().allocationRequestId((long)(i + 1)).priority(PRIORITY_NORMAL).resourceName("*").capability(CAPABILITY_1GB).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build());
            reqs.add(ResourceRequest.newBuilder().allocationRequestId((long)(i + 1)).priority(PRIORITY_NORMAL).resourceName("h1").capability(CAPABILITY_1GB).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build());
            reqs.add(ResourceRequest.newBuilder().allocationRequestId((long)(i + 1)).priority(PRIORITY_NORMAL).resourceName("/r1").capability(CAPABILITY_1GB).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build());
        }
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h3", (int)1234), (String)"h3:1234", (String)"/r2"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h2", (int)1234), (String)"h2:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h5", (int)1234), (String)"h5:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h4", (int)1234), (String)"h4:1234", (String)"/r2")));
        ArrayList containers = new ArrayList();
        for (int i = 0; i < 25; ++i) {
            containers.addAll(this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "luser"));
        }
        Assert.assertEquals((long)100L, (long)containers.size());
    }

    @Test
    public void testAllocationWithNodeLabels() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());
        List<ResourceRequest> reqs = Arrays.asList(ResourceRequest.newInstance((Priority)PRIORITY_NORMAL, (String)"*", (Resource)CAPABILITY_1GB, (int)1, (boolean)true, (String)"label", (ExecutionTypeRequest)OPPORTUNISTIC_REQ));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h1", (int)1234), (String)"h1:1234", (String)"/r1")));
        List containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "luser");
        Assert.assertEquals((long)0L, (long)containers.size());
        Assert.assertEquals((long)1L, (long)this.oppCntxt.getOutstandingOpReqs().size());
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h1", (int)1234), (String)"h1:1234", (String)"/r1", (String)"label")));
        containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "luser");
        Assert.assertEquals((long)1L, (long)containers.size());
        Assert.assertEquals((long)0L, (long)this.oppCntxt.getOutstandingOpReqs().size());
    }

    @Test
    public void testMaxAllocationsPerAMHeartbeat() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());
        this.allocator.setMaxAllocationsPerAMHeartbeat(2);
        List<ResourceRequest> reqs = Arrays.asList(ResourceRequest.newInstance((Priority)PRIORITY_NORMAL, (String)"*", (Resource)CAPABILITY_1GB, (int)3, (boolean)true, null, (ExecutionTypeRequest)OPPORTUNISTIC_REQ), ResourceRequest.newInstance((Priority)PRIORITY_NORMAL, (String)"h6", (Resource)CAPABILITY_1GB, (int)3, (boolean)true, null, (ExecutionTypeRequest)OPPORTUNISTIC_REQ), ResourceRequest.newInstance((Priority)PRIORITY_NORMAL, (String)"/r3", (Resource)CAPABILITY_1GB, (int)3, (boolean)true, null, (ExecutionTypeRequest)OPPORTUNISTIC_REQ));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h3", (int)1234), (String)"h3:1234", (String)"/r2"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h2", (int)1234), (String)"h2:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h5", (int)1234), (String)"h5:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h4", (int)1234), (String)"h4:1234", (String)"/r2")));
        List containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "user1");
        LOG.info("Containers: {}", (Object)containers);
        Assert.assertEquals((long)2L, (long)containers.size());
        containers = this.allocator.allocateContainers(blacklistRequest, new ArrayList(), appAttId, this.oppCntxt, 1L, "user1");
        LOG.info("Containers: {}", (Object)containers);
        Assert.assertEquals((long)1L, (long)containers.size());
    }

    @Test
    public void testMaxAllocationsPerAMHeartbeatDifferentSchedKey() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());
        this.allocator.setMaxAllocationsPerAMHeartbeat(2);
        ExecutionTypeRequest oppRequest = ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.OPPORTUNISTIC, (boolean)true);
        List<ResourceRequest> reqs = Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)CAPABILITY_1GB, (int)1, (boolean)true, null, (ExecutionTypeRequest)OPPORTUNISTIC_REQ), ResourceRequest.newInstance((Priority)Priority.newInstance((int)2), (String)"h6", (Resource)CAPABILITY_1GB, (int)2, (boolean)true, null, (ExecutionTypeRequest)OPPORTUNISTIC_REQ), ResourceRequest.newInstance((Priority)Priority.newInstance((int)3), (String)"/r3", (Resource)CAPABILITY_1GB, (int)2, (boolean)true, null, (ExecutionTypeRequest)OPPORTUNISTIC_REQ));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h3", (int)1234), (String)"h3:1234", (String)"/r2"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h2", (int)1234), (String)"h2:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h5", (int)1234), (String)"h5:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h4", (int)1234), (String)"h4:1234", (String)"/r2")));
        List containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "user1");
        LOG.info("Containers: {}", (Object)containers);
        Assert.assertEquals((long)2L, (long)containers.size());
        containers = this.allocator.allocateContainers(blacklistRequest, new ArrayList(), appAttId, this.oppCntxt, 1L, "user1");
        LOG.info("Containers: {}", (Object)containers);
        Assert.assertEquals((long)2L, (long)containers.size());
        containers = this.allocator.allocateContainers(blacklistRequest, new ArrayList(), appAttId, this.oppCntxt, 1L, "user1");
        LOG.info("Containers: {}", (Object)containers);
        Assert.assertEquals((long)1L, (long)containers.size());
    }

    @Test
    public void testMaxAllocationsPerAMHeartbeatWithNoLimit() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());
        this.allocator.setMaxAllocationsPerAMHeartbeat(-1);
        ArrayList<ResourceRequest> reqs = new ArrayList<ResourceRequest>();
        for (int i = 0; i < 20; ++i) {
            reqs.add(ResourceRequest.newBuilder().allocationRequestId((long)(i + 1)).priority(PRIORITY_NORMAL).resourceName("h1").capability(CAPABILITY_1GB).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build());
        }
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h1", (int)1234), (String)"h1:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h2", (int)1234), (String)"h2:1234", (String)"/r1")));
        List containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "user1");
        Assert.assertEquals((long)20L, (long)containers.size());
    }

    @Test
    public void testMaxAllocationsPerAMHeartbeatWithHighLimit() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());
        this.allocator.setMaxAllocationsPerAMHeartbeat(100);
        ArrayList<ResourceRequest> reqs = new ArrayList<ResourceRequest>();
        for (int i = 0; i < 20; ++i) {
            reqs.add(ResourceRequest.newBuilder().allocationRequestId((long)(i + 1)).priority(PRIORITY_NORMAL).resourceName("h1").capability(CAPABILITY_1GB).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build());
        }
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h1", (int)1234), (String)"h1:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h2", (int)1234), (String)"h2:1234", (String)"/r1")));
        List containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "user1");
        Assert.assertEquals((long)20L, (long)containers.size());
    }

    @Test
    public void testAllocationLatencyMetrics() throws Exception {
        this.oppCntxt = (OpportunisticContainerContext)Mockito.spy((Object)this.oppCntxt);
        OpportunisticSchedulerMetrics metrics = (OpportunisticSchedulerMetrics)Mockito.mock(OpportunisticSchedulerMetrics.class);
        Mockito.when((Object)this.oppCntxt.getOppSchedulerMetrics()).thenReturn((Object)metrics);
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(Collections.emptyList(), Collections.emptyList());
        List<ResourceRequest> reqs = Arrays.asList(ResourceRequest.newInstance((Priority)PRIORITY_NORMAL, (String)"*", (Resource)CAPABILITY_1GB, (int)2, (boolean)true, null, (ExecutionTypeRequest)OPPORTUNISTIC_REQ), ResourceRequest.newInstance((Priority)PRIORITY_NORMAL, (String)"h6", (Resource)CAPABILITY_1GB, (int)2, (boolean)true, null, (ExecutionTypeRequest)OPPORTUNISTIC_REQ), ResourceRequest.newInstance((Priority)PRIORITY_NORMAL, (String)"/r3", (Resource)CAPABILITY_1GB, (int)2, (boolean)true, null, (ExecutionTypeRequest)OPPORTUNISTIC_REQ));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h3", (int)1234), (String)"h3:1234", (String)"/r2"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h2", (int)1234), (String)"h2:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h5", (int)1234), (String)"h5:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h4", (int)1234), (String)"h4:1234", (String)"/r2")));
        List containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "luser");
        LOG.info("Containers: {}", (Object)containers);
        Assert.assertEquals((long)2L, (long)containers.size());
        ((OpportunisticSchedulerMetrics)Mockito.verify((Object)metrics, (VerificationMode)Mockito.times((int)2))).addAllocateOLatencyEntry(ArgumentMatchers.anyLong());
    }
}

