/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.security;

import java.io.File;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.KerberosTestUtils;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.rpcauth.KerberosAuthMethod;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryServer;
import org.apache.hadoop.yarn.server.timeline.MemoryTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTimelineAuthenticationFilterForV1 {
    private static final Logger LOG = LoggerFactory.getLogger(TestTimelineAuthenticationFilterForV1.class);
    private static final String FOO_USER = "foo";
    private static final String BAR_USER = "bar";
    private static final String HTTP_USER = "HTTP";
    private static final String PRINCIPAL = "HTTP/localhost";
    private static final File TEST_ROOT_DIR = new File(System.getProperty("test.build.dir", "target/test-dir"), TestTimelineAuthenticationFilterForV1.class.getName() + "-root");
    private static final File httpSpnegoKeytabFile = new File(KerberosTestUtils.getKeytabFile());
    private static final String httpSpnegoPrincipal = KerberosTestUtils.getServerPrincipal();
    private static final String BASEDIR = System.getProperty("test.build.dir", "target/test-dir") + "/" + TestTimelineAuthenticationFilterForV1.class.getSimpleName();
    private static MiniKdc testMiniKDC;
    private static String keystoresDir;
    private static String sslConfDir;
    private static ApplicationHistoryServer testTimelineServer;
    private static Configuration conf;
    private static boolean withSsl;

    public static Collection<Object[]> withSsl() {
        return Arrays.asList({false}, {true});
    }

    public void initTestTimelineAuthenticationFilterForV1(boolean isSslEnabled) {
        withSsl = isSslEnabled;
    }

    @BeforeAll
    public static void setup() {
        try {
            testMiniKDC = new MiniKdc(MiniKdc.createConf(), TEST_ROOT_DIR);
            testMiniKDC.start();
            testMiniKDC.createPrincipal(httpSpnegoKeytabFile, new String[]{PRINCIPAL});
        }
        catch (Exception e) {
            LOG.error("Failed to setup MiniKDC", (Throwable)e);
            Assertions.fail((String)"Couldn't setup MiniKDC");
        }
        try {
            testTimelineServer = new ApplicationHistoryServer();
            conf = new Configuration(false);
            conf.setStrings("yarn.timeline-service.http-authentication.type", new String[]{"kerberos"});
            conf.set("yarn.timeline-service.http-authentication.kerberos.principal", httpSpnegoPrincipal);
            conf.set("yarn.timeline-service.http-authentication.kerberos.keytab", httpSpnegoKeytabFile.getAbsolutePath());
            conf.set("hadoop.security.authentication", "kerberos");
            conf.set("yarn.timeline-service.principal", httpSpnegoPrincipal);
            conf.set("yarn.timeline-service.keytab", httpSpnegoKeytabFile.getAbsolutePath());
            conf.setBoolean("yarn.timeline-service.enabled", true);
            conf.setClass("yarn.timeline-service.store-class", MemoryTimelineStore.class, TimelineStore.class);
            conf.set("yarn.timeline-service.address", "localhost:10200");
            conf.set("yarn.timeline-service.webapp.address", "localhost:8188");
            conf.set("yarn.timeline-service.webapp.https.address", "localhost:8190");
            conf.set("hadoop.proxyuser.HTTP.hosts", "*");
            conf.set("hadoop.proxyuser.HTTP.users", FOO_USER);
            conf.setInt("yarn.timeline-service.client.max-retries", 1);
            conf.set("hadoop.security.custom.auth.principal.class", User.class.getName());
            conf.set("hadoop.security.custom.rpc.auth.method.class", KerberosAuthMethod.class.getName());
            System.setProperty("hadoop.login", "kerberos");
            UserGroupInformation.getLoginUser().reloginFromKeytab();
            if (withSsl) {
                conf.set("yarn.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
                File base = new File(BASEDIR);
                FileUtil.fullyDelete((File)base);
                base.mkdirs();
                keystoresDir = new File(BASEDIR).getAbsolutePath();
                sslConfDir = KeyStoreTestUtil.getClasspathDir(TestTimelineAuthenticationFilterForV1.class);
                KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)conf, (boolean)false);
            }
            UserGroupInformation.setConfiguration((Configuration)conf);
            testTimelineServer.init(conf);
            testTimelineServer.start();
        }
        catch (Exception e) {
            LOG.error("Failed to setup TimelineServer", (Throwable)e);
            Assertions.fail((String)"Couldn't setup TimelineServer");
        }
    }

    private TimelineClient createTimelineClientForUGI() {
        TimelineClient client = TimelineClient.createTimelineClient();
        client.init(conf);
        client.start();
        return client;
    }

    @AfterAll
    public static void tearDown() throws Exception {
        if (testMiniKDC != null) {
            testMiniKDC.stop();
        }
        if (testTimelineServer != null) {
            testTimelineServer.stop();
        }
        if (withSsl) {
            KeyStoreTestUtil.cleanupSSLConfig((String)keystoresDir, (String)sslConfDir);
            File base = new File(BASEDIR);
            FileUtil.fullyDelete((File)base);
        }
    }

    @MethodSource(value={"withSsl"})
    @ParameterizedTest
    void testPutTimelineEntities(boolean isSslEnabled) throws Exception {
        this.initTestTimelineAuthenticationFilterForV1(isSslEnabled);
        KerberosTestUtils.doAs((String)PRINCIPAL, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TimelineClient client = TestTimelineAuthenticationFilterForV1.this.createTimelineClientForUGI();
                TimelineEntity entityToStore = new TimelineEntity();
                entityToStore.setEntityType(TestTimelineAuthenticationFilterForV1.class.getName());
                entityToStore.setEntityId("entity1");
                entityToStore.setStartTime(Long.valueOf(0L));
                TimelinePutResponse putResponse = client.putEntities(new TimelineEntity[]{entityToStore});
                if (putResponse.getErrors().size() > 0) {
                    LOG.error("putResponse errors: {}", (Object)putResponse.getErrors());
                }
                Assertions.assertTrue((boolean)putResponse.getErrors().isEmpty(), (String)"There were some errors in the putResponse");
                TimelineEntity entityToRead = testTimelineServer.getTimelineStore().getEntity("entity1", TestTimelineAuthenticationFilterForV1.class.getName(), null);
                Assertions.assertNotNull((Object)entityToRead, (String)"Timeline entity should not be null");
                return null;
            }
        });
    }

    @MethodSource(value={"withSsl"})
    @ParameterizedTest
    void testPutDomains(boolean isSslEnabled) throws Exception {
        this.initTestTimelineAuthenticationFilterForV1(isSslEnabled);
        KerberosTestUtils.doAs((String)PRINCIPAL, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TimelineClient client = TestTimelineAuthenticationFilterForV1.this.createTimelineClientForUGI();
                TimelineDomain domainToStore = new TimelineDomain();
                domainToStore.setId(TestTimelineAuthenticationFilterForV1.class.getName());
                domainToStore.setReaders("*");
                domainToStore.setWriters("*");
                client.putDomain(domainToStore);
                TimelineDomain domainToRead = testTimelineServer.getTimelineStore().getDomain(TestTimelineAuthenticationFilterForV1.class.getName());
                Assertions.assertNotNull((Object)domainToRead, (String)"Timeline domain should not be null");
                return null;
            }
        });
    }

    @MethodSource(value={"withSsl"})
    @ParameterizedTest
    void testDelegationTokenOperations(boolean isSslEnabled) throws Exception {
        this.initTestTimelineAuthenticationFilterForV1(isSslEnabled);
        TimelineClient httpUserClient = (TimelineClient)KerberosTestUtils.doAs((String)PRINCIPAL, (Callable)new Callable<TimelineClient>(){

            @Override
            public TimelineClient call() throws Exception {
                return TestTimelineAuthenticationFilterForV1.this.createTimelineClientForUGI();
            }
        });
        UserGroupInformation httpUser = (UserGroupInformation)KerberosTestUtils.doAs((String)PRINCIPAL, (Callable)new Callable<UserGroupInformation>(){

            @Override
            public UserGroupInformation call() throws Exception {
                return UserGroupInformation.getCurrentUser();
            }
        });
        Token token = httpUserClient.getDelegationToken(httpUser.getShortUserName());
        Assertions.assertNotNull((Object)token, (String)"Delegation token should not be null");
        TimelineDelegationTokenIdentifier tDT = (TimelineDelegationTokenIdentifier)token.decodeIdentifier();
        Assertions.assertNotNull((Object)tDT, (String)"Delegation token identifier should not be null");
        Assertions.assertEquals((Object)new Text(HTTP_USER), (Object)tDT.getOwner(), (String)"Owner of delegation token identifier does not match");
        Assertions.assertFalse((boolean)token.getService().toString().isEmpty(), (String)"Service field of token should not be empty");
        long renewTime1 = httpUserClient.renewDelegationToken(token);
        Thread.sleep(100L);
        token.setService(new Text());
        Assertions.assertTrue((boolean)token.getService().toString().isEmpty(), (String)"Service field of token should be empty");
        long renewTime2 = httpUserClient.renewDelegationToken(token);
        Assertions.assertTrue((renewTime1 < renewTime2 ? 1 : 0) != 0, (String)"renewTime2 should be later than renewTime1");
        Assertions.assertTrue((boolean)token.getService().toString().isEmpty(), (String)"Service field of token should be empty");
        httpUserClient.cancelDelegationToken(token);
        try {
            httpUserClient.renewDelegationToken(token);
            Assertions.fail((String)"Renew of delegation token should not be successful");
        }
        catch (Exception e) {
            LOG.info("Exception while renewing delegation token", (Throwable)e);
            Assertions.assertTrue((boolean)e.getMessage().contains("Renewal request for unknown token"));
        }
        UserGroupInformation fooUgi = UserGroupInformation.createProxyUser((String)FOO_USER, (UserGroupInformation)httpUser);
        TimelineClient fooUserClient = (TimelineClient)fooUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<TimelineClient>(){

            @Override
            public TimelineClient run() {
                return TestTimelineAuthenticationFilterForV1.this.createTimelineClientForUGI();
            }
        });
        token = fooUserClient.getDelegationToken(httpUser.getShortUserName());
        Assertions.assertNotNull((Object)token, (String)"Delegation token should not be null");
        tDT = (TimelineDelegationTokenIdentifier)token.decodeIdentifier();
        Assertions.assertNotNull((Object)tDT, (String)"Delegation token identifier should not be null");
        Assertions.assertEquals((Object)new Text(FOO_USER), (Object)tDT.getOwner(), (String)"Owner of delegation token is not the expected");
        Assertions.assertEquals((Object)new Text(HTTP_USER), (Object)tDT.getRealUser(), (String)"Real user of delegation token is not the expected");
        Token tokenToRenew = token;
        renewTime1 = httpUserClient.renewDelegationToken(tokenToRenew);
        renewTime2 = httpUserClient.renewDelegationToken(tokenToRenew);
        Assertions.assertTrue((renewTime1 < renewTime2 ? 1 : 0) != 0, (String)"renewTime2 should be later than renewTime1");
        Assertions.assertFalse((boolean)tokenToRenew.getService().toString().isEmpty(), (String)"Service field of token should not be empty");
        fooUserClient.cancelDelegationToken(tokenToRenew);
        try {
            httpUserClient.renewDelegationToken(tokenToRenew);
            Assertions.fail((String)"Renew of delegation token should not be successful");
        }
        catch (Exception e) {
            LOG.info("Exception while renewing delegation token", (Throwable)e);
            Assertions.assertTrue((boolean)e.getMessage().contains("Renewal request for unknown token"));
        }
        UserGroupInformation barUgi = UserGroupInformation.createProxyUser((String)BAR_USER, (UserGroupInformation)httpUser);
        TimelineClient barUserClient = (TimelineClient)barUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<TimelineClient>(){

            @Override
            public TimelineClient run() {
                return TestTimelineAuthenticationFilterForV1.this.createTimelineClientForUGI();
            }
        });
        try {
            barUserClient.getDelegationToken(httpUser.getShortUserName());
            Assertions.fail((String)"Retrieval of delegation token should not be successful");
        }
        catch (Exception e) {
            LOG.info("Exception while retrieving delegation token", (Throwable)e);
            Assertions.assertTrue((e.getCause() instanceof AuthorizationException || e.getCause() instanceof AuthenticationException ? 1 : 0) != 0);
        }
    }
}

