/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice.webapp;

import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryClientService;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManager;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManagerImpl;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryStoreTestUtils;
import org.apache.hadoop.yarn.server.applicationhistoryservice.MemoryApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.AHSController;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.AHSView;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.AboutPage;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.AppAttemptPage;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.AppPage;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.ContainerPage;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.test.WebAppTests;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestAHSWebApp
extends ApplicationHistoryStoreTestUtils {
    public void setApplicationHistoryStore(ApplicationHistoryStore store) {
        this.store = store;
    }

    @BeforeEach
    public void setup() {
        this.store = new MemoryApplicationHistoryStore();
    }

    @Test
    void testAppControllerIndex() throws Exception {
        ApplicationHistoryManager ahManager = (ApplicationHistoryManager)Mockito.mock(ApplicationHistoryManager.class);
        Injector injector = WebAppTests.createMockInjector(ApplicationHistoryManager.class, (Object)ahManager, (Module[])new Module[0]);
        AHSController controller = (AHSController)injector.getInstance(AHSController.class);
        controller.index();
        Assertions.assertEquals((Object)"Application History", (Object)controller.get("title", "unknown"));
    }

    @Test
    void testView() throws Exception {
        Injector injector = WebAppTests.createMockInjector(ApplicationBaseProtocol.class, (Object)this.mockApplicationHistoryClientService(5, 1, 1), (Module[])new Module[0]);
        AHSView ahsViewInstance = (AHSView)injector.getInstance(AHSView.class);
        ahsViewInstance.render();
        WebAppTests.flushOutput((Injector)injector);
        ahsViewInstance.set("app.state", YarnApplicationState.FAILED.toString());
        ahsViewInstance.render();
        WebAppTests.flushOutput((Injector)injector);
        ahsViewInstance.set("app.state", StringHelper.cjoin((Object[])new Object[]{YarnApplicationState.FAILED.toString(), YarnApplicationState.KILLED}));
        ahsViewInstance.render();
        WebAppTests.flushOutput((Injector)injector);
    }

    @Test
    void testAPPViewNaturalSortType() throws Exception {
        Injector injector = WebAppTests.createMockInjector(ApplicationBaseProtocol.class, (Object)this.mockApplicationHistoryClientService(5, 1, 1), (Module[])new Module[0]);
        AHSView ahsViewInstance = (AHSView)injector.getInstance(AHSView.class);
        ahsViewInstance.render();
        WebAppTests.flushOutput((Injector)injector);
        Map moreParams = ahsViewInstance.context().requestContext().moreParams();
        String appTableColumnsMeta = (String)moreParams.get("ui.dataTables.apps.init");
        Assertions.assertTrue((appTableColumnsMeta.indexOf("natural") != -1 ? 1 : 0) != 0);
    }

    @Test
    void testAboutPage() throws Exception {
        Injector injector = WebAppTests.createMockInjector(ApplicationBaseProtocol.class, (Object)this.mockApplicationHistoryClientService(0, 0, 0), (Module[])new Module[0]);
        AboutPage aboutPageInstance = (AboutPage)injector.getInstance(AboutPage.class);
        aboutPageInstance.render();
        WebAppTests.flushOutput((Injector)injector);
        aboutPageInstance.render();
        WebAppTests.flushOutput((Injector)injector);
    }

    @Test
    void testAppPage() throws Exception {
        Injector injector = WebAppTests.createMockInjector(ApplicationBaseProtocol.class, (Object)this.mockApplicationHistoryClientService(1, 5, 1), (Module[])new Module[0]);
        AppPage appPageInstance = (AppPage)injector.getInstance(AppPage.class);
        appPageInstance.render();
        WebAppTests.flushOutput((Injector)injector);
        appPageInstance.set("app.id", ApplicationId.newInstance((long)0L, (int)1).toString());
        appPageInstance.render();
        WebAppTests.flushOutput((Injector)injector);
    }

    @Test
    void testAppPageNaturalSortType() throws Exception {
        Injector injector = WebAppTests.createMockInjector(ApplicationBaseProtocol.class, (Object)this.mockApplicationHistoryClientService(1, 5, 1), (Module[])new Module[0]);
        AppPage appPageInstance = (AppPage)injector.getInstance(AppPage.class);
        appPageInstance.render();
        WebAppTests.flushOutput((Injector)injector);
        Map moreParams = appPageInstance.context().requestContext().moreParams();
        String attemptsTableColumnsMeta = (String)moreParams.get("ui.dataTables.attempts.init");
        Assertions.assertTrue((attemptsTableColumnsMeta.indexOf("natural") != -1 ? 1 : 0) != 0);
    }

    @Test
    void testAppAttemptPage() throws Exception {
        Injector injector = WebAppTests.createMockInjector(ApplicationBaseProtocol.class, (Object)this.mockApplicationHistoryClientService(1, 1, 5), (Module[])new Module[0]);
        AppAttemptPage appAttemptPageInstance = (AppAttemptPage)injector.getInstance(AppAttemptPage.class);
        appAttemptPageInstance.render();
        WebAppTests.flushOutput((Injector)injector);
        appAttemptPageInstance.set("appattempt.id", ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1).toString());
        appAttemptPageInstance.render();
        WebAppTests.flushOutput((Injector)injector);
    }

    @Test
    void testAppAttemptPageNaturalSortType() throws Exception {
        Injector injector = WebAppTests.createMockInjector(ApplicationBaseProtocol.class, (Object)this.mockApplicationHistoryClientService(1, 1, 5), (Module[])new Module[0]);
        AppAttemptPage appAttemptPageInstance = (AppAttemptPage)injector.getInstance(AppAttemptPage.class);
        appAttemptPageInstance.render();
        WebAppTests.flushOutput((Injector)injector);
        Map moreParams = appAttemptPageInstance.context().requestContext().moreParams();
        String tableColumnsMeta = (String)moreParams.get("ui.dataTables.containers.init");
        Assertions.assertTrue((tableColumnsMeta.indexOf("natural") != -1 ? 1 : 0) != 0);
    }

    @Test
    void testContainerPage() throws Exception {
        Injector injector = WebAppTests.createMockInjector(ApplicationBaseProtocol.class, (Object)this.mockApplicationHistoryClientService(1, 1, 1), (Module[])new Module[0]);
        ContainerPage containerPageInstance = (ContainerPage)injector.getInstance(ContainerPage.class);
        containerPageInstance.render();
        WebAppTests.flushOutput((Injector)injector);
        containerPageInstance.set("container.id", ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (long)1L).toString());
        containerPageInstance.render();
        WebAppTests.flushOutput((Injector)injector);
    }

    ApplicationHistoryClientService mockApplicationHistoryClientService(int numApps, int numAppAttempts, int numContainers) throws Exception {
        MockApplicationHistoryManagerImpl ahManager = new MockApplicationHistoryManagerImpl(this.store);
        ApplicationHistoryClientService historyClientService = new ApplicationHistoryClientService((ApplicationHistoryManager)ahManager);
        for (int i = 1; i <= numApps; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)0L, (int)i);
            this.writeApplicationStartData(appId);
            for (int j = 1; j <= numAppAttempts; ++j) {
                ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)j);
                this.writeApplicationAttemptStartData(appAttemptId);
                for (int k = 1; k <= numContainers; ++k) {
                    ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)k);
                    this.writeContainerStartData(containerId);
                    this.writeContainerFinishData(containerId);
                }
                this.writeApplicationAttemptFinishData(appAttemptId);
            }
            this.writeApplicationFinishData(appId);
        }
        return historyClientService;
    }

    class MockApplicationHistoryManagerImpl
    extends ApplicationHistoryManagerImpl {
        MockApplicationHistoryManagerImpl(ApplicationHistoryStore store) {
            this.init((Configuration)new YarnConfiguration());
            this.start();
        }

        protected ApplicationHistoryStore createApplicationHistoryStore(Configuration conf) {
            return TestAHSWebApp.this.store;
        }
    }
}

