/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import java.io.IOException;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryStoreTestUtils;
import org.apache.hadoop.yarn.server.applicationhistoryservice.MemoryApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationAttemptHistoryData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationHistoryData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ContainerHistoryData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestMemoryApplicationHistoryStore
extends ApplicationHistoryStoreTestUtils {
    @BeforeEach
    public void setup() {
        this.store = new MemoryApplicationHistoryStore();
    }

    @Test
    void testReadWriteApplicationHistory() throws Exception {
        int i;
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        try {
            this.writeApplicationFinishData(appId);
            Assertions.fail();
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("is stored before the start information"));
        }
        int numApps = 5;
        for (i = 1; i <= numApps; ++i) {
            appId = ApplicationId.newInstance((long)0L, (int)i);
            this.writeApplicationStartData(appId);
            this.writeApplicationFinishData(appId);
        }
        Assertions.assertEquals((int)numApps, (int)this.store.getAllApplications().size());
        for (i = 1; i <= numApps; ++i) {
            appId = ApplicationId.newInstance((long)0L, (int)i);
            ApplicationHistoryData data = this.store.getApplication(appId);
            Assertions.assertNotNull((Object)data);
            Assertions.assertEquals((Object)appId.toString(), (Object)data.getApplicationName());
            Assertions.assertEquals((Object)appId.toString(), (Object)data.getDiagnosticsInfo());
        }
        appId = ApplicationId.newInstance((long)0L, (int)1);
        try {
            this.writeApplicationStartData(appId);
            Assertions.fail();
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("is already stored"));
        }
        try {
            this.writeApplicationFinishData(appId);
            Assertions.fail();
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("is already stored"));
        }
    }

    @Test
    void testReadWriteApplicationAttemptHistory() throws Exception {
        int i;
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        try {
            this.writeApplicationAttemptFinishData(appAttemptId);
            Assertions.fail();
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("is stored before the start information"));
        }
        int numAppAttempts = 5;
        this.writeApplicationStartData(appId);
        for (i = 1; i <= numAppAttempts; ++i) {
            appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)i);
            this.writeApplicationAttemptStartData(appAttemptId);
            this.writeApplicationAttemptFinishData(appAttemptId);
        }
        Assertions.assertEquals((int)numAppAttempts, (int)this.store.getApplicationAttempts(appId).size());
        for (i = 1; i <= numAppAttempts; ++i) {
            appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)i);
            ApplicationAttemptHistoryData data = this.store.getApplicationAttempt(appAttemptId);
            Assertions.assertNotNull((Object)data);
            Assertions.assertEquals((Object)appAttemptId.toString(), (Object)data.getHost());
            Assertions.assertEquals((Object)appAttemptId.toString(), (Object)data.getDiagnosticsInfo());
        }
        this.writeApplicationFinishData(appId);
        appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        try {
            this.writeApplicationAttemptStartData(appAttemptId);
            Assertions.fail();
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("is already stored"));
        }
        try {
            this.writeApplicationAttemptFinishData(appAttemptId);
            Assertions.fail();
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("is already stored"));
        }
    }

    @Test
    void testReadWriteContainerHistory() throws Exception {
        int i;
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        try {
            this.writeContainerFinishData(containerId);
            Assertions.fail();
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("is stored before the start information"));
        }
        this.writeApplicationAttemptStartData(appAttemptId);
        int numContainers = 5;
        for (i = 1; i <= numContainers; ++i) {
            containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)i);
            this.writeContainerStartData(containerId);
            this.writeContainerFinishData(containerId);
        }
        Assertions.assertEquals((int)numContainers, (int)this.store.getContainers(appAttemptId).size());
        for (i = 1; i <= numContainers; ++i) {
            containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)i);
            ContainerHistoryData data = this.store.getContainer(containerId);
            Assertions.assertNotNull((Object)data);
            Assertions.assertEquals((Object)Priority.newInstance((int)containerId.getId()), (Object)data.getPriority());
            Assertions.assertEquals((Object)containerId.toString(), (Object)data.getDiagnosticsInfo());
        }
        ContainerHistoryData masterContainer = this.store.getAMContainer(appAttemptId);
        Assertions.assertNotNull((Object)masterContainer);
        Assertions.assertEquals((Object)ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L), (Object)masterContainer.getContainerId());
        this.writeApplicationAttemptFinishData(appAttemptId);
        containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        try {
            this.writeContainerStartData(containerId);
            Assertions.fail();
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("is already stored"));
        }
        try {
            this.writeContainerFinishData(containerId);
            Assertions.fail();
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("is already stored"));
        }
    }

    @Test
    void testMassiveWriteContainerHistory() throws IOException {
        long mb = 0x100000L;
        Runtime runtime = Runtime.getRuntime();
        long usedMemoryBefore = (runtime.totalMemory() - runtime.freeMemory()) / mb;
        int numContainers = 100000;
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        for (int i = 1; i <= numContainers; ++i) {
            ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)i);
            this.writeContainerStartData(containerId);
            this.writeContainerFinishData(containerId);
        }
        long usedMemoryAfter = (runtime.totalMemory() - runtime.freeMemory()) / mb;
        Assertions.assertTrue((usedMemoryAfter - usedMemoryBefore < 400L ? 1 : 0) != 0);
    }
}

