/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.ApplicationAttemptNotFoundException;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.ContainerNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryClientService;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManager;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManagerOnTimelineStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.TestApplicationHistoryManagerOnTimelineStore;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.security.TimelineACLsManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestApplicationHistoryClientService {
    private static ApplicationHistoryClientService clientService;
    private static TimelineDataManager dataManager;
    private static final int MAX_APPS = 2;

    @BeforeAll
    public static void setup() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        TimelineStore store = TestApplicationHistoryManagerOnTimelineStore.createStore(2);
        TimelineACLsManager aclsManager = new TimelineACLsManager((Configuration)conf);
        aclsManager.setTimelineStore(store);
        dataManager = new TimelineDataManager(store, aclsManager);
        dataManager.init((Configuration)conf);
        ApplicationACLsManager appAclsManager = new ApplicationACLsManager((Configuration)conf);
        ApplicationHistoryManagerOnTimelineStore historyManager = new ApplicationHistoryManagerOnTimelineStore(dataManager, appAclsManager);
        historyManager.init((Configuration)conf);
        historyManager.start();
        clientService = new ApplicationHistoryClientService((ApplicationHistoryManager)historyManager);
    }

    @Test
    void testApplicationNotFound() throws IOException, YarnException {
        ApplicationId appId = null;
        appId = ApplicationId.newInstance((long)0L, (int)3);
        GetApplicationReportRequest request = GetApplicationReportRequest.newInstance((ApplicationId)appId);
        try {
            GetApplicationReportResponse response = clientService.getApplicationReport(request);
            Assertions.fail((String)"Exception should have been thrown before we reach here.");
        }
        catch (ApplicationNotFoundException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("doesn't exist in the timeline store"));
        }
        catch (Exception e) {
            Assertions.fail((String)"Undesired exception caught");
        }
    }

    @Test
    void testApplicationAttemptNotFound() throws IOException, YarnException {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)3);
        GetApplicationAttemptReportRequest request = GetApplicationAttemptReportRequest.newInstance((ApplicationAttemptId)appAttemptId);
        try {
            GetApplicationAttemptReportResponse response = clientService.getApplicationAttemptReport(request);
            Assertions.fail((String)"Exception should have been thrown before we reach here.");
        }
        catch (ApplicationAttemptNotFoundException e) {
            System.out.println(e.getMessage());
            Assertions.assertTrue((boolean)e.getMessage().contains("doesn't exist in the timeline store"));
        }
        catch (Exception e) {
            Assertions.fail((String)"Undesired exception caught");
        }
    }

    @Test
    void testContainerNotFound() throws IOException, YarnException {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)3L);
        GetContainerReportRequest request = GetContainerReportRequest.newInstance((ContainerId)containerId);
        try {
            GetContainerReportResponse getContainerReportResponse = clientService.getContainerReport(request);
        }
        catch (ContainerNotFoundException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("doesn't exist in the timeline store"));
        }
        catch (Exception e) {
            Assertions.fail((String)"Undesired exception caught");
        }
    }

    @Test
    void testApplicationReport() throws IOException, YarnException {
        ApplicationId appId = null;
        appId = ApplicationId.newInstance((long)0L, (int)1);
        GetApplicationReportRequest request = GetApplicationReportRequest.newInstance((ApplicationId)appId);
        GetApplicationReportResponse response = clientService.getApplicationReport(request);
        ApplicationReport appReport = response.getApplicationReport();
        Assertions.assertNotNull((Object)appReport);
        Assertions.assertEquals((long)123L, (long)appReport.getApplicationResourceUsageReport().getMemorySeconds());
        Assertions.assertEquals((long)345L, (long)appReport.getApplicationResourceUsageReport().getVcoreSeconds());
        Assertions.assertEquals((Object)"application_0_0001", (Object)appReport.getApplicationId().toString());
        Assertions.assertEquals((Object)"test app type", (Object)appReport.getApplicationType().toString());
        Assertions.assertEquals((Object)"test queue", (Object)appReport.getQueue().toString());
    }

    @Test
    void testApplications() throws IOException, YarnException {
        ApplicationId appId = null;
        appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationId appId1 = ApplicationId.newInstance((long)0L, (int)2);
        GetApplicationsRequest request = GetApplicationsRequest.newInstance();
        GetApplicationsResponse response = clientService.getApplications(request);
        List appReport = response.getApplicationList();
        Assertions.assertNotNull((Object)appReport);
        Assertions.assertEquals((Object)appId, (Object)((ApplicationReport)appReport.get(1)).getApplicationId());
        Assertions.assertEquals((Object)appId1, (Object)((ApplicationReport)appReport.get(0)).getApplicationId());
        YarnConfiguration conf = new YarnConfiguration();
        conf.setLong("yarn.timeline-service.generic-application-history.max-applications", 1L);
        ApplicationHistoryManagerOnTimelineStore historyManager2 = new ApplicationHistoryManagerOnTimelineStore(dataManager, new ApplicationACLsManager((Configuration)conf));
        historyManager2.init((Configuration)conf);
        historyManager2.start();
        ApplicationHistoryClientService clientService2 = new ApplicationHistoryClientService((ApplicationHistoryManager)historyManager2);
        response = clientService2.getApplications(request);
        appReport = response.getApplicationList();
        Assertions.assertNotNull((Object)appReport);
        Assertions.assertTrue((appReport.size() == 1 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)appId1, (Object)((ApplicationReport)appReport.get(0)).getApplicationId());
    }

    @Test
    void testApplicationAttemptReport() throws IOException, YarnException {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        GetApplicationAttemptReportRequest request = GetApplicationAttemptReportRequest.newInstance((ApplicationAttemptId)appAttemptId);
        GetApplicationAttemptReportResponse response = clientService.getApplicationAttemptReport(request);
        ApplicationAttemptReport attemptReport = response.getApplicationAttemptReport();
        Assertions.assertNotNull((Object)attemptReport);
        Assertions.assertEquals((Object)"appattempt_0_0001_000001", (Object)attemptReport.getApplicationAttemptId().toString());
    }

    @Test
    void testApplicationAttempts() throws IOException, YarnException {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ApplicationAttemptId appAttemptId1 = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)2);
        GetApplicationAttemptsRequest request = GetApplicationAttemptsRequest.newInstance((ApplicationId)appId);
        GetApplicationAttemptsResponse response = clientService.getApplicationAttempts(request);
        List attemptReports = response.getApplicationAttemptList();
        Assertions.assertNotNull((Object)attemptReports);
        Assertions.assertEquals((Object)appAttemptId, (Object)((ApplicationAttemptReport)attemptReports.get(0)).getApplicationAttemptId());
        Assertions.assertEquals((Object)appAttemptId1, (Object)((ApplicationAttemptReport)attemptReports.get(1)).getApplicationAttemptId());
    }

    @Test
    void testContainerReport() throws IOException, YarnException {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        GetContainerReportRequest request = GetContainerReportRequest.newInstance((ContainerId)containerId);
        GetContainerReportResponse response = clientService.getContainerReport(request);
        ContainerReport container = response.getContainerReport();
        Assertions.assertNotNull((Object)container);
        Assertions.assertEquals((Object)containerId, (Object)container.getContainerId());
        Assertions.assertEquals((Object)"http://0.0.0.0:8188/applicationhistory/logs/test host:100/container_0_0001_01_000001/container_0_0001_01_000001/user1", (Object)container.getLogUrl());
    }

    @Test
    void testContainers() throws IOException, YarnException {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        ContainerId containerId1 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)2L);
        GetContainersRequest request = GetContainersRequest.newInstance((ApplicationAttemptId)appAttemptId);
        GetContainersResponse response = clientService.getContainers(request);
        List containers = response.getContainerList();
        Assertions.assertNotNull((Object)containers);
        Assertions.assertEquals((Object)containerId, (Object)((ContainerReport)containers.get(0)).getContainerId());
        Assertions.assertEquals((Object)containerId1, (Object)((ContainerReport)containers.get(1)).getContainerId());
    }
}

