/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import java.io.IOException;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryStoreTestUtils;
import org.apache.hadoop.yarn.server.applicationhistoryservice.MemoryApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationAttemptHistoryData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationHistoryData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ContainerHistoryData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestMemoryApplicationHistoryStore
extends ApplicationHistoryStoreTestUtils {
    @Before
    public void setup() {
        this.store = new MemoryApplicationHistoryStore();
    }

    @Test
    public void testReadWriteApplicationHistory() throws Exception {
        int i;
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        try {
            this.writeApplicationFinishData(appId);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is stored before the start information"));
        }
        int numApps = 5;
        for (i = 1; i <= numApps; ++i) {
            appId = ApplicationId.newInstance((long)0L, (int)i);
            this.writeApplicationStartData(appId);
            this.writeApplicationFinishData(appId);
        }
        Assert.assertEquals((long)numApps, (long)this.store.getAllApplications().size());
        for (i = 1; i <= numApps; ++i) {
            appId = ApplicationId.newInstance((long)0L, (int)i);
            ApplicationHistoryData data = this.store.getApplication(appId);
            Assert.assertNotNull((Object)data);
            Assert.assertEquals((Object)appId.toString(), (Object)data.getApplicationName());
            Assert.assertEquals((Object)appId.toString(), (Object)data.getDiagnosticsInfo());
        }
        appId = ApplicationId.newInstance((long)0L, (int)1);
        try {
            this.writeApplicationStartData(appId);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is already stored"));
        }
        try {
            this.writeApplicationFinishData(appId);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is already stored"));
        }
    }

    @Test
    public void testReadWriteApplicationAttemptHistory() throws Exception {
        int i;
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        try {
            this.writeApplicationAttemptFinishData(appAttemptId);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is stored before the start information"));
        }
        int numAppAttempts = 5;
        this.writeApplicationStartData(appId);
        for (i = 1; i <= numAppAttempts; ++i) {
            appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)i);
            this.writeApplicationAttemptStartData(appAttemptId);
            this.writeApplicationAttemptFinishData(appAttemptId);
        }
        Assert.assertEquals((long)numAppAttempts, (long)this.store.getApplicationAttempts(appId).size());
        for (i = 1; i <= numAppAttempts; ++i) {
            appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)i);
            ApplicationAttemptHistoryData data = this.store.getApplicationAttempt(appAttemptId);
            Assert.assertNotNull((Object)data);
            Assert.assertEquals((Object)appAttemptId.toString(), (Object)data.getHost());
            Assert.assertEquals((Object)appAttemptId.toString(), (Object)data.getDiagnosticsInfo());
        }
        this.writeApplicationFinishData(appId);
        appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        try {
            this.writeApplicationAttemptStartData(appAttemptId);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is already stored"));
        }
        try {
            this.writeApplicationAttemptFinishData(appAttemptId);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is already stored"));
        }
    }

    @Test
    public void testReadWriteContainerHistory() throws Exception {
        int i;
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        try {
            this.writeContainerFinishData(containerId);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is stored before the start information"));
        }
        this.writeApplicationAttemptStartData(appAttemptId);
        int numContainers = 5;
        for (i = 1; i <= numContainers; ++i) {
            containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)i);
            this.writeContainerStartData(containerId);
            this.writeContainerFinishData(containerId);
        }
        Assert.assertEquals((long)numContainers, (long)this.store.getContainers(appAttemptId).size());
        for (i = 1; i <= numContainers; ++i) {
            containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)i);
            ContainerHistoryData data = this.store.getContainer(containerId);
            Assert.assertNotNull((Object)data);
            Assert.assertEquals((Object)Priority.newInstance((int)containerId.getId()), (Object)data.getPriority());
            Assert.assertEquals((Object)containerId.toString(), (Object)data.getDiagnosticsInfo());
        }
        ContainerHistoryData masterContainer = this.store.getAMContainer(appAttemptId);
        Assert.assertNotNull((Object)masterContainer);
        Assert.assertEquals((Object)ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L), (Object)masterContainer.getContainerId());
        this.writeApplicationAttemptFinishData(appAttemptId);
        containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        try {
            this.writeContainerStartData(containerId);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is already stored"));
        }
        try {
            this.writeContainerFinishData(containerId);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is already stored"));
        }
    }

    @Test
    public void testMassiveWriteContainerHistory() throws IOException {
        long mb = 0x100000L;
        Runtime runtime = Runtime.getRuntime();
        long usedMemoryBefore = (runtime.totalMemory() - runtime.freeMemory()) / mb;
        int numContainers = 100000;
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        for (int i = 1; i <= numContainers; ++i) {
            ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)i);
            this.writeContainerStartData(containerId);
            this.writeContainerFinishData(containerId);
        }
        long usedMemoryAfter = (runtime.totalMemory() - runtime.freeMemory()) / mb;
        Assert.assertTrue((usedMemoryAfter - usedMemoryBefore < 400L ? 1 : 0) != 0);
    }
}

