/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManagerOnTimelineStore;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.timeline.MemoryTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.security.TimelineACLsManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestApplicationHistoryManagerOnTimelineStore {
    private static final int SCALE = 5;
    private static TimelineStore store;
    private ApplicationHistoryManagerOnTimelineStore historyManager;
    private UserGroupInformation callerUGI;
    private Configuration conf = new YarnConfiguration();

    @BeforeClass
    public static void prepareStore() throws Exception {
        store = TestApplicationHistoryManagerOnTimelineStore.createStore(5);
        TimelineEntities entities = new TimelineEntities();
        entities.addEntity(TestApplicationHistoryManagerOnTimelineStore.createApplicationTimelineEntity(ApplicationId.newInstance((long)0L, (int)6), true, true, false, false, YarnApplicationState.FINISHED));
        entities.addEntity(TestApplicationHistoryManagerOnTimelineStore.createApplicationTimelineEntity(ApplicationId.newInstance((long)0L, (int)7), true, false, true, false, YarnApplicationState.FINISHED));
        store.put(entities);
    }

    public static TimelineStore createStore(int scale) throws Exception {
        MemoryTimelineStore store = new MemoryTimelineStore();
        TestApplicationHistoryManagerOnTimelineStore.prepareTimelineStore((TimelineStore)store, scale);
        return store;
    }

    @Before
    public void setup() throws Exception {
        TimelineACLsManager aclsManager = new TimelineACLsManager((Configuration)new YarnConfiguration());
        aclsManager.setTimelineStore(store);
        TimelineDataManager dataManager = new TimelineDataManager(store, aclsManager);
        dataManager.init(this.conf);
        ApplicationACLsManager appAclsManager = new ApplicationACLsManager(this.conf);
        this.historyManager = new ApplicationHistoryManagerOnTimelineStore(dataManager, appAclsManager);
        this.historyManager.init(this.conf);
        this.historyManager.start();
    }

    @After
    public void tearDown() {
        if (this.historyManager != null) {
            this.historyManager.stop();
        }
    }

    @Parameterized.Parameters
    public static Collection<Object[]> callers() {
        return Arrays.asList({""}, {"user1"}, {"user2"}, {"user3"}, {"admin"});
    }

    public TestApplicationHistoryManagerOnTimelineStore(String caller) {
        if (!caller.equals("")) {
            this.callerUGI = UserGroupInformation.createRemoteUser((String)caller, (SaslRpcServer.AuthMethod)SaslRpcServer.AuthMethod.SIMPLE);
            this.conf.setBoolean("yarn.acl.enable", true);
            this.conf.set("yarn.admin.acl", "admin");
        }
    }

    private static void prepareTimelineStore(TimelineStore store, int scale) throws Exception {
        for (int i = 1; i <= scale; ++i) {
            TimelineEntities entities = new TimelineEntities();
            ApplicationId appId = ApplicationId.newInstance((long)0L, (int)i);
            if (i == 2) {
                entities.addEntity(TestApplicationHistoryManagerOnTimelineStore.createApplicationTimelineEntity(appId, true, false, false, true, YarnApplicationState.FINISHED));
            } else if (i == 3) {
                entities.addEntity(TestApplicationHistoryManagerOnTimelineStore.createApplicationTimelineEntity(appId, false, false, false, false, YarnApplicationState.FINISHED, true, false));
            } else if (i == 6) {
                entities.addEntity(TestApplicationHistoryManagerOnTimelineStore.createApplicationTimelineEntity(appId, false, false, false, false, YarnApplicationState.FINISHED, false, true));
            } else {
                entities.addEntity(TestApplicationHistoryManagerOnTimelineStore.createApplicationTimelineEntity(appId, false, false, false, false, YarnApplicationState.FINISHED));
            }
            store.put(entities);
            for (int j = 1; j <= scale; ++j) {
                entities = new TimelineEntities();
                ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)j);
                entities.addEntity(TestApplicationHistoryManagerOnTimelineStore.createAppAttemptTimelineEntity(appAttemptId));
                store.put(entities);
                for (int k = 1; k <= scale; ++k) {
                    entities = new TimelineEntities();
                    ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)k);
                    entities.addEntity(TestApplicationHistoryManagerOnTimelineStore.createContainerEntity(containerId));
                    store.put(entities);
                }
            }
        }
        TimelineEntities entities = new TimelineEntities();
        ApplicationId appId = ApplicationId.newInstance((long)1234L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        entities.addEntity(TestApplicationHistoryManagerOnTimelineStore.createApplicationTimelineEntity(appId, true, false, false, false, YarnApplicationState.RUNNING));
        entities.addEntity(TestApplicationHistoryManagerOnTimelineStore.createAppAttemptTimelineEntity(appAttemptId));
        entities.addEntity(TestApplicationHistoryManagerOnTimelineStore.createContainerEntity(containerId));
        store.put(entities);
    }

    @Test
    public void testGetApplicationReport() throws Exception {
        for (int i = 1; i <= 3; ++i) {
            final ApplicationId appId = ApplicationId.newInstance((long)0L, (int)i);
            ApplicationReport app = this.callerUGI == null ? this.historyManager.getApplication(appId) : (ApplicationReport)this.callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ApplicationReport>(){

                @Override
                public ApplicationReport run() throws Exception {
                    return TestApplicationHistoryManagerOnTimelineStore.this.historyManager.getApplication(appId);
                }
            });
            Assert.assertNotNull((Object)app);
            Assert.assertEquals((Object)appId, (Object)app.getApplicationId());
            Assert.assertEquals((Object)"test app", (Object)app.getName());
            Assert.assertEquals((Object)"test app type", (Object)app.getApplicationType());
            Assert.assertEquals((Object)"user1", (Object)app.getUser());
            if (i == 2) {
                Assert.assertEquals((Object)"changed queue1", (Object)app.getQueue());
                Assert.assertEquals((Object)Priority.newInstance((int)6), (Object)app.getPriority());
            } else {
                Assert.assertEquals((Object)"test queue", (Object)app.getQueue());
                Assert.assertEquals((Object)Priority.newInstance((int)0), (Object)app.getPriority());
            }
            Assert.assertEquals((long)(0x80000001L + (long)app.getApplicationId().getId()), (long)app.getStartTime());
            Assert.assertEquals((long)0x80000000L, (long)app.getSubmitTime());
            Assert.assertEquals((long)(0x80000002L + (long)app.getApplicationId().getId()), (long)app.getFinishTime());
            Assert.assertTrue(((double)Math.abs(app.getProgress() - 1.0f) < 1.0E-4 ? 1 : 0) != 0);
            Assert.assertEquals((long)2L, (long)app.getApplicationTags().size());
            Assert.assertTrue((boolean)app.getApplicationTags().contains("Test_APP_TAGS_1"));
            Assert.assertTrue((boolean)app.getApplicationTags().contains("Test_APP_TAGS_2"));
            if (i != 2 && this.callerUGI != null && this.callerUGI.getShortUserName().equals("user3") || i == 2 && this.callerUGI != null && (this.callerUGI.getShortUserName().equals("user2") || this.callerUGI.getShortUserName().equals("user3"))) {
                Assert.assertEquals((Object)ApplicationAttemptId.newInstance((ApplicationId)appId, (int)-1), (Object)app.getCurrentApplicationAttemptId());
                Assert.assertEquals((Object)"N/A", (Object)app.getHost());
                Assert.assertEquals((long)-1L, (long)app.getRpcPort());
                Assert.assertEquals((Object)"N/A", (Object)app.getTrackingUrl());
                Assert.assertEquals((Object)"N/A", (Object)app.getOriginalTrackingUrl());
                Assert.assertEquals((Object)"", (Object)app.getDiagnostics());
            } else {
                Assert.assertEquals((Object)ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), (Object)app.getCurrentApplicationAttemptId());
                Assert.assertEquals((Object)"test host", (Object)app.getHost());
                Assert.assertEquals((long)100L, (long)app.getRpcPort());
                Assert.assertEquals((Object)"test tracking url", (Object)app.getTrackingUrl());
                Assert.assertEquals((Object)"test original tracking url", (Object)app.getOriginalTrackingUrl());
                Assert.assertEquals((Object)"test diagnostics info", (Object)app.getDiagnostics());
            }
            ApplicationResourceUsageReport applicationResourceUsageReport = app.getApplicationResourceUsageReport();
            Assert.assertEquals((long)123L, (long)applicationResourceUsageReport.getMemorySeconds());
            Assert.assertEquals((long)345L, (long)applicationResourceUsageReport.getVcoreSeconds());
            long expectedPreemptMemSecs = 456L;
            long expectedPreemptVcoreSecs = 789L;
            if (i == 3) {
                expectedPreemptMemSecs = 0L;
                expectedPreemptVcoreSecs = 0L;
            }
            Assert.assertEquals((long)expectedPreemptMemSecs, (long)applicationResourceUsageReport.getPreemptedMemorySeconds());
            Assert.assertEquals((long)expectedPreemptVcoreSecs, (long)applicationResourceUsageReport.getPreemptedVcoreSeconds());
            Assert.assertEquals((Object)FinalApplicationStatus.UNDEFINED, (Object)app.getFinalApplicationStatus());
            Assert.assertEquals((Object)YarnApplicationState.FINISHED, (Object)app.getYarnApplicationState());
        }
    }

    @Test
    public void testGetApplicationReportWithNotAttempt() throws Exception {
        final ApplicationId appId = ApplicationId.newInstance((long)0L, (int)6);
        ApplicationReport app = this.callerUGI == null ? this.historyManager.getApplication(appId) : (ApplicationReport)this.callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ApplicationReport>(){

            @Override
            public ApplicationReport run() throws Exception {
                return TestApplicationHistoryManagerOnTimelineStore.this.historyManager.getApplication(appId);
            }
        });
        Assert.assertNotNull((Object)app);
        Assert.assertEquals((Object)appId, (Object)app.getApplicationId());
        Assert.assertEquals((Object)ApplicationAttemptId.newInstance((ApplicationId)appId, (int)-1), (Object)app.getCurrentApplicationAttemptId());
    }

    @Test
    public void testGetApplicationAttemptReport() throws Exception {
        ApplicationAttemptReport appAttempt;
        final ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        if (this.callerUGI == null) {
            appAttempt = this.historyManager.getApplicationAttempt(appAttemptId);
        } else {
            try {
                appAttempt = (ApplicationAttemptReport)this.callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ApplicationAttemptReport>(){

                    @Override
                    public ApplicationAttemptReport run() throws Exception {
                        return TestApplicationHistoryManagerOnTimelineStore.this.historyManager.getApplicationAttempt(appAttemptId);
                    }
                });
                if (this.callerUGI != null && this.callerUGI.getShortUserName().equals("user3")) {
                    Assert.fail();
                }
            }
            catch (AuthorizationException e) {
                if (this.callerUGI != null && this.callerUGI.getShortUserName().equals("user3")) {
                    return;
                }
                throw e;
            }
        }
        Assert.assertNotNull((Object)appAttempt);
        Assert.assertEquals((Object)appAttemptId, (Object)appAttempt.getApplicationAttemptId());
        Assert.assertEquals((Object)ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L), (Object)appAttempt.getAMContainerId());
        Assert.assertEquals((Object)"test host", (Object)appAttempt.getHost());
        Assert.assertEquals((long)100L, (long)appAttempt.getRpcPort());
        Assert.assertEquals((Object)"test tracking url", (Object)appAttempt.getTrackingUrl());
        Assert.assertEquals((Object)"test original tracking url", (Object)appAttempt.getOriginalTrackingUrl());
        Assert.assertEquals((Object)"test diagnostics info", (Object)appAttempt.getDiagnostics());
        Assert.assertEquals((Object)YarnApplicationAttemptState.FINISHED, (Object)appAttempt.getYarnApplicationAttemptState());
    }

    @Test
    public void testGetContainerReport() throws Exception {
        ContainerReport container;
        final ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (long)1L);
        if (this.callerUGI == null) {
            container = this.historyManager.getContainer(containerId);
        } else {
            try {
                container = (ContainerReport)this.callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ContainerReport>(){

                    @Override
                    public ContainerReport run() throws Exception {
                        return TestApplicationHistoryManagerOnTimelineStore.this.historyManager.getContainer(containerId);
                    }
                });
                if (this.callerUGI != null && this.callerUGI.getShortUserName().equals("user3")) {
                    Assert.fail();
                }
            }
            catch (AuthorizationException e) {
                if (this.callerUGI != null && this.callerUGI.getShortUserName().equals("user3")) {
                    return;
                }
                throw e;
            }
        }
        Assert.assertNotNull((Object)container);
        Assert.assertEquals((long)0x80000000L, (long)container.getCreationTime());
        Assert.assertEquals((long)0x80000001L, (long)container.getFinishTime());
        Assert.assertEquals((Object)Resource.newInstance((int)-1, (int)-1), (Object)container.getAllocatedResource());
        Assert.assertEquals((Object)NodeId.newInstance((String)"test host", (int)100), (Object)container.getAssignedNode());
        Assert.assertEquals((Object)Priority.UNDEFINED, (Object)container.getPriority());
        Assert.assertEquals((Object)"test diagnostics info", (Object)container.getDiagnosticsInfo());
        Assert.assertEquals((Object)ContainerState.COMPLETE, (Object)container.getContainerState());
        Assert.assertEquals((long)-1L, (long)container.getContainerExitStatus());
        Assert.assertEquals((Object)"http://0.0.0.0:8188/applicationhistory/logs/test host:100/container_0_0001_01_000001/container_0_0001_01_000001/user1", (Object)container.getLogUrl());
    }

    @Test
    public void testGetApplications() throws Exception {
        Collection apps = this.historyManager.getApplications(Long.MAX_VALUE, 0L, Long.MAX_VALUE).values();
        Assert.assertNotNull(apps);
        Assert.assertEquals((long)7L, (long)apps.size());
        ApplicationId ignoredAppId = ApplicationId.newInstance((long)0L, (int)7);
        for (ApplicationReport app : apps) {
            Assert.assertNotEquals((Object)ignoredAppId, (Object)app.getApplicationId());
        }
        apps = this.historyManager.getApplications(Long.MAX_VALUE, 0x80000005L, Long.MAX_VALUE).values();
        Assert.assertNotNull(apps);
        Assert.assertEquals((long)2L, (long)apps.size());
    }

    @Test
    public void testGetApplicationAttempts() throws Exception {
        Collection appAttempts;
        final ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        if (this.callerUGI == null) {
            appAttempts = this.historyManager.getApplicationAttempts(appId).values();
        } else {
            try {
                appAttempts = (Collection)this.callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Collection<ApplicationAttemptReport>>(){

                    @Override
                    public Collection<ApplicationAttemptReport> run() throws Exception {
                        return TestApplicationHistoryManagerOnTimelineStore.this.historyManager.getApplicationAttempts(appId).values();
                    }
                });
                if (this.callerUGI != null && this.callerUGI.getShortUserName().equals("user3")) {
                    Assert.fail();
                }
            }
            catch (AuthorizationException e) {
                if (this.callerUGI != null && this.callerUGI.getShortUserName().equals("user3")) {
                    return;
                }
                throw e;
            }
        }
        Assert.assertNotNull(appAttempts);
        Assert.assertEquals((long)5L, (long)appAttempts.size());
    }

    @Test
    public void testGetContainers() throws Exception {
        Collection containers;
        final ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        if (this.callerUGI == null) {
            containers = this.historyManager.getContainers(appAttemptId).values();
        } else {
            try {
                containers = (Collection)this.callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Collection<ContainerReport>>(){

                    @Override
                    public Collection<ContainerReport> run() throws Exception {
                        return TestApplicationHistoryManagerOnTimelineStore.this.historyManager.getContainers(appAttemptId).values();
                    }
                });
                if (this.callerUGI != null && this.callerUGI.getShortUserName().equals("user3")) {
                    Assert.fail();
                }
            }
            catch (AuthorizationException e) {
                if (this.callerUGI != null && this.callerUGI.getShortUserName().equals("user3")) {
                    return;
                }
                throw e;
            }
        }
        Assert.assertNotNull(containers);
        Assert.assertEquals((long)5L, (long)containers.size());
    }

    @Test
    public void testGetAMContainer() throws Exception {
        ContainerReport container;
        final ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        if (this.callerUGI == null) {
            container = this.historyManager.getAMContainer(appAttemptId);
        } else {
            try {
                container = (ContainerReport)this.callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ContainerReport>(){

                    @Override
                    public ContainerReport run() throws Exception {
                        return TestApplicationHistoryManagerOnTimelineStore.this.historyManager.getAMContainer(appAttemptId);
                    }
                });
                if (this.callerUGI != null && this.callerUGI.getShortUserName().equals("user3")) {
                    Assert.fail();
                }
            }
            catch (AuthorizationException e) {
                if (this.callerUGI != null && this.callerUGI.getShortUserName().equals("user3")) {
                    return;
                }
                throw e;
            }
        }
        Assert.assertNotNull((Object)container);
        Assert.assertEquals((Object)appAttemptId, (Object)container.getContainerId().getApplicationAttemptId());
    }

    private static TimelineEntity createApplicationTimelineEntity(ApplicationId appId, boolean emptyACLs, boolean noAttemptId, boolean wrongAppId, boolean enableUpdateEvent, YarnApplicationState state) {
        return TestApplicationHistoryManagerOnTimelineStore.createApplicationTimelineEntity(appId, emptyACLs, noAttemptId, wrongAppId, enableUpdateEvent, state, false, false);
    }

    private static TimelineEntity createApplicationTimelineEntity(ApplicationId appId, boolean emptyACLs, boolean noAttemptId, boolean wrongAppId, boolean enableUpdateEvent, YarnApplicationState state, boolean missingPreemptMetrics, boolean missingQueue) {
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityType("YARN_APPLICATION");
        if (wrongAppId) {
            entity.setEntityId("wrong_app_id");
        } else {
            entity.setEntityId(appId.toString());
        }
        entity.setDomainId("DEFAULT");
        entity.addPrimaryFilter(TimelineStore.SystemFilter.ENTITY_OWNER.toString(), (Object)"yarn");
        HashMap<String, Object> entityInfo = new HashMap<String, Object>();
        entityInfo.put("YARN_APPLICATION_NAME", "test app");
        entityInfo.put("YARN_APPLICATION_TYPE", "test app type");
        entityInfo.put("YARN_APPLICATION_USER", "user1");
        if (!missingQueue) {
            entityInfo.put("YARN_APPLICATION_QUEUE", "test queue");
        }
        entityInfo.put("YARN_APPLICATION_UNMANAGED_APPLICATION", "false");
        entityInfo.put("YARN_APPLICATION_PRIORITY", Priority.newInstance((int)0));
        entityInfo.put("YARN_APPLICATION_SUBMITTED_TIME", 0x80000000L);
        entityInfo.put("YARN_APPLICATION_MEMORY", 123);
        entityInfo.put("YARN_APPLICATION_CPU", 345);
        if (!missingPreemptMetrics) {
            entityInfo.put("YARN_APPLICATION_MEM_PREEMPT_METRIC", 456);
            entityInfo.put("YARN_APPLICATION_CPU_PREEMPT_METRIC", 789);
        }
        if (emptyACLs) {
            entityInfo.put("YARN_APPLICATION_VIEW_ACLS", "");
        } else {
            entityInfo.put("YARN_APPLICATION_VIEW_ACLS", "user2");
        }
        HashSet<String> appTags = new HashSet<String>();
        appTags.add("Test_APP_TAGS_1");
        appTags.add("Test_APP_TAGS_2");
        entityInfo.put("YARN_APPLICATION_TAGS", appTags);
        entity.setOtherInfo(entityInfo);
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setEventType("YARN_APPLICATION_CREATED");
        tEvent.setTimestamp(0x80000001L + (long)appId.getId());
        entity.addEvent(tEvent);
        tEvent = new TimelineEvent();
        tEvent.setEventType("YARN_APPLICATION_FINISHED");
        tEvent.setTimestamp(0x80000002L + (long)appId.getId());
        HashMap<String, String> eventInfo = new HashMap<String, String>();
        eventInfo.put("YARN_APPLICATION_DIAGNOSTICS_INFO", "test diagnostics info");
        eventInfo.put("YARN_APPLICATION_FINAL_STATUS", FinalApplicationStatus.UNDEFINED.toString());
        eventInfo.put("YARN_APPLICATION_STATE", state.toString());
        if (!noAttemptId) {
            eventInfo.put("YARN_APPLICATION_LATEST_APP_ATTEMPT", (String)ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1));
        }
        tEvent.setEventInfo(eventInfo);
        entity.addEvent(tEvent);
        tEvent = new TimelineEvent();
        tEvent.setEventType("YARN_APPLICATION_STATE_UPDATED");
        tEvent.setTimestamp(0x80000003L + (long)appId.getId());
        eventInfo = new HashMap();
        eventInfo.put("YARN_APPLICATION_STATE", (String)YarnApplicationState.KILLED);
        tEvent.setEventInfo(eventInfo);
        entity.addEvent(tEvent);
        if (enableUpdateEvent) {
            tEvent = new TimelineEvent();
            long updatedTimeIndex = 4L;
            TestApplicationHistoryManagerOnTimelineStore.createAppModifiedEvent(appId, tEvent, updatedTimeIndex++, "changed queue", 5);
            entity.addEvent(tEvent);
            tEvent = new TimelineEvent();
            TestApplicationHistoryManagerOnTimelineStore.createAppModifiedEvent(appId, tEvent, updatedTimeIndex++, "changed queue", 6);
            tEvent = new TimelineEvent();
            TestApplicationHistoryManagerOnTimelineStore.createAppModifiedEvent(appId, tEvent, updatedTimeIndex++, "changed queue1", 6);
            entity.addEvent(tEvent);
        }
        return entity;
    }

    private static void createAppModifiedEvent(ApplicationId appId, TimelineEvent tEvent, long updatedTimeIndex, String queue, int priority) {
        tEvent.setEventType("YARN_APPLICATION_UPDATED");
        tEvent.setTimestamp(Integer.MAX_VALUE + updatedTimeIndex + (long)appId.getId());
        HashMap<String, Object> eventInfo = new HashMap<String, Object>();
        eventInfo.put("YARN_APPLICATION_QUEUE", queue);
        eventInfo.put("YARN_APPLICATION_PRIORITY", priority);
        tEvent.setEventInfo(eventInfo);
    }

    private static TimelineEntity createAppAttemptTimelineEntity(ApplicationAttemptId appAttemptId) {
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityType("YARN_APPLICATION_ATTEMPT");
        entity.setEntityId(appAttemptId.toString());
        entity.setDomainId("DEFAULT");
        entity.addPrimaryFilter("YARN_APPLICATION_ATTEMPT_PARENT", (Object)appAttemptId.getApplicationId().toString());
        entity.addPrimaryFilter(TimelineStore.SystemFilter.ENTITY_OWNER.toString(), (Object)"yarn");
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setEventType("YARN_APPLICATION_ATTEMPT_REGISTERED");
        tEvent.setTimestamp(0x80000000L);
        HashMap<String, Object> eventInfo = new HashMap<String, Object>();
        eventInfo.put("YARN_APPLICATION_ATTEMPT_TRACKING_URL", "test tracking url");
        eventInfo.put("YARN_APPLICATION_ATTEMPT_ORIGINAL_TRACKING_URL", "test original tracking url");
        eventInfo.put("YARN_APPLICATION_ATTEMPT_HOST", "test host");
        eventInfo.put("YARN_APPLICATION_ATTEMPT_RPC_PORT", 100);
        eventInfo.put("YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER", ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L));
        tEvent.setEventInfo(eventInfo);
        entity.addEvent(tEvent);
        tEvent = new TimelineEvent();
        tEvent.setEventType("YARN_APPLICATION_ATTEMPT_FINISHED");
        tEvent.setTimestamp(0x80000001L);
        eventInfo = new HashMap();
        eventInfo.put("YARN_APPLICATION_ATTEMPT_TRACKING_URL", "test tracking url");
        eventInfo.put("YARN_APPLICATION_ATTEMPT_ORIGINAL_TRACKING_URL", "test original tracking url");
        eventInfo.put("YARN_APPLICATION_ATTEMPT_DIAGNOSTICS_INFO", "test diagnostics info");
        eventInfo.put("YARN_APPLICATION_ATTEMPT_FINAL_STATUS", FinalApplicationStatus.UNDEFINED.toString());
        eventInfo.put("YARN_APPLICATION_ATTEMPT_STATE", YarnApplicationAttemptState.FINISHED.toString());
        tEvent.setEventInfo(eventInfo);
        entity.addEvent(tEvent);
        return entity;
    }

    private static TimelineEntity createContainerEntity(ContainerId containerId) {
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityType("YARN_CONTAINER");
        entity.setEntityId(containerId.toString());
        entity.setDomainId("DEFAULT");
        entity.addPrimaryFilter("YARN_CONTAINER_PARENT", (Object)containerId.getApplicationAttemptId().toString());
        entity.addPrimaryFilter(TimelineStore.SystemFilter.ENTITY_OWNER.toString(), (Object)"yarn");
        HashMap<String, Object> entityInfo = new HashMap<String, Object>();
        entityInfo.put("YARN_CONTAINER_ALLOCATED_MEMORY", -1);
        entityInfo.put("YARN_CONTAINER_ALLOCATED_VCORE", -1);
        entityInfo.put("YARN_CONTAINER_ALLOCATED_HOST", "test host");
        entityInfo.put("YARN_CONTAINER_ALLOCATED_PORT", 100);
        entityInfo.put("YARN_CONTAINER_ALLOCATED_PRIORITY", -1);
        entityInfo.put("YARN_CONTAINER_ALLOCATED_HOST_HTTP_ADDRESS", "http://test:1234");
        entity.setOtherInfo(entityInfo);
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setEventType("YARN_CONTAINER_CREATED");
        tEvent.setTimestamp(0x80000000L);
        entity.addEvent(tEvent);
        tEvent = new TimelineEvent();
        tEvent.setEventType("YARN_CONTAINER_FINISHED");
        tEvent.setTimestamp(0x80000001L);
        HashMap<String, Object> eventInfo = new HashMap<String, Object>();
        eventInfo.put("YARN_CONTAINER_DIAGNOSTICS_INFO", "test diagnostics info");
        eventInfo.put("YARN_CONTAINER_EXIT_STATUS", -1);
        eventInfo.put("YARN_CONTAINER_STATE", ContainerState.COMPLETE.toString());
        tEvent.setEventInfo(eventInfo);
        entity.addEvent(tEvent);
        return entity;
    }
}

