/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.timeline.GenericObjectMapper;
import org.apache.hadoop.yarn.server.timeline.LeveldbTimelineStore;
import org.apache.hadoop.yarn.server.timeline.NameValuePair;
import org.apache.hadoop.yarn.server.timeline.TimelineStoreTestUtils;
import org.apache.hadoop.yarn.server.utils.LeveldbIterator;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.Options;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TestLeveldbTimelineStore
extends TimelineStoreTestUtils {
    private FileContext fsContext;
    private File fsPath;
    private Configuration config = new YarnConfiguration();

    @Before
    public void setup() throws Exception {
        this.fsContext = FileContext.getLocalFSFileContext();
        this.fsPath = new File("target", this.getClass().getSimpleName() + "-tmpDir").getAbsoluteFile();
        this.fsContext.delete(new Path(this.fsPath.getAbsolutePath()), true);
        this.config.set("yarn.timeline-service.leveldb-timeline-store.path", this.fsPath.getAbsolutePath());
        this.config.setBoolean("yarn.timeline-service.ttl-enable", false);
        this.store = new LeveldbTimelineStore();
        this.store.init(this.config);
        this.store.start();
        this.loadTestEntityData();
        this.loadVerificationEntityData();
        this.loadTestDomainData();
    }

    @After
    public void tearDown() throws Exception {
        this.store.stop();
        this.fsContext.delete(new Path(this.fsPath.getAbsolutePath()), true);
    }

    @Test
    public void testRootDirPermission() throws IOException {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)new YarnConfiguration());
        FileStatus file = fs.getFileStatus(new Path(this.fsPath.getAbsolutePath(), "leveldb-timeline-store.ldb"));
        Assert.assertNotNull((Object)file);
        Assert.assertEquals((Object)LeveldbTimelineStore.LEVELDB_DIR_UMASK, (Object)file.getPermission());
    }

    @Override
    @Test
    public void testGetSingleEntity() throws IOException {
        super.testGetSingleEntity();
        ((LeveldbTimelineStore)this.store).clearStartTimeCache();
        super.testGetSingleEntity();
        this.loadTestEntityData();
    }

    @Override
    @Test
    public void testGetEntities() throws IOException {
        super.testGetEntities();
    }

    @Override
    @Test
    public void testGetEntitiesWithFromId() throws IOException {
        super.testGetEntitiesWithFromId();
    }

    @Override
    @Test
    public void testGetEntitiesWithFromTs() throws IOException {
        super.testGetEntitiesWithFromTs();
    }

    @Override
    @Test
    public void testGetEntitiesWithPrimaryFilters() throws IOException {
        super.testGetEntitiesWithPrimaryFilters();
    }

    @Override
    @Test
    public void testGetEntitiesWithSecondaryFilters() throws IOException {
        super.testGetEntitiesWithSecondaryFilters();
    }

    @Override
    @Test
    public void testGetEvents() throws IOException {
        super.testGetEvents();
    }

    @Test
    public void testCacheSizes() {
        Configuration conf = new Configuration();
        Assert.assertEquals((long)10000L, (long)LeveldbTimelineStore.getStartTimeReadCacheSize((Configuration)conf));
        Assert.assertEquals((long)10000L, (long)LeveldbTimelineStore.getStartTimeWriteCacheSize((Configuration)conf));
        conf.setInt("yarn.timeline-service.leveldb-timeline-store.start-time-read-cache-size", 10001);
        Assert.assertEquals((long)10001L, (long)LeveldbTimelineStore.getStartTimeReadCacheSize((Configuration)conf));
        conf = new Configuration();
        conf.setInt("yarn.timeline-service.leveldb-timeline-store.start-time-write-cache-size", 10002);
        Assert.assertEquals((long)10002L, (long)LeveldbTimelineStore.getStartTimeWriteCacheSize((Configuration)conf));
    }

    private boolean deleteNextEntity(String entityType, byte[] ts) throws IOException, InterruptedException {
        boolean bl;
        LeveldbIterator iterator = null;
        LeveldbIterator pfIterator = null;
        try {
            iterator = ((LeveldbTimelineStore)this.store).getDbIterator(false);
            pfIterator = ((LeveldbTimelineStore)this.store).getDbIterator(false);
            bl = ((LeveldbTimelineStore)this.store).deleteNextEntity(entityType, ts, iterator, pfIterator, false);
        }
        catch (DBException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{iterator, pfIterator});
                throw throwable;
            }
        }
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{iterator, pfIterator});
        return bl;
    }

    @Test
    public void testGetEntityTypes() throws IOException {
        List entityTypes = ((LeveldbTimelineStore)this.store).getEntityTypes();
        Assert.assertEquals((long)7L, (long)entityTypes.size());
        Assert.assertEquals((Object)"ACL_ENTITY_TYPE_1", entityTypes.get(0));
        Assert.assertEquals((Object)"OLD_ENTITY_TYPE_1", entityTypes.get(1));
        Assert.assertEquals((Object)this.entityType1, entityTypes.get(2));
        Assert.assertEquals((Object)this.entityType2, entityTypes.get(3));
        Assert.assertEquals((Object)this.entityType4, entityTypes.get(4));
        Assert.assertEquals((Object)this.entityType5, entityTypes.get(5));
    }

    @Test
    public void testDeleteEntities() throws IOException, InterruptedException {
        Assert.assertEquals((long)3L, (long)this.getEntities("type_1").size());
        Assert.assertEquals((long)1L, (long)this.getEntities("type_2").size());
        Assert.assertEquals((Object)false, (Object)this.deleteNextEntity(this.entityType1, GenericObjectMapper.writeReverseOrderedLong((long)60L)));
        Assert.assertEquals((long)3L, (long)this.getEntities("type_1").size());
        Assert.assertEquals((long)1L, (long)this.getEntities("type_2").size());
        Assert.assertEquals((Object)true, (Object)this.deleteNextEntity(this.entityType1, GenericObjectMapper.writeReverseOrderedLong((long)123L)));
        List<TimelineEntity> entities = this.getEntities("type_2");
        Assert.assertEquals((long)1L, (long)entities.size());
        TestLeveldbTimelineStore.verifyEntityInfo(this.entityId2, this.entityType2, this.events2, Collections.singletonMap(this.entityType1, Collections.singleton(this.entityId1b)), EMPTY_PRIMARY_FILTERS, EMPTY_MAP, entities.get(0), this.domainId1);
        entities = this.getEntitiesWithPrimaryFilter("type_1", this.userFilter);
        Assert.assertEquals((long)2L, (long)entities.size());
        TestLeveldbTimelineStore.verifyEntityInfo(this.entityId1b, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(0), this.domainId1);
        TestLeveldbTimelineStore.verifyEntityInfo(this.entityId6, this.entityType1, EMPTY_EVENTS, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(1), this.domainId2);
        ((LeveldbTimelineStore)this.store).discardOldEntities(0L);
        Assert.assertEquals((long)2L, (long)this.getEntities("type_1").size());
        Assert.assertEquals((long)0L, (long)this.getEntities("type_2").size());
        Assert.assertEquals((long)6L, (long)((LeveldbTimelineStore)this.store).getEntityTypes().size());
        ((LeveldbTimelineStore)this.store).discardOldEntities(123L);
        Assert.assertEquals((long)0L, (long)this.getEntities("type_1").size());
        Assert.assertEquals((long)0L, (long)this.getEntities("type_2").size());
        Assert.assertEquals((long)0L, (long)((LeveldbTimelineStore)this.store).getEntityTypes().size());
        Assert.assertEquals((long)0L, (long)this.getEntitiesWithPrimaryFilter("type_1", this.userFilter).size());
    }

    @Test
    public void testDeleteEntitiesPrimaryFilters() throws IOException, InterruptedException {
        Map<String, Set<Object>> primaryFilter = Collections.singletonMap("user", Collections.singleton("otheruser"));
        TimelineEntities atsEntities = new TimelineEntities();
        atsEntities.setEntities(Collections.singletonList(TestLeveldbTimelineStore.createEntity(this.entityId1b, this.entityType1, 789L, Collections.singletonList(this.ev2), null, primaryFilter, null, this.domainId1)));
        TimelinePutResponse response = this.store.put(atsEntities);
        Assert.assertEquals((long)0L, (long)response.getErrors().size());
        NameValuePair pfPair = new NameValuePair("user", (Object)"otheruser");
        List<TimelineEntity> entities = this.getEntitiesWithPrimaryFilter("type_1", pfPair);
        Assert.assertEquals((long)1L, (long)entities.size());
        TestLeveldbTimelineStore.verifyEntityInfo(this.entityId1b, this.entityType1, Collections.singletonList(this.ev2), EMPTY_REL_ENTITIES, primaryFilter, EMPTY_MAP, entities.get(0), this.domainId1);
        entities = this.getEntitiesWithPrimaryFilter("type_1", this.userFilter);
        Assert.assertEquals((long)3L, (long)entities.size());
        TestLeveldbTimelineStore.verifyEntityInfo(this.entityId1, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(0), this.domainId1);
        TestLeveldbTimelineStore.verifyEntityInfo(this.entityId1b, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(1), this.domainId1);
        TestLeveldbTimelineStore.verifyEntityInfo(this.entityId6, this.entityType1, EMPTY_EVENTS, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(2), this.domainId2);
        ((LeveldbTimelineStore)this.store).discardOldEntities(-123L);
        Assert.assertEquals((long)1L, (long)this.getEntitiesWithPrimaryFilter("type_1", pfPair).size());
        Assert.assertEquals((long)3L, (long)this.getEntitiesWithPrimaryFilter("type_1", this.userFilter).size());
        ((LeveldbTimelineStore)this.store).discardOldEntities(123L);
        Assert.assertEquals((long)0L, (long)this.getEntities("type_1").size());
        Assert.assertEquals((long)0L, (long)this.getEntities("type_2").size());
        Assert.assertEquals((long)0L, (long)((LeveldbTimelineStore)this.store).getEntityTypes().size());
        Assert.assertEquals((long)0L, (long)this.getEntitiesWithPrimaryFilter("type_1", pfPair).size());
        Assert.assertEquals((long)0L, (long)this.getEntitiesWithPrimaryFilter("type_1", this.userFilter).size());
    }

    @Test
    public void testFromTsWithDeletion() throws IOException, InterruptedException {
        long l = System.currentTimeMillis();
        Assert.assertEquals((long)3L, (long)this.getEntitiesFromTs("type_1", l).size());
        Assert.assertEquals((long)1L, (long)this.getEntitiesFromTs("type_2", l).size());
        Assert.assertEquals((long)3L, (long)this.getEntitiesFromTsWithPrimaryFilter("type_1", this.userFilter, l).size());
        ((LeveldbTimelineStore)this.store).discardOldEntities(123L);
        Assert.assertEquals((long)0L, (long)this.getEntitiesFromTs("type_1", l).size());
        Assert.assertEquals((long)0L, (long)this.getEntitiesFromTs("type_2", l).size());
        Assert.assertEquals((long)0L, (long)this.getEntitiesFromTsWithPrimaryFilter("type_1", this.userFilter, l).size());
        Assert.assertEquals((long)0L, (long)this.getEntities("type_1").size());
        Assert.assertEquals((long)0L, (long)this.getEntities("type_2").size());
        Assert.assertEquals((long)0L, (long)this.getEntitiesFromTsWithPrimaryFilter("type_1", this.userFilter, l).size());
        this.loadTestEntityData();
        Assert.assertEquals((long)0L, (long)this.getEntitiesFromTs("type_1", l).size());
        Assert.assertEquals((long)0L, (long)this.getEntitiesFromTs("type_2", l).size());
        Assert.assertEquals((long)0L, (long)this.getEntitiesFromTsWithPrimaryFilter("type_1", this.userFilter, l).size());
        Assert.assertEquals((long)3L, (long)this.getEntities("type_1").size());
        Assert.assertEquals((long)1L, (long)this.getEntities("type_2").size());
        Assert.assertEquals((long)3L, (long)this.getEntitiesWithPrimaryFilter("type_1", this.userFilter).size());
    }

    @Test
    public void testCheckVersion() throws IOException {
        LeveldbTimelineStore dbStore = (LeveldbTimelineStore)this.store;
        Version defaultVersion = dbStore.getCurrentVersion();
        Assert.assertEquals((Object)defaultVersion, (Object)dbStore.loadVersion());
        Version compatibleVersion = Version.newInstance((int)defaultVersion.getMajorVersion(), (int)(defaultVersion.getMinorVersion() + 2));
        dbStore.storeVersion(compatibleVersion);
        Assert.assertEquals((Object)compatibleVersion, (Object)dbStore.loadVersion());
        this.restartTimelineStore();
        dbStore = (LeveldbTimelineStore)this.store;
        Assert.assertEquals((Object)defaultVersion, (Object)dbStore.loadVersion());
        Version incompatibleVersion = Version.newInstance((int)(defaultVersion.getMajorVersion() + 1), (int)defaultVersion.getMinorVersion());
        dbStore.storeVersion(incompatibleVersion);
        try {
            this.restartTimelineStore();
            Assert.fail((String)"Incompatible version, should expect fail here.");
        }
        catch (ServiceStateException e) {
            Assert.assertTrue((String)"Exception message mismatch", (boolean)e.getMessage().contains("Incompatible version for timeline store"));
        }
    }

    @Test
    public void testValidateConfig() throws IOException {
        YarnConfiguration newConfig;
        YarnConfiguration copyConfig = new YarnConfiguration(this.config);
        try {
            newConfig = new YarnConfiguration((Configuration)copyConfig);
            newConfig.setLong("yarn.timeline-service.ttl-ms", 0L);
            this.config = newConfig;
            this.restartTimelineStore();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("yarn.timeline-service.ttl-ms"));
        }
        try {
            newConfig = new YarnConfiguration((Configuration)copyConfig);
            newConfig.setLong("yarn.timeline-service.leveldb-timeline-store.ttl-interval-ms", 0L);
            this.config = newConfig;
            this.restartTimelineStore();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("yarn.timeline-service.leveldb-timeline-store.ttl-interval-ms"));
        }
        try {
            newConfig = new YarnConfiguration((Configuration)copyConfig);
            newConfig.setLong("yarn.timeline-service.leveldb-timeline-store.read-cache-size", -1L);
            this.config = newConfig;
            this.restartTimelineStore();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("yarn.timeline-service.leveldb-timeline-store.read-cache-size"));
        }
        try {
            newConfig = new YarnConfiguration((Configuration)copyConfig);
            newConfig.setLong("yarn.timeline-service.leveldb-timeline-store.start-time-read-cache-size", 0L);
            this.config = newConfig;
            this.restartTimelineStore();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("yarn.timeline-service.leveldb-timeline-store.start-time-read-cache-size"));
        }
        try {
            newConfig = new YarnConfiguration((Configuration)copyConfig);
            newConfig.setLong("yarn.timeline-service.leveldb-timeline-store.start-time-write-cache-size", 0L);
            this.config = newConfig;
            this.restartTimelineStore();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("yarn.timeline-service.leveldb-timeline-store.start-time-write-cache-size"));
        }
        this.config = copyConfig;
        this.restartTimelineStore();
    }

    private void restartTimelineStore() throws IOException {
        if (this.store != null) {
            this.store.close();
        }
        this.store = new LeveldbTimelineStore();
        this.store.init(this.config);
        this.store.start();
    }

    @Override
    @Test
    public void testGetDomain() throws IOException {
        super.testGetDomain();
    }

    @Override
    @Test
    public void testGetDomains() throws IOException {
        super.testGetDomains();
    }

    @Test
    public void testRelatingToNonExistingEntity() throws IOException {
        TimelineEntity entityToStore = new TimelineEntity();
        entityToStore.setEntityType("TEST_ENTITY_TYPE_1");
        entityToStore.setEntityId("TEST_ENTITY_ID_1");
        entityToStore.setDomainId("DEFAULT");
        entityToStore.addRelatedEntity("TEST_ENTITY_TYPE_2", "TEST_ENTITY_ID_2");
        TimelineEntities entities = new TimelineEntities();
        entities.addEntity(entityToStore);
        this.store.put(entities);
        TimelineEntity entityToGet = this.store.getEntity("TEST_ENTITY_ID_2", "TEST_ENTITY_TYPE_2", null);
        Assert.assertNotNull((Object)entityToGet);
        Assert.assertEquals((Object)"DEFAULT", (Object)entityToGet.getDomainId());
        Assert.assertEquals((Object)"TEST_ENTITY_TYPE_1", entityToGet.getRelatedEntities().keySet().iterator().next());
        Assert.assertEquals((Object)"TEST_ENTITY_ID_1", ((Set)entityToGet.getRelatedEntities().values().iterator().next()).iterator().next());
    }

    @Test
    public void testRelatingToOldEntityWithoutDomainId() throws IOException {
        TimelineEntity entityToStore = new TimelineEntity();
        entityToStore.setEntityType("NEW_ENTITY_TYPE_1");
        entityToStore.setEntityId("NEW_ENTITY_ID_1");
        entityToStore.setDomainId("DEFAULT");
        entityToStore.addRelatedEntity("OLD_ENTITY_TYPE_1", "OLD_ENTITY_ID_1");
        TimelineEntities entities = new TimelineEntities();
        entities.addEntity(entityToStore);
        this.store.put(entities);
        TimelineEntity entityToGet = this.store.getEntity("OLD_ENTITY_ID_1", "OLD_ENTITY_TYPE_1", null);
        Assert.assertNotNull((Object)entityToGet);
        Assert.assertNull((Object)entityToGet.getDomainId());
        Assert.assertEquals((Object)"NEW_ENTITY_TYPE_1", entityToGet.getRelatedEntities().keySet().iterator().next());
        Assert.assertEquals((Object)"NEW_ENTITY_ID_1", ((Set)entityToGet.getRelatedEntities().values().iterator().next()).iterator().next());
        entityToStore = new TimelineEntity();
        entityToStore.setEntityType("NEW_ENTITY_TYPE_2");
        entityToStore.setEntityId("NEW_ENTITY_ID_2");
        entityToStore.setDomainId("NON_DEFAULT");
        entityToStore.addRelatedEntity("OLD_ENTITY_TYPE_1", "OLD_ENTITY_ID_1");
        entities = new TimelineEntities();
        entities.addEntity(entityToStore);
        TimelinePutResponse response = this.store.put(entities);
        Assert.assertEquals((long)1L, (long)response.getErrors().size());
        Assert.assertEquals((long)6L, (long)((TimelinePutResponse.TimelinePutError)response.getErrors().get(0)).getErrorCode());
        entityToGet = this.store.getEntity("OLD_ENTITY_ID_1", "OLD_ENTITY_TYPE_1", null);
        Assert.assertNotNull((Object)entityToGet);
        Assert.assertNull((Object)entityToGet.getDomainId());
        Assert.assertEquals((long)1L, (long)entityToGet.getRelatedEntities().keySet().size());
        Assert.assertEquals((long)1L, (long)((Set)entityToGet.getRelatedEntities().values().iterator().next()).size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLevelDbRepair() throws IOException {
        LeveldbTimelineStore store = new LeveldbTimelineStore();
        JniDBFactory factory = (JniDBFactory)Mockito.mock(JniDBFactory.class);
        Mockito.when((Object)factory.open((File)Mockito.any(File.class), (Options)Mockito.any(Options.class))).thenThrow(new Throwable[]{new IOException()}).thenCallRealMethod();
        store.setFactory(factory);
        File path = new File("target", this.getClass().getSimpleName() + "-tmpDir1").getAbsoluteFile();
        Configuration conf = new Configuration(this.config);
        conf.set("yarn.timeline-service.leveldb-timeline-store.path", path.getAbsolutePath());
        try {
            store.init(conf);
            ((JniDBFactory)Mockito.verify((Object)factory, (VerificationMode)Mockito.times((int)1))).repair((File)Mockito.any(File.class), (Options)Mockito.any(Options.class));
            WildcardFileFilter fileFilter = new WildcardFileFilter("*.backup-*");
            Assert.assertTrue((path.listFiles((FileFilter)fileFilter).length > 0 ? 1 : 0) != 0);
        }
        finally {
            store.close();
            this.fsContext.delete(new Path(path.getAbsolutePath()), true);
        }
    }
}

