/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.ProcfsBasedProcessTree;
import org.apache.hadoop.yarn.util.SystemClock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestProcfsBasedProcessTree {
    private static final Logger LOG = LoggerFactory.getLogger(TestProcfsBasedProcessTree.class);
    protected static File TEST_ROOT_DIR = new File("target", TestProcfsBasedProcessTree.class.getName() + "-localDir");
    private Shell.ShellCommandExecutor shexec = null;
    private String pidFile;
    private String lowestDescendant;
    private String lostDescendant;
    private String shellScript;
    private static final int N = 6;

    private String getRogueTaskPID() {
        File f = new File(this.pidFile);
        while (!f.exists()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ie) {
                break;
            }
        }
        return TestProcfsBasedProcessTree.getPidFromPidFile(this.pidFile);
    }

    @BeforeEach
    public void setup() throws IOException {
        Assumptions.assumeTrue((boolean)Shell.LINUX);
        FileContext.getLocalFSFileContext().delete(new Path(TEST_ROOT_DIR.getAbsolutePath()), true);
    }

    @Test
    @Timeout(value=30000L)
    void testProcessTree() throws Exception {
        try {
            Assertions.assertTrue((boolean)ProcfsBasedProcessTree.isAvailable());
        }
        catch (Exception e) {
            LOG.info(StringUtils.stringifyException((Throwable)e));
            Assertions.assertTrue((boolean)false, (String)"ProcfsBaseProcessTree should be available on Linux");
            return;
        }
        Random rm = new Random();
        File tempFile = new File(TEST_ROOT_DIR, this.getClass().getName() + "_shellScript_" + rm.nextInt() + ".sh");
        tempFile.deleteOnExit();
        this.shellScript = TEST_ROOT_DIR + File.separator + tempFile.getName();
        tempFile = new File(TEST_ROOT_DIR, this.getClass().getName() + "_pidFile_" + rm.nextInt() + ".pid");
        tempFile.deleteOnExit();
        this.pidFile = TEST_ROOT_DIR + File.separator + tempFile.getName();
        this.lowestDescendant = TEST_ROOT_DIR + File.separator + "lowestDescendantPidFile";
        this.lostDescendant = TEST_ROOT_DIR + File.separator + "lostDescendantPidFile";
        File file = new File(this.shellScript);
        FileUtils.writeStringToFile((File)file, (String)("# rogue task\nsleep 1\necho hello\nif [ $1 -ne 0 ]\nthen\n sh " + this.shellScript + " $(($1-1))\nelse\n echo $$ > " + this.lowestDescendant + "\n(sleep 300&\necho $! > " + this.lostDescendant + ")\n while true\n do\n  sleep 5\n done\nfi"), (Charset)StandardCharsets.UTF_8);
        RogueTaskThread t = new RogueTaskThread();
        t.start();
        String pid = this.getRogueTaskPID();
        LOG.info("Root process pid: " + pid);
        ProcfsBasedProcessTree p = this.createProcessTree(pid);
        p.updateProcessTree();
        LOG.info("ProcessTree: " + p);
        File leaf = new File(this.lowestDescendant);
        while (!leaf.exists()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ie) {
                // empty catch block
                break;
            }
        }
        p.updateProcessTree();
        LOG.info("ProcessTree: " + p);
        String lostpid = TestProcfsBasedProcessTree.getPidFromPidFile(this.lostDescendant);
        LOG.info("Orphaned pid: " + lostpid);
        Assertions.assertTrue((boolean)p.contains(lostpid), (String)"Child process owned by init escaped process tree.");
        String processTreeDump = p.getProcessTreeDump();
        this.destroyProcessTree(pid);
        boolean isAlive = true;
        for (int tries = 100; tries > 0 && (isAlive = TestProcfsBasedProcessTree.isSetsidAvailable() ? TestProcfsBasedProcessTree.isAnyProcessInTreeAlive(p) : TestProcfsBasedProcessTree.isAlive(pid)); --tries) {
            Thread.sleep(100L);
        }
        if (isAlive) {
            Assertions.fail((String)"ProcessTree shouldn't be alive");
        }
        LOG.info("Process-tree dump follows: \n" + processTreeDump);
        Assertions.assertTrue((boolean)processTreeDump.startsWith("\t|- PID PPID PGRPID SESSID CMD_NAME USER_MODE_TIME(MILLIS) SYSTEM_TIME(MILLIS) VMEM_USAGE(BYTES) RSSMEM_USAGE(PAGES) FULL_CMD_LINE\n"), (String)"Process-tree dump doesn't start with a proper header");
        for (int i = 6; i >= 0; --i) {
            String cmdLineDump = "\\|- [0-9]+ [0-9]+ [0-9]+ [0-9]+ \\(sh\\) [0-9]+ [0-9]+ [0-9]+ [0-9]+ sh " + this.shellScript + " " + i;
            Pattern pat = Pattern.compile(cmdLineDump);
            Matcher mat = pat.matcher(processTreeDump);
            Assertions.assertTrue((boolean)mat.find(), (String)("Process-tree dump doesn't contain the cmdLineDump of " + i + "th process!"));
        }
        try {
            t.join(2000L);
            LOG.info("RogueTaskThread successfully joined.");
        }
        catch (InterruptedException ie) {
            LOG.info("Interrupted while joining RogueTaskThread.");
        }
        p.updateProcessTree();
        Assertions.assertFalse((boolean)TestProcfsBasedProcessTree.isAlive(pid), (String)"ProcessTree must have been gone");
        Assertions.assertTrue((p.getVirtualMemorySize() == -1L ? 1 : 0) != 0, (String)("vmem for the gone-process is " + p.getVirtualMemorySize() + " . It should be UNAVAILABLE(-1)."));
        Assertions.assertEquals((Object)"[ ]", (Object)p.toString());
    }

    protected ProcfsBasedProcessTree createProcessTree(String pid) {
        return new ProcfsBasedProcessTree(pid);
    }

    protected ProcfsBasedProcessTree createProcessTree(String pid, String procfsRootDir, Clock clock) {
        return new ProcfsBasedProcessTree(pid, procfsRootDir, clock);
    }

    protected void destroyProcessTree(String pid) throws IOException {
        TestProcfsBasedProcessTree.sendSignal("-" + pid, 9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPidFromPidFile(String pidFileName) {
        BufferedReader pidFile = null;
        FileReader fReader = null;
        String pid = null;
        try {
            fReader = new FileReader(pidFileName);
            pidFile = new BufferedReader(fReader);
        }
        catch (FileNotFoundException f) {
            LOG.debug("PidFile doesn't exist : {}", (Object)pidFileName);
            return pid;
        }
        try {
            pid = pidFile.readLine();
        }
        catch (IOException i) {
            LOG.error("Failed to read from " + pidFileName);
        }
        finally {
            try {
                if (fReader != null) {
                    fReader.close();
                }
                try {
                    if (pidFile != null) {
                        pidFile.close();
                    }
                }
                catch (IOException i) {
                    LOG.warn("Error closing the stream " + pidFile);
                }
            }
            catch (IOException i) {
                LOG.warn("Error closing the stream " + fReader);
            }
        }
        return pid;
    }

    public ProcfsBasedProcessTree.ProcessSmapMemoryInfo constructMemoryMappingInfo(String address, String[] entries) {
        ProcfsBasedProcessTree.ProcessSmapMemoryInfo info = new ProcfsBasedProcessTree.ProcessSmapMemoryInfo(address);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.SIZE.name(), entries[0]);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.RSS.name(), entries[1]);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.PSS.name(), entries[2]);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.SHARED_CLEAN.name(), entries[3]);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.SHARED_DIRTY.name(), entries[4]);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.PRIVATE_CLEAN.name(), entries[5]);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.PRIVATE_DIRTY.name(), entries[6]);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.REFERENCED.name(), entries[7]);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.ANONYMOUS.name(), entries[8]);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.ANON_HUGE_PAGES.name(), entries[9]);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.SWAP.name(), entries[10]);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.KERNEL_PAGE_SIZE.name(), entries[11]);
        info.setMemInfo(ProcfsBasedProcessTree.MemInfo.MMU_PAGE_SIZE.name(), entries[12]);
        return info;
    }

    public void createMemoryMappingInfo(ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[] procMemInfo) {
        for (int i = 0; i < procMemInfo.length; ++i) {
            List memoryMappingList = procMemInfo[i].getMemoryInfoList();
            memoryMappingList.add(this.constructMemoryMappingInfo("7f56c177c000-7f56c177d000 rw-p 00010000 08:02 40371558                   /grid/0/jdk1.7.0_25/jre/lib/amd64/libnio.so", new String[]{"4", "4", "25", "4", "25", "15", "10", "4", "10", "0", "0", "4", "4"}));
            memoryMappingList.add(this.constructMemoryMappingInfo("7fb09382e000-7fb09382f000 r--s 00003000 08:02 25953545", new String[]{"4", "4", "25", "4", "0", "15", "10", "4", "10", "0", "0", "4", "4"}));
            memoryMappingList.add(this.constructMemoryMappingInfo("7e8790000-7e8b80000 r-xs 00000000 00:00 0", new String[]{"4", "4", "25", "4", "0", "15", "10", "4", "10", "0", "0", "4", "4"}));
            memoryMappingList.add(this.constructMemoryMappingInfo("7da677000-7e0dcf000 rw-p 00000000 00:00 0", new String[]{"4", "4", "25", "4", "50", "15", "10", "4", "10", "0", "0", "4", "4"}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30000L)
    void testCpuAndMemoryForProcessTree() throws IOException {
        String[] pids = new String[]{"100", "200", "300", "400"};
        ControlledClock testClock = new ControlledClock();
        testClock.setTime(0L);
        File procfsRootDir = new File(TEST_ROOT_DIR, "proc");
        try {
            TestProcfsBasedProcessTree.setupProcfsRootDir(procfsRootDir);
            TestProcfsBasedProcessTree.setupPidDirs(procfsRootDir, pids);
            ProcessStatInfo[] procInfos = new ProcessStatInfo[]{new ProcessStatInfo(new String[]{"100", "proc1", "1", "100", "100", "100000", "100", "1000", "200"}), new ProcessStatInfo(new String[]{"200", "process two", "100", "100", "100", "200000", "200", "2000", "400"}), new ProcessStatInfo(new String[]{"300", "proc(3)", "200", "100", "100", "300000", "300", "3000", "600"}), new ProcessStatInfo(new String[]{"400", "proc4", "1", "400", "400", "400000", "400", "4000", "800"})};
            ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[] memInfo = new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[]{new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("100"), new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("200"), new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("300"), new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("400")};
            this.createMemoryMappingInfo(memInfo);
            TestProcfsBasedProcessTree.writeStatFiles(procfsRootDir, pids, procInfos, memInfo);
            Configuration conf = new Configuration();
            ProcfsBasedProcessTree processTree = this.createProcessTree("100", procfsRootDir.getAbsolutePath(), testClock);
            processTree.setConf(conf);
            processTree.updateProcessTree();
            Assertions.assertEquals((long)600000L, (long)processTree.getVirtualMemorySize(), (String)"Virtual memory does not match");
            long cumuRssMem = ProcfsBasedProcessTree.PAGE_SIZE > 0L ? 600L * ProcfsBasedProcessTree.PAGE_SIZE : -1L;
            Assertions.assertEquals((long)cumuRssMem, (long)processTree.getRssMemorySize(), (String)"rss memory does not match");
            long cumuCpuTime = ProcfsBasedProcessTree.JIFFY_LENGTH_IN_MILLIS > 0L ? 7200L * ProcfsBasedProcessTree.JIFFY_LENGTH_IN_MILLIS : 0L;
            Assertions.assertEquals((long)cumuCpuTime, (long)processTree.getCumulativeCpuTime(), (String)"Cumulative cpu time does not match");
            Assertions.assertEquals((double)-1.0, (double)processTree.getCpuUsagePercent(), (double)0.01, (String)"Percent CPU time should be set to -1 initially");
            this.setSmapsInProceTree(processTree, true);
            Assertions.assertEquals((long)61440L, (long)processTree.getRssMemorySize(), (String)"rss memory does not match");
            procInfos[0] = new ProcessStatInfo(new String[]{"100", "proc1", "1", "100", "100", "100000", "100", "2000", "300"});
            procInfos[1] = new ProcessStatInfo(new String[]{"200", "process two", "100", "100", "100", "200000", "200", "3000", "500"});
            TestProcfsBasedProcessTree.writeStatFiles(procfsRootDir, pids, procInfos, memInfo);
            long elapsedTimeBetweenUpdatesMsec = 200000L;
            testClock.setTime(elapsedTimeBetweenUpdatesMsec);
            processTree.updateProcessTree();
            long prevCumuCpuTime = cumuCpuTime;
            cumuCpuTime = ProcfsBasedProcessTree.JIFFY_LENGTH_IN_MILLIS > 0L ? 9400L * ProcfsBasedProcessTree.JIFFY_LENGTH_IN_MILLIS : 0L;
            Assertions.assertEquals((long)cumuCpuTime, (long)processTree.getCumulativeCpuTime(), (String)"Cumulative cpu time does not match");
            double expectedCpuUsagePercent = ProcfsBasedProcessTree.JIFFY_LENGTH_IN_MILLIS > 0L ? (double)(cumuCpuTime - prevCumuCpuTime) * 100.0 / (double)elapsedTimeBetweenUpdatesMsec : 0.0;
            Assertions.assertEquals((double)11.0, (double)expectedCpuUsagePercent, (double)0.001);
            Assertions.assertEquals((double)expectedCpuUsagePercent, (double)processTree.getCpuUsagePercent(), (double)0.01, (String)("Percent CPU time is not correct expected " + expectedCpuUsagePercent));
        }
        finally {
            FileUtil.fullyDelete((File)procfsRootDir);
        }
    }

    private void setSmapsInProceTree(ProcfsBasedProcessTree processTree, boolean enableFlag) {
        Configuration conf = processTree.getConf();
        if (conf == null) {
            conf = new Configuration();
        }
        conf.setBoolean("yarn.nodemanager.container-monitor.procfs-tree.smaps-based-rss.enabled", enableFlag);
        processTree.setConf(conf);
        processTree.updateProcessTree();
    }

    @Test
    @Timeout(value=30000L)
    void testMemForOlderProcesses() throws IOException {
        this.testMemForOlderProcesses(false);
        this.testMemForOlderProcesses(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMemForOlderProcesses(boolean smapEnabled) throws IOException {
        String[] pids = new String[]{"100", "200", "300", "400"};
        File procfsRootDir = new File(TEST_ROOT_DIR, "proc");
        try {
            long cumuRssMem;
            TestProcfsBasedProcessTree.setupProcfsRootDir(procfsRootDir);
            TestProcfsBasedProcessTree.setupPidDirs(procfsRootDir, pids);
            ProcessStatInfo[] procInfos = new ProcessStatInfo[]{new ProcessStatInfo(new String[]{"100", "proc1", "1", "100", "100", "100000", "100"}), new ProcessStatInfo(new String[]{"200", "process two", "100", "100", "100", "200000", "200"}), new ProcessStatInfo(new String[]{"300", "proc(3)", "1", "300", "300", "300000", "300"}), new ProcessStatInfo(new String[]{"400", "proc4", "100", "100", "100", "400000", "400"})};
            ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[] memInfo = new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[]{new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("100"), new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("200"), new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("300"), new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("400")};
            this.createMemoryMappingInfo(memInfo);
            TestProcfsBasedProcessTree.writeStatFiles(procfsRootDir, pids, procInfos, memInfo);
            ProcfsBasedProcessTree processTree = this.createProcessTree("100", procfsRootDir.getAbsolutePath(), (Clock)SystemClock.getInstance());
            this.setSmapsInProceTree(processTree, smapEnabled);
            Assertions.assertEquals((long)700000L, (long)processTree.getVirtualMemorySize(), (String)"Virtual memory does not match");
            String[] newPids = new String[]{"500"};
            TestProcfsBasedProcessTree.setupPidDirs(procfsRootDir, newPids);
            ProcessStatInfo[] newProcInfos = new ProcessStatInfo[]{new ProcessStatInfo(new String[]{"500", "proc5", "100", "100", "100", "500000", "500"})};
            ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[] newMemInfos = new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[]{new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("500")};
            this.createMemoryMappingInfo(newMemInfos);
            TestProcfsBasedProcessTree.writeStatFiles(procfsRootDir, newPids, newProcInfos, newMemInfos);
            processTree.updateProcessTree();
            Assertions.assertEquals((long)1200000L, (long)processTree.getVirtualMemorySize(), (String)"vmem does not include new process");
            if (!smapEnabled) {
                cumuRssMem = ProcfsBasedProcessTree.PAGE_SIZE > 0L ? 1200L * ProcfsBasedProcessTree.PAGE_SIZE : -1L;
                Assertions.assertEquals((long)cumuRssMem, (long)processTree.getRssMemorySize(), (String)"rssmem does not include new process");
            } else {
                Assertions.assertEquals((long)81920L, (long)processTree.getRssMemorySize(), (String)"rssmem does not include new process");
            }
            Assertions.assertEquals((long)700000L, (long)processTree.getVirtualMemorySize(1), (String)"vmem shouldn't have included new process");
            if (!smapEnabled) {
                cumuRssMem = ProcfsBasedProcessTree.PAGE_SIZE > 0L ? 700L * ProcfsBasedProcessTree.PAGE_SIZE : -1L;
                Assertions.assertEquals((long)cumuRssMem, (long)processTree.getRssMemorySize(1), (String)"rssmem shouldn't have included new process");
            } else {
                Assertions.assertEquals((long)61440L, (long)processTree.getRssMemorySize(1), (String)"rssmem shouldn't have included new process");
            }
            newPids = new String[]{"600"};
            TestProcfsBasedProcessTree.setupPidDirs(procfsRootDir, newPids);
            newProcInfos = new ProcessStatInfo[]{new ProcessStatInfo(new String[]{"600", "proc6", "100", "100", "100", "600000", "600"})};
            newMemInfos = new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[]{new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("600")};
            this.createMemoryMappingInfo(newMemInfos);
            TestProcfsBasedProcessTree.writeStatFiles(procfsRootDir, newPids, newProcInfos, newMemInfos);
            processTree.updateProcessTree();
            Assertions.assertEquals((long)700000L, (long)processTree.getVirtualMemorySize(2), (String)"vmem shouldn't have included new processes");
            if (!smapEnabled) {
                cumuRssMem = ProcfsBasedProcessTree.PAGE_SIZE > 0L ? 700L * ProcfsBasedProcessTree.PAGE_SIZE : -1L;
                Assertions.assertEquals((long)cumuRssMem, (long)processTree.getRssMemorySize(2), (String)"rssmem shouldn't have included new processes");
            } else {
                Assertions.assertEquals((long)61440L, (long)processTree.getRssMemorySize(2), (String)"rssmem shouldn't have included new processes");
            }
            Assertions.assertEquals((long)1200000L, (long)processTree.getVirtualMemorySize(1), (String)"vmem shouldn't have included new processes");
            if (!smapEnabled) {
                cumuRssMem = ProcfsBasedProcessTree.PAGE_SIZE > 0L ? 1200L * ProcfsBasedProcessTree.PAGE_SIZE : -1L;
                Assertions.assertEquals((long)cumuRssMem, (long)processTree.getRssMemorySize(1), (String)"rssmem shouldn't have included new processes");
            } else {
                Assertions.assertEquals((long)81920L, (long)processTree.getRssMemorySize(1), (String)"rssmem shouldn't have included new processes");
            }
            Assertions.assertEquals((long)0L, (long)processTree.getVirtualMemorySize(3), (String)"Getting non-zero vmem for processes older than 3 iterations");
            Assertions.assertEquals((long)0L, (long)processTree.getRssMemorySize(3), (String)"Getting non-zero rssmem for processes older than 3 iterations");
        }
        finally {
            FileUtil.fullyDelete((File)procfsRootDir);
        }
    }

    @Test
    @Timeout(value=30000L)
    void testDestroyProcessTree() throws IOException {
        String pid = "100";
        File procfsRootDir = new File(TEST_ROOT_DIR, "proc");
        try {
            TestProcfsBasedProcessTree.setupProcfsRootDir(procfsRootDir);
            this.createProcessTree(pid, procfsRootDir.getAbsolutePath(), (Clock)SystemClock.getInstance());
            Assertions.assertTrue((boolean)ProcfsBasedProcessTree.checkPidPgrpidForMatch((String)pid, (String)procfsRootDir.getAbsolutePath()));
        }
        finally {
            FileUtil.fullyDelete((File)procfsRootDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30000L)
    void testProcessTreeDump() throws IOException {
        String[] pids = new String[]{"100", "200", "300", "400", "500", "600"};
        File procfsRootDir = new File(TEST_ROOT_DIR, "proc");
        try {
            TestProcfsBasedProcessTree.setupProcfsRootDir(procfsRootDir);
            TestProcfsBasedProcessTree.setupPidDirs(procfsRootDir, pids);
            int numProcesses = pids.length;
            ProcessStatInfo[] procInfos = new ProcessStatInfo[numProcesses];
            procInfos[0] = new ProcessStatInfo(new String[]{"100", "proc1", "1", "100", "100", "100000", "100", "1000", "200"});
            procInfos[1] = new ProcessStatInfo(new String[]{"200", "process two", "100", "100", "100", "200000", "200", "2000", "400"});
            procInfos[2] = new ProcessStatInfo(new String[]{"300", "proc(3)", "200", "100", "100", "300000", "300", "3000", "600"});
            procInfos[3] = new ProcessStatInfo(new String[]{"400", "proc4", "200", "100", "100", "400000", "400", "4000", "800"});
            procInfos[4] = new ProcessStatInfo(new String[]{"500", "proc5", "400", "100", "100", "400000", "400", "4000", "800"});
            procInfos[5] = new ProcessStatInfo(new String[]{"600", "proc6", "1", "1", "1", "400000", "400", "4000", "800"});
            ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[] memInfos = new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[]{new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("100"), new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("200"), new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("300"), new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("400"), new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("500"), new ProcfsBasedProcessTree.ProcessTreeSmapMemInfo("600")};
            String[] cmdLines = new String[numProcesses];
            cmdLines[0] = "proc1 arg1 arg2";
            cmdLines[1] = "process two arg3 arg4";
            cmdLines[2] = "proc(3) arg5 arg6";
            cmdLines[3] = "proc4 arg7 arg8";
            cmdLines[4] = "proc5 arg9 arg10";
            cmdLines[5] = "proc6 arg11 arg12";
            this.createMemoryMappingInfo(memInfos);
            TestProcfsBasedProcessTree.writeStatFiles(procfsRootDir, pids, procInfos, memInfos);
            TestProcfsBasedProcessTree.writeCmdLineFiles(procfsRootDir, pids, cmdLines);
            ProcfsBasedProcessTree processTree = this.createProcessTree("100", procfsRootDir.getAbsolutePath(), (Clock)SystemClock.getInstance());
            processTree.updateProcessTree();
            String processTreeDump = processTree.getProcessTreeDump();
            LOG.info("Process-tree dump follows: \n" + processTreeDump);
            Assertions.assertTrue((boolean)processTreeDump.startsWith("\t|- PID PPID PGRPID SESSID CMD_NAME USER_MODE_TIME(MILLIS) SYSTEM_TIME(MILLIS) VMEM_USAGE(BYTES) RSSMEM_USAGE(PAGES) FULL_CMD_LINE\n"), (String)"Process-tree dump doesn't start with a proper header");
            for (int i = 0; i < 5; ++i) {
                ProcessStatInfo p = procInfos[i];
                Assertions.assertTrue((boolean)processTreeDump.contains("\t|- " + p.pid + " " + p.ppid + " " + p.pgrpId + " " + p.session + " (" + p.name + ") " + p.utime + " " + p.stime + " " + p.vmem + " " + p.rssmemPage + " " + cmdLines[i]), (String)("Process-tree dump doesn't contain the cmdLineDump of process " + p.pid));
            }
            ProcessStatInfo p = procInfos[5];
            Assertions.assertFalse((boolean)processTreeDump.contains("\t|- " + p.pid + " " + p.ppid + " " + p.pgrpId + " " + p.session + " (" + p.name + ") " + p.utime + " " + p.stime + " " + p.vmem + " " + cmdLines[5]), (String)("Process-tree dump shouldn't contain the cmdLineDump of process " + p.pid));
        }
        finally {
            FileUtil.fullyDelete((File)procfsRootDir);
        }
    }

    protected static boolean isSetsidAvailable() {
        Shell.ShellCommandExecutor shexec = null;
        boolean setsidSupported = true;
        try {
            String[] args = new String[]{"setsid", "bash", "-c", "echo $$"};
            shexec = new Shell.ShellCommandExecutor(args);
            shexec.execute();
        }
        catch (IOException ioe) {
            LOG.warn("setsid is not available on this machine. So not using it.");
            setsidSupported = false;
        }
        finally {
            LOG.info("setsid exited with exit code " + shexec.getExitCode());
        }
        return setsidSupported;
    }

    private static boolean isAlive(String pid) {
        try {
            String sigpid = TestProcfsBasedProcessTree.isSetsidAvailable() ? "-" + pid : pid;
            try {
                TestProcfsBasedProcessTree.sendSignal(sigpid, 0);
            }
            catch (Shell.ExitCodeException e) {
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static void sendSignal(String pid, int signal) throws IOException {
        Shell.ShellCommandExecutor shexec = null;
        String[] arg = new String[]{"kill", "-" + signal, "--", pid};
        shexec = new Shell.ShellCommandExecutor(arg);
        shexec.execute();
    }

    private static boolean isAnyProcessInTreeAlive(ProcfsBasedProcessTree processTree) {
        for (String pId : processTree.getCurrentProcessIDs()) {
            if (!TestProcfsBasedProcessTree.isAlive(pId)) continue;
            return true;
        }
        return false;
    }

    public static void setupProcfsRootDir(File procfsRootDir) throws IOException {
        if (procfsRootDir.exists()) {
            Assertions.assertTrue((boolean)FileUtil.fullyDelete((File)procfsRootDir));
        }
        Assertions.assertTrue((boolean)procfsRootDir.mkdirs());
    }

    public static void setupPidDirs(File procfsRootDir, String[] pids) throws IOException {
        for (String pid : pids) {
            File pidDir = new File(procfsRootDir, pid);
            FileUtils.forceMkdir((File)pidDir);
            LOG.info("created pid dir: " + pidDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStatFiles(File procfsRootDir, String[] pids, ProcessStatInfo[] procs, ProcfsBasedProcessTree.ProcessTreeSmapMemInfo[] smaps) throws IOException {
        for (int i = 0; i < pids.length; ++i) {
            File statFile = new File(new File(procfsRootDir, pids[i]), "stat");
            try (BufferedWriter bw = null;){
                FileWriter fw = new FileWriter(statFile);
                bw = new BufferedWriter(fw);
                bw.write(procs[i].getStatLine());
                LOG.info("wrote stat file for " + pids[i] + " with contents: " + procs[i].getStatLine());
            }
            if (smaps == null) continue;
            File smapFile = new File(new File(procfsRootDir, pids[i]), "smaps");
            bw = null;
            try {
                FileWriter fw = new FileWriter(smapFile);
                bw = new BufferedWriter(fw);
                bw.write(smaps[i].toString());
                bw.flush();
                LOG.info("wrote smap file for " + pids[i] + " with contents: " + smaps[i].toString());
                continue;
            }
            finally {
                if (bw != null) {
                    bw.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCmdLineFiles(File procfsRootDir, String[] pids, String[] cmdLines) throws IOException {
        for (int i = 0; i < pids.length; ++i) {
            File statFile = new File(new File(procfsRootDir, pids[i]), "cmdline");
            try (BufferedWriter bw = null;){
                bw = new BufferedWriter(new FileWriter(statFile));
                bw.write(cmdLines[i]);
                LOG.info("wrote command-line file for " + pids[i] + " with contents: " + cmdLines[i]);
                continue;
            }
        }
    }

    public static class ProcessStatInfo {
        String pid;
        String name;
        String ppid;
        String pgrpId;
        String session;
        String vmem = "0";
        String rssmemPage = "0";
        String utime = "0";
        String stime = "0";

        public ProcessStatInfo(String[] statEntries) {
            this.pid = statEntries[0];
            this.name = statEntries[1];
            this.ppid = statEntries[2];
            this.pgrpId = statEntries[3];
            this.session = statEntries[4];
            this.vmem = statEntries[5];
            if (statEntries.length > 6) {
                this.rssmemPage = statEntries[6];
            }
            if (statEntries.length > 7) {
                this.utime = statEntries[7];
                this.stime = statEntries[8];
            }
        }

        public String getStatLine() {
            return String.format("%s (%s) S %s %s %s 0 0 0 0 0 0 0 %s %s 0 0 0 0 0 0 0 %s %s 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0", this.pid, this.name, this.ppid, this.pgrpId, this.session, this.utime, this.stime, this.vmem, this.rssmemPage);
        }
    }

    private class RogueTaskThread
    extends Thread {
        private RogueTaskThread() {
        }

        @Override
        public void run() {
            try {
                Vector<String> args = new Vector<String>();
                if (TestProcfsBasedProcessTree.isSetsidAvailable()) {
                    args.add("setsid");
                }
                args.add("bash");
                args.add("-c");
                args.add(" echo $$ > " + TestProcfsBasedProcessTree.this.pidFile + "; sh " + TestProcfsBasedProcessTree.this.shellScript + " " + 6 + ";");
                TestProcfsBasedProcessTree.this.shexec = new Shell.ShellCommandExecutor(args.toArray(new String[0]));
                TestProcfsBasedProcessTree.this.shexec.execute();
            }
            catch (Shell.ExitCodeException ee) {
                LOG.info("Shell Command exit with a non-zero exit code. This is expected as we are killing the subprocesses of the task intentionally. " + (Object)((Object)ee));
            }
            catch (IOException ioe) {
                LOG.info("Error executing shell command " + ioe);
            }
            finally {
                LOG.info("Exit code: " + TestProcfsBasedProcessTree.this.shexec.getExitCode());
            }
        }
    }
}

