/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.File;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.util.Apps;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestApps {
    @Test
    void testSetEnvFromInputString() {
        HashMap<String, String> environment = new HashMap<String, String>();
        environment.put("JAVA_HOME", "/path/jdk");
        String goodEnv = "a1=1,b_2=2,_c=3,d=4,e=,f_win=%JAVA_HOME%,g_nix=$JAVA_HOME";
        Apps.setEnvFromInputString(environment, (String)goodEnv, (String)File.pathSeparator);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1", environment.get("a1"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"2", environment.get("b_2"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"3", environment.get("_c"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"4", environment.get("d"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", environment.get("e"));
        if (Shell.WINDOWS) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"$JAVA_HOME", environment.get("g_nix"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"/path/jdk", environment.get("f_win"));
        } else {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"/path/jdk", environment.get("g_nix"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"%JAVA_HOME%", environment.get("f_win"));
        }
        String badEnv = "1,,2=a=b,3=a=,4==,5==a,==,c-3=3,=";
        environment.clear();
        Apps.setEnvFromInputString(environment, (String)badEnv, (String)File.pathSeparator);
        Assertions.assertThat(environment).isEmpty();
        environment.clear();
        Apps.setEnvFromInputString(environment, (String)"b1,e1==,e2=a1=a2,b2", (String)File.pathSeparator);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"=", environment.get("e1"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a1=a2", environment.get("e2"));
    }

    @Test
    void testSetEnvFromInputProperty() {
        Configuration conf = new Configuration(false);
        HashMap env = new HashMap();
        String propName = "mapreduce.map.env";
        String defaultPropName = "mapreduce.child.env";
        conf.set(propName, "env1=env1_val,env2=env2_val,env3=env3_val");
        conf.set(propName + ".env4", "env4_val");
        conf.set(propName + ".env2", "new_env2_val");
        conf.set(defaultPropName, "env1=def1_val,env2=def2_val,env3=def3_val");
        String defaultPropValue = conf.get(defaultPropName);
        conf.set(defaultPropName + ".env4", "def4_val");
        conf.set(defaultPropName + ".env2", "new_def2_val");
        Apps.setEnvFromInputProperty(env, (String)propName, (String)defaultPropValue, (Configuration)conf, (String)File.pathSeparator);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"env1_val", env.get("env1"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"env3_val", env.get("env3"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"env4_val", env.get("env4"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"new_env2_val", env.get("env2"));
    }

    @Test
    void testSetEnvFromInputPropertyDefault() {
        Configuration conf = new Configuration(false);
        HashMap env = new HashMap();
        String propName = "mapreduce.map.env";
        String defaultPropName = "mapreduce.child.env";
        conf.set(propName, "env1=env1_val,env2=env2_val,env3=env3_val");
        conf.set(propName + ".env4", "env4_val");
        conf.set(propName + ".env2", "new_env2_val");
        conf.set(defaultPropName, "env1=def1_val,env2=def2_val,env3=def3_val");
        String defaultPropValue = conf.get(defaultPropName);
        conf.set(defaultPropName + ".env4", "def4_val");
        conf.set(defaultPropName + ".env2", "new_def2_val");
        String bogusProp = propName + "bogus";
        Apps.setEnvFromInputProperty(env, (String)bogusProp, (String)defaultPropValue, (Configuration)conf, (String)File.pathSeparator);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"def1_val", env.get("env1"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"def2_val", env.get("env2"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"def3_val", env.get("env3"));
        org.junit.jupiter.api.Assertions.assertNull(env.get("env4"));
    }

    @Test
    void testSetEnvFromInputPropertyOverrideDefault() {
        Configuration conf = new Configuration(false);
        HashMap env = new HashMap();
        String propName = "mapreduce.reduce.env";
        conf.set(propName + ".env2", "new2_val");
        conf.set(propName + ".env4", "new4_val");
        String defaultPropName = "mapreduce.child.env";
        conf.set(defaultPropName, "env1=def1_val,env2=def2_val,env3=def3_val");
        String defaultPropValue = conf.get(defaultPropName);
        conf.set(defaultPropName + ".env4", "def4_val");
        conf.set(defaultPropName + ".env2", "new_def2_val");
        Apps.setEnvFromInputProperty(env, (String)propName, (String)defaultPropValue, (Configuration)conf, (String)File.pathSeparator);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"def1_val", env.get("env1"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"def3_val", env.get("env3"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"new4_val", env.get("env4"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"new2_val", env.get("env2"));
    }

    @Test
    void testSetEnvFromInputPropertyCommas() {
        Configuration conf = new Configuration(false);
        HashMap env = new HashMap();
        String propName = "mapreduce.reduce.env";
        conf.set(propName, "env1=env1_val,env2=env2_val,env3=env3_val");
        conf.set(propName + ".env2", "new2_val1,new2_val2,new2_val3");
        conf.set(propName + ".env4", "new4_valwith=equals");
        String defaultPropName = "mapreduce.child.env";
        conf.set(defaultPropName, "env1=def1_val,env2=def2_val,env3=def3_val");
        String defaultPropValue = conf.get(defaultPropName);
        Apps.setEnvFromInputProperty(env, (String)propName, (String)defaultPropValue, (Configuration)conf, (String)File.pathSeparator);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"env1_val", env.get("env1"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"env3_val", env.get("env3"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"new4_valwith=equals", env.get("env4"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"new2_val1,new2_val2,new2_val3", env.get("env2"));
    }

    @Test
    void testSetEnvFromInputPropertyNull() {
        Configuration conf = new Configuration(false);
        HashMap env = new HashMap();
        String propName = "mapreduce.map.env";
        String defaultPropName = "mapreduce.child.env";
        conf.set(propName, "env1=env1_val,env2=env2_val,env3=env3_val");
        conf.set(propName + ".env4", "env4_val");
        conf.set(propName + ".env2", "new_env2_val");
        conf.set(defaultPropName, "env1=def1_val,env2=def2_val,env3=def3_val");
        String defaultPropValue = conf.get(defaultPropName);
        conf.set(defaultPropName + ".env4", "def4_val");
        conf.set(defaultPropName + ".env2", "new_def2_val");
        Apps.setEnvFromInputProperty(env, (String)"bogus1", null, (Configuration)conf, (String)File.pathSeparator);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)env.isEmpty());
    }
}

