/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.testutils;

import java.util.List;
import org.apache.hadoop.test.MockitoUtil;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.mockito.Mockito;

public class MockRMClientUtils {
    public static ApplicationClientProtocol createMockRMClient(List<ApplicationId> finishedApplications, List<ApplicationId> runningApplications) throws Exception {
        GetApplicationReportResponse response;
        GetApplicationReportRequest request;
        ApplicationClientProtocol mockProtocol = (ApplicationClientProtocol)MockitoUtil.mockProtocol(ApplicationClientProtocol.class);
        if (finishedApplications != null && !finishedApplications.isEmpty()) {
            for (ApplicationId appId : finishedApplications) {
                request = GetApplicationReportRequest.newInstance((ApplicationId)appId);
                response = MockRMClientUtils.createApplicationReportWithFinishedApplication();
                Mockito.when((Object)mockProtocol.getApplicationReport(request)).thenReturn((Object)response);
            }
        }
        if (runningApplications != null && !runningApplications.isEmpty()) {
            for (ApplicationId appId : runningApplications) {
                request = GetApplicationReportRequest.newInstance((ApplicationId)appId);
                response = MockRMClientUtils.createApplicationReportWithRunningApplication();
                Mockito.when((Object)mockProtocol.getApplicationReport(request)).thenReturn((Object)response);
            }
        }
        return mockProtocol;
    }

    public static GetApplicationReportResponse createApplicationReportWithRunningApplication() {
        ApplicationReport report = (ApplicationReport)Mockito.mock(ApplicationReport.class);
        Mockito.when((Object)report.getYarnApplicationState()).thenReturn((Object)YarnApplicationState.RUNNING);
        GetApplicationReportResponse response = (GetApplicationReportResponse)Mockito.mock(GetApplicationReportResponse.class);
        Mockito.when((Object)response.getApplicationReport()).thenReturn((Object)report);
        return response;
    }

    public static GetApplicationReportResponse createApplicationReportWithFinishedApplication() {
        ApplicationReport report = (ApplicationReport)Mockito.mock(ApplicationReport.class);
        Mockito.when((Object)report.getYarnApplicationState()).thenReturn((Object)YarnApplicationState.FINISHED);
        GetApplicationReportResponse response = (GetApplicationReportResponse)Mockito.mock(GetApplicationReportResponse.class);
        Mockito.when((Object)response.getApplicationReport()).thenReturn((Object)report);
        return response;
    }
}

