/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.yarn.logaggregation.LogAggregationTestUtils;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileController;
import org.apache.hadoop.yarn.logaggregation.filecontroller.ifile.LogAggregationIndexedFileController;
import org.apache.hadoop.yarn.logaggregation.filecontroller.tfile.LogAggregationTFileController;
import org.apache.hadoop.yarn.logaggregation.testutils.LogAggregationTestcase;
import org.apache.hadoop.yarn.logaggregation.testutils.LogAggregationTestcaseBuilder;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestAggregatedLogDeletionService {
    private static final String T_FILE = "TFile";
    private static final String I_FILE = "IFile";
    private static final String USER_ME = "me";
    private static final String DIR_HOST1 = "host1";
    private static final String DIR_HOST2 = "host2";
    private static final String ROOT = "mockfs://foo/";
    private static final String REMOTE_ROOT_LOG_DIR = "mockfs://foo/tmp/logs/";
    private static final String SUFFIX = "logs";
    private static final int TEN_DAYS_IN_SECONDS = 864000;
    private static final List<Class<? extends LogAggregationFileController>> ALL_FILE_CONTROLLERS = Arrays.asList(LogAggregationIndexedFileController.class, LogAggregationTFileController.class);
    public static final List<String> ALL_FILE_CONTROLLER_NAMES = Arrays.asList("IFile", "TFile");

    @BeforeAll
    public static void beforeClass() {
        Logger.getRootLogger().setLevel(Level.DEBUG);
    }

    @BeforeEach
    public void closeFilesystems() throws IOException {
        FileSystem.closeAll();
    }

    private Configuration setupConfiguration(int retainSeconds, int retainCheckIntervalSeconds) {
        Configuration conf = new Configuration();
        String root = ROOT;
        conf.setClass("fs.mockfs.impl", MockFileSystem.class, FileSystem.class);
        conf.set("fs.defaultFS", root);
        conf.setBoolean("yarn.log-aggregation-enable", true);
        conf.setInt("yarn.log-aggregation.retain-seconds", retainSeconds);
        conf.setInt("yarn.log-aggregation.retain-check-interval-seconds", retainCheckIntervalSeconds);
        conf.set("yarn.nodemanager.remote-app-log-dir", REMOTE_ROOT_LOG_DIR);
        conf.set("yarn.nodemanager.remote-app-log-dir-suffix", SUFFIX);
        conf.set("yarn.log-aggregation.file-formats", T_FILE);
        conf.set(String.format("yarn.log-aggregation.file-controller.%s.class", T_FILE), LogAggregationTFileController.class.getName());
        return conf;
    }

    @Test
    void testDeletion() throws Exception {
        long now = System.currentTimeMillis();
        long toDeleteTime = now - 2000000L;
        long toKeepTime = now - 1500000L;
        Configuration conf = this.setupConfiguration(1800, -1);
        long timeout = 2000L;
        LogAggregationTestcaseBuilder.create(conf).withRootPath(ROOT).withRemoteRootLogPath(REMOTE_ROOT_LOG_DIR).withUserDir(USER_ME, toKeepTime).withSuffixDir(SUFFIX, toDeleteTime).withBucketDir(toDeleteTime).withApps(Lists.newArrayList((Object[])new LogAggregationTestcaseBuilder.AppDescriptor[]{new LogAggregationTestcaseBuilder.AppDescriptor(toDeleteTime, Lists.newArrayList()), new LogAggregationTestcaseBuilder.AppDescriptor(toDeleteTime, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)DIR_HOST1, (Object)toDeleteTime), Pair.of((Object)DIR_HOST2, (Object)toKeepTime)})), new LogAggregationTestcaseBuilder.AppDescriptor(toDeleteTime, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)DIR_HOST1, (Object)toDeleteTime), Pair.of((Object)DIR_HOST2, (Object)toDeleteTime)})), new LogAggregationTestcaseBuilder.AppDescriptor(toDeleteTime, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)DIR_HOST1, (Object)toDeleteTime), Pair.of((Object)DIR_HOST2, (Object)toKeepTime)}))})).withFinishedApps(1, 2, 3).withRunningApps(4).injectExceptionForAppDirDeletion(3).build().startDeletionService().verifyAppDirsDeleted(timeout, 1, 3).verifyAppDirsNotDeleted(timeout, 2, 4).verifyAppFileDeleted(4, 1, timeout).verifyAppFileNotDeleted(4, 2, timeout).teardown(1);
    }

    @Test
    void testRefreshLogRetentionSettings() throws Exception {
        long now = System.currentTimeMillis();
        long before2000Secs = now - 2000000L;
        long before50Secs = now - 50000L;
        int checkIntervalSeconds = 2;
        int checkIntervalMilliSeconds = checkIntervalSeconds * 1000;
        Configuration conf = this.setupConfiguration(1800, 1);
        LogAggregationTestcase testcase = LogAggregationTestcaseBuilder.create(conf).withRootPath(ROOT).withRemoteRootLogPath(REMOTE_ROOT_LOG_DIR).withUserDir(USER_ME, before50Secs).withSuffixDir(SUFFIX, before50Secs).withBucketDir(before50Secs).withApps(Lists.newArrayList((Object[])new LogAggregationTestcaseBuilder.AppDescriptor[]{new LogAggregationTestcaseBuilder.AppDescriptor(before2000Secs, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)DIR_HOST1, (Object)before2000Secs)})), new LogAggregationTestcaseBuilder.AppDescriptor(before50Secs, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)DIR_HOST1, (Object)before50Secs)}))})).withFinishedApps(1, 2).withRunningApps(new int[0]).build();
        testcase.startDeletionService().verifyAppDirDeleted(1, 10000L).verifyAppDirNotDeleted(2, 3000L);
        conf.setInt("yarn.log-aggregation.retain-seconds", 50);
        conf.setInt("yarn.log-aggregation.retain-check-interval-seconds", checkIntervalSeconds);
        testcase.verifyCheckIntervalMilliSecondsNotEqualTo(checkIntervalMilliSeconds).refreshLogRetentionSettings().verifyCheckIntervalMilliSecondsEqualTo(checkIntervalMilliSeconds).verifyAppDirDeleted(2, 10000L).teardown(2);
    }

    @Test
    void testCheckInterval() throws Exception {
        long now = System.currentTimeMillis();
        long toDeleteTime = now - 864000000L;
        Configuration conf = this.setupConfiguration(864000, 1);
        FileSystem.closeAll();
        LogAggregationTestcaseBuilder.create(conf).withRootPath(ROOT).withRemoteRootLogPath(REMOTE_ROOT_LOG_DIR).withUserDir(USER_ME, now).withSuffixDir(SUFFIX, now).withBucketDir(now).withApps(Lists.newArrayList((Object[])new LogAggregationTestcaseBuilder.AppDescriptor[]{new LogAggregationTestcaseBuilder.AppDescriptor(now, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)DIR_HOST1, (Object)now)})), new LogAggregationTestcaseBuilder.AppDescriptor(now)})).withFinishedApps(1).withRunningApps(new int[0]).build().startDeletionService().verifyAnyPathListedAtLeast(4, 10000L).verifyAppDirNotDeleted(1, -1L).changeModTimeOfApp(1, toDeleteTime).changeModTimeOfAppLogDir(1, 1, toDeleteTime).changeModTimeOfBucketDir(toDeleteTime).reinitAllPaths().verifyAppDirDeleted(1, 10000L).teardown(1);
    }

    @Test
    void testRobustLogDeletion() throws Exception {
        Configuration conf = this.setupConfiguration(864000, 1);
        FileSystem.closeAll();
        long modTime = 0L;
        LogAggregationTestcaseBuilder.create(conf).withRootPath(ROOT).withRemoteRootLogPath(REMOTE_ROOT_LOG_DIR).withUserDir(USER_ME, modTime).withSuffixDir(SUFFIX, modTime).withBucketDir(modTime, "0").withApps(Lists.newArrayList((Object[])new LogAggregationTestcaseBuilder.AppDescriptor[]{new LogAggregationTestcaseBuilder.AppDescriptor(modTime), new LogAggregationTestcaseBuilder.AppDescriptor(modTime), new LogAggregationTestcaseBuilder.AppDescriptor(modTime, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)DIR_HOST1, (Object)modTime)}))})).withAdditionalAppDirs(Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"application_a", (Object)modTime)})).withFinishedApps(1, 3).withRunningApps(new int[0]).injectExceptionForAppDirDeletion(1).build().runDeletionTask(864000L).verifyAppDirDeleted(3, -1L);
    }

    @Test
    void testDeletionTwoControllers() throws IOException {
        long now = System.currentTimeMillis();
        long toDeleteTime = now - 2000000L;
        long toKeepTime = now - 1500000L;
        Configuration conf = this.setupConfiguration(1800, -1);
        LogAggregationTestUtils.enableFileControllers(conf, REMOTE_ROOT_LOG_DIR, ALL_FILE_CONTROLLERS, ALL_FILE_CONTROLLER_NAMES);
        long timeout = 2000L;
        LogAggregationTestcaseBuilder.create(conf).withRootPath(ROOT).withRemoteRootLogPath(REMOTE_ROOT_LOG_DIR).withBothFileControllers().withUserDir(USER_ME, toKeepTime).withSuffixDir(SUFFIX, toDeleteTime).withBucketDir(toDeleteTime).withApps(Lists.newArrayList((Object[])new LogAggregationTestcaseBuilder.AppDescriptor[]{new LogAggregationTestcaseBuilder.AppDescriptor(T_FILE, toDeleteTime, Lists.newArrayList()), new LogAggregationTestcaseBuilder.AppDescriptor(T_FILE, toDeleteTime, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)DIR_HOST1, (Object)toDeleteTime), Pair.of((Object)DIR_HOST2, (Object)toKeepTime)})), new LogAggregationTestcaseBuilder.AppDescriptor(T_FILE, toDeleteTime, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)DIR_HOST1, (Object)toDeleteTime), Pair.of((Object)DIR_HOST2, (Object)toDeleteTime)})), new LogAggregationTestcaseBuilder.AppDescriptor(T_FILE, toDeleteTime, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)DIR_HOST1, (Object)toDeleteTime), Pair.of((Object)DIR_HOST2, (Object)toKeepTime)})), new LogAggregationTestcaseBuilder.AppDescriptor(I_FILE, toDeleteTime, Lists.newArrayList()), new LogAggregationTestcaseBuilder.AppDescriptor(I_FILE, toDeleteTime, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)DIR_HOST1, (Object)toDeleteTime), Pair.of((Object)DIR_HOST2, (Object)toKeepTime)})), new LogAggregationTestcaseBuilder.AppDescriptor(I_FILE, toDeleteTime, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)DIR_HOST1, (Object)toDeleteTime), Pair.of((Object)DIR_HOST2, (Object)toDeleteTime)})), new LogAggregationTestcaseBuilder.AppDescriptor(I_FILE, toDeleteTime, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)DIR_HOST1, (Object)toDeleteTime), Pair.of((Object)DIR_HOST2, (Object)toKeepTime)}))})).withFinishedApps(1, 2, 3, 5, 6, 7).withRunningApps(4, 8).injectExceptionForAppDirDeletion(3, 6).build().startDeletionService().verifyAppDirsDeleted(timeout, 1, 3, 5, 7).verifyAppDirsNotDeleted(timeout, 2, 4, 6, 8).verifyAppFilesDeleted(timeout, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)4, (Object)1), Pair.of((Object)8, (Object)1)})).verifyAppFilesNotDeleted(timeout, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)4, (Object)2), Pair.of((Object)8, (Object)2)})).teardown(1);
    }

    static class MockFileSystem
    extends FilterFileSystem {
        MockFileSystem() {
            super((FileSystem)Mockito.mock(FileSystem.class));
        }

        public void initialize(URI name, Configuration conf) throws IOException {
        }

        public boolean hasPathCapability(Path path, String capability) {
            return true;
        }
    }
}

