/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.ipc.HadoopYarnProtoRPC;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.Records;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestClientRMProxy {
    @Test
    void testGetRMDelegationTokenService() {
        String defaultRMAddress = "0.0.0.0:8032";
        YarnConfiguration conf = new YarnConfiguration();
        Text tokenService = ClientRMProxy.getRMDelegationTokenService((Configuration)conf);
        String[] services = tokenService.toString().split(",");
        Assertions.assertEquals((int)1, (int)services.length);
        for (String service : services) {
            Assertions.assertTrue((boolean)service.contains(defaultRMAddress), (String)"Incorrect token service name");
        }
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2");
        conf.set(HAUtil.addSuffix((String)"yarn.resourcemanager.hostname", (String)"rm1"), "0.0.0.0");
        conf.set(HAUtil.addSuffix((String)"yarn.resourcemanager.hostname", (String)"rm2"), "0.0.0.0");
        tokenService = ClientRMProxy.getRMDelegationTokenService((Configuration)conf);
        services = tokenService.toString().split(",");
        Assertions.assertEquals((int)2, (int)services.length);
        for (String service : services) {
            Assertions.assertTrue((boolean)service.contains(defaultRMAddress), (String)"Incorrect token service name");
        }
    }

    @Test
    void testGetAMRMTokenService() {
        String defaultRMAddress = "0.0.0.0:8030";
        YarnConfiguration conf = new YarnConfiguration();
        Text tokenService = ClientRMProxy.getAMRMTokenService((Configuration)conf);
        String[] services = tokenService.toString().split(",");
        Assertions.assertEquals((int)1, (int)services.length);
        for (String service : services) {
            Assertions.assertTrue((boolean)service.contains(defaultRMAddress), (String)"Incorrect token service name");
        }
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2");
        conf.set(HAUtil.addSuffix((String)"yarn.resourcemanager.hostname", (String)"rm1"), "0.0.0.0");
        conf.set(HAUtil.addSuffix((String)"yarn.resourcemanager.hostname", (String)"rm2"), "0.0.0.0");
        tokenService = ClientRMProxy.getAMRMTokenService((Configuration)conf);
        services = tokenService.toString().split(",");
        Assertions.assertEquals((int)2, (int)services.length);
        for (String service : services) {
            Assertions.assertTrue((boolean)service.contains(defaultRMAddress), (String)"Incorrect token service name");
        }
    }

    @Test
    void testProxyUserCorrectUGI() throws Exception {
        final YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2");
        conf.set(HAUtil.addSuffix((String)"yarn.resourcemanager.hostname", (String)"rm1"), "0.0.0.0");
        conf.set(HAUtil.addSuffix((String)"yarn.resourcemanager.hostname", (String)"rm2"), "0.0.0.0");
        conf.setLong("yarn.client.failover-max-attempts", 2L);
        conf.setLong("yarn.resourcemanager.connect.max-wait.ms", 2L);
        conf.setLong("yarn.resourcemanager.connect.retry-interval.ms", 2L);
        conf.setClass("yarn.ipc.rpc.class", UGICapturingHadoopYarnProtoRPC.class, YarnRPC.class);
        UserGroupInformation realUser = UserGroupInformation.getCurrentUser();
        UserGroupInformation proxyUser = UserGroupInformation.createProxyUserForTesting((String)"proxy", (UserGroupInformation)realUser, (String[])new String[]{"group1"});
        ApplicationClientProtocol rmProxy = (ApplicationClientProtocol)proxyUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ApplicationClientProtocol>(){

            @Override
            public ApplicationClientProtocol run() throws Exception {
                return (ApplicationClientProtocol)ClientRMProxy.createRMProxy((Configuration)conf, ApplicationClientProtocol.class);
            }
        });
        this.assertUGI();
        GetNewApplicationRequest request = (GetNewApplicationRequest)Records.newRecord(GetNewApplicationRequest.class);
        UGICapturingHadoopYarnProtoRPC.lastCurrentUser = null;
        try {
            rmProxy.getNewApplication(request);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.assertUGI();
    }

    private void assertUGI() throws IOException {
        UserGroupInformation lastCurrentUser = UGICapturingHadoopYarnProtoRPC.lastCurrentUser;
        Assertions.assertNotNull((Object)lastCurrentUser);
        Assertions.assertEquals((Object)"proxy", (Object)lastCurrentUser.getShortUserName());
        Assertions.assertEquals((Object)UserGroupInformation.AuthenticationMethod.PROXY, (Object)lastCurrentUser.getAuthenticationMethod());
        Assertions.assertEquals((Object)UserGroupInformation.getCurrentUser(), (Object)lastCurrentUser.getRealUser());
        UGICapturingHadoopYarnProtoRPC.lastCurrentUser = null;
    }

    public static class UGICapturingHadoopYarnProtoRPC
    extends HadoopYarnProtoRPC {
        static UserGroupInformation lastCurrentUser = null;

        public Object getProxy(Class protocol, InetSocketAddress addr, Configuration conf) {
            UserGroupInformation currentUser = null;
            try {
                currentUser = UserGroupInformation.getCurrentUser();
            }
            catch (IOException ioe) {
                Assertions.fail((String)("Unable to get current user\n" + StringUtils.stringifyException((Throwable)ioe)));
            }
            lastCurrentUser = currentUser;
            return super.getProxy(protocol, addr, conf);
        }
    }
}

